/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingHelper;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.metamodels.diagram.PresentationEntity;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.transformation.SqlAlias;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.properties.EnumeratedValuesPropertyDescriptor;
import org.teiid.designer.ui.properties.ITransientPropertyDescriptor;
import org.teiid.designer.ui.properties.ModelObjectPropertyDescriptor;
import org.teiid.designer.ui.properties.NamespacePropertyDescriptor;
import org.teiid.designer.ui.properties.ObjectUriPropertyDescriptor;
import org.teiid.designer.ui.properties.ReadOnlyPropertyDescriptor;
import org.teiid.designer.ui.properties.extension.ModelExtensionPropertySource;
import org.teiid.designer.ui.properties.udp.ExtensionPropertySource;
import org.teiid.designer.ui.viewsupport.DatatypeUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.StatusBarUpdater;

public class ModelObjectPropertySource
extends PropertySource {
    public static final String SET = String.valueOf(UiConstants.Util.getString("ModelObjectPropertySource.undoSetPrefix", new Object[0])) + ' ';
    public static final String RESET = String.valueOf(UiConstants.Util.getString("ModelObjectPropertySource.undoResetPrefix", new Object[0])) + ' ';
    private boolean isReadOnlyType = false;
    private boolean isPrimaryMetamodelObject = false;
    private ExtensionPropertySource extensionDelegate;
    private ModelExtensionPropertySource modelExtensionDelegate;
    private ITransientPropertyDescriptor[] transientDescriptors = new ITransientPropertyDescriptor[0];
    private Map idDescriptorMap;
    private boolean initialized = false;

    public ModelObjectPropertySource(Object object, IItemPropertySource itemPropertySource) {
        super(object, itemPropertySource);
        boolean bl = this.isReadOnlyType = object instanceof PresentationEntity || object instanceof Mapping || object instanceof MappingHelper || object instanceof SqlAlias;
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (ModelUtil.isLockedSourceObject((Object)eObject)) {
                this.isReadOnlyType = true;
            } else {
                ModelResource mr = ModelUtilities.getModelResource(eObject);
                if (mr != null && mr.isReadOnly()) {
                    this.isReadOnlyType = true;
                } else {
                    DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)eObject, (boolean)true);
                    if (dtMgr.isSimpleDatatype(eObject)) {
                        try {
                            this.isReadOnlyType = dtMgr.isBuiltInDatatype(eObject);
                        }
                        catch (Exception e) {
                            UiConstants.Util.log(4, (Throwable)e, e.getClass().getName());
                            this.isReadOnlyType = false;
                        }
                    }
                }
            }
            this.modelExtensionDelegate = new ModelExtensionPropertySource(eObject);
        }
        this.extensionDelegate = new ExtensionPropertySource((EObject)object);
    }

    public boolean canDisplayExtensionProperties() {
        return this.isPrimaryMetamodelObject;
    }

    protected IPropertyDescriptor createPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor) {
        return new ModelObjectPropertyDescriptor(this.object, itemPropertyDescriptor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPropertyValue(Object propertyId, Object value) {
        try {
            if (this.object == null || !(this.object instanceof EObject)) return;
            boolean started = ModelerCore.startTxn((String)(String.valueOf(SET) + propertyId.toString()), (Object)((Object)this));
            boolean succeeded = false;
            try {
                if (this.modelExtensionDelegate.isExtensionProperty(propertyId)) {
                    this.modelExtensionDelegate.setPropertyValue(propertyId, value);
                    succeeded = true;
                    return;
                }
                if (this.extensionDelegate.isExtensionProperty(propertyId)) {
                    this.extensionDelegate.setPropertyValue(propertyId, value);
                    succeeded = true;
                    return;
                }
                if (!(propertyId instanceof String)) return;
                IItemPropertyDescriptor itemPropertyDescriptor = this.itemPropertySource.getPropertyDescriptor(this.object, propertyId);
                Object genericFeature = itemPropertyDescriptor.getFeature(this.object);
                if (genericFeature instanceof EStructuralFeature) {
                    EStructuralFeature feature = (EStructuralFeature)genericFeature;
                    EClassifier eType = feature.getEType();
                    if (feature.isMany() && eType instanceof EEnum && !(value instanceof EList)) {
                        itemPropertyDescriptor.setPropertyValue(this.object, value);
                        succeeded = true;
                        return;
                    }
                }
                IItemPropertyDescriptor descriptor = this.itemPropertySource.getPropertyDescriptor(this.object, propertyId);
                if (!this.isValidPropertyChange((EObject)this.object, propertyId, value)) return;
                if (descriptor instanceof ItemPropertyDescriptor) {
                    boolean success = ModelerCore.getModelEditor().setPropertyValue((EObject)this.object, value, (ItemPropertyDescriptor)descriptor);
                    if (!success) return;
                    succeeded = true;
                    return;
                } else if (genericFeature instanceof EStructuralFeature) {
                    boolean success = ModelerCore.getModelEditor().setPropertyValue((EObject)this.object, value, genericFeature);
                    if (success) {
                        succeeded = true;
                        return;
                    }
                    descriptor.setPropertyValue(this.object, value);
                    succeeded = true;
                    return;
                } else {
                    descriptor.setPropertyValue(this.object, value);
                    succeeded = true;
                }
                return;
            }
            finally {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        catch (Exception e) {
            String objectString = this.object.toString();
            if (this.object instanceof EObject) {
                StatusBarUpdater.formatEObjectMessage((EObject)this.object);
            }
            Object[] strings = new String[]{e.getClass().getName(), propertyId.toString(), value.toString(), objectString};
            String message = UiConstants.Util.getString("ModelObjectPropertySource.setPropertyValueError", strings);
            UiConstants.Util.log(4, (Throwable)e, message);
        }
    }

    private boolean isValidPropertyChange(EObject eObject, Object propertyId, Object value) {
        Integer intValue;
        if (eObject instanceof Column) {
            Integer intValue2;
            if (propertyId instanceof String && ((String)propertyId).equals("length") && value instanceof Integer && !DatatypeUtilities.canSetLength(eObject, intValue2 = (Integer)value)) {
                if (eObject instanceof Column) {
                    UiConstants.Util.log(2, UiConstants.Util.getString("ModelObjectPropertySource.cannotChangeColumnCharLengthWarning", new Object[0]));
                } else {
                    UiConstants.Util.log(2, UiConstants.Util.getString("ModelObjectPropertySource.cannotChangeParameterCharLengthWarning", new Object[0]));
                }
                return false;
            }
        } else if (eObject instanceof ProcedureParameter && propertyId instanceof String && ((String)propertyId).equals("length") && value instanceof Integer && !DatatypeUtilities.canSetLength(eObject, intValue = (Integer)value)) {
            if (eObject instanceof Column) {
                UiConstants.Util.log(2, UiConstants.Util.getString("ModelObjectPropertySource.cannotChangeColumnCharLengthWarning", new Object[0]));
            } else {
                UiConstants.Util.log(2, UiConstants.Util.getString("ModelObjectPropertySource.cannotChangeParameterCharLengthWarning", new Object[0]));
            }
            return false;
        }
        return true;
    }

    private IPropertyDescriptor[] getAllDescriptors() {
        int i;
        IPropertyDescriptor[] emfDescriptors = super.getPropertyDescriptors();
        IPropertyDescriptor[] extDescriptors = this.extensionDelegate.getPropertyDescriptors();
        this.transientDescriptors = this.getTransientPropertyDescriptors(this.object);
        IPropertyDescriptor[] modelExtensionDescriptors = this.modelExtensionDelegate.getPropertyDescriptors();
        if (this.transientDescriptors.length > 0) {
            this.idDescriptorMap = new HashMap();
            int i2 = 0;
            while (i2 < this.transientDescriptors.length) {
                this.idDescriptorMap.put(this.transientDescriptors[i2].getId(), this.transientDescriptors[i2]);
                ++i2;
            }
        }
        IPropertyDescriptor[] result = new IPropertyDescriptor[emfDescriptors.length + extDescriptors.length + this.transientDescriptors.length + modelExtensionDescriptors.length];
        int resultIndex = 0;
        if (emfDescriptors.length != 0) {
            i = 0;
            while (i < emfDescriptors.length) {
                result[resultIndex] = emfDescriptors[i];
                ++i;
                ++resultIndex;
            }
        }
        if (extDescriptors.length != 0) {
            i = 0;
            while (i < extDescriptors.length) {
                result[resultIndex] = extDescriptors[i];
                ++i;
                ++resultIndex;
            }
        }
        if (this.transientDescriptors.length != 0) {
            i = 0;
            while (i < this.transientDescriptors.length) {
                result[resultIndex] = this.transientDescriptors[i];
                ++i;
                ++resultIndex;
            }
        }
        if (modelExtensionDescriptors.length != 0) {
            i = 0;
            while (i < modelExtensionDescriptors.length) {
                result[resultIndex] = modelExtensionDescriptors[i];
                ++i;
                ++resultIndex;
            }
        }
        this.initialized = true;
        return result;
    }

    private ITransientPropertyDescriptor[] getTransientPropertyDescriptors(Object theObject) {
        ArrayList<ITransientPropertyDescriptor> temp = new ArrayList<ITransientPropertyDescriptor>();
        ITransientPropertyDescriptor id = new ObjectUriPropertyDescriptor();
        if (id.supports(theObject)) {
            id.setObject(theObject);
            temp.add(id);
        }
        if ((id = new NamespacePropertyDescriptor()).supports(theObject)) {
            id.setObject(theObject);
            temp.add(id);
        }
        if ((id = new EnumeratedValuesPropertyDescriptor()).supports(theObject)) {
            id.setObject(theObject);
            temp.add(id);
        }
        ITransientPropertyDescriptor[] result = !temp.isEmpty() ? temp.toArray(new ITransientPropertyDescriptor[temp.size()]) : new ITransientPropertyDescriptor[]{};
        return result;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] descriptors = this.getAllDescriptors();
        if (this.isReadOnlyType) {
            IPropertyDescriptor[] result = new IPropertyDescriptor[descriptors.length];
            int i = 0;
            while (i < descriptors.length) {
                result[i] = new ReadOnlyPropertyDescriptor(descriptors[i], 0);
                ++i;
            }
            descriptors = result;
        }
        return descriptors;
    }

    public Object getPropertyValue(Object propertyId) {
        if (this.modelExtensionDelegate.isExtensionProperty(propertyId)) {
            return this.modelExtensionDelegate.getPropertyValue(propertyId);
        }
        if (this.extensionDelegate.isExtensionProperty(propertyId)) {
            return this.extensionDelegate.getPropertyValue(propertyId);
        }
        ITransientPropertyDescriptor descriptor = null;
        if (!this.initialized) {
            this.getPropertyDescriptors();
        }
        if (this.idDescriptorMap != null) {
            descriptor = (ITransientPropertyDescriptor)this.idDescriptorMap.get(propertyId);
        }
        if (descriptor != null) {
            Object propValue = null;
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Get Property Value", (Object)((Object)this));
            boolean succeeded = false;
            try {
                propValue = descriptor.getPropertyValue();
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
            return propValue;
        }
        Object result = null;
        if (this.itemPropertySource.getPropertyDescriptor(this.object, propertyId) != null) {
            try {
                result = super.getPropertyValue(propertyId);
            }
            catch (Exception e) {
                String objectString = this.object.toString();
                if (this.object instanceof EObject) {
                    StatusBarUpdater.formatEObjectMessage((EObject)this.object);
                }
                Object[] strings = new String[]{e.getClass().getName(), propertyId.toString(), objectString};
                String message = UiConstants.Util.getString("ModelObjectPropertySource.getPropertyValueError", strings);
                UiConstants.Util.log(4, (Throwable)e, message);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetPropertyValue(Object propertyId) {
        try {
            if (this.object == null || !(this.object instanceof EObject)) return;
            boolean started = ModelerCore.startTxn((String)(String.valueOf(SET) + propertyId.toString()), (Object)((Object)this));
            boolean succeeded = false;
            try {
                if (this.modelExtensionDelegate.isExtensionProperty(propertyId)) {
                    this.modelExtensionDelegate.resetPropertyValue(propertyId);
                    succeeded = true;
                    return;
                }
                if (this.extensionDelegate.isExtensionProperty(propertyId)) {
                    this.extensionDelegate.resetPropertyValue(propertyId);
                    succeeded = true;
                    return;
                }
                if (!(propertyId instanceof String)) return;
                ItemPropertyDescriptor descriptor = (ItemPropertyDescriptor)this.itemPropertySource.getPropertyDescriptor(this.object, propertyId);
                descriptor.resetPropertyValue(this.object);
                succeeded = true;
                return;
            }
            finally {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        catch (Exception e) {
            String objectString = this.object.toString();
            if (this.object instanceof EObject) {
                StatusBarUpdater.formatEObjectMessage((EObject)this.object);
            }
            Object[] strings = new String[]{e.getClass().getName(), propertyId.toString(), objectString};
            String message = UiConstants.Util.getString("ModelObjectPropertySource.resetPropertyValueError", strings);
            UiConstants.Util.log(4, (Throwable)e, message);
        }
    }
}

