/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.properties.PropertyEditorFactory;
import org.teiid.designer.ui.viewsupport.ModelObjectPathLabelProvider;

public class ModelObjectPropertyDescriptor
extends PropertyDescriptor {
    private boolean showReadOnlyDialog = true;
    private boolean lazyLoadValues = false;

    public ModelObjectPropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
        super(object, itemPropertyDescriptor);
    }

    public void setShowReadOnlyDialog(boolean enable) {
        this.showReadOnlyDialog = enable;
    }

    public void setLazyLoadValues(boolean enable) {
        this.lazyLoadValues = enable;
    }

    public Object getObject() {
        return this.object;
    }

    public ILabelProvider getLabelProvider() {
        int upperBound;
        Object feature = this.itemPropertyDescriptor.getFeature(this.object);
        if (feature instanceof EReference && ((upperBound = ((EReference)feature).getUpperBound()) > 1 || upperBound == -1)) {
            return this.getLabelProvider(false);
        }
        return this.getLabelProvider(true);
    }

    ILabelProvider getLabelProvider(boolean theUseLocationFlag) {
        Object result = null;
        result = theUseLocationFlag && this.getObject() instanceof EObject ? new ModelObjectPathLabelProvider() : super.getLabelProvider();
        return result;
    }

    public CellEditor createDelegatePropertyEditor(Composite composite) {
        return super.createPropertyEditor(composite);
    }

    public CellEditor createPropertyEditor(Composite composite) {
        if (!this.itemPropertyDescriptor.canSetProperty(this.object)) {
            return null;
        }
        if (this.object instanceof EObject && !this.lazyLoadValues && !ModelEditorManager.autoOpen(UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell(), (EObject)this.object, this.showReadOnlyDialog)) {
            return null;
        }
        return PropertyEditorFactory.createPropertyEditor(composite, this.itemPropertyDescriptor, (IPropertyDescriptor)this, this.object, this.lazyLoadValues);
    }

    public Object getFeature() {
        return this.itemPropertyDescriptor.getFeature(this.object);
    }

    class ModelObjectLocationLabelProvider
    extends LabelProvider {
        ILabelProvider delegate = new ModelObjectPathLabelProvider();

        ModelObjectLocationLabelProvider() {
        }

        public String getText(Object theElement) {
            return theElement instanceof EObject ? this.delegate.getText(theElement) : ModelObjectPropertyDescriptor.this.getLabelProvider(false).getText(theElement);
        }
    }
}

