/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.ValidationDescriptor;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.preferences.ValidationItem;

public class ValidationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
UiConstants {
    public static final String[] STORED_VALUES = new String[4];
    public static final String[] VALUE_DISPLAY_NAMES = new String[4];
    private TabFolder tabFolder;
    private TabItem[] tabs;
    private Map tabItemsMap = new HashMap();
    private Map currentValuesMap;
    private List descriptors;

    static {
        ValidationPreferencePage.STORED_VALUES[0] = "error";
        ValidationPreferencePage.VALUE_DISPLAY_NAMES[0] = Util.getString("ValidationPreferencePage.error", new Object[0]);
        ValidationPreferencePage.STORED_VALUES[1] = "warning";
        ValidationPreferencePage.VALUE_DISPLAY_NAMES[1] = Util.getString("ValidationPreferencePage.warning", new Object[0]);
        ValidationPreferencePage.STORED_VALUES[2] = "info";
        ValidationPreferencePage.VALUE_DISPLAY_NAMES[2] = Util.getString("ValidationPreferencePage.info", new Object[0]);
        ValidationPreferencePage.STORED_VALUES[3] = "ignore";
        ValidationPreferencePage.VALUE_DISPLAY_NAMES[3] = Util.getString("ValidationPreferencePage.ignore", new Object[0]);
    }

    public static int indexOfStoredValueName(String name) {
        int index = -1;
        int i = 0;
        while (i < STORED_VALUES.length && index < 0) {
            if (STORED_VALUES[i].equals(name)) {
                index = i;
                continue;
            }
            ++i;
        }
        return index;
    }

    public ValidationPreferencePage() {
        this.setDescription(Util.getString("ValidationPreferencePage.description", new Object[0]));
    }

    public Control createContents(Composite parent) {
        String BLANK = "";
        String TAB_NAME_FOR_BLANK = Util.getString("ValidationPreferencePage.general", new Object[0]);
        this.descriptors = ModelerCore.getValidationPreferences().getValidationDescriptors();
        ArrayList<String> categories = new ArrayList<String>(this.descriptors.size());
        for (ValidationDescriptor vd : this.descriptors) {
            String category = vd.getPreferenceCategory();
            if (category == null) {
                category = BLANK;
            }
            if (categories.contains(category)) continue;
            categories.add(category);
        }
        int index = categories.indexOf(BLANK);
        if (index >= 0) {
            categories.remove(index);
            categories.add(0, BLANK);
        }
        this.tabFolder = new TabFolder(parent, 0);
        this.tabs = new TabItem[categories.size()];
        Iterator it = categories.iterator();
        int i = 0;
        while (it.hasNext()) {
            String tabName = (String)it.next();
            if (tabName.equals(BLANK)) {
                tabName = TAB_NAME_FOR_BLANK;
            }
            this.tabs[i] = new TabItem(this.tabFolder, 0);
            this.tabs[i].setText(tabName);
            this.tabs[i].setToolTipText(tabName);
            ArrayList<ValidationItem> validationItemsThisTab = new ArrayList<ValidationItem>();
            this.tabItemsMap.put(this.tabs[i], validationItemsThisTab);
            Composite tabComposite = new Composite((Composite)this.tabFolder, 0);
            GridLayout tabLayout = new GridLayout();
            tabLayout.marginHeight = 4;
            tabComposite.setLayout((Layout)tabLayout);
            tabComposite.setLayoutData((Object)new GridData(1808));
            this.tabs[i].setControl((Control)tabComposite);
            String tabDescriptionText = String.valueOf(tabName) + " " + Util.getString("ValidationPreferencePage.validationControlSettings", new Object[0]);
            Label tabDescriptionLabel = new Label(tabComposite, 0);
            tabDescriptionLabel.setText(tabDescriptionText);
            ScrolledComposite tabScrollPane = new ScrolledComposite(tabComposite, 768);
            Point pt = tabScrollPane.getParent().computeSize(-1, -1);
            tabScrollPane.setExpandHorizontal(true);
            tabScrollPane.setExpandVertical(true);
            tabScrollPane.setMinWidth(pt.x);
            tabScrollPane.setMinHeight(pt.y);
            GridLayout tabScrollPaneLayout = new GridLayout();
            tabScrollPaneLayout.marginHeight = 0;
            tabScrollPaneLayout.marginWidth = 0;
            tabScrollPane.setLayout((Layout)tabScrollPaneLayout);
            GridData tabScrollPaneGridData = new GridData(1808);
            tabScrollPaneGridData.horizontalIndent = 4;
            tabScrollPane.setLayoutData((Object)tabScrollPaneGridData);
            Composite groupContents = new Composite((Composite)tabScrollPane, 0);
            tabScrollPane.setContent((Control)groupContents);
            GridLayout groupContentsLayout = new GridLayout();
            groupContents.setLayout((Layout)groupContentsLayout);
            groupContentsLayout.marginHeight = 0;
            groupContents.setLayoutData((Object)new GridData(1808));
            for (ValidationDescriptor vd : this.descriptors) {
                String descriptorTabName = vd.getPreferenceCategory();
                if (descriptorTabName == null || descriptorTabName.equals(BLANK)) {
                    descriptorTabName = TAB_NAME_FOR_BLANK;
                }
                if (!descriptorTabName.equals(tabName)) continue;
                ValidationItem vi = new ValidationItem(groupContents, vd);
                validationItemsThisTab.add(vi);
            }
            ++i;
        }
        this.setValues();
        this.setValid(true);
        this.tabFolder.setSelection(0);
        return this.tabFolder;
    }

    private void setValues() {
        this.currentValuesMap = ModelerCore.getValidationPreferences().getOptions();
        int i = 0;
        while (i < this.tabs.length) {
            List itemsThisTab = (List)this.tabItemsMap.get(this.tabs[i]);
            for (ValidationItem item : itemsThisTab) {
                ValidationDescriptor descriptor = item.getDescriptor();
                String itemName = String.valueOf(descriptor.getExtensionID()) + "." + descriptor.getPreferenceName();
                String currentValue = (String)this.currentValuesMap.get(itemName);
                if (currentValue == null) {
                    String defaultValue;
                    currentValue = defaultValue = descriptor.getDefaultOption();
                }
                item.setToValue(currentValue, true);
            }
            ++i;
        }
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        HashMap<ValidationDescriptor, String> changedValuesMap = new HashMap<ValidationDescriptor, String>();
        boolean changeMade = false;
        int i = 0;
        while (i < this.tabs.length) {
            List items = (List)this.tabItemsMap.get(this.tabs[i]);
            Iterator it = items.iterator();
            while (it.hasNext()) {
                ValidationItem item;
                ValidationDescriptor descriptor = (item = (ValidationItem)((Object)it.next())).getDescriptor();
                String itemName = String.valueOf(descriptor.getExtensionID()) + "." + descriptor.getPreferenceName();
                boolean nullIfUnchanged = this.currentValuesMap.get(itemName) != null;
                String changedValue = item.getValue(nullIfUnchanged);
                if (changedValue == null) continue;
                changedValuesMap.put(descriptor, changedValue);
                changeMade = true;
            }
            ++i;
        }
        if (changeMade) {
            ModelerCore.getValidationPreferences().setOptions(changedValuesMap);
            MessageDialog dialog = new MessageDialog(this.getShell(), Util.getString("ValidationPreferencePage.dialogChangedTitle", new Object[0]), null, Util.getString("ValidationPreferencePage.dialogChangedMessage", new Object[0]), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
            int res = dialog.open();
            if (res == 0) {
                try {
                    final IWorkbenchWindow window = UiPlugin.getDefault().getCurrentWorkbenchWindow();
                    IRunnableWithProgress op = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            try {
                                ModelerCore.getWorkspace().build(15, monitor);
                                GlobalBuildAction build = new GlobalBuildAction(window, 6);
                                build.doBuild();
                            }
                            catch (CoreException ex) {
                                Util.log((Throwable)ex);
                            }
                        }
                    };
                    new ProgressMonitorDialog(this.getShell()).run(true, true, op);
                }
                catch (InvocationTargetException ex) {
                    Util.log((Throwable)ex);
                }
                catch (InterruptedException ex) {
                    Util.log((Throwable)ex);
                }
            } else if (res != 1) {
                return false;
            }
            this.setValues();
        }
        return true;
    }

    public void performDefaults() {
        int i = 0;
        while (i < this.tabs.length) {
            List items = (List)this.tabItemsMap.get(this.tabs[i]);
            for (ValidationItem item : items) {
                ValidationDescriptor descriptor = item.getDescriptor();
                String defaultValue = descriptor.getDefaultOption();
                item.setToValue(defaultValue, false);
            }
            ++i;
        }
        super.performDefaults();
    }
}

