/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.preferences.IGeneralPreferencePageContributor;

public class AutoOpenEditorPreferenceContributor
implements IGeneralPreferencePageContributor,
UiConstants {
    private static final String PREF_ID = "autoOpenEditorIfNeeded";
    private static final String PREFIX = I18nUtil.getPropertyPrefix(AutoOpenEditorPreferenceContributor.class);
    private Button btn;

    @Override
    public void createPreferenceEditor(Composite theParent) {
        this.btn = new Button(theParent, 32);
        this.btn.setText(Util.getStringOrKey(String.valueOf(PREFIX) + "btn.text"));
        this.refresh();
    }

    private IPreferenceStore getPreferenceStore() {
        return UiPlugin.getDefault().getPreferenceStore();
    }

    private boolean getPreferenceStoreValue(boolean theDefaultFlag) {
        boolean result = false;
        IPreferenceStore prefStore = this.getPreferenceStore();
        String value = null;
        value = theDefaultFlag ? prefStore.getDefaultString(PREF_ID) : prefStore.getString(PREF_ID);
        if (value.equals("always")) {
            result = true;
        }
        return result;
    }

    @Override
    public String getName() {
        return Util.getStringOrKey(String.valueOf(PREFIX) + "name");
    }

    @Override
    public String getToolTip() {
        return Util.getStringOrKey(String.valueOf(PREFIX) + "toolTip");
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public boolean performDefaults() {
        this.btn.setSelection(this.getPreferenceStoreValue(true));
        return true;
    }

    @Override
    public boolean performOk() {
        String value = "never";
        if (this.btn.getSelection()) {
            value = "always";
        }
        this.getPreferenceStore().setValue(PREF_ID, value);
        return true;
    }

    @Override
    public void refresh() {
        this.btn.setSelection(this.getPreferenceStoreValue(false));
    }

    @Override
    public void setWorkbench(IWorkbench theWorkbench) {
    }
}

