/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.forms;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class FormTextObjectEditor {
    private static final String LINK_VALUE = "val";
    private static final String LINK_CHANGE = "chg";
    private static final String HTML_LINK_CHANGE_BEGIN = " <a nowrap=\"true\" href=\"chg\">";
    public static final String HTML_LINK_VAL_BEGIN = "<a nowrap=\"true\" href=\"val\">";
    public static final String HTML_LINK_END = "</a>";
    private ScrolledForm toReflow;
    private FormText text;
    private boolean editible;
    private Object value;
    private final String addText;
    private final String changeText;
    private final boolean valueClickable;
    private IHyperlinkListener myListener;

    public FormTextObjectEditor(String addText, String changeText, boolean valueClickable) {
        this.addText = addText;
        this.changeText = changeText;
        this.valueClickable = valueClickable;
        this.myListener = new MyHyperlinkListener();
    }

    public FormText getFormText() {
        return this.text;
    }

    public void setEditible(boolean editible) {
        if (editible != this.editible) {
            this.editible = editible;
            this.updateText();
        }
    }

    public void setValue(Object newValue) {
        if (this.value != newValue) {
            this.value = newValue;
            this.updateText();
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void addControl(Composite parent, int style) {
        this.text = new FormText(parent, style);
        this.text.addHyperlinkListener(this.myListener);
        this.updateText();
    }

    public Control addControl(ScrolledForm toReflow, Composite parent, FormToolkit ftk) {
        this.toReflow = toReflow;
        this.text = ftk.createFormText(parent, false);
        this.text.addHyperlinkListener(this.myListener);
        this.updateText();
        return this.text;
    }

    public void updateText() {
        if (this.text != null && !this.text.isDisposed()) {
            String html = this.getHTMLText(this.value, this.editible);
            this.text.setText(html, true, false);
            if (this.toReflow != null) {
                this.toReflow.reflow(true);
            }
        }
    }

    protected Object changeValue(Object startingValue) {
        return startingValue;
    }

    protected void valueClicked(Object value) {
    }

    private String getHTMLText(Object value, boolean editible) {
        StringBuffer sb = new StringBuffer("<form><p>");
        if (value != null) {
            if (this.valueClickable) {
                sb.append(HTML_LINK_VAL_BEGIN);
            }
            sb.append(this.getDisplayString(value));
            if (this.valueClickable) {
                sb.append(HTML_LINK_END);
            }
            if (editible) {
                sb.append(HTML_LINK_CHANGE_BEGIN);
                sb.append(this.changeText);
                sb.append(HTML_LINK_END);
            }
        } else if (editible && this.addText != null) {
            sb.append(HTML_LINK_CHANGE_BEGIN);
            sb.append(this.addText);
            sb.append(HTML_LINK_END);
        }
        sb.append("</p></form>");
        return sb.toString();
    }

    protected String getDisplayString(Object value) {
        return value.toString();
    }

    class MyHyperlinkListener
    implements IHyperlinkListener {
        MyHyperlinkListener() {
        }

        public void linkEntered(HyperlinkEvent e) {
        }

        public void linkExited(HyperlinkEvent e) {
        }

        public void linkActivated(HyperlinkEvent e) {
            Object link = e.getHref();
            if (FormTextObjectEditor.LINK_CHANGE.equals(link)) {
                FormTextObjectEditor.this.setValue(FormTextObjectEditor.this.changeValue(FormTextObjectEditor.this.getValue()));
            } else if (FormTextObjectEditor.LINK_VALUE.equals(link)) {
                FormTextObjectEditor.this.valueClicked(FormTextObjectEditor.this.getValue());
            }
        }
    }
}

