/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.explorer;

import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelExplorerSelectionHelper {
    private TreeViewer viewer;

    public ModelExplorerSelectionHelper(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public IStructuredSelection getBestSelection() {
        return this.getBestSelection(this.viewer.getSelection());
    }

    public IStructuredSelection getBestSelection(ISelection theSelection) {
        IResource resrc = null;
        if (SelectionUtilities.isAllEObjects((ISelection)theSelection)) {
            EObject eObj = (EObject)SelectionUtilities.getSelectedEObjects((ISelection)theSelection).get(0);
            ModelResource mr = ModelUtilities.getModelResourceForModelObject(eObj);
            if (mr != null) {
                try {
                    resrc = mr.getUnderlyingResource();
                }
                catch (ModelWorkspaceException e) {
                    UiConstants.Util.log((Throwable)e);
                }
            }
        } else if (!SelectionUtilities.isEmptySelection((ISelection)theSelection)) {
            Object obj = SelectionUtilities.getSelectedObjects((ISelection)theSelection).get(0);
            if (obj instanceof EObject) {
                ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)obj);
                if (mr != null) {
                    try {
                        resrc = mr.getUnderlyingResource();
                    }
                    catch (ModelWorkspaceException e) {
                        UiConstants.Util.log((Throwable)e);
                    }
                }
            } else if (obj instanceof IResource) {
                resrc = (IResource)obj;
            }
        }
        if (resrc == null) {
            return new StructuredSelection();
        }
        return new StructuredSelection(resrc);
    }
}

