/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.explorer;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.actions.RefreshAction;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.framelist.BackAction;
import org.eclipse.ui.views.framelist.ForwardAction;
import org.eclipse.ui.views.framelist.GoIntoAction;
import org.eclipse.ui.views.navigator.ResourceNavigator;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.core.designer.event.EventSourceException;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.runtime.spi.EventManager;
import org.teiid.designer.runtime.spi.ExecutionConfigurationEvent;
import org.teiid.designer.runtime.spi.IExecutionConfigurationListener;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerManager;
import org.teiid.designer.runtime.spi.ITeiidServerVersionListener;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.DelegatableAction;
import org.teiid.designer.ui.actions.DeleteAction;
import org.teiid.designer.ui.actions.IModelerActionConstants;
import org.teiid.designer.ui.actions.ModelProjectActionManager;
import org.teiid.designer.ui.actions.ModelResourceActionManager;
import org.teiid.designer.ui.actions.ModelerActionBarIdManager;
import org.teiid.designer.ui.actions.ModelerActionService;
import org.teiid.designer.ui.actions.ModelerGlobalActionsMap;
import org.teiid.designer.ui.actions.ModelerSpecialActionManager;
import org.teiid.designer.ui.actions.PasteInResourceAction;
import org.teiid.designer.ui.actions.PasteSpecialAction;
import org.teiid.designer.ui.actions.PropertyDialogAction;
import org.teiid.designer.ui.actions.RemoveProjectAction;
import org.teiid.designer.ui.actions.SortModelContentsAction;
import org.teiid.designer.ui.common.actions.ActionService;
import org.teiid.designer.ui.common.actions.ExtendedMenuManager;
import org.teiid.designer.ui.common.actions.GlobalActionsMap;
import org.teiid.designer.ui.common.actions.IActionConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.graphics.GlobalUiFontManager;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.editors.ModelEditorSelectionSynchronizer;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerDragAdapter;
import org.teiid.designer.ui.explorer.ModelExplorerDropAdapter;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.explorer.ModelExplorerMoveAction;
import org.teiid.designer.ui.explorer.ModelExplorerNewAction;
import org.teiid.designer.ui.explorer.ModelExplorerNotificationHandler;
import org.teiid.designer.ui.explorer.ModelExplorerRenameAction;
import org.teiid.designer.ui.explorer.ModelExplorerSelectionHelper;
import org.teiid.designer.ui.forms.FormUtil;
import org.teiid.designer.ui.product.IModelerProductContexts;
import org.teiid.designer.ui.properties.ModelObjectPropertySourceProvider;
import org.teiid.designer.ui.refactor.rename.RenameRefactorAction;
import org.teiid.designer.ui.search.IModelObjectMatch;
import org.teiid.designer.ui.search.MetadataMatchInfo;
import org.teiid.designer.ui.util.EObjectTransfer;
import org.teiid.designer.ui.views.ModelViewer;
import org.teiid.designer.ui.viewsupport.IExtendedModelObject;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;
import org.teiid.designer.ui.viewsupport.StatusBarUpdater;

public class ModelExplorerResourceNavigator
extends ResourceNavigator
implements IModelerActionConstants,
IGotoMarker,
ModelViewer,
UiConstants {
    static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ModelExplorerResourceNavigator.class);
    private static final String CREATE_RENAME_ACTION_ERROR_MESSAGE = ModelExplorerResourceNavigator.getString("createRenameActionErrorMessage");
    public static final String MODELING_LABEL = UiConstants.Util.getString("ModelerSpecialActionManager.specialLabel", new Object[0]);
    public static final String CONNECTION_LABEL = UiConstants.Util.getString("ModelResourceActionManager.connectionLabel", new Object[0]);
    protected static final String MENU_START_ID = "menuStart";
    protected static final String IMPORT_ACTION_ID = "modelExplorer.importAction";
    protected static final String EXPORT_ACTION_ID = "modelExplorer.exportAction";
    private static List<String> definedFilters;
    private static List<String> defaultFilters;
    private static Image changeServerImage;
    private ModelObjectPropertySourceProvider propertySourceProvider;
    private ISelectionListener selectionListener;
    private INotifyChangedListener notificationHandler;
    private ModelerGlobalActionsMap actionsMap;
    private ModelExplorerRenameAction renameAction;
    private ModelExplorerMoveAction moveAction;
    private ModelExplorerCopyAction copyAction;
    private RemoveProjectAction removeProjectAction;
    private IAction refreshAction;
    private IAction sortModelContentsAction;
    private IResourceChangeListener markerListener;
    private EventObjectListener modelResourceListener;
    private PropertyDialogAction propertyAction;
    private MenuManager menuMgr;
    private IPartListener partListener;
    private FormToolkit toolkit;
    private Composite contentsPanel;
    private Section defaultServerSection;
    private Composite defaultServerSectionBody;
    private Hyperlink defaultServerLink;
    private Label defaultTeiidVersionLabel;
    private Label defaultServerStatusLabel;
    private Label defaultTeiidStatusLabel;
    private ITeiidServerVersionListener teiidServerVersionListener = new ITeiidServerVersionListener(){

        public void serverChanged(ITeiidServer server) {
            if (ModelExplorerResourceNavigator.this.defaultServerLink == null || ModelExplorerResourceNavigator.this.defaultServerStatusLabel == null || ModelExplorerResourceNavigator.this.defaultTeiidVersionLabel == null) {
                return;
            }
            UiUtil.runInSwtThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ModelExplorerResourceNavigator.this.setDefaultServerText(ModelerCore.getDefaultServerName());
                    ModelExplorerResourceNavigator.this.setDefaultServerStatusIcon(ModelerCore.isDefaultParentConnected());
                    ModelExplorerResourceNavigator.this.setDefaultTeiidInstanceStatusIcon(ModelerCore.isDefaultTeiidConnected());
                    ModelExplorerResourceNavigator.this.setDefaultTeiidVersionText(ModelerCore.getTeiidServerVersion());
                }
            }, (boolean)true);
            if (server != null) {
                ModelExplorerResourceNavigator.this.addExecutionConfigurationListener(server.getEventManager());
            }
        }

        public void versionChanged(ITeiidServerVersion version) {
            if (ModelExplorerResourceNavigator.this.defaultTeiidVersionLabel == null) {
                return;
            }
            ModelExplorerResourceNavigator.this.setDefaultTeiidVersionText(version);
        }
    };
    private IExecutionConfigurationListener execConfigurationListener = new IExecutionConfigurationListener(){

        public void configurationChanged(ExecutionConfigurationEvent event) {
            UiUtil.runInSwtThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ModelExplorerResourceNavigator.this.setDefaultServerText(ModelerCore.getDefaultServerName());
                    ModelExplorerResourceNavigator.this.setDefaultServerStatusIcon(ModelerCore.isDefaultParentConnected());
                    ModelExplorerResourceNavigator.this.setDefaultTeiidInstanceStatusIcon(ModelerCore.isDefaultTeiidConnected());
                    ModelExplorerResourceNavigator.this.setDefaultTeiidVersionText(ModelerCore.getTeiidServerVersion());
                }
            }, (boolean)true);
        }
    };

    static {
        changeServerImage = UiPlugin.getDefault().getImage("icons/full/cview16/configure.png");
    }

    public static List<String> getDefinedFilters() {
        if (definedFilters == null) {
            ModelExplorerResourceNavigator.readFilters();
        }
        return definedFilters;
    }

    static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static void readFilters() {
        if (definedFilters == null) {
            definedFilters = new ArrayList<String>();
            defaultFilters = new ArrayList<String>();
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "resourceFilters");
            if (extension != null) {
                IExtension[] extensions = extension.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        String selected;
                        String pattern = configElements[j].getAttribute("pattern");
                        if (pattern != null) {
                            definedFilters.add(pattern);
                        }
                        if ((selected = configElements[j].getAttribute("selected")) != null && selected.equalsIgnoreCase("true")) {
                            defaultFilters.add(pattern);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public void createPartControl(Composite parent) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.contentsPanel = this.toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.contentsPanel);
        GridLayoutFactory.fillDefaults().applyTo(this.contentsPanel);
        super.createPartControl(this.contentsPanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.getTreeViewer().getTree());
        this.createServerStatusPanel(this.contentsPanel);
        new ModelExplorerSelectionHelper(this.getTreeViewer());
        if (UiPlugin.getDefault().isProductContextSupported(IModelerProductContexts.Views.ID_MODEL_PROJECT_FILTER)) {
            ModelWorkspaceViewerFilter filter = new ModelWorkspaceViewerFilter(true, true, true);
            filter.setResourceFilter((ViewerFilter)this.getPatternFilter());
            this.getTreeViewer().addFilter((ViewerFilter)filter);
        }
        IWorkbenchWindow wdw = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        ModelerActionService svc = (ModelerActionService)UiPlugin.getDefault().getActionService(this.getSite().getPage());
        IActionBars bars = this.getViewSite().getActionBars();
        this.copyAction = new ModelExplorerCopyAction(bars, (ActionService)svc);
        wdw.getSelectionService().addSelectionListener((ISelectionListener)this.copyAction);
        this.removeProjectAction = new RemoveProjectAction();
        wdw.getSelectionService().addSelectionListener((ISelectionListener)this.removeProjectAction);
        svc.registerDefaultGlobalActions(bars);
        this.actionsMap = new ModelerGlobalActionsMap();
        try {
            bars.setGlobalActionHandler(IActionConstants.EclipseGlobalActions.COPY, (IAction)this.copyAction);
            this.renameAction = new ModelExplorerRenameAction(wdw.getShell(), this.getTreeViewer());
            this.renameAction.selectionChanged((IStructuredSelection)this.getTreeViewer().getSelection());
            this.actionsMap.put(IActionConstants.EclipseGlobalActions.RENAME, this.renameAction);
            bars.setGlobalActionHandler(IActionConstants.EclipseGlobalActions.RENAME, (IAction)this.renameAction);
            IAction deleteAction = svc.getAction(DeleteAction.class);
            bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), deleteAction);
            IAction pasteAction = svc.getAction(PasteInResourceAction.class);
            bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), pasteAction);
            this.moveAction = new ModelExplorerMoveAction(wdw.getShell(), this.getTreeViewer());
            bars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.moveAction);
            bars.updateActionBars();
        }
        catch (CoreException err) {
            Util.log((Throwable)err);
            WidgetUtil.showError((String)CREATE_RENAME_ACTION_ERROR_MESSAGE);
        }
        this.propertyAction = new PropertyDialogAction(this.getTreeViewer().getControl(), (ISelectionProvider)this.getTreeViewer());
        bars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertyAction);
        this.notificationHandler = this.getNotifyChangedListener();
        if (this.notificationHandler != null) {
            ModelUtilities.addNotifyChangedListener(this.notificationHandler);
        }
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
                this.checkResource(part);
            }

            private void checkResource(final IWorkbenchPart part) {
                if (part instanceof ModelEditor) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ModelExplorerResourceNavigator.this.getViewer().getTree().isDisposed()) {
                                ModelExplorerResourceNavigator.this.getViewer().refresh((Object)((ModelEditor)part).getModelFile());
                            }
                        }
                    });
                }
            }
        };
        this.getSite().getPage().addPartListener(this.partListener);
        this.markerListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IMarkerDelta[] deltas = event.findMarkerDeltas(null, true);
                if (deltas != null && deltas.length > 0) {
                    HashSet<IProject> projects = new HashSet<IProject>();
                    int i = 0;
                    while (i < deltas.length) {
                        projects.add(deltas[i].getResource().getProject());
                        ++i;
                    }
                    final Iterator itr = projects.iterator();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ModelExplorerResourceNavigator.this.getTreeViewer().getTree().isDisposed()) {
                                TreeViewer viewer = ModelExplorerResourceNavigator.this.getTreeViewer();
                                while (itr.hasNext()) {
                                    IProject project = (IProject)itr.next();
                                    viewer.refresh((Object)project, true);
                                }
                            }
                        }
                    });
                }
            }
        };
        ModelerCore.getWorkspace().addResourceChangeListener(this.markerListener);
        this.addCustomListeners();
        IUndoContext undoContext = (IUndoContext)ResourcesPlugin.getWorkspace().getAdapter(IUndoContext.class);
        UndoActionHandler undoAction = new UndoActionHandler(this.getSite(), undoContext);
        undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)undoAction);
        IContributionItem[] items = bars.getToolBarManager().getItems();
        ArrayList<IContributionItem> itemsToRemove = new ArrayList<IContributionItem>();
        IContributionItem[] iContributionItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem) {
                if (((ActionContributionItem)item).getAction() instanceof BackAction) {
                    itemsToRemove.add(item);
                }
                if (((ActionContributionItem)item).getAction() instanceof ForwardAction) {
                    itemsToRemove.add(item);
                }
                if (((ActionContributionItem)item).getAction() instanceof GoIntoAction) {
                    itemsToRemove.add(item);
                }
            }
            ++n2;
        }
        for (IContributionItem item : itemsToRemove) {
            bars.getToolBarManager().remove(item);
        }
    }

    private void createServerStatusPanel(Composite parent) {
        this.defaultServerSection = this.toolkit.createSection(parent, 322);
        Color bkgdColor = this.toolkit.getColors().getBackground();
        this.defaultServerSection.setText(ModelExplorerResourceNavigator.getString("defaultServerTitle"));
        this.defaultServerSection.setTitleBarForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.defaultServerSection);
        this.defaultServerSectionBody = new Composite((Composite)this.defaultServerSection, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.defaultServerSectionBody);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(this.defaultServerSectionBody);
        this.defaultServerSectionBody.setBackground(bkgdColor);
        Composite serverDetailsPanel = this.toolkit.createComposite(this.defaultServerSectionBody);
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)serverDetailsPanel);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(serverDetailsPanel);
        Label serverPrefixLabel = this.toolkit.createLabel(serverDetailsPanel, ModelExplorerResourceNavigator.getString("defaultServerPrefix"));
        serverPrefixLabel.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)serverPrefixLabel);
        this.defaultServerStatusLabel = this.toolkit.createLabel(serverDetailsPanel, "", 0);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.defaultServerStatusLabel);
        this.defaultServerLink = this.toolkit.createHyperlink(serverDetailsPanel, "", 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.defaultServerLink);
        this.defaultServerLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                try {
                    window.getActivePage().showView("org.eclipse.wst.server.ui.ServersView");
                    if (!ModelerCore.hasDefaultTeiidServer()) {
                        IHandlerService handlerService = (IHandlerService)ModelExplorerResourceNavigator.this.getSite().getService(IHandlerService.class);
                        handlerService.executeCommand("org.teiid.designer.dqp.ui.newServerAction", null);
                    } else {
                        IHandlerService handlerService = (IHandlerService)ModelExplorerResourceNavigator.this.getSite().getService(IHandlerService.class);
                        Event event = ModelerCore.createDefaultTeiidServerEvent();
                        handlerService.executeCommand("org.teiid.designer.dqp.ui.editServerAction", event);
                    }
                }
                catch (Exception ex) {
                    UiConstants.Util.log((Throwable)ex);
                }
            }
        });
        Label versionPrefixLabel = this.toolkit.createLabel(this.defaultServerSectionBody, ModelExplorerResourceNavigator.getString("defaultServerVersionPrefix"));
        versionPrefixLabel.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)versionPrefixLabel);
        this.defaultTeiidStatusLabel = this.toolkit.createLabel(this.defaultServerSectionBody, "", 0);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.defaultTeiidStatusLabel);
        this.defaultTeiidVersionLabel = this.toolkit.createLabel(this.defaultServerSectionBody, "");
        Font standardFont = this.defaultTeiidVersionLabel.getFont();
        FontData boldData = standardFont.getFontData()[0];
        boldData.setStyle(1);
        this.defaultTeiidVersionLabel.setFont(GlobalUiFontManager.getFont((FontData)boldData));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.defaultTeiidVersionLabel);
        this.createDefaultServerSectionToolbar();
        this.defaultServerSection.setClient((Control)this.defaultServerSectionBody);
        ServerVersionLoadingThread thread = new ServerVersionLoadingThread();
        thread.start();
    }

    private void createDefaultServerSectionToolbar() {
        Composite toolbar = FormUtil.createSectionToolBar(this.defaultServerSection, this.toolkit);
        ImageHyperlink changeDefaultServerLink = this.toolkit.createImageHyperlink(toolbar, 0);
        changeDefaultServerLink.setImage(changeServerImage);
        changeDefaultServerLink.setToolTipText(ModelExplorerResourceNavigator.getString("changeServerLinkTooltip"));
        changeDefaultServerLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    IHandlerService handlerService = (IHandlerService)ModelExplorerResourceNavigator.this.getSite().getService(IHandlerService.class);
                    handlerService.executeCommand("org.teiid.designer.dqp.ui.setDefaultServerAction", null);
                }
                catch (Exception ex) {
                    UiConstants.Util.log((Throwable)ex);
                }
            }
        });
    }

    private void addExecutionConfigurationListener(EventManager eventManager) {
        if (eventManager == null) {
            return;
        }
        eventManager.addListener(this.execConfigurationListener);
    }

    private void setDefaultServerText(String serverName) {
        if (this.defaultServerSectionBody.isDisposed() || this.defaultServerLink.isDisposed()) {
            return;
        }
        Display display = this.defaultServerSectionBody.getDisplay();
        final String hyperlinkText = serverName;
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ModelExplorerResourceNavigator.this.defaultServerLink.setText(hyperlinkText);
            }
        });
    }

    private void setDefaultServerStatusIcon(boolean serverConnected) {
        if (this.defaultServerSectionBody.isDisposed() || this.defaultServerStatusLabel.isDisposed()) {
            return;
        }
        Image newImage = null;
        String tooltip = null;
        if (serverConnected) {
            newImage = UiPlugin.getDefault().getImage("icons/full/cview16/jboss-started.png");
            tooltip = ModelExplorerResourceNavigator.getString("connectedDefaultServerTooltip");
        } else {
            newImage = UiPlugin.getDefault().getImage("icons/full/cview16/jboss-stopped.png");
            tooltip = ModelExplorerResourceNavigator.getString("disconnectedDefaultServerTooltip");
        }
        this.defaultServerStatusLabel.setImage(newImage);
        this.defaultServerStatusLabel.setToolTipText(tooltip);
        this.defaultServerStatusLabel.getParent().layout(true);
        this.defaultServerSectionBody.layout(true);
    }

    private void setDefaultTeiidVersionText(final ITeiidServerVersion teiidServerVersion) {
        if (this.defaultServerSectionBody == null || this.defaultServerSectionBody.isDisposed() || this.defaultTeiidVersionLabel.isDisposed()) {
            return;
        }
        Display display = this.defaultTeiidVersionLabel.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ModelExplorerResourceNavigator.this.defaultTeiidVersionLabel.setText(teiidServerVersion.toString());
            }
        });
    }

    private void setDefaultTeiidInstanceStatusIcon(boolean teiidConnected) {
        if (this.defaultServerSectionBody.isDisposed() || this.defaultTeiidStatusLabel.isDisposed()) {
            return;
        }
        Image newImage = null;
        String tooltip = null;
        if (teiidConnected) {
            newImage = UiPlugin.getDefault().getImage("icons/full/cview16/teiid-server-default.png");
            tooltip = ModelExplorerResourceNavigator.getString("connectedDefaultTeiidTooltip");
        } else {
            newImage = UiPlugin.getDefault().getImage("icons/full/cview16/teiid-server-disconnected.png");
            tooltip = ModelExplorerResourceNavigator.getString("disconnectedDefaultTeiidTooltip");
        }
        this.defaultTeiidStatusLabel.setImage(newImage);
        this.defaultTeiidStatusLabel.setToolTipText(tooltip);
        this.defaultTeiidStatusLabel.getParent().layout(true);
        this.defaultServerSectionBody.layout(true);
    }

    protected void addCustomListeners() {
        this.modelResourceListener = new EventObjectListener(){

            public void processEvent(EventObject obj) {
                ModelResourceEvent event = (ModelResourceEvent)obj;
                if (event.getType() == 2) {
                    final IResource file = event.getResource();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ModelExplorerResourceNavigator.this.getTreeViewer().getTree().isDisposed()) {
                                ModelExplorerResourceNavigator.this.getTreeViewer().collapseToLevel((Object)file, -1);
                            }
                        }
                    });
                } else if (event.getType() == 3) {
                    final IResource file = event.getResource();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ModelExplorerResourceNavigator.this.getTreeViewer().getTree().isDisposed()) {
                                ModelExplorerResourceNavigator.this.getTreeViewer().remove((Object)file);
                                ModelExplorerResourceNavigator.this.getTreeViewer().refresh((Object)file.getParent(), false);
                            }
                        }
                    });
                } else if (event.getType() == 6) {
                    final IResource file = event.getResource();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ModelExplorerResourceNavigator.this.getTreeViewer().getTree().isDisposed()) {
                                ModelExplorerResourceNavigator.this.getTreeViewer().refresh((Object)file.getParent(), false);
                            }
                        }
                    });
                }
            }
        };
        try {
            UiPlugin.getDefault().getEventBroker().addListener(ModelResourceEvent.class, this.modelResourceListener);
        }
        catch (EventSourceException e) {
            Util.log(4, (Throwable)e, e.getMessage());
        }
    }

    protected IAction getRefreshAction() {
        if (this.refreshAction == null) {
            this.refreshAction = new RefreshAction((IShellProvider)this.getViewSite());
            this.refreshAction.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/refresh.gif"));
            this.refreshAction.setToolTipText(ModelExplorerResourceNavigator.getString("refreshAction.tooltip"));
            this.refreshAction.setText(ModelExplorerResourceNavigator.getString("refreshAction.text"));
            this.refreshAction.setId("modelExplorerResourceNavigator.refreshAction");
        }
        return this.refreshAction;
    }

    protected void makeActions() {
        super.makeActions();
        this.getViewSite().getActionBars().getMenuManager().add((IContributionItem)new GroupMarker(MENU_START_ID));
        this.getViewSite().getActionBars().getMenuManager().add((IAction)new ShowImportsAction());
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)new ModelExplorerNewAction());
        IAction previewAction = this.getPreviewDataAction();
        if (previewAction != null) {
            this.getViewSite().getActionBars().getToolBarManager().add((IContributionItem)new Separator());
            this.getViewSite().getActionBars().getToolBarManager().add(previewAction);
            this.getViewSite().getActionBars().getToolBarManager().add((IContributionItem)new Separator());
        }
        this.getViewSite().getActionBars().getToolBarManager().add(this.getSortModelContentsAction());
        this.getViewSite().getActionBars().getToolBarManager().add(this.getRefreshAction());
    }

    protected IAction getSortModelContentsAction() {
        if (this.sortModelContentsAction == null) {
            this.sortModelContentsAction = new SortModelContentsAction((ContentViewer)this.getTreeViewer());
        }
        return this.sortModelContentsAction;
    }

    protected IAction getPreviewDataAction() {
        return ModelerSpecialActionManager.getAction("org.teiid.designer.runtime.ui.preview.PreviewTableDataContextAction");
    }

    public void dispose() {
        ModelerCore.removeTeiidServerVersionListener((ITeiidServerVersionListener)this.teiidServerVersionListener);
        this.getViewSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.getModelObjectSelectionListener());
        if (this.copyAction != null) {
            this.getViewSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this.copyAction);
        }
        if (this.propertySourceProvider != null) {
            this.propertySourceProvider.dispose();
        }
        if (this.notificationHandler != null) {
            ModelUtilities.removeNotifyChangedListener(this.notificationHandler);
        }
        if (this.markerListener != null) {
            ModelerCore.getWorkspace().removeResourceChangeListener(this.markerListener);
        }
        if (this.modelResourceListener != null) {
            try {
                UiPlugin.getDefault().getEventBroker().removeListener(this.modelResourceListener);
            }
            catch (EventSourceException e) {
                Util.log(4, (Throwable)e, e.getMessage());
            }
        }
        if (this.partListener != null) {
            this.getSite().getPage().removePartListener(this.partListener);
        }
        if (this.getViewer().getContentProvider() != null) {
            this.getViewer().getContentProvider().dispose();
        }
        if (this.getViewer().getLabelProvider() != null) {
            this.getViewer().getLabelProvider().dispose();
        }
        super.dispose();
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            if (this.propertySourceProvider == null) {
                this.propertySourceProvider = ModelUtilities.getPropertySourceProvider();
            }
            return this.propertySourceProvider.getPropertySheetPage();
        }
        return super.getAdapter(key);
    }

    protected IShowInTarget getShowInTarget() {
        return new IShowInTarget(){

            public boolean show(ShowInContext context) {
                HashSet<EObject> toSelect = new HashSet<EObject>();
                ISelection sel = context.getSelection();
                if (sel instanceof IStructuredSelection) {
                    Object[] objectArray = ((IStructuredSelection)sel).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (obj instanceof IModelObjectMatch) {
                            EObject eObj = ((IModelObjectMatch)obj).getEObject();
                            if (eObj != null) {
                                toSelect.add(eObj);
                            }
                        } else if (obj instanceof MetadataMatchInfo) {
                            Match[] matches;
                            Match[] matchArray = matches = ((MetadataMatchInfo)obj).getMatches();
                            int n3 = matches.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                EObject eObj;
                                Match match = matchArray[n4];
                                if (match instanceof IModelObjectMatch && (eObj = ((IModelObjectMatch)match).getEObject()) != null) {
                                    toSelect.add(eObj);
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                if (!toSelect.isEmpty()) {
                    ModelExplorerResourceNavigator.this.getViewer().getControl().setRedraw(false);
                    ModelExplorerResourceNavigator.this.getViewer().setSelection((ISelection)new StructuredSelection(toSelect.toArray()), true);
                    ModelExplorerResourceNavigator.this.getViewer().getControl().setRedraw(true);
                    return true;
                }
                return ModelExplorerResourceNavigator.this.superShowInTarget(context);
            }
        };
    }

    boolean superShowInTarget(ShowInContext context) {
        return super.getShowInTarget().show(context);
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        this.updateActionBars(sel);
        this.linkToEditor(sel);
    }

    protected void initContentProvider(TreeViewer viewer) {
        viewer.setContentProvider((IContentProvider)new ModelExplorerContentProvider());
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                ISelection selection = e.getSelection();
                if (SelectionUtilities.isSingleSelection((ISelection)selection) && SelectionUtilities.getSelectedEObject((ISelection)selection) != null) {
                    EObject eObj = SelectionUtilities.getSelectedEObject((ISelection)selection);
                    ModelEditorManager.open(eObj, true, 3);
                } else {
                    ModelEditorSelectionSynchronizer.handleDoubleClick(e);
                }
            }
        });
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        viewer.addSelectionChangedListener((ISelectionChangedListener)new StatusBarUpdater(slManager));
        this.getViewSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.getModelObjectSelectionListener());
        this.getViewSite().setSelectionProvider(this.getModelObjectSelectionProvider());
    }

    public void addContextMenuListener(IMenuListener theListener) {
        this.menuMgr.addMenuListener(theListener);
    }

    public void removeContextMenuListener(IMenuListener theListener) {
        this.menuMgr.removeMenuListener(theListener);
    }

    protected void initContextMenu() {
        this.menuMgr = new ExtendedMenuManager("explorer.contextMenu");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager theMenuMgr) {
                ModelExplorerResourceNavigator.this.fillContextMenu(theMenuMgr);
            }
        });
        TreeViewer viewer = this.getTreeViewer();
        Menu menu = this.menuMgr.createContextMenu((Control)viewer.getTree());
        viewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(this.menuMgr, (ISelectionProvider)viewer);
    }

    private void overrideAction(IMenuManager theMenu, String ActionId, IAction newAction) throws CoreException {
        if (theMenu.find(ActionId) == null) {
            return;
        }
        theMenu.insertAfter(ActionId, newAction);
        theMenu.remove(ActionId);
        if (newAction instanceof BaseSelectionListenerAction) {
            ((BaseSelectionListenerAction)newAction).selectionChanged((IStructuredSelection)this.getTreeViewer().getSelection());
        } else if (newAction instanceof SelectionProviderAction) {
            ((SelectionProviderAction)newAction).selectionChanged((IStructuredSelection)this.getTreeViewer().getSelection());
        }
    }

    private void overrideAction(IMenuManager theMenu, String ActionId, Class<? extends IAction> newActionClass) throws CoreException {
        IAction action = this.getActionService().getAction(newActionClass);
        this.overrideAction(theMenu, ActionId, action);
    }

    private IMenuManager createRefactorMenu() {
        MenuManager refactorMenu = new MenuManager(UiConstants.Util.getString("ModelerActionService.RefactorMenu.title", new Object[0]), ModelerActionBarIdManager.getRefactorMenuId());
        refactorMenu.add((IContributionItem)new GroupMarker("reorgStart"));
        refactorMenu.add((IAction)this.renameAction);
        refactorMenu.add((IAction)this.moveAction);
        refactorMenu.add((IContributionItem)new GroupMarker("reorgEnd"));
        StructuredSelection selection = new StructuredSelection();
        if (this.getViewer().getSelection() instanceof IStructuredSelection) {
            selection = (IStructuredSelection)this.getViewer().getSelection();
        }
        this.renameAction.selectionChanged((IStructuredSelection)selection);
        this.moveAction.selectionChanged((IStructuredSelection)selection);
        return refactorMenu;
    }

    protected void fillContextMenu(IMenuManager theMenu) {
        Object obj;
        ISelection selection = this.getViewer().getSelection();
        if (ModelExplorerResourceNavigator.isAllExtendedModelObjects(selection)) {
            Object[] objs = SelectionUtilities.getSelectedObjects((ISelection)selection).toArray();
            boolean didOverride = false;
            int i = 0;
            while (i < objs.length) {
                IExtendedModelObject obj2 = (IExtendedModelObject)objs[i];
                if (obj2.overrideContextMenu()) {
                    didOverride = true;
                    obj2.fillContextMenu(theMenu);
                }
                ++i;
            }
            if (didOverride) {
                if (theMenu.find("additions") == null) {
                    theMenu.add((IContributionItem)new Separator("additions"));
                }
                return;
            }
        }
        if (SelectionUtilities.isAllEObjects((ISelection)selection)) {
            this.getActionService().contributeToContextMenu(theMenu, this.actionsMap, selection);
        } else {
            super.fillContextMenu(theMenu);
            try {
                this.overrideAction(theMenu, "org.eclipse.ui.DeleteResourceAction", DeleteAction.class);
                if (SelectionUtilities.isSingleSelection((ISelection)selection) && (obj = SelectionUtilities.getSelectedObject((ISelection)selection)) instanceof IResource && ModelUtilities.isModelFile((IResource)obj) && theMenu.find("org.eclipse.ui.PasteAction") != null) {
                    IAction pasteSpecialAction = this.getActionService().getAction(PasteSpecialAction.class);
                    theMenu.insertAfter("org.eclipse.ui.PasteAction", pasteSpecialAction);
                }
                this.overrideAction(theMenu, "org.eclipse.ui.PasteAction", PasteInResourceAction.class);
                IMenuManager refactorMenu = this.createRefactorMenu();
                if (theMenu.find("org.eclipse.ui.RenameResourceAction") != null) {
                    theMenu.insertAfter("org.eclipse.ui.RenameResourceAction", (IContributionItem)refactorMenu);
                } else {
                    theMenu.insertBefore("additions", (IContributionItem)refactorMenu);
                }
                theMenu.remove("org.eclipse.ui.RenameResourceAction");
                theMenu.remove("org.eclipse.ui.MoveResourceAction");
                if (theMenu.find(ActionFactory.PROPERTIES.getId()) == null) {
                    IContributionItem[] items = theMenu.getItems();
                    IContributionItem oldItem = null;
                    int i = items.length - 1;
                    while (i >= 0) {
                        IAction action;
                        if (items[i] instanceof ActionContributionItem && (action = ((ActionContributionItem)items[i]).getAction()) instanceof org.eclipse.ui.dialogs.PropertyDialogAction) {
                            action.setId(ActionFactory.PROPERTIES.getId());
                            oldItem = items[i];
                            break;
                        }
                        --i;
                    }
                    if (oldItem != null) {
                        theMenu.remove(oldItem);
                        theMenu.add((IAction)this.propertyAction);
                    }
                }
                this.overrideAction(theMenu, ActionFactory.PROPERTIES.getId(), (IAction)this.propertyAction);
            }
            catch (CoreException theException) {
                Util.log((Throwable)theException);
            }
            if (theMenu.find("org.eclipse.ui.OpenFileAction") != null) {
                theMenu.insertBefore("org.eclipse.ui.OpenFileAction", (IContributionItem)new GroupMarker("insertStart"));
                theMenu.insertAfter("insertStart", (IContributionItem)new Separator("insertEnd"));
            } else {
                IContributionItem[] items = theMenu.getItems();
                theMenu.removeAll();
                String sepID = "separator_999";
                boolean foundFirstSeparator = false;
                IContributionItem[] iContributionItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    if (!foundFirstSeparator && item.isSeparator()) {
                        foundFirstSeparator = true;
                        Separator sep = new Separator(sepID);
                        theMenu.add((IContributionItem)sep);
                    } else {
                        theMenu.add(item);
                    }
                    ++n2;
                }
                theMenu.insertBefore(sepID, (IContributionItem)new GroupMarker("insertStart"));
                theMenu.insertAfter("insertStart", (IContributionItem)new Separator("insertEnd"));
            }
            if (SelectionUtilities.isSingleSelection((ISelection)selection) && (obj = SelectionUtilities.getSelectedObject((ISelection)selection)) instanceof IResource && ModelUtilities.isModelFile((IResource)obj)) {
                MenuManager newChildMenu = this.getActionService().getInsertChildMenu(selection);
                this.getActionService().contributePermanentActionsToContextMenu((IMenuManager)newChildMenu, selection);
                theMenu.insertAfter("insertStart", (IContributionItem)newChildMenu);
            }
            theMenu.insertBefore(ActionFactory.IMPORT.getId(), (IContributionItem)new GroupMarker("modelStart"));
            theMenu.insertBefore(ActionFactory.IMPORT.getId(), (IContributionItem)new Separator("modelStart"));
            theMenu.insertAfter("modelStart", (IContributionItem)new GroupMarker("modelEnd"));
            MenuManager modelingActionMenu = this.getModelingActionMenu(selection);
            if (modelingActionMenu != null && modelingActionMenu.getItems().length > 0) {
                theMenu.insertBefore("insertEnd", (IContributionItem)modelingActionMenu);
            }
        }
        if (SelectionUtilities.isSingleSelection((ISelection)selection) && (obj = SelectionUtilities.getSelectedObject((ISelection)selection)) instanceof IProject) {
            MenuManager mpaMenu;
            if (!((IProject)obj).isOpen()) {
                theMenu.insertBefore("additions", (IAction)this.removeProjectAction);
            } else if (DotProjectUtils.isModelerProject((IProject)((IProject)obj)) && (mpaMenu = ModelProjectActionManager.getModelProjectActionMenu(selection)) != null && mpaMenu.getItems().length > 0) {
                theMenu.insertBefore("additions", (IContributionItem)mpaMenu);
            }
        }
        theMenu.updateAll(true);
    }

    public static boolean isAllExtendedModelObjects(ISelection theSelection) {
        boolean result;
        boolean bl = result = theSelection != null && !theSelection.isEmpty() && theSelection instanceof IStructuredSelection;
        if (result) {
            Object[] objs = SelectionUtilities.getSelectedObjects((ISelection)theSelection).toArray();
            int i = 0;
            while (i < objs.length) {
                if (result) {
                    result = objs[i] instanceof IExtendedModelObject;
                }
                ++i;
            }
        }
        return result;
    }

    private MenuManager getModelingActionMenu(ISelection theSelection) {
        MenuManager mraMenu;
        MenuManager menu = new MenuManager(MODELING_LABEL, ModelerActionBarIdManager.getModelingMenuId());
        MenuManager mosaMenu = ModelerSpecialActionManager.getModeObjectSpecialActionMenu(theSelection);
        if (mosaMenu != null && mosaMenu.getItems().length > 0) {
            IContributionItem[] items = mosaMenu.getItems();
            int i = 0;
            while (i < items.length) {
                menu.add(mosaMenu.getItems()[i]);
                ++i;
            }
            menu.add((IContributionItem)new Separator());
        }
        if ((mraMenu = ModelResourceActionManager.getModelResourceActionMenu(theSelection)) != null && mraMenu.getItems().length > 0) {
            IContributionItem[] items = mraMenu.getItems();
            int i = 0;
            while (i < items.length) {
                menu.add(mraMenu.getItems()[i]);
                ++i;
            }
        }
        return menu;
    }

    private MenuManager getConnectionActionMenu(ISelection theSelection) {
        MenuManager menu = new MenuManager(CONNECTION_LABEL, ModelerActionBarIdManager.getConnectionMenuId());
        MenuManager connMenu = ModelResourceActionManager.getModelResourceConnectionActionMenu(theSelection);
        if (connMenu != null && connMenu.getItems().length > 0) {
            IContributionItem[] items = connMenu.getItems();
            int i = 0;
            while (i < items.length) {
                menu.add(connMenu.getItems()[i]);
                ++i;
            }
        }
        return menu;
    }

    private ModelerActionService getActionService() {
        UiPlugin plugin = UiPlugin.getDefault();
        return (ModelerActionService)plugin.getActionService(this.getSite().getPage());
    }

    protected void initLabelProvider(TreeViewer viewer) {
        ModelExplorerLabelProvider lp = new ModelExplorerLabelProvider();
        ILabelDecorator decorator = this.getPlugin().getWorkbench().getDecoratorManager().getLabelDecorator();
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)lp, decorator));
    }

    protected void initDragAndDrop() {
        TreeViewer viewer = this.getTreeViewer();
        int ops = 3;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer(), ResourceTransfer.getInstance(), FileTransfer.getInstance(), PluginTransfer.getInstance(), EObjectTransfer.getInstance()};
        viewer.addDragSupport(ops, transfers, (DragSourceListener)new ModelExplorerDragAdapter((ISelectionProvider)this.getTreeViewer()));
        ModelExplorerDropAdapter adapter = new ModelExplorerDropAdapter((StructuredViewer)this.getTreeViewer());
        adapter.setFeedbackEnabled(false);
        viewer.addDropSupport(ops | 0x10, transfers, (DropTargetListener)adapter);
    }

    protected void restoreState(IMemento memento) {
        try {
            super.restoreState(memento);
        }
        catch (Exception ex) {
            UiConstants.Util.log((Throwable)ex);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)ModelExplorerResourceNavigator.this.getViewSite().getShell(), (String)Util.getString("ModelExplorerResourceNavigator.restoreStateError.title", new Object[0]), (String)Util.getString("ModelExplorerResourceNavigator.restoreStateError.text", (Object)ex.getLocalizedMessage()));
                }
            });
        }
    }

    @Override
    public void addModelObjectDoubleClickListener(IDoubleClickListener listener) {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().addDoubleClickListener(listener);
        }
    }

    public ISelectionListener getModelObjectSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, final ISelection selection) {
                    if (part != ModelExplorerResourceNavigator.this && ModelExplorerResourceNavigator.this.isSynchronized() && selection instanceof IStructuredSelection && !selection.isEmpty()) {
                        int nEObj;
                        int nObj = ((IStructuredSelection)selection).size();
                        if (nObj == (nEObj = SelectionUtilities.getSelectedEObjects((ISelection)selection).size())) {
                            ModelExplorerResourceNavigator.this.getTreeViewer().setSelection(selection, true);
                        } else if (nObj == 1 && ((IStructuredSelection)selection).getFirstElement() instanceof IResource) {
                            ModelExplorerResourceNavigator.this.getTreeViewer().getControl().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!ModelExplorerResourceNavigator.this.getTreeViewer().getControl().isDisposed()) {
                                        ModelExplorerResourceNavigator.this.getTreeViewer().setSelection(selection, true);
                                        if (ModelExplorerResourceNavigator.this.getTreeViewer().getSelection().isEmpty()) {
                                            ITreeContentProvider cp = (ITreeContentProvider)ModelExplorerResourceNavigator.this.getTreeViewer().getContentProvider();
                                            Object parent = cp.getParent(((IStructuredSelection)selection).getFirstElement());
                                            if (parent == null) {
                                                ModelExplorerResourceNavigator.this.getTreeViewer().refresh(true);
                                            } else {
                                                ModelExplorerResourceNavigator.this.getTreeViewer().refresh(parent, true);
                                            }
                                            ModelExplorerResourceNavigator.this.getTreeViewer().setSelection(selection, true);
                                        }
                                    }
                                }
                            });
                        }
                    }
                }
            };
        }
        return this.selectionListener;
    }

    public ISelectionProvider getModelObjectSelectionProvider() {
        return this.getTreeViewer();
    }

    public void gotoMarker(IMarker theMarker) {
        EObject targetEObject = ModelObjectUtilities.getMarkedEObject(theMarker);
        if (targetEObject != null) {
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)targetEObject), true);
        }
    }

    public boolean isSynchronized() {
        return this.isLinkingEnabled();
    }

    @Override
    public void removeModelObjectDoubleClickListener(IDoubleClickListener listener) {
        this.getTreeViewer().removeDoubleClickListener(listener);
    }

    protected void updateActionBars(IStructuredSelection selection) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return;
        }
        if (workbenchWindow.getShell() == null || !workbenchWindow.getShell().isVisible()) {
            return;
        }
        super.updateActionBars(selection);
        if (this.renameAction != null) {
            this.renameAction.selectionChanged(selection);
        }
        if (this.moveAction != null) {
            this.moveAction.selectionChanged(selection);
        }
    }

    private INotifyChangedListener getNotifyChangedListener() {
        if (this.notificationHandler == null) {
            this.notificationHandler = this.createNotifyChangedListener();
        }
        return this.notificationHandler;
    }

    protected INotifyChangedListener createNotifyChangedListener() {
        return new ModelExplorerNotificationHandler(this.getTreeViewer(), this);
    }

    private ModelerActionService getModelerActionService() {
        return (ModelerActionService)UiPlugin.getDefault().getActionService(this.getSite().getPage());
    }

    protected void handleKeyPressed(KeyEvent event) {
        if (event.stateMask != 0) {
            return;
        }
        if (event.keyCode == 0x100000B) {
            ISelection selection = this.getViewer().getSelection();
            if (SelectionUtilities.isSingleSelection((ISelection)selection)) {
                Object obj = SelectionUtilities.getSelectedObject((ISelection)selection);
                if (obj instanceof IResource) {
                    IWorkbenchWindow window = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                    RenameRefactorAction delRefactorRename = new RenameRefactorAction();
                    DelegatableAction actRefactorRename = new DelegatableAction((IActionDelegate)delRefactorRename, window);
                    actRefactorRename.setText("");
                    actRefactorRename.setToolTipText("");
                    delRefactorRename.selectionChanged((IAction)actRefactorRename, selection);
                    if (actRefactorRename.isEnabled()) {
                        actRefactorRename.run();
                    }
                } else if (this.renameAction != null && this.renameAction.isEnabled()) {
                    this.renameAction.run();
                }
            } else if (this.renameAction != null && this.renameAction.isEnabled()) {
                this.renameAction.run();
            }
        } else if (event.character == '\u007f') {
            try {
                IAction actDelete = null;
                ISelection selection = this.getViewer().getSelection();
                actDelete = SelectionUtilities.isAllEObjects((ISelection)selection) ? this.getModelerActionService().getAction(ActionFactory.DELETE.getId()) : this.getViewSite().getActionBars().getGlobalActionHandler(ActionFactory.DELETE.getId());
                if (actDelete != null && actDelete.isEnabled()) {
                    actDelete.run();
                    event.doit = false;
                }
            }
            catch (CoreException coreException) {
                System.out.println("[ModelExplorerResourceNavigator.handleKeyEvent] CoreException retrieving delete action");
            }
        } else {
            super.handleKeyPressed(event);
        }
    }

    protected void editorActivated(IEditorPart editor) {
        if (!this.isLinkingEnabled()) {
            return;
        }
        IFile file = ResourceUtil.getFile((IEditorInput)editor.getEditorInput());
        if (file == null) {
            return;
        }
        StructuredSelection newSelection = new StructuredSelection((Object)file);
        TreeViewer treeViewer = this.getTreeViewer();
        ISelection oldSelection = treeViewer.getSelection();
        if (oldSelection.equals(newSelection)) {
            treeViewer.getTree().showSelection();
            return;
        }
        if (oldSelection instanceof IStructuredSelection && !oldSelection.isEmpty()) {
            IStructuredSelection sSelection = (IStructuredSelection)oldSelection;
            Object[] objectArray = sSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (file.equals((Object)ResourceUtil.getFile((Object)element))) {
                    return;
                }
                ++n2;
            }
        }
        treeViewer.setSelection((ISelection)newSelection, true);
    }

    private class ModelExplorerCopyAction
    extends Action
    implements ISelectionListener {
        private IAction defaultAction = null;
        private IAction modelerAction = null;
        private IAction currentAction = null;

        public ModelExplorerCopyAction(IActionBars theActionBars, ActionService theService) {
            this.defaultAction = theActionBars.getGlobalActionHandler(IActionConstants.EclipseGlobalActions.COPY);
            if (this.defaultAction == null) {
                this.defaultAction = GlobalActionsMap.UNSUPPORTED_ACTION;
                Util.log(4, ModelExplorerResourceNavigator.getString("msg.noDefaultCopyActionFound"));
            }
            try {
                this.modelerAction = theService.getAction(IActionConstants.EclipseGlobalActions.COPY);
            }
            catch (CoreException theException) {
                Util.log((Throwable)theException);
            }
            if (this.modelerAction == null) {
                this.modelerAction = GlobalActionsMap.UNSUPPORTED_ACTION;
            }
            this.currentAction = this.defaultAction;
            this.setEnabled(this.currentAction.isEnabled());
        }

        public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
            IAction handler;
            IAction iAction = handler = SelectionUtilities.isAllEObjects((ISelection)theSelection) ? this.modelerAction : this.defaultAction;
            if (this.currentAction != handler) {
                this.currentAction = handler;
            }
            this.setEnabled(this.currentAction.isEnabled());
        }

        public void run() {
            this.currentAction.runWithEvent(new Event());
        }
    }

    private class ServerVersionLoadingThread
    extends Thread {
        public ServerVersionLoadingThread() {
            super(ModelExplorerResourceNavigator.this + "." + ServerVersionLoadingThread.class.getSimpleName());
            this.setDaemon(true);
        }

        @Override
        public void run() {
            ITeiidServerManager serverManager = ModelerCore.getTeiidServerManager();
            while (!serverManager.isStarted()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Util.log((Throwable)ex);
                }
            }
            UiUtil.runInSwtThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ModelExplorerResourceNavigator.this.setDefaultServerText(ModelerCore.getDefaultServerName());
                    ModelExplorerResourceNavigator.this.setDefaultServerStatusIcon(ModelerCore.isDefaultParentConnected());
                    ModelExplorerResourceNavigator.this.setDefaultTeiidInstanceStatusIcon(ModelerCore.isDefaultTeiidConnected());
                    ModelExplorerResourceNavigator.this.setDefaultTeiidVersionText(ModelerCore.getTeiidServerVersion());
                    ModelerCore.addTeiidServerVersionListener((ITeiidServerVersionListener)ModelExplorerResourceNavigator.this.teiidServerVersionListener);
                    ModelExplorerResourceNavigator.this.addExecutionConfigurationListener(ModelerCore.getDefaultServerEventManager());
                }
            }, (boolean)true);
        }
    }

    protected class ShowImportsAction
    extends Action {
        public ShowImportsAction() {
            super(Util.getString(String.valueOf(I18N_PREFIX) + "showImportsAction", new Object[0]), 2);
            this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/obj16/Imports.gif"));
            this.setChecked(true);
        }

        private ModelExplorerContentProvider getContentProvider() {
            return (ModelExplorerContentProvider)this.getViewer().getContentProvider();
        }

        private TreeViewer getViewer() {
            return ModelExplorerResourceNavigator.this.getViewer();
        }

        public void run() {
            this.getContentProvider().setShowImportStatements(this.isChecked());
            this.getViewer().refresh();
        }
    }
}

