/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Display;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;

public class OpenModelEditorJob
extends Job {
    private static final String JOB_NAME = "Open Model Editor";
    IFile fileToOpen;
    EObject editableObject;

    public OpenModelEditorJob(IFile fileToOpen, EObject eObjectToEdit) {
        super(JOB_NAME);
        this.fileToOpen = fileToOpen;
        this.editableObject = eObjectToEdit;
    }

    protected IStatus run(IProgressMonitor theMonitor) {
        UiBusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (OpenModelEditorJob.this.editableObject != null) {
                    ModelEditorManager.edit(OpenModelEditorJob.this.editableObject);
                } else {
                    ModelEditor modelEditor = ModelEditorManager.getModelEditorForFile(OpenModelEditorJob.this.fileToOpen, true);
                    if (modelEditor != null) {
                        ModelEditorManager.activate(modelEditor);
                    }
                }
            }
        });
        return Status.OK_STATUS;
    }
}

