/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.editors;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.explorer.ModelExplorerResourceNavigator;
import org.teiid.designer.ui.outline.ModelOutlinePage;
import org.teiid.designer.ui.views.ModelViewer;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelEditorSelectionSynchronizer
implements IPartListener,
ISelectionListener,
ISelectionProvider,
IDoubleClickListener,
UiConstants {
    private ModelEditor modelEditor;
    private IFile modelFile;
    private ISelection lastSelection;
    private ArrayList registeredViewers = new ArrayList();

    public static void handleDoubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object object = selection.getFirstElement();
        if (object != null) {
            IWorkbenchPage page;
            ModelResource mdlRsrc;
            IFile file = null;
            if (object instanceof EObject && (mdlRsrc = ModelUtilities.getModelResourceForModelObject((EObject)object)) != null) {
                file = (IFile)mdlRsrc.getResource();
            }
            if (file != null && (page = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
                IEditorReference[] editors = page.getEditorReferences();
                int i = 0;
                while (i < editors.length) {
                    IEditorInput input;
                    IEditorPart editor = editors[i].getEditor(false);
                    if (editor != null && (input = editor.getEditorInput()) instanceof IFileEditorInput && file.equals((Object)((IFileEditorInput)input).getFile())) {
                        return;
                    }
                    ++i;
                }
                try {
                    IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                    if (editor instanceof ModelEditor) {
                        ((ModelEditor)editor).openModelObject(object);
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean shouldHandleDoubleClick(Object target, ModelEditorSelectionSynchronizer instance) {
        IFile file = null;
        ModelResource modelResrc = null;
        if (target instanceof EObject) {
            modelResrc = ModelUtilities.getModelResourceForModelObject((EObject)target);
        } else if (target instanceof Resource) {
            modelResrc = ModelerCore.getModelWorkspace().findModelResource((Resource)target);
        } else if (target instanceof ModelResource) {
            modelResrc = (ModelResource)target;
        }
        if (modelResrc == null) {
            Util.log(2, Util.getString("ModelEditorSelectionSynchronizer.invalidTarget", new Object[0]));
            return false;
        }
        file = (IFile)modelResrc.getResource();
        if (instance.modelFile.equals((Object)file)) {
            IWorkbenchPage page = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null && page.getActiveEditor() != instance.modelEditor) {
                page.bringToTop((IWorkbenchPart)instance.modelEditor);
            }
            return true;
        }
        IEditorReference[] editors = instance.modelEditor.getEditorSite().getPage().getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            IEditorInput input;
            IEditorPart editor = editors[i].getEditor(false);
            if (editor != null && (input = editor.getEditorInput()) instanceof IFileEditorInput && file.equals((Object)((IFileEditorInput)input).getFile())) {
                return false;
            }
            ++i;
        }
        try {
            IEditorPart editor = IDE.openEditor((IWorkbenchPage)instance.modelEditor.getEditorSite().getPage(), (IFile)file);
            if (editor instanceof ModelEditor) {
                ((ModelEditor)editor).openModelObject(target);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return false;
    }

    ModelEditorSelectionSynchronizer(ModelEditor editor, IFile editorInput) {
        this.modelEditor = editor;
        this.modelFile = editorInput;
        editor.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
    }

    public synchronized void partActivated(IWorkbenchPart part) {
        if (part instanceof ModelViewer) {
            this.register((ModelViewer)part);
        } else if (part instanceof PageBookView) {
            Object innerPage;
            PageBookView pbv = (PageBookView)part;
            IPage page = pbv.getCurrentPage();
            if (page instanceof ModelViewer) {
                this.register((ModelViewer)page);
            } else if (page instanceof ModelOutlinePage && (innerPage = ((ModelOutlinePage)page).getCurrentViewer()) instanceof ModelViewer) {
                this.register((ModelViewer)innerPage);
            }
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof ModelViewer) {
            this.unregister((ModelViewer)part);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        PageBookView pbv;
        IPage page;
        if (part instanceof ModelViewer) {
            this.register((ModelViewer)part);
        } else if (part instanceof PageBookView && (page = (pbv = (PageBookView)part).getCurrentPage()) instanceof ModelViewer) {
            this.register((ModelViewer)page);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, null, (Object)this);
        boolean succeeded = false;
        try {
            if (this.isActivePart(part) && !(part instanceof ModelEditor) && selection instanceof IStructuredSelection) {
                if (((IStructuredSelection)selection).size() == 1) {
                    Object o = ((IStructuredSelection)selection).getFirstElement();
                    if (o instanceof EObject) {
                        this.lastSelection = selection;
                        ModelEditorPage page = (ModelEditorPage)this.modelEditor.getCurrentPage();
                        if (page != null && page.getModelObjectSelectionChangedListener() != null) {
                            page.getModelObjectSelectionChangedListener().selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
                        }
                        this.modelEditor.setSelection(selection);
                    }
                } else if (SelectionUtilities.isMultiSelection((ISelection)selection)) {
                    int nEObjects;
                    int nObjects = SelectionUtilities.getSelectedObjects((ISelection)selection).size();
                    if (nObjects == (nEObjects = SelectionUtilities.getSelectedEObjects((ISelection)selection).size())) {
                        this.lastSelection = selection;
                        ModelEditorPage page = (ModelEditorPage)this.modelEditor.getCurrentPage();
                        if (page != null && page.getModelObjectSelectionChangedListener() != null) {
                            page.getModelObjectSelectionChangedListener().selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
                        }
                        this.modelEditor.setSelection(selection);
                    }
                } else if (SelectionUtilities.isEmptySelection((ISelection)selection)) {
                    ModelEditorPage page = (ModelEditorPage)this.modelEditor.getCurrentPage();
                    if (page != null && page.getModelObjectSelectionChangedListener() != null) {
                        page.getModelObjectSelectionChangedListener().selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
                    }
                    this.modelEditor.setSelection(selection);
                }
            }
            succeeded = true;
        }
        finally {
            if (startedTxn) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public ISelection getSelection() {
        return this.lastSelection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
        this.lastSelection = selection;
        this.selectionChanged((IWorkbenchPart)this.modelEditor, selection);
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object object = selection.getFirstElement();
        if (object != null && object instanceof EObject && ModelEditorSelectionSynchronizer.shouldHandleDoubleClick(object, this)) {
            ModelEditorManager.open((EObject)object, false, 3);
        }
    }

    protected synchronized void register(ModelViewer viewer) {
        if (!this.registeredViewers.contains(viewer)) {
            if (!(viewer instanceof ModelExplorerResourceNavigator)) {
                viewer.addModelObjectDoubleClickListener(this);
            }
            this.registeredViewers.add(viewer);
        }
    }

    protected synchronized void unregister(ModelViewer viewer) {
        viewer.removeModelObjectDoubleClickListener(this);
        this.registeredViewers.remove(viewer);
    }

    public void dispose() {
        Object[] viewArray = this.registeredViewers.toArray();
        int i = 0;
        while (i < viewArray.length) {
            this.unregister((ModelViewer)viewArray[i]);
            ++i;
        }
        this.modelEditor.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
    }

    private boolean isActivePart(IWorkbenchPart part) {
        return part == this.modelEditor.getEditorSite().getWorkbenchWindow().getPartService().getActivePart();
    }
}

