/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.editors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.StatusLineContributionItem;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.IModelerActionConstants;
import org.teiid.designer.ui.actions.ModelerGlobalActionsMap;
import org.teiid.designer.ui.common.actions.ActionService;
import org.teiid.designer.ui.common.actions.GlobalActionsMap;
import org.teiid.designer.ui.editors.AbstractModelEditorPageActionBarContributor;
import org.teiid.designer.ui.editors.ModelEditor;

public class ModelEditorActionContributor
extends MultiPageEditorActionBarContributor
implements IModelerActionConstants,
UiConstants {
    private static ModelerGlobalActionsMap defaultActionsMap = new ModelerGlobalActionsMap();
    private StatusLineContributionItem fileStateItem;
    private IFileEditorInput input;
    private Map partContributorMap;
    private IPartListener partListener;
    private Map<String, IHandlerActivation> actionHandlerMap = new HashMap<String, IHandlerActivation>(ModelerGlobalActionsMap.ALL_GLOBAL_ACTIONS.length);

    public void addContributor(IEditorPart thePart, IEditorActionBarContributor theContributor) {
        if (this.partContributorMap == null) {
            this.partContributorMap = new HashMap();
        }
        this.partContributorMap.put(thePart, theContributor);
        if (this.partListener == null) {
            this.partListener = new EditorPartListener();
            this.getPage().addPartListener(this.partListener);
        }
        theContributor.init(this.getActionBars(), this.getPage());
    }

    public void contributeToStatusLine(IStatusLineManager theStatusLineManager) {
        super.contributeToStatusLine(theStatusLineManager);
        this.fileStateItem = new StatusLineContributionItem("modelEditorFileState.statusBarField");
        theStatusLineManager.add((IContributionItem)this.fileStateItem);
    }

    public void dispose() {
        if (this.partListener != null) {
            this.getPage().removePartListener(this.partListener);
        }
        super.dispose();
    }

    private AbstractModelEditorPageActionBarContributor getActionContributor(IEditorPart thePart) {
        AbstractModelEditorPageActionBarContributor result = null;
        if (this.partContributorMap != null) {
            result = (AbstractModelEditorPageActionBarContributor)((Object)this.partContributorMap.get(thePart));
        }
        return result;
    }

    void handlePartClosed(IWorkbenchPart thePart) {
        if (thePart instanceof ModelEditor) {
            List editors = ((ModelEditor)thePart).getAllEditors();
            int size = editors.size();
            int i = 0;
            while (i < size) {
                this.partContributorMap.remove(editors.get(i));
                ++i;
            }
        }
    }

    public void setActiveEditor(IEditorPart thePart) {
        this.setActivePage(thePart);
    }

    public void setActivePage(IEditorPart thePart) {
        ModelerGlobalActionsMap globalActions;
        AbstractModelEditorPageActionBarContributor contributor = null;
        IEditorPart part = thePart;
        if (thePart instanceof ModelEditor) {
            part = ((ModelEditor)thePart).getCurrentPage();
        }
        if (this.partContributorMap != null) {
            for (IEditorActionBarContributor pageContributor : this.partContributorMap.values()) {
                if (pageContributor == null) continue;
                pageContributor.setActiveEditor(part);
            }
        }
        if ((contributor = this.getActionContributor(part)) != null) {
            contributor.setActiveEditor(part);
        }
        ModelerGlobalActionsMap modelerGlobalActionsMap = globalActions = contributor == null ? defaultActionsMap : (ModelerGlobalActionsMap)contributor.getGlobalActions();
        if (globalActions == null) {
            globalActions = new ModelerGlobalActionsMap();
        }
        IWorkbenchWindow window = this.getPage().getWorkbenchWindow();
        ActionService actionService = contributor == null ? UiPlugin.getDefault().getActionService(window.getActivePage()) : contributor.getActionService();
        IHandlerService svc = (IHandlerService)part.getSite().getService(IHandlerService.class);
        for (Map.Entry entry : globalActions.entrySet()) {
            IHandlerActivation activation;
            String actionId = (String)entry.getKey();
            IAction action = null;
            action = globalActions.isDefaultAction(actionId) && actionService != null ? actionService.getDefaultAction(actionId) : (IAction)entry.getValue();
            if (action == null) {
                action = GlobalActionsMap.UNSUPPORTED_ACTION;
            }
            if (this.actionHandlerMap.containsKey(actionId) && (activation = this.actionHandlerMap.get(actionId)).getHandlerService() != null) {
                activation.getHandlerService().deactivateHandler(activation);
            }
            this.getActionBars().setGlobalActionHandler(actionId, action);
            this.actionHandlerMap.put(actionId, svc.activateHandler(actionId, (IHandler)new ActionHandler(action)));
        }
        this.getActionBars().updateActionBars();
    }

    public void setEditorInput(IFileEditorInput theInput) {
        this.input = theInput;
        this.setReadOnlyState();
    }

    public void setReadOnlyState() {
        if (this.input != null && this.fileStateItem != null) {
            this.fileStateItem.setText(this.getReadOnlyState() ? Util.getString("ModelerEditorActionContributor.modelIsReadOnly", new Object[0]) : Util.getString("ModelerEditorActionContributor.modelIsWritable", new Object[0]));
        }
    }

    public boolean getReadOnlyState() {
        if (this.input != null) {
            return ModelUtil.isIResourceReadOnly((IResource)this.input.getFile());
        }
        return true;
    }

    class EditorPartListener
    implements IPartListener {
        EditorPartListener() {
        }

        public void partActivated(IWorkbenchPart thePart) {
        }

        public void partBroughtToTop(IWorkbenchPart thePart) {
        }

        public void partDeactivated(IWorkbenchPart thePart) {
        }

        public void partOpened(IWorkbenchPart thePart) {
        }

        public void partClosed(IWorkbenchPart thePart) {
            ModelEditorActionContributor.this.handlePartClosed(thePart);
        }
    }
}

