/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.part.ResourceTransfer;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.CopyFilesAndFoldersOperation;
import org.teiid.designer.ui.actions.ModelObjectAction;
import org.teiid.designer.ui.actions.PasteAction;
import org.teiid.designer.ui.common.UiConstants;
import org.teiid.designer.ui.common.actions.AbstractAction;
import org.teiid.designer.ui.common.actions.ActionService;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.SystemClipboardUtilities;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class PasteInResourceAction
extends ModelObjectAction
implements UiConstants {
    private AbstractAction eObjDelegateAction;
    private ResourcePasteAction resourceDelegateAction = new ResourcePasteAction();

    public PasteInResourceAction() {
        super(UiPlugin.getDefault());
        ActionService actionService = UiPlugin.getDefault().getActionService(UiUtil.getWorkbenchWindowOnlyIfUiThread().getActivePage());
        try {
            this.eObjDelegateAction = (AbstractAction)actionService.getAction(PasteAction.class.getName());
            this.setHoverImageDescriptor(this.eObjDelegateAction.getHoverImageDescriptor());
            this.setImageDescriptor(this.eObjDelegateAction.getImageDescriptor());
            this.setDisabledImageDescriptor(this.eObjDelegateAction.getDisabledImageDescriptor());
            this.setText(this.eObjDelegateAction.getText());
            this.setToolTipText(this.eObjDelegateAction.getToolTipText());
        }
        catch (CoreException theException) {
            Util.log((Throwable)theException);
            this.eObjDelegateAction = new AbstractAction(UiPlugin.getDefault()){

                protected void doRun() {
                }
            };
            this.eObjDelegateAction.setEnabled(false);
        }
    }

    @Override
    protected void doRun() {
        if (this.eObjDelegateAction.isEnabled()) {
            this.eObjDelegateAction.run();
        } else if (this.resourceDelegateAction.isEnabled()) {
            this.resourceDelegateAction.run();
        }
        this.setEnabledState();
    }

    Shell getShell() {
        return this.getPart().getSite().getShell();
    }

    private boolean resourceAlreadyInWorkspace(IResource theResource) {
        boolean result = false;
        try {
            result = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(theResource) != null;
        }
        catch (ModelWorkspaceException theException) {
            Util.log((Throwable)theException);
        }
        return result;
    }

    private boolean isValidPasteResource(IResource theResource) {
        boolean result;
        block13: {
            result = true;
            if (theResource.getProject().isOpen()) {
                if (theResource instanceof IFile) {
                    if (!ModelUtilities.isModelFile(theResource) && !ModelUtilities.isVdbFile(theResource)) {
                        result = true;
                    } else if (ModelUtilities.isVdbFile(theResource)) {
                        result = this.selectedIsInModelProject();
                    }
                } else if (theResource instanceof IContainer) {
                    try {
                        IResource[] members = ((IContainer)theResource).members();
                        if (members.length <= 0) break block13;
                        int i = 0;
                        while (i < members.length) {
                            result = this.isValidPasteResource(members[i]);
                            if (result) {
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (CoreException coreException) {
                        result = false;
                    }
                } else {
                    result = false;
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    @Override
    protected boolean preRun() {
        boolean result = true;
        if (this.eObjDelegateAction.isEnabled()) {
            result = this.activateEditor();
        }
        return result;
    }

    @Override
    protected boolean requiresEditorForRun() {
        return true;
    }

    @Override
    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        Object selection = null;
        selection = theSelection instanceof IStructuredSelection ? (IStructuredSelection)theSelection : StructuredSelection.EMPTY;
        this.resourceDelegateAction.selectionChanged((IStructuredSelection)selection);
        this.setEnabledState();
    }

    public void selectionChanged(SelectionChangedEvent theEvent) {
        super.selectionChanged(theEvent);
        this.eObjDelegateAction.selectionChanged(theEvent);
        this.resourceDelegateAction.selectionChanged(theEvent);
        this.setEnabledState();
    }

    private boolean selectedIsInModelProject() {
        boolean result = false;
        IContainer targetResource = this.resourceDelegateAction.getContainer();
        if (targetResource != null) {
            result = ModelUtilities.isModelProjectResource((IResource)targetResource);
        }
        return result;
    }

    private void setEnabledState() {
        IResource[] resources;
        boolean result = this.eObjDelegateAction.isEnabled();
        if (!result && this.resourceDelegateAction.isEnabled() && (resources = (IResource[])SystemClipboardUtilities.getContents((Transfer)ResourceTransfer.getInstance())) != null && resources.length > 0) {
            result = true;
            int i = 0;
            while (i < resources.length) {
                if (this.resourceAlreadyInWorkspace(resources[i]) || !this.isValidPasteResource(resources[i])) {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        this.setEnabled(result);
    }

    private boolean activateEditor() {
        if (this.requiresEditorForRun()) {
            Object selectedObject;
            List allSelectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
            if (allSelectedEObjects != null && !allSelectedEObjects.isEmpty()) {
                EObject eObject = (EObject)allSelectedEObjects.get(0);
                ModelResource mr = ModelUtilities.getModelResourceForModelObject(eObject);
                if (mr != null) {
                    ModelEditorManager.activate(mr, true);
                }
            } else if (SelectionUtilities.isSingleSelection((ISelection)this.getSelection()) && (selectedObject = SelectionUtilities.getSelectedObject((ISelection)this.getSelection())) instanceof IFile && ModelUtilities.isModelFile((IResource)((IFile)selectedObject))) {
                ModelResource mr = null;
                try {
                    try {
                        mr = ModelUtil.getModelResource((IFile)((IFile)selectedObject), (boolean)false);
                    }
                    catch (ModelWorkspaceException err) {
                        Util.log((Throwable)err);
                        if (mr != null) {
                            ModelEditorManager.activate(mr, true);
                        }
                    }
                }
                finally {
                    if (mr != null) {
                        ModelEditorManager.activate(mr, true);
                    }
                }
            }
        }
        return true;
    }

    private class ResourcePasteAction
    extends SelectionListenerAction {
        public ResourcePasteAction() {
            super("not used");
        }

        IContainer getContainer() {
            List selection = this.getSelectedResources();
            if (selection == null || selection.isEmpty()) {
                return null;
            }
            if (selection.get(0) instanceof IFile) {
                return ((IFile)selection.get(0)).getParent();
            }
            return (IContainer)selection.get(0);
        }

        private IResource getTarget() {
            List selectedResources = this.getSelectedResources();
            int i = 0;
            while (i < selectedResources.size()) {
                IResource resource = (IResource)selectedResources.get(i);
                if (resource instanceof IProject && !((IProject)resource).isOpen()) {
                    return null;
                }
                if (resource.getType() == 1) {
                    resource = resource.getParent();
                }
                if (resource != null) {
                    return resource;
                }
                ++i;
            }
            return null;
        }

        private boolean isLinked(IResource[] resources) {
            if (resources != null) {
                int i = 0;
                while (i < resources.length) {
                    if (resources[i].isLinked()) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public void run() {
            ResourceTransfer resTransfer = ResourceTransfer.getInstance();
            IResource[] resourceData = (IResource[])SystemClipboardUtilities.getContents((Transfer)resTransfer);
            if (resourceData != null && resourceData.length > 0) {
                if (resourceData[0].getType() == 4) {
                    int i = 0;
                    while (i < resourceData.length) {
                        CopyProjectOperation operation = new CopyProjectOperation(PasteInResourceAction.this.getShell());
                        operation.copyProject((IProject)resourceData[i]);
                        ++i;
                    }
                } else {
                    IContainer container = this.getContainer();
                    CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(PasteInResourceAction.this.getShell());
                    operation.copyResources(resourceData, container);
                }
                return;
            }
            FileTransfer fileTransfer = FileTransfer.getInstance();
            String[] fileData = (String[])SystemClipboardUtilities.getContents((Transfer)fileTransfer);
            if (fileData != null) {
                IContainer container = this.getContainer();
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(PasteInResourceAction.this.getShell());
                operation.copyFiles(fileData, container);
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        protected boolean updateSelection(IStructuredSelection selection) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench == null) {
                return false;
            }
            IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            if (workbenchWindow == null) {
                return false;
            }
            if (workbenchWindow.getShell() == null || !workbenchWindow.getShell().isVisible()) {
                return false;
            }
            if (selection == null || selection.isEmpty()) {
                return false;
            }
            try {
                int i;
                boolean isProjectRes;
                ResourceTransfer resTransfer = ResourceTransfer.getInstance();
                IResource[] resourceData = (IResource[])SystemClipboardUtilities.getContents((Transfer)resTransfer);
                FileTransfer fileTransfer = FileTransfer.getInstance();
                String[] fileData = (String[])SystemClipboardUtilities.getContents((Transfer)fileTransfer);
                if (resourceData == null && fileData == null) {
                    return false;
                }
                boolean bl = isProjectRes = resourceData != null && resourceData.length > 0 && resourceData[0].getType() == 4;
                if (isProjectRes) {
                    int i2 = 1;
                    while (i2 < resourceData.length) {
                        if (resourceData[i2].getType() != 4) {
                            return false;
                        }
                        ++i2;
                    }
                    return true;
                }
                if (this.getSelectedNonResources().size() > 0) {
                    return false;
                }
                List selectedResources = this.getSelectedResources();
                IResource targetResource = this.getTarget();
                if (targetResource == null) {
                    return false;
                }
                if (this.isLinked(resourceData) && targetResource.getType() != 4) {
                    return false;
                }
                if (selectedResources.size() > 1) {
                    i = 0;
                    while (i < selectedResources.size()) {
                        IResource resource = (IResource)selectedResources.get(i);
                        if (resource.getType() != 1) {
                            return false;
                        }
                        if (!targetResource.equals((Object)resource.getParent())) {
                            return false;
                        }
                        ++i;
                    }
                }
                if (targetResource.getType() == 2 && resourceData != null) {
                    i = 0;
                    while (i < resourceData.length) {
                        if (targetResource.equals((Object)resourceData[i])) {
                            return false;
                        }
                        ++i;
                    }
                }
                return true;
            }
            catch (Exception e) {
                Util.log((Throwable)e);
                return false;
            }
        }
    }
}

