/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.search.ModelObjectSelectionDialog;

public final class FindModelObjectHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ModelObjectSelectionDialog dialog = new ModelObjectSelectionDialog(shell);
        if (!dialog.userCancelledDuringLoad()) {
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                EObject eObj = dialog.getSelectedEObject();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (eObj != null) {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                    try {
                        workbench.showPerspective("modelerPerspective", window);
                    }
                    catch (Exception theException) {
                        UiConstants.Util.log((Throwable)theException);
                    }
                    IWorkbenchPage page = window.getActivePage();
                    IViewPart view = page.findView("explorer.view");
                    if (view == null) {
                        try {
                            view = page.showView("explorer.view");
                        }
                        catch (PartInitException theException) {
                            UiConstants.Util.log((Throwable)theException);
                            WidgetUtil.showError((String)theException.getLocalizedMessage());
                        }
                    }
                    if (view != null) {
                        ISelectionProvider selectionProvider = view.getViewSite().getSelectionProvider();
                        selectionProvider.setSelection((ISelection)new StructuredSelection((Object)eObj));
                    }
                    ModelEditorManager.open(eObj, !ModelEditorManager.isOpen(eObj));
                }
            }
        }
        return null;
    }
}

