/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.core.workspace.ModelMappingClassSets;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.mapping.PluginConstants;
import org.teiid.designer.mapping.factory.ModelMapperFactory;
import org.teiid.designer.mapping.factory.TreeMappingAdapter;
import org.teiid.designer.metamodels.transformation.InputBinding;
import org.teiid.designer.metamodels.transformation.MappingClassSet;
import org.teiid.designer.ui.undo.ModelerUndoManager;

public class MappingNotificationListener
implements INotifyChangedListener {
    private static final String THIS_CLASS = "MappingNotificationListener";
    private static final boolean NOT_SIGNIFICANT = false;
    private static final boolean IS_UNDOABLE = true;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void notifyChanged(Notification notification) {
        if (notification instanceof SourcedNotification) {
            if (!this.isValidSource((SourcedNotification)notification) || !this.shouldHandleNotification(notification)) return;
            boolean requiredStart = false;
            boolean succeeded = false;
            try {
                try {
                    requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Reconcile Mapping Class Set", (Object)this);
                    this.handleNotification(notification);
                    succeeded = true;
                    return;
                }
                catch (ModelerCoreException ex) {
                    PluginConstants.Util.log(4, (Throwable)ex, String.valueOf(((Object)((Object)ex)).getClass().getName()) + ":" + THIS_CLASS + ".notifyModel()");
                    if (!requiredStart) return;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        return;
                    }
                    ModelerCore.rollbackTxn();
                }
                return;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        if (!this.shouldHandleNotification(notification)) return;
        boolean requiredStart = false;
        boolean succeeded = false;
        try {
            try {
                requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Reconcile Mapping Class Set", (Object)this);
                this.handleNotification(notification);
                succeeded = true;
                return;
            }
            catch (ModelerCoreException ex) {
                PluginConstants.Util.log(4, (Throwable)ex, String.valueOf(((Object)((Object)ex)).getClass().getName()) + ":" + THIS_CLASS + ".notifyModel()");
                if (!requiredStart) return;
                if (succeeded) {
                    ModelerCore.commitTxn();
                    return;
                }
                ModelerCore.rollbackTxn();
            }
            return;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private void handleNotification(Notification notification) throws ModelerCoreException {
        if (notification instanceof SourcedNotification) {
            boolean handled = false;
            Object source = ((SourcedNotification)notification).getSource();
            if (source == null || !source.equals(this)) {
                Collection notifications = ((SourcedNotification)notification).getNotifications();
                Iterator iter = notifications.iterator();
                Notification nextNotification = null;
                while (iter.hasNext() && !handled) {
                    nextNotification = (Notification)iter.next();
                    Object targetObject = ModelerCore.getModelEditor().getChangedObject(nextNotification);
                    if (targetObject == null || !(targetObject instanceof EObject) || !ModelMapperFactory.isXmlTreeNode((EObject)((EObject)targetObject))) continue;
                    if (nextNotification.getEventType() == 4 || nextNotification.getEventType() == 6) {
                        this.handleRemoveNotification((EObject)targetObject);
                        handled = true;
                        continue;
                    }
                    if (!NotificationUtilities.isRemoved((Notification)nextNotification)) continue;
                    this.handleRemoveNotification((EObject)targetObject);
                    handled = true;
                }
            }
        } else {
            Object targetObject = ModelerCore.getModelEditor().getChangedObject(notification);
            if (targetObject != null && targetObject instanceof EObject && ModelMapperFactory.isXmlTreeNode((EObject)((EObject)targetObject)) && (notification.getEventType() == 4 || notification.getEventType() == 6)) {
                this.handleRemoveNotification((EObject)targetObject);
            }
        }
    }

    private boolean isValidSource(SourcedNotification sn) {
        boolean valid = true;
        Object source = sn.getSource();
        if (source != null && (source.equals(this) || source instanceof ModelerUndoManager)) {
            valid = false;
        }
        return valid;
    }

    private boolean shouldHandleNotification(Notification notification) {
        boolean shouldHandle = false;
        if (notification instanceof SourcedNotification) {
            Object source = ((SourcedNotification)notification).getSource();
            if (source == null || !source.equals(this)) {
                Collection notifications = ((SourcedNotification)notification).getNotifications();
                Iterator iter = notifications.iterator();
                Notification nextNotification = null;
                while (iter.hasNext() && !shouldHandle) {
                    nextNotification = (Notification)iter.next();
                    Object targetObject = ModelerCore.getModelEditor().getChangedObject(nextNotification);
                    if (targetObject == null || !(targetObject instanceof EObject) || !ModelMapperFactory.isXmlTreeNode((EObject)((EObject)targetObject))) continue;
                    if (nextNotification.getEventType() == 4 || nextNotification.getEventType() == 6) {
                        shouldHandle = true;
                        continue;
                    }
                    if (!NotificationUtilities.isRemoved((Notification)nextNotification)) continue;
                    shouldHandle = true;
                }
            }
        } else {
            Object targetObject = ModelerCore.getModelEditor().getChangedObject(notification);
            if (targetObject != null && targetObject instanceof EObject && ModelMapperFactory.isXmlTreeNode((EObject)((EObject)targetObject))) {
                if (notification.getEventType() == 4 || notification.getEventType() == 6) {
                    shouldHandle = true;
                } else if (NotificationUtilities.isRemoved((Notification)notification)) {
                    shouldHandle = true;
                }
            }
        }
        return shouldHandle;
    }

    private void handleRemoveNotification(EObject targetEObject) throws ModelerCoreException {
        EObject treeRoot = ModelMapperFactory.getTreeRoot((EObject)targetEObject);
        if (treeRoot != null) {
            MappingClassSet mcs;
            TreeMappingAdapter tma = new TreeMappingAdapter(treeRoot);
            List currentMappingClasses = tma.getAllMappingClasses();
            List allStagingTables = tma.getAllStagingTables();
            EObject document = tma.getDocument();
            ArrayList mappingClasses = null;
            if (document != null) {
                mcs = this.getMappingClassSet(treeRoot);
                if (mcs != null) {
                    mappingClasses = new ArrayList(mcs.eContents());
                }
            } else {
                mcs = this.getMappingClassSet(treeRoot);
                if (mcs != null) {
                    mappingClasses = new ArrayList(mcs.eContents());
                }
            }
            if (mappingClasses != null && !mappingClasses.isEmpty()) {
                Object nextObj2 = null;
                for (Object nextObj2 : currentMappingClasses) {
                    if (!(nextObj2 instanceof EObject) || !mappingClasses.contains(nextObj2)) continue;
                    mappingClasses.remove(nextObj2);
                }
                for (Object nextObj2 : allStagingTables) {
                    if (!(nextObj2 instanceof EObject) || !mappingClasses.contains(nextObj2)) continue;
                    mappingClasses.remove(nextObj2);
                }
                if (!mappingClasses.isEmpty()) {
                    for (Object nextObj2 : mappingClasses) {
                        if (!(nextObj2 instanceof EObject) || nextObj2 instanceof InputBinding) continue;
                        ModelerCore.getModelEditor().delete((EObject)nextObj2);
                    }
                }
            }
        }
    }

    private MappingClassSet getMappingClassSet(EObject treeRoot) {
        MappingClassSet mappingClassSet = null;
        ModelResource mr = ModelerCore.getModelEditor().findModelResource(treeRoot);
        if (mr != null) {
            try {
                ModelMappingClassSets sets = mr.getModelMappingClassSets();
                List setList = sets.getMappingClassSets(treeRoot);
                mappingClassSet = setList == null || setList.isEmpty() ? sets.createNewMappingClassSet(treeRoot) : (MappingClassSet)setList.get(0);
            }
            catch (ModelWorkspaceException e) {
                PluginConstants.Util.log((Throwable)e);
            }
        }
        return mappingClassSet;
    }
}

