/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.part;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.connection.AnchorManager;
import org.teiid.designer.diagram.ui.connection.ChopBoxAnchorManager;
import org.teiid.designer.diagram.ui.connection.NodeConnectionEditPart;
import org.teiid.designer.diagram.ui.figure.DiagramFigureFactory;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.model.LabelModelNode;
import org.teiid.designer.diagram.ui.notation.NotationPartGenerator;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierNode;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlClassifierEditPart;
import org.teiid.designer.diagram.ui.part.AbstractDiagramEditPart;
import org.teiid.designer.diagram.ui.part.AbstractDiagramEditPartFactory;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.part.DropEditPartHelper;
import org.teiid.designer.diagram.ui.part.LabelEditPart;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.connection.EnumeratedTypeLink;
import org.teiid.designer.mapping.ui.connection.MappingClassAnchorManager;
import org.teiid.designer.mapping.ui.connection.MappingExtentAnchorManager;
import org.teiid.designer.mapping.ui.connection.MappingLink;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramUtil;
import org.teiid.designer.mapping.ui.figure.MappingDiagramFigureFactory;
import org.teiid.designer.mapping.ui.model.MappingDiagramNode;
import org.teiid.designer.mapping.ui.model.MappingExtentNode;
import org.teiid.designer.mapping.ui.model.SummaryExtentNode;
import org.teiid.designer.mapping.ui.part.EnumeratedTypeLinkEditPart;
import org.teiid.designer.mapping.ui.part.MappingDiagramEditPart;
import org.teiid.designer.mapping.ui.part.MappingExtentEditPart;
import org.teiid.designer.mapping.ui.part.MappingLinkEditPart;
import org.teiid.designer.mapping.ui.part.MappingTransformationDropEditPartHelper;
import org.teiid.designer.mapping.ui.part.SummaryExtentEditPart;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.transformation.ui.actions.TransformationSourceManager;
import org.teiid.designer.transformation.ui.connection.TransformationAnchorManager;
import org.teiid.designer.transformation.ui.connection.TransformationLink;
import org.teiid.designer.transformation.ui.model.TransformationNode;
import org.teiid.designer.transformation.ui.part.TransformationEditPart;
import org.teiid.designer.transformation.ui.part.TransformationLinkEditPart;
import org.teiid.designer.transformation.util.TransformationHelper;

public class MappingDiagramPartFactory
extends AbstractDiagramEditPartFactory
implements UiConstants {
    private DiagramFigureFactory figureFactory;
    private static final String diagramTypeId = "mappingDiagramType";

    public EditPart createEditPart(EditPart iContext, Object iModel) {
        Object editPart = null;
        if (this.figureFactory == null) {
            this.figureFactory = new MappingDiagramFigureFactory();
        }
        if (iModel instanceof MappingDiagramNode) {
            editPart = new MappingDiagramEditPart();
            ((AbstractDiagramEditPart)editPart).setFigureFactory(this.figureFactory);
            Object transform = this.getTransformation(iModel);
            if (transform != null) {
                ((MappingDiagramEditPart)((Object)editPart)).setDropHelper((DropEditPartHelper)new MappingTransformationDropEditPartHelper(transform));
            }
        } else if (iModel instanceof SummaryExtentNode) {
            editPart = new SummaryExtentEditPart(diagramTypeId);
            editPart.setFigureFactory(this.figureFactory);
            ((DiagramEditPart)editPart).setResizable(false);
        } else if (iModel instanceof MappingExtentNode) {
            editPart = new MappingExtentEditPart(diagramTypeId);
            editPart.setFigureFactory(this.figureFactory);
            ((DiagramEditPart)editPart).setResizable(false);
        } else if (iModel instanceof TransformationNode) {
            editPart = new TransformationEditPart(diagramTypeId);
            editPart.setFigureFactory(this.figureFactory);
            ((DiagramEditPart)editPart).setResizable(false);
            Object transform = this.getTransformation(iModel);
            if (transform != null) {
                ((TransformationEditPart)editPart).setDropHelper((DropEditPartHelper)new MappingTransformationDropEditPartHelper(transform));
            }
        } else if (iModel instanceof LabelModelNode) {
            editPart = new LabelEditPart();
            ((DiagramEditPart)editPart).setResizable(false);
        } else if (iModel instanceof TransformationLink) {
            editPart = this.getTransformationConnectionEditPart(iModel);
        } else if (iModel instanceof MappingLink) {
            editPart = this.getConnectionEditPart(iModel);
        } else if (iModel instanceof EnumeratedTypeLink) {
            editPart = new EnumeratedTypeLinkEditPart();
        } else {
            NotationPartGenerator generator = DiagramUiPlugin.getDiagramNotationManager().getEditPartGenerator(this.getNotationId());
            if (generator != null) {
                editPart = generator.createEditPart(iContext, iModel, diagramTypeId);
                if (editPart instanceof UmlClassifierEditPart) {
                    EObject eObj;
                    Object transform;
                    if (editPart instanceof UmlClassifierEditPart && (transform = this.getTransformation(iModel)) != null) {
                        ((UmlClassifierEditPart)editPart).setDropHelper((DropEditPartHelper)new MappingTransformationDropEditPartHelper(transform));
                    }
                    if (MappingDiagramUtil.isMappingSqlTable(eObj = ((DiagramModelNode)iModel).getModelObject())) {
                        ((DiagramModelNode)iModel).setHideLocation(true);
                    }
                }
            } else {
                ModelerCore.Util.log(4, Util.getString("DiagramErrors.partGeneratorFailure", new Object[0]));
            }
        }
        if (editPart != null) {
            if (editPart instanceof NodeConnectionEditPart) {
                editPart.setModel(iModel);
                ((NodeConnectionEditPart)editPart).setSourceAndTarget(iContext);
            } else if (editPart instanceof DiagramEditPart) {
                editPart.setModel(iModel);
                ((DiagramEditPart)editPart).setNotationId(this.getNotationId());
                ((DiagramEditPart)editPart).setSelectionHandler(this.getSelectionHandler());
                ((DiagramEditPart)editPart).setDiagramTypeId(diagramTypeId);
            }
        } else {
            ModelerCore.Util.log(4, Util.getString("DiagramErrors.editPartFailure", new Object[0]));
        }
        if (editPart instanceof DiagramEditPart) {
            ((DiagramEditPart)editPart).setUnderConstruction(true);
        }
        return editPart;
    }

    public NodeConnectionEditPart getConnectionEditPart(Object iModel) {
        return new MappingLinkEditPart();
    }

    public NodeConnectionEditPart getTransformationConnectionEditPart(Object iModel) {
        return new TransformationLinkEditPart();
    }

    public AnchorManager getAnchorManager(DiagramEditPart editPart) {
        if (editPart instanceof UmlClassifierEditPart) {
            return new MappingClassAnchorManager(editPart);
        }
        if (editPart instanceof MappingExtentEditPart) {
            return new MappingExtentAnchorManager(editPart);
        }
        if (editPart instanceof TransformationEditPart) {
            return new ChopBoxAnchorManager(editPart);
        }
        return new TransformationAnchorManager(editPart);
    }

    private Object getTransformation(Object iModel) {
        if (iModel instanceof MappingDiagramNode) {
            Diagram diagram = (Diagram)((MappingDiagramNode)((Object)iModel)).getModelObject();
            if (diagram != null) {
                return TransformationSourceManager.getTransformationFromDiagram((Diagram)diagram);
            }
        } else {
            DiagramModelNode parentClassifierNode;
            if (iModel instanceof TransformationNode) {
                return ((TransformationNode)iModel).getModelObject();
            }
            if (iModel instanceof UmlClassifierNode && (parentClassifierNode = DiagramUiUtilities.getClassifierParentNode((DiagramModelNode)((DiagramModelNode)iModel))) != null) {
                EObject diagramTransform;
                MappingDiagramNode tdep;
                Diagram diagram;
                EObject thisTransform = null;
                if (TransformationHelper.isValidSqlTransformationTarget((Object)parentClassifierNode.getModelObject()) && (thisTransform = TransformationHelper.getTransformationMappingRoot((EObject)parentClassifierNode.getModelObject())) != null && (diagram = (Diagram)(tdep = (MappingDiagramNode)parentClassifierNode.getParent()).getModelObject()) != null && (diagramTransform = TransformationSourceManager.getTransformationFromDiagram((Diagram)diagram)) != null && diagramTransform.equals(thisTransform)) {
                    return thisTransform;
                }
            }
        }
        return null;
    }
}

