/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.model.AbstractDiagramModelNode;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.editor.MappingExtent;
import org.teiid.designer.mapping.ui.editor.SummaryExtent;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramEntity;
import org.teiid.designer.metamodels.transformation.FragmentMappingRoot;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.metamodels.transformation.TreeMappingRoot;

public class MappingExtentNode
extends AbstractDiagramModelNode {
    protected static final String sNone = UiConstants.Util.getString("MappingExtentTooltip.none", new Object[0]);
    protected static final String sNamePrefix = UiConstants.Util.getString("MappingExtentTooltip.namePrefix", new Object[0]);
    protected static final String sTypePrefix = UiConstants.Util.getString("MappingExtentTooltip.typePrefix", new Object[0]);
    protected static final String sTargetNamespace = UiConstants.Util.getString("MappingExtentTooltip.targetNamespace", new Object[0]);
    protected static final String sQualifiedName = UiConstants.Util.getString("MappingExtentTooltip.qualifiedName", new Object[0]);
    protected static final String sMappingClassPrefix = UiConstants.Util.getString("MappingExtentTooltip.mappingClassPrefix", new Object[0]);
    protected static final String sStagingTablePrefix = UiConstants.Util.getString("MappingExtentTooltip.stagingTablePrefix", new Object[0]);
    protected static final String sPathInDocumentPrefix = UiConstants.Util.getString("MappingExtentTooltip.pathInDocumentPrefix", new Object[0]);
    protected static final String sXsdComponentPrefix = UiConstants.Util.getString("MappingExtentTooltip.xsdComponentPrefix", new Object[0]);
    protected static final String sMappingRequiredPrefix = UiConstants.Util.getString("MappingExtentTooltip.mappingRequiredPrefix", new Object[0]);
    protected static final String threeSpaces = "   ";
    protected static final String NODE_PREFIX = UiConstants.Util.getString("MappingExtentTooltip.nodePrefix", new Object[0]);
    protected static final String PATH_PREFIX = UiConstants.Util.getString("MappingExtentTooltip.pathPrefix", new Object[0]);
    protected static final int MC_EXTENT_WIDTH = 20;
    protected static final int ST_EXTENT_WIDTH = 40;
    protected static final int SM_EXTENT_WIDTH = 75;
    public static final int X_ORIGIN = 4;
    protected EObject mappingClassEObject = null;
    protected MappingExtent extent = null;
    protected boolean isCoarseExtent = false;

    public MappingExtentNode(Diagram diagramModelObject, EObject modelObject, boolean isCoarse) {
        super(diagramModelObject, modelObject);
        this.setName("M");
        this.isCoarseExtent = isCoarse;
    }

    public MappingExtentNode(DiagramModelNode diagramModelNode, EObject modelObject, MappingExtent theExtent, boolean isCoarse) {
        super((Diagram)diagramModelNode.getModelObject(), modelObject, (Object)theExtent);
        this.isCoarseExtent = isCoarse;
        this.setParent(diagramModelNode);
        this.setExtent(theExtent);
        this.setName("M");
    }

    protected DiagramEntity findDiagramEntity(Diagram diagram, Object secondaryObject) {
        return null;
    }

    protected void initialize(Diagram diagramModelObject, Object secondObject) {
    }

    public String toString() {
        return "MappingExtentNode(" + this.getName() + ")";
    }

    public void setMappingClass(EObject locationEObject) {
        this.mappingClassEObject = locationEObject;
    }

    public EObject getMappingClass() {
        return this.mappingClassEObject;
    }

    public List getDependencies() {
        if (this.getModelObject() instanceof TreeMappingRoot || this.getModelObject() instanceof FragmentMappingRoot) {
            ArrayList<EObject> deps = new ArrayList<EObject>(1);
            Iterator connIter = this.getTargetConnections().iterator();
            NodeConnectionModel nextLink = null;
            while (connIter.hasNext()) {
                nextLink = (NodeConnectionModel)connIter.next();
                if (nextLink.getSourceNode() == null) continue;
                deps.add(((DiagramModelNode)nextLink.getSourceNode()).getModelObject());
            }
            return deps;
        }
        return Collections.EMPTY_LIST;
    }

    public void updateModelForExtent() {
        double zoomFactor = DiagramEditorUtil.getCurrentZoomFactor();
        if (this.getExtent() != null) {
            this.setPosition(new Point(4, (int)(this.extent.getOffset() / zoomFactor)));
            if (this.getExtent().getMappingReference() instanceof StagingTable) {
                this.setSize(new Dimension((int)(40.0 / zoomFactor), (int)(this.extent.getHeight() / zoomFactor)));
            } else if (this.getExtent() instanceof SummaryExtent) {
                this.setSize(new Dimension((int)(75.0 / zoomFactor), (int)(this.extent.getHeight() / zoomFactor)));
            } else {
                this.setSize(new Dimension((int)(20.0 / zoomFactor), (int)(this.extent.getHeight() / zoomFactor)));
            }
        }
    }

    public MappingExtent getExtent() {
        return this.extent;
    }

    public void setExtent(MappingExtent extent) {
        this.extent = extent;
    }

    public void setExtentPosition(int newYOrigin) {
        double zoomFactor = DiagramEditorUtil.getCurrentZoomFactor();
        if (this.getExtent() != null) {
            int iExtentOffset = (int)this.getExtent().getOffset();
            int newY = (int)((double)iExtentOffset / zoomFactor) + (int)((double)newYOrigin / zoomFactor);
            this.setPosition(new Point(4, newY));
        } else {
            this.setPosition(new Point(4, (int)((double)newYOrigin / zoomFactor)));
        }
    }

    public String getReferenceName() {
        String extentReference = this.extent.getDocumentNodeReference().toString();
        return extentReference;
    }

    public boolean isOnCoarseMappingDiagram() {
        return this.isCoarseExtent;
    }

    public EObject getModelObject() {
        if (this.isOnCoarseMappingDiagram()) {
            return super.getModelObject();
        }
        if (this.getExtent() != null && !(this.getExtent().getMappingReference() instanceof StagingTable)) {
            return super.getModelObject();
        }
        if (this.getExtent() != null) {
            return this.getExtent().getMappingReference();
        }
        return super.getModelObject();
    }

    public List getToolTipStrings() {
        ArrayList<String> returnList = new ArrayList<String>();
        if (this.isOnCoarseMappingDiagram()) {
            if (this.getExtent().getMappingReference() instanceof StagingTable) {
                String stName = ModelerCore.getModelEditor().getName(this.getExtent().getMappingReference());
                returnList.add(String.valueOf(sStagingTablePrefix) + stName);
            } else if (this.getExtent().getMappingReference() != null) {
                String stName = ModelerCore.getModelEditor().getName(this.getExtent().getMappingReference());
                returnList.add(String.valueOf(sMappingClassPrefix) + stName);
            } else {
                returnList.add("(unmapped)");
            }
            if (this.getExtent().getDocumentNodeReference() != null) {
                this.addToolTipStringsForLocation(returnList, this.getExtent());
            }
        } else if (this.getExtent() != null) {
            if (this.getExtent().getMappingReference() instanceof StagingTable) {
                String stName = ModelerCore.getModelEditor().getName(this.getExtent().getMappingReference());
                returnList.add(String.valueOf(sStagingTablePrefix) + stName);
            } else {
                String stName = ModelerCore.getModelEditor().getName(super.getModelObject());
                returnList.add(String.valueOf(sNamePrefix) + stName);
                String sType = ModelerCore.getMetamodelRegistry().getMetaClassLabel(super.getModelObject().eClass());
                returnList.add(String.valueOf(sTypePrefix) + sType);
                returnList.add(String.valueOf(sPathInDocumentPrefix) + this.getExtent().getPathToDocumentRoot());
                String sComp = this.getExtent().getXsdQualifiedName();
                if (sComp == null || sComp.trim().length() == 0) {
                    sComp = sNone;
                    returnList.add(String.valueOf(sXsdComponentPrefix) + sComp);
                } else {
                    returnList.add(sXsdComponentPrefix);
                    String sNamespace = this.getExtent().getXsdTargetNamespace();
                    if (sNamespace == null || sNamespace.trim().length() == 0) {
                        sNamespace = sNone;
                    }
                    returnList.add(threeSpaces + sTargetNamespace + sNamespace);
                    returnList.add(threeSpaces + sQualifiedName + sComp);
                }
                stName = "" + this.getExtent().isMappingRequired();
                returnList.add(String.valueOf(sMappingRequiredPrefix) + stName);
            }
        }
        return returnList;
    }

    public List addToolTipStringsForLocation(List lstTooltipStrings, MappingExtent meExtent) {
        String sFullPath = "";
        if (meExtent.getPathToDocumentRoot() != null && !meExtent.getPathToDocumentRoot().equals("null")) {
            sFullPath = meExtent.getPathToDocumentRoot();
        }
        if (!sFullPath.equals("")) {
            int iLastSlash = sFullPath.lastIndexOf(47);
            String sNode = sFullPath.substring(iLastSlash + 1);
            String sPath = sFullPath.substring(0, iLastSlash);
            lstTooltipStrings.add(String.valueOf(NODE_PREFIX) + sNode);
            lstTooltipStrings.add(String.valueOf(PATH_PREFIX) + sPath);
        }
        return lstTooltipStrings;
    }
}

