/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.CoordinateListener;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.editor.DiagramController;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramSelectionHandler;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierNode;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlClassifierEditPart;
import org.teiid.designer.mapping.factory.IMappableTree;
import org.teiid.designer.mapping.factory.ITreeToRelationalMapper;
import org.teiid.designer.mapping.factory.ModelMapperFactory;
import org.teiid.designer.mapping.factory.TreeMappingAdapter;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramSelectionHandler;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramUtil;
import org.teiid.designer.mapping.ui.editor.DocumentContentProvider;
import org.teiid.designer.mapping.ui.editor.DocumentNotificationHandler;
import org.teiid.designer.mapping.ui.editor.DocumentTreeController;
import org.teiid.designer.mapping.ui.editor.MappingAdapterFilter;
import org.teiid.designer.mapping.ui.editor.MappingDiagramBehavior;
import org.teiid.designer.mapping.ui.model.MappingDiagramModelFactory;
import org.teiid.designer.mapping.ui.part.MappingDiagramEditPart;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.InputSet;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.event.IRevealHideListener;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class MappingDiagramController
implements DiagramController,
ISelectionChangedListener,
ControlListener,
IRevealHideListener,
UiConstants {
    DocumentTreeController documentController;
    DiagramEditor diagramEditor;
    int scrollBarYPosition = 0;
    int treeYOrigin = 0;
    private ScrollBar scrollBar = null;
    private int mappingType = 0;
    private SelectionAdapter verticalScrollAdapter;
    private DocumentNotificationHandler notificationHandler;
    private CoordinateListener coordinateListener;
    private Diagram currentDiagram;
    boolean limitAutoScroll = false;
    private static final int SCROLL_OBJECT_LIMIT = 100;
    private static final int SCROLL_EXTENT_LIMIT = 40;
    static final String PREFIX = I18nUtil.getPropertyPrefix(MappingDiagramController.class);
    private List visibleMappingClasses = new ArrayList();
    private boolean bSynchronizeInProgress = false;
    private MappingDiagramBehavior mappingDiagramBehavior;
    private IDoubleClickListener dclDocumentTreeDoubleClickListener;

    public MappingDiagramController(DiagramEditor editor) {
        this.diagramEditor = editor;
        this.documentController = new DocumentTreeController(this);
        this.documentController.createControl((Composite)this.diagramEditor.getPrimaryControl().getSashForm());
        this.documentController.getControl().moveAbove(this.diagramEditor.getDiagramViewer().getControl());
        this.diagramEditor.getPrimaryControl().setControllerControl(this.documentController.getControl());
        this.diagramEditor.getModelObjectSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.documentController);
    }

    public void setDiagramEditor(DiagramEditor editor) {
        this.diagramEditor = editor;
    }

    public ModelResource getCurrentModelResource() {
        ModelResource mr = null;
        if (this.diagramEditor != null && this.diagramEditor.getDiagram() != null) {
            mr = ModelUtilities.getModelResourceForModelObject((EObject)this.diagramEditor.getDiagram());
        }
        return mr;
    }

    public EObject getDocumentEObject() {
        EObject targetEO = null;
        if (this.getMappingType() == 1) {
            MappingClass mappingClassEO = (MappingClass)this.currentDiagram.getTarget();
            targetEO = mappingClassEO.getMappingClassSet().getTarget();
        } else {
            targetEO = this.currentDiagram.getTarget();
        }
        return targetEO;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        List selectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)selection);
        if (!selectedEObjects.isEmpty()) {
            this.getDocumentTreeController().setSelection(selection);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        List selectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)selection);
        if (!selectedEObjects.isEmpty()) {
            this.diagramEditor.getDiagramViewer().getSelectionHandler().select(selection);
            if (this.diagramEditor.getControl() != null && !this.diagramEditor.getControl().isDisposed()) {
                this.documentController.resetExtentsFromDocument();
            }
        }
    }

    public void wireDiagram(Diagram theInput) {
        try {
            this.currentDiagram = theInput;
            if (theInput.getType() != null && theInput.getType().equals("mappingTransformationDiagramType")) {
                this.setMappingType(1);
            } else {
                this.setMappingType(0);
            }
            this.addVerticalScrollListener();
            this.addCoordinateListener();
            EObject targetEO = null;
            if (this.getMappingType() == 1) {
                MappingClass mappingClassEO = (MappingClass)theInput.getTarget();
                targetEO = mappingClassEO.getMappingClassSet().getTarget();
                this.addDocumentTreeListener();
            } else {
                targetEO = theInput.getTarget();
            }
            if (targetEO != null) {
                this.documentController.getViewer().setXmlMappingTarget(targetEO);
                DocumentContentProvider provider = new DocumentContentProvider(this);
                this.documentController.getViewer().setContentProvider((IContentProvider)provider);
                this.documentController.addSelectionChangedListener(this);
                this.documentController.getViewer().setInput(targetEO);
                this.documentController.getViewer().getControl().setRedraw(false);
                this.diagramEditor.getDiagramViewForm().setRedraw(false);
                if (this.getMappingType() == 0) {
                    Object[] oExpandedElements = (Object[])this.diagramEditor.getTreeStatesMap().get(this.getDocumentEObject());
                    if (oExpandedElements != null) {
                        this.documentController.getViewer().setExpandedElements(oExpandedElements);
                    } else {
                        this.doDefaultExpansion();
                    }
                } else {
                    this.doDefaultExpansion();
                }
                this.documentController.getViewer().getControl().setRedraw(true);
                this.diagramEditor.getDiagramViewForm().setRedraw(true);
                ITreeToRelationalMapper mapper = ModelMapperFactory.createModelMapper((EObject)targetEO);
                this.notificationHandler = new DocumentNotificationHandler(this, mapper.getMappableTree());
                this.documentController.getViewer().setMappingType(this.getMappingType());
                this.documentController.getViewer().getTree().getVerticalBar().setSelection(0);
            }
        }
        catch (Exception ex) {
            Util.log(4, (Throwable)ex, ex.getClass().getName());
        }
        this.refresh(false);
    }

    private void addDocumentTreeListener() {
        if (this.dclDocumentTreeDoubleClickListener == null) {
            this.dclDocumentTreeDoubleClickListener = new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    Object element = sel.getFirstElement();
                    if (element instanceof EObject) {
                        EObject selectedEObject = (EObject)element;
                        MappingClass mc = MappingDiagramController.this.getMappingAdapter().getMappingClass(selectedEObject);
                        if (mc == null) {
                            mc = MappingDiagramController.this.getMappingAdapter().getStagingTable(selectedEObject);
                        }
                        if (mc == null) {
                            mc = MappingDiagramController.this.getMappingAdapter().getMappingClass(selectedEObject);
                        }
                        if (mc != null) {
                            MappingDiagramSelectionHandler mdsh = (MappingDiagramSelectionHandler)MappingDiagramController.this.diagramEditor.getDiagramViewer().getSelectionHandler();
                            mdsh.handleDoubleClick((EObject)mc);
                        }
                    }
                }
            };
        }
        this.documentController.getViewer().addDoubleClickListener(this.dclDocumentTreeDoubleClickListener);
    }

    private void removeDocumentTreeListener() {
        if (this.dclDocumentTreeDoubleClickListener != null) {
            this.documentController.getViewer().removeDoubleClickListener(this.dclDocumentTreeDoubleClickListener);
        }
    }

    private void doDefaultExpansion() {
        TreeMappingAdapter mappingAdapter = this.documentController.getViewer().getMappingAdapterFilter(false).getMappingAdapter();
        List mappingClasses = mappingAdapter.getAllMappingClasses();
        if (mappingClasses.size() < this.getLargeMappingClassBreakpointPreference()) {
            this.documentController.getViewer().expandAll();
        } else {
            this.documentController.getViewer().expandToLevel(this.getExpandLevelPreference());
        }
    }

    private int getExpandLevelPreference() {
        int iResult = 1;
        String sExpandLevelVal = UiPlugin.getDefault().getPreferenceStore().getString("autoExpandTargetLevel");
        try {
            Integer IVal = new Integer(sExpandLevelVal);
            if (IVal > 0) {
                iResult = IVal;
            }
        }
        catch (Exception exception) {}
        return iResult;
    }

    private int getLargeMappingClassBreakpointPreference() {
        int iResult = 20;
        String sMaxMappingVal = UiPlugin.getDefault().getPreferenceStore().getString("autoExpandMaxMappingClasses");
        try {
            Integer IVal = new Integer(sMaxMappingVal);
            if (IVal > 0) {
                iResult = IVal;
            }
        }
        catch (Exception exception) {}
        return iResult;
    }

    public void deactivate() {
        this.diagramEditor.getModelObjectSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.documentController);
        this.removeVerticalScrollListener();
        this.removeCoordinateListener();
        if (this.getMappingType() == 0) {
            Object[] oExpandedElements = this.documentController.getViewer().getExpandedElements();
            this.diagramEditor.getTreeStatesMap().put(this.getDocumentEObject(), oExpandedElements);
        }
        this.removeDocumentTreeListener();
    }

    public void dispose() {
        this.documentController.dispose();
    }

    public int getMappingType() {
        return this.mappingType;
    }

    public DocumentTreeController getDocumentTreeController() {
        return this.documentController;
    }

    public void setMappingType(int i) {
        this.mappingType = i;
    }

    void refreshDiagram(IProgressMonitor theMonitor, boolean forceMappingClassReconcile) {
        block19: {
            block18: {
                IProgressMonitor monitor = theMonitor;
                try {
                    try {
                        boolean showProgress;
                        boolean bl = showProgress = monitor != null;
                        if (showProgress) {
                            monitor.subTask(Util.getString(String.valueOf(PREFIX) + "monitorRefreshDiagram", new Object[0]));
                        }
                        if (this.diagramEditor.getDiagram() == null || this.diagramEditor.getCurrentModel() == null) break block18;
                        MappingAdapterFilter mappingFilter = this.documentController.getViewer().getMappingAdapterFilter(false);
                        MappingDiagramModelFactory modelFactory = (MappingDiagramModelFactory)DiagramUiPlugin.getDiagramTypeManager().getDiagram("mappingDiagramType").getModelFactory();
                        if (showProgress) {
                            boolean bl2 = showProgress = !mappingFilter.getMappingAdapter().getAllMappingClasses().isEmpty();
                        }
                        if (!showProgress) {
                            monitor = new NullProgressMonitor();
                        }
                        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Refresh Diagram", (Object)this);
                        boolean succeeded = false;
                        try {
                            if (showProgress) {
                                monitor.subTask(Util.getString(String.valueOf(PREFIX) + "taskRefreshDiagram", new Object[0]));
                                monitor.worked(20);
                            }
                            modelFactory.refresh(this.diagramEditor.getCurrentModel(), this.diagramEditor.getDiagram(), mappingFilter, forceMappingClassReconcile, monitor);
                            if (showProgress) {
                                monitor.subTask(Util.getString(String.valueOf(PREFIX) + "taskAutolayout", new Object[0]));
                                monitor.worked(10);
                            }
                            this.updateForAutoLayout();
                            MappingDiagramUtil.hiliteUnconnectedExtents(this.diagramEditor.getCurrentModel());
                            succeeded = true;
                        }
                        finally {
                            if (requiredStart) {
                                if (succeeded) {
                                    ModelerCore.commitTxn();
                                } else {
                                    ModelerCore.rollbackTxn();
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        UiConstants.Util.log(4, (Throwable)ex, ex.getClass().getName());
                        this.limitAutoScroll = false;
                        if (this.diagramEditor != null && this.diagramEditor.getCurrentModel() != null && this.diagramEditor.getCurrentModel().getChildren() != null) {
                            int nExt = this.getNumberOfExtents(this.diagramEditor.getCurrentModel());
                            this.limitAutoScroll = this.diagramEditor.getCurrentModel().getChildren().size() > 100 || nExt > 40;
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    this.limitAutoScroll = false;
                    if (this.diagramEditor != null && this.diagramEditor.getCurrentModel() != null && this.diagramEditor.getCurrentModel().getChildren() != null) {
                        int nExt = this.getNumberOfExtents(this.diagramEditor.getCurrentModel());
                        this.limitAutoScroll = this.diagramEditor.getCurrentModel().getChildren().size() > 100 || nExt > 40;
                    }
                    throw throwable;
                }
            }
            this.limitAutoScroll = false;
            if (this.diagramEditor != null && this.diagramEditor.getCurrentModel() != null && this.diagramEditor.getCurrentModel().getChildren() != null) {
                int nExt = this.getNumberOfExtents(this.diagramEditor.getCurrentModel());
                this.limitAutoScroll = this.diagramEditor.getCurrentModel().getChildren().size() > 100 || nExt > 40;
            }
        }
    }

    private boolean mappingClassesChanged() {
        boolean haveChanged = true;
        MappingAdapterFilter mappingFilter = this.documentController.getViewer().getMappingAdapterFilter(false);
        List currentMappingClasses = mappingFilter.getMappedClassifiers();
        if (!this.visibleMappingClasses.isEmpty() && this.visibleMappingClasses.size() == currentMappingClasses.size()) {
            boolean allSame = true;
            Iterator currIter = currentMappingClasses.iterator();
            while (currIter.hasNext()) {
                if (this.visibleMappingClasses.contains(currIter.next())) continue;
                allSame = false;
                break;
            }
            if (allSame) {
                haveChanged = false;
            }
        }
        this.visibleMappingClasses = currentMappingClasses;
        return haveChanged;
    }

    private int getNumberOfExtents(Object diagramModelNode) {
        MappingDiagramModelFactory modelFactory = (MappingDiagramModelFactory)DiagramUiPlugin.getDiagramTypeManager().getDiagram("mappingDiagramType").getModelFactory();
        if (modelFactory != null) {
            return modelFactory.getNumberOfMappingExtents(diagramModelNode);
        }
        return 0;
    }

    public void refresh(boolean forceMappingClassReconcile) {
        boolean reconcileMappingClasses;
        if (this.getDocumentEObject() == null || this.getDocumentEObject().eResource() == null) {
            return;
        }
        MappingAdapterFilter filter = this.getMappingFilter(forceMappingClassReconcile);
        boolean bl = reconcileMappingClasses = forceMappingClassReconcile ? true : this.mappingClassesChanged();
        if (filter != null) {
            int nVisibleObjects;
            if (forceMappingClassReconcile) {
                filter.setTreeExpansionMonitorStale();
            }
            if ((nVisibleObjects = filter.getNumberVisibleNodes()) < 60) {
                UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MappingDiagramController.this.refreshDiagram(null, reconcileMappingClasses);
                    }
                });
            } else {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask(Util.getString(String.valueOf(PREFIX) + "taskMappingDiagram", new Object[0]), 100);
                        MappingDiagramController.this.diagramEditor.getDiagramViewForm().setRedraw(false);
                        MappingDiagramController.this.refreshDiagram(monitor, reconcileMappingClasses);
                        MappingDiagramController.this.diagramEditor.getDiagramViewForm().setRedraw(true);
                    }
                };
                try {
                    ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.documentController.getControl().getShell());
                    dlg.run(false, true, op);
                    if (dlg.getProgressMonitor().isCanceled()) {
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {}
            }
        }
    }

    public void resetExtentLocations(int newY) {
        final int tempY = newY;
        if (this.diagramEditor.getDiagram() != null) {
            final Diagram thisDiagram = this.diagramEditor.getDiagram();
            final DiagramModelNode diagramNode = this.diagramEditor.getCurrentModel();
            if (thisDiagram != null && diagramNode != null) {
                UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MappingAdapterFilter mappingFilter = MappingDiagramController.this.documentController.getMappingAdapterFilter();
                        MappingDiagramModelFactory modelFactory = (MappingDiagramModelFactory)DiagramUiPlugin.getDiagramTypeManager().getDiagram("mappingDiagramType").getModelFactory();
                        modelFactory.resetExtentLocations(diagramNode, thisDiagram, mappingFilter, tempY);
                    }
                });
            }
        }
    }

    public void resetExtentLocationsFromDocument(int newY) {
        final int tempY = newY;
        UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                MappingDiagramController.this.treeYOrigin = tempY;
                DiagramViewer scrolledViewer = MappingDiagramController.this.diagramEditor.getDiagramViewer();
                FigureCanvas scrolledCanvas = (FigureCanvas)scrolledViewer.getControl();
                int viewportY = scrolledCanvas.getViewport().getViewLocation().y;
                int yValue = tempY + viewportY;
                MappingDiagramController.this.resetExtentLocations(yValue);
            }
        });
    }

    public int getScrollOffset() {
        return this.treeYOrigin;
    }

    public void resetExtentLocationsFromDiagram(int newY) {
        final int tempY = newY;
        UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                MappingDiagramController.this.scrollBarYPosition = tempY;
                int yValue = tempY + MappingDiagramController.this.treeYOrigin;
                int minY = MappingDiagramController.this.getDiagramYMin();
                int maxY = MappingDiagramController.this.getDiagramYMax();
                int currentCanvasHeight = maxY - minY;
                if (minY < 0 && MappingDiagramController.this.treeYOrigin < 0) {
                    int deltaYSB = MappingDiagramController.this.scrollBarYPosition + MappingDiagramController.this.treeYOrigin;
                    yValue = minY + deltaYSB;
                    MappingDiagramController.this.scrollBarYPosition = MappingDiagramController.this.scrollBarYPosition * (currentCanvasHeight + yValue) / currentCanvasHeight;
                }
                MappingDiagramController.this.resetExtentLocations(yValue);
            }
        });
    }

    private void addVerticalScrollListener() {
        DiagramViewer scrolledViewer = this.diagramEditor.getDiagramViewer();
        FigureCanvas scrolledCanvas = (FigureCanvas)scrolledViewer.getControl();
        this.scrollBar = scrolledCanvas.getVerticalBar();
        this.verticalScrollAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                if (theEvent.detail != 1) {
                    MappingDiagramController.this.autoScrollToReveal();
                    MappingDiagramController.this.documentController.resetExtentsFromDocument();
                }
                if (!MappingDiagramController.this.limitAutoScroll || MappingDiagramController.this.limitAutoScroll && theEvent.detail != 1) {
                    MappingDiagramController.this.documentController.resetExtentsFromDocument();
                }
            }
        };
        this.scrollBar.addSelectionListener((SelectionListener)this.verticalScrollAdapter);
    }

    private void removeVerticalScrollListener() {
        if (this.verticalScrollAdapter != null && this.diagramEditor.getDiagramViewer().isValidViewer()) {
            DiagramViewer scrolledViewer = this.diagramEditor.getDiagramViewer();
            FigureCanvas scrolledCanvas = (FigureCanvas)scrolledViewer.getControl();
            this.scrollBar = scrolledCanvas.getVerticalBar();
            this.scrollBar.removeSelectionListener((SelectionListener)this.verticalScrollAdapter);
        }
    }

    private void addCoordinateListener() {
        if (this.coordinateListener == null) {
            this.coordinateListener = new CoordinateListener(){

                public void coordinateSystemChanged(IFigure f) {
                    MappingDiagramController.this.documentController.resetExtentsFromDocument();
                }
            };
        }
        DiagramViewer scrolledViewer = this.diagramEditor.getDiagramViewer();
        FigureCanvas scrolledCanvas = (FigureCanvas)scrolledViewer.getControl();
        scrolledCanvas.getViewport().addCoordinateListener(this.coordinateListener);
    }

    private void removeCoordinateListener() {
        if (this.coordinateListener != null && this.diagramEditor.getDiagramViewer().isValidViewer()) {
            DiagramViewer scrolledViewer = this.diagramEditor.getDiagramViewer();
            FigureCanvas scrolledCanvas = (FigureCanvas)scrolledViewer.getControl();
            scrolledCanvas.getViewport().removeCoordinateListener(this.coordinateListener);
        }
    }

    public ISelectionProvider getSelectionSource() {
        return this.documentController;
    }

    public void handleNotification(Notification notification) {
        if (this.notificationHandler != null) {
            this.notificationHandler.handleNotification(notification);
        }
    }

    void autoScrollToReveal() {
        EditPart diagramEditPart = this.diagramEditor.getDiagramViewer().getContents();
        if (diagramEditPart instanceof MappingDiagramEditPart) {
            Rectangle vpRect = ((FigureCanvas)this.diagramEditor.getDiagramViewer().getControl()).getViewport().getBounds();
            Point vpLoc = this.diagramEditor.getDiagramViewer().getViewportLocation();
            MappingDiagramEditPart mdep = (MappingDiagramEditPart)diagramEditPart;
            MappingDiagramEditPart.TopAndBottomClassifierInfo info = mdep.getTopAndBottomClassifierInfo();
            if (info.bottomY < vpLoc.y) {
                if (info.bottomPart != null) {
                    this.diagramEditor.getDiagramViewer().reveal((EditPart)info.bottomPart);
                }
            } else if (info.topY > vpLoc.y + vpRect.height && info.topPart != null) {
                this.diagramEditor.getDiagramViewer().reveal((EditPart)info.topPart);
            }
        }
    }

    public boolean maintainControl(Diagram newDiagram) {
        boolean isSameDocument = false;
        try {
            boolean newMappingType = false;
            if (newDiagram.getType() != null && newDiagram.getType().equals("mappingTransformationDiagramType")) {
                newMappingType = true;
            }
            EObject targetEO = null;
            if (newMappingType) {
                MappingClass mappingClassEO = (MappingClass)newDiagram.getTarget();
                targetEO = mappingClassEO.getMappingClassSet().getTarget();
            } else {
                targetEO = newDiagram.getTarget();
            }
            EObject currentTargetEO = (EObject)this.documentController.getViewer().getInput();
            if (targetEO != null && currentTargetEO != null && targetEO.equals(currentTargetEO)) {
                isSameDocument = true;
            }
        }
        catch (Exception ex) {
            UiConstants.Util.log(4, (Throwable)ex, ex.getClass().getName());
        }
        return isSameDocument;
    }

    public void rewireDiagram(Diagram newDiagram) {
        if (newDiagram.getType() != null && newDiagram.getType().equals("mappingTransformationDiagramType")) {
            this.setMappingType(1);
        } else {
            this.setMappingType(0);
        }
        this.currentDiagram = newDiagram;
        this.documentController.getViewer().setMappingType(this.getMappingType());
        this.refresh(true);
        if (this.getMappingType() == 1) {
            this.addDocumentTreeListener();
        }
    }

    public MappingAdapterFilter getMappingFilter(boolean bForceRecreate) {
        MappingAdapterFilter filter = this.documentController.getMappingAdapterFilter(bForceRecreate);
        if (filter == null) {
            String message = "Current diagram = " + this.currentDiagram.getName() + " Document Input = " + this.documentController.getViewer().getInput();
            if (this.currentDiagram.getType().equals("mappingTransformationDiagramType")) {
                message = String.valueOf(message) + " Mapping Class = " + this.currentDiagram.getTarget();
            }
            Util.log(4, (Throwable)new Exception("Mapping Filter Not Found"), message);
        }
        return filter;
    }

    public MappingAdapterFilter getMappingFilter() {
        MappingAdapterFilter filter = this.documentController.getMappingAdapterFilter();
        if (filter == null) {
            String message = "Current diagram = " + this.currentDiagram.getName() + " Document Input = " + this.documentController.getViewer().getInput();
            if (this.currentDiagram.getType().equals("mappingTransformationDiagramType")) {
                message = String.valueOf(message) + " Mapping Class = " + this.currentDiagram.getTarget();
            }
            Util.log(4, (Throwable)new Exception("Mapping Filter Not Found"), message);
        }
        return filter;
    }

    public TreeMappingAdapter getMappingAdapter() {
        MappingAdapterFilter filter = this.getMappingFilter();
        if (filter != null) {
            return filter.getMappingAdapter();
        }
        return null;
    }

    public IMappableTree getMappableTree() {
        MappingAdapterFilter filter = this.getMappingFilter();
        if (filter != null) {
            return filter.getMappableTree();
        }
        return null;
    }

    int getDiagramYMin() {
        int minY = 0;
        EditPart diagramEditPart = this.diagramEditor.getDiagramViewer().getContents();
        if (diagramEditPart instanceof MappingDiagramEditPart) {
            minY = ((MappingDiagramEditPart)diagramEditPart).getLowestYValue();
        }
        return minY;
    }

    int getDiagramYMax() {
        int maxY = 0;
        EditPart diagramEditPart = this.diagramEditor.getDiagramViewer().getContents();
        if (diagramEditPart instanceof MappingDiagramEditPart) {
            maxY = ((MappingDiagramEditPart)diagramEditPart).getHighestYValue();
        }
        return maxY;
    }

    public void clearDiagramSelection() {
        this.diagramEditor.getDiagramViewer().clearAllSelections(false);
    }

    public void updateForAutoLayout() {
        this.autoScrollToReveal();
        this.documentController.resetExtentsFromDocument();
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        if (this.diagramEditor.getControl() != null && !this.diagramEditor.getControl().isDisposed()) {
            this.documentController.resetExtentsFromDocument();
        }
    }

    public void handleZoomChanged() {
        if (this.diagramEditor.getControl() != null && !this.diagramEditor.getControl().isDisposed()) {
            this.documentController.resetExtentsFromDocument();
        }
    }

    public Diagram getCurrentDiagram() {
        return this.currentDiagram;
    }

    public void notifyElementsRevealed(Object oSource, List lstElements) {
        if (this.bSynchronizeInProgress) {
            return;
        }
        if (oSource instanceof UmlClassifierEditPart) {
            this.revealElementsInTree(lstElements);
        } else if (oSource instanceof DocumentTreeController) {
            this.revealElementsInDiagram(lstElements);
        }
    }

    public boolean isRevealHideBehaviorEnabled() {
        boolean bFeatureIsOn = MappingDiagramUtil.getCurrentMappingDiagramBehavior().getSyncTreeAndDiagramState();
        return bFeatureIsOn;
    }

    public IRevealHideListener getRevealHideListener() {
        return this;
    }

    public void notifyElementsHidden(Object oSource, List lstElements) {
        if (this.bSynchronizeInProgress) {
            return;
        }
        if (oSource instanceof UmlClassifierEditPart) {
            this.hideElementsInTree(lstElements);
        } else if (oSource instanceof DocumentTreeController) {
            this.hideElementsInDiagram(lstElements);
        }
    }

    public void revealElementsInTree(List lstElements) {
        List lstResultNodes = this.getTreeNodesForMappingClassColumns(lstElements);
        Iterator itResultNodes = lstResultNodes.iterator();
        this.documentController.getViewer().getTree().setVisible(false);
        while (itResultNodes.hasNext()) {
            Object oTemp = itResultNodes.next();
            this.documentController.getViewer().reveal(oTemp);
        }
        if (!lstResultNodes.isEmpty()) {
            this.documentController.getViewer().reveal(lstResultNodes.get(0));
        }
        this.documentController.getViewer().getTree().setVisible(true);
    }

    public List getTreeNodesForMappingClassColumns(List lstElements) {
        TreeMappingAdapter mappingAdapter = this.documentController.getViewer().getMappingAdapterFilter(false).getMappingAdapter();
        List lstNodes = new ArrayList();
        Iterator it = lstElements.iterator();
        ArrayList arylResultNodes = new ArrayList();
        while (it.hasNext()) {
            MappingClassColumn mccTemp = (MappingClassColumn)it.next();
            lstNodes = mappingAdapter.getMappingClassColumnOutputLocations(mccTemp);
            for (Object oTemp : lstNodes) {
                if (arylResultNodes.contains(oTemp)) continue;
                arylResultNodes.add(oTemp);
            }
        }
        return arylResultNodes;
    }

    public void hideElementsInTree(List lstElements) {
        ITreeContentProvider cp = (ITreeContentProvider)this.documentController.getViewer().getContentProvider();
        List lstResultNodes = this.getTreeNodesForMappingClassColumns(lstElements);
        for (EObject eoTemp : lstResultNodes) {
            boolean bOkToCollapseParent = true;
            Object oParent = cp.getParent((Object)eoTemp);
            if (oParent == null || !(oParent instanceof EObject)) continue;
            Object[] children = cp.getChildren(oParent);
            int i = 0;
            while (i < children.length) {
                if (!(children[i] instanceof InputSet) && !lstResultNodes.contains(children[i])) {
                    bOkToCollapseParent = false;
                    break;
                }
                ++i;
            }
            if (!bOkToCollapseParent) continue;
            this.documentController.getViewer().setExpandedState(oParent, false);
        }
    }

    public void revealElementsInDiagram(List lstElements) {
        ArrayList<MappingClass> arylParentsToExpand = new ArrayList<MappingClass>();
        List lstMCCols = this.getMappingClassColumnsForTreeNodes(lstElements);
        for (MappingClassColumn mccTemp : lstMCCols) {
            MappingClass mc = mccTemp.getMappingClass();
            if (arylParentsToExpand.contains(mc)) continue;
            arylParentsToExpand.add(mc);
        }
        if (arylParentsToExpand.size() > 0) {
            DiagramSelectionHandler dsh = new DiagramSelectionHandler(this.diagramEditor.getDiagramViewer());
            for (MappingClass mcTemp : arylParentsToExpand) {
                EditPart ep = dsh.findEditPart((EObject)mcTemp, false);
                if (!(ep instanceof UmlClassifierEditPart)) continue;
                this.bSynchronizeInProgress = true;
                UmlClassifierNode node = (UmlClassifierNode)((UmlClassifierEditPart)ep).getModel();
                node.expand();
                this.bSynchronizeInProgress = false;
            }
            this.diagramEditor.doRefreshDiagram();
        }
    }

    public List getMappingClassColumnsForTreeNodes(List lstElements) {
        TreeMappingAdapter mappingAdapter = this.documentController.getViewer().getMappingAdapterFilter(false).getMappingAdapter();
        Iterator it = lstElements.iterator();
        ArrayList<MappingClassColumn> arylResultNodes = new ArrayList<MappingClassColumn>();
        while (it.hasNext()) {
            EObject eoTemp = (EObject)it.next();
            MappingClassColumn oMCCol = mappingAdapter.getMappingClassColumn(eoTemp);
            if (oMCCol == null) continue;
            arylResultNodes.add(oMCCol);
        }
        return arylResultNodes;
    }

    public void hideElementsInDiagram(List lstElements) {
        ArrayList<MappingClass> arylParentsToCollapse = new ArrayList<MappingClass>();
        List lstMCCols = this.getMappingClassColumnsForTreeNodes(lstElements);
        for (MappingClassColumn mccTemp : lstMCCols) {
            MappingClass mc = mccTemp.getMappingClass();
            if (arylParentsToCollapse.contains(mc)) continue;
            arylParentsToCollapse.add(mc);
        }
        if (arylParentsToCollapse.size() > 0) {
            DiagramSelectionHandler dsh = new DiagramSelectionHandler(this.diagramEditor.getDiagramViewer());
            for (MappingClass mcTemp : arylParentsToCollapse) {
                EditPart ep = dsh.findEditPart((EObject)mcTemp, false);
                if (!(ep instanceof UmlClassifierEditPart)) continue;
                this.bSynchronizeInProgress = true;
                UmlClassifierNode node = (UmlClassifierNode)((UmlClassifierEditPart)ep).getModel();
                node.collapse();
                this.bSynchronizeInProgress = false;
            }
        }
    }

    public MappingDiagramBehavior getMappingDiagramBehavior() {
        if (this.mappingDiagramBehavior == null) {
            this.mappingDiagramBehavior = new MappingDiagramBehavior();
        }
        return this.mappingDiagramBehavior;
    }
}

