/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.editor;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingHelper;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.IgnorableNotificationSource;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.mapping.factory.IMappableTree;
import org.teiid.designer.mapping.ui.editor.MappingDiagramController;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.MappingClassObject;
import org.teiid.designer.metamodels.transformation.MappingClassSet;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class DocumentNotificationHandler {
    private static final String[] notificationTypes = new String[]{"CREATE", "SET", "UNSET", "ADD", "REMOVE", "ADD_MANY", "REMOVE_MANY", "MOVE", "REMOVING_ADAPTER", "RESOLVE"};
    private MappingDiagramController mappingDiagramController;
    private IMappableTree mappableTree;

    public DocumentNotificationHandler(MappingDiagramController controller, IMappableTree theTree) {
        this.mappingDiagramController = controller;
        this.mappableTree = theTree;
    }

    public void handleNotification(Notification notification) {
        boolean ignoreNotification;
        boolean somethingChanged = false;
        boolean bl = ignoreNotification = notification instanceof SourcedNotification && ((SourcedNotification)notification).getSource() instanceof IgnorableNotificationSource;
        if (!ignoreNotification) {
            if (notification instanceof SourcedNotification) {
                if (((SourcedNotification)notification).getSource() != this.mappingDiagramController) {
                    Collection notifications = ((SourcedNotification)notification).getNotifications();
                    Iterator iter = notifications.iterator();
                    boolean singleChange = false;
                    while (iter.hasNext()) {
                        singleChange = this.handleSingleNotification((Notification)iter.next());
                        if (somethingChanged || !singleChange) continue;
                        somethingChanged = true;
                    }
                }
            } else {
                somethingChanged = this.handleSingleNotification(notification);
            }
        }
        if (somethingChanged && this.shouldRefreshDiagram(notification)) {
            this.mappingDiagramController.refresh(true);
        }
    }

    private boolean shouldHandleMappingClassSet(MappingClassSet theMappingClassSet) {
        return theMappingClassSet.getTarget().equals(this.mappableTree.getTreeRoot());
    }

    private boolean isMappingObject(EObject eObject) {
        boolean result = false;
        if (eObject instanceof Mapping || eObject instanceof MappingClass || eObject instanceof MappingClassColumn || eObject instanceof MappingClassSet || eObject instanceof MappingHelper) {
            result = true;
        }
        return result;
    }

    public boolean shouldHandleNotification(Notification notification) {
        EObject notifier;
        boolean result = false;
        boolean isDiagramObject = false;
        if (NotificationUtilities.isEObjectNotifier((Notification)notification) && !(isDiagramObject = DiagramUiUtilities.isDiagramObject((EObject)(notifier = (EObject)ModelerCore.getModelEditor().getChangedObject(notification))))) {
            if (this.mappableTree.isAncestorOf(this.mappableTree.getTreeRoot(), notifier)) {
                result = true;
            } else {
                EObject parent = notifier.eContainer();
                if (notifier instanceof MappingClassSet) {
                    result = this.shouldHandleMappingClassSet((MappingClassSet)notifier);
                } else if (notifier instanceof MappingClassObject && parent != null && parent instanceof MappingClassSet) {
                    result = this.shouldHandleMappingClassSet((MappingClassSet)notifier.eContainer());
                } else if (notifier instanceof MappingClassColumn) {
                    result = true;
                } else if (parent instanceof MappingClassObject && parent.eContainer() != null) {
                    result = this.shouldHandleMappingClassSet((MappingClassSet)parent.eContainer());
                } else if (parent instanceof Mapping) {
                    result = true;
                }
            }
        }
        return result;
    }

    private boolean handleSingleNotification(Notification notification) {
        boolean result = false;
        if (this.shouldHandleNotification(notification)) {
            if (NotificationUtilities.isAdded((Notification)notification)) {
                result = this.performAdd(notification);
            } else if (NotificationUtilities.isRemoved((Notification)notification)) {
                result = this.performRemove(notification);
            } else if (NotificationUtilities.isChanged((Notification)notification)) {
                result = this.performChange(notification);
            }
        }
        return result;
    }

    private boolean performAdd(Notification notification) {
        boolean somethingChanged = false;
        Object targetObject = ModelerCore.getModelEditor().getChangedObject(notification);
        if (targetObject != null && targetObject instanceof EObject) {
            if (targetObject instanceof MappingClassSet && this.shouldHandleMappingClassSet((MappingClassSet)targetObject)) {
                somethingChanged = true;
            } else {
                this.mappingDiagramController.getDocumentTreeController().getViewer().refresh(targetObject, true);
                somethingChanged = true;
            }
        }
        return somethingChanged;
    }

    private boolean performRemove(Notification notification) {
        boolean somethingChanged = false;
        Object targetObject = ModelerCore.getModelEditor().getChangedObject(notification);
        if (targetObject != null && targetObject instanceof EObject) {
            if (targetObject instanceof MappingClassSet && this.shouldHandleMappingClassSet((MappingClassSet)targetObject)) {
                somethingChanged = true;
            } else if (targetObject instanceof Mapping) {
                somethingChanged = true;
            } else if (targetObject instanceof MappingClass || targetObject instanceof MappingClassColumn) {
                somethingChanged = true;
            } else {
                this.mappingDiagramController.getDocumentTreeController().getViewer().refresh(targetObject, true);
                somethingChanged = true;
            }
        }
        return somethingChanged;
    }

    private boolean performChange(Notification notification) {
        boolean somethingChanged = false;
        Object targetObject = ModelerCore.getModelEditor().getChangedObject(notification);
        if (targetObject != null && targetObject instanceof EObject) {
            if (targetObject instanceof MappingClassSet && this.shouldHandleMappingClassSet((MappingClassSet)targetObject)) {
                somethingChanged = true;
            } else if (this.isMappingObject((EObject)targetObject)) {
                somethingChanged = true;
            } else {
                this.mappingDiagramController.getDocumentTreeController().getViewer().refresh(targetObject, true);
                somethingChanged = true;
            }
        }
        return somethingChanged;
    }

    private boolean shouldRefreshDiagram(Notification notification) {
        boolean shouldRefresh = false;
        ModelResource documentMR = this.mappingDiagramController.getCurrentModelResource();
        if (documentMR != null) {
            if (notification instanceof SourcedNotification) {
                Collection notifications = ((SourcedNotification)notification).getNotifications();
                Iterator iter = notifications.iterator();
                Notification nextNotification = null;
                while (iter.hasNext() && !shouldRefresh) {
                    MappingClassSet mapSet;
                    ModelResource mr;
                    nextNotification = (Notification)iter.next();
                    Object targetObject = ModelerCore.getModelEditor().getChangedObject(nextNotification);
                    if (targetObject == null || !(targetObject instanceof EObject) || DiagramUiUtilities.isDiagramObject((EObject)((EObject)targetObject)) || (mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)targetObject))) == null || !mr.equals(documentMR)) continue;
                    SourcedNotification sn = (SourcedNotification)notification;
                    Object src = sn.getSource();
                    if (src instanceof DiagramModelNode) {
                        DiagramModelNode dmn = (DiagramModelNode)src;
                        Diagram diag = DocumentNotificationHandler.findDiagram(dmn);
                        if (!this.mappingDiagramController.getCurrentDiagram().equals(diag)) continue;
                        shouldRefresh = false;
                        continue;
                    }
                    if (targetObject instanceof TransformationMappingRoot) {
                        mapSet = this.findMappingClassSet(((TransformationMappingRoot)targetObject).getTarget());
                        shouldRefresh = this.shouldHandleMappingClassSet(mapSet);
                        continue;
                    }
                    if (targetObject instanceof MappingClassObject) {
                        mapSet = this.findMappingClassSet(targetObject);
                        shouldRefresh = this.shouldHandleMappingClassSet(mapSet);
                        continue;
                    }
                    shouldRefresh = true;
                }
            } else {
                ModelResource mr;
                Object targetObject = ModelerCore.getModelEditor().getChangedObject(notification);
                if (targetObject != null && targetObject instanceof EObject && !DiagramUiUtilities.isDiagramObject((EObject)((EObject)targetObject)) && (mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)targetObject))) != null && mr.equals(documentMR)) {
                    shouldRefresh = true;
                }
            }
        }
        return shouldRefresh;
    }

    private MappingClassSet findMappingClassSet(Object targetObject) {
        MappingClassSet result = null;
        if (targetObject instanceof EObject) {
            EObject parent = ((EObject)targetObject).eContainer();
            result = targetObject instanceof MappingClassSet ? (MappingClassSet)targetObject : (parent instanceof MappingClassSet ? (MappingClassSet)parent : this.findMappingClassSet(parent));
        }
        return result;
    }

    public static Diagram findDiagram(DiagramModelNode dmn) {
        DiagramModelNode nextNode = dmn;
        Diagram diag = nextNode.getDiagram();
        while (diag == null) {
            nextNode = nextNode.getParent();
            diag = nextNode.getDiagram();
        }
        return diag;
    }

    public static String paramString2(Notification theNotification) {
        if (theNotification.getEventType() == 3) {
            return new StringBuffer().append("\n Notification:  TYPE =").append(notificationTypes[theNotification.getEventType()]).append("\n    NOTIFIER =").append(NotificationUtilities.getEObject((Notification)theNotification)).append("\n    getAddedChildren=").append(DocumentNotificationHandler.getAddedChildrenPrintString(theNotification)).toString();
        }
        if (theNotification.getEventType() == 4) {
            return new StringBuffer().append("\n Notification:  TYPE =").append(notificationTypes[theNotification.getEventType()]).append("\n    NOTIFIER =").append(NotificationUtilities.getEObject((Notification)theNotification)).append("\n    getRemovedChildren=").append(DocumentNotificationHandler.getRemovedChildrenPrintString(theNotification)).toString();
        }
        if (theNotification.getEventType() == 1) {
            return new StringBuffer().append("\n Notification:  TYPE =").append(notificationTypes[theNotification.getEventType()]).append("\n    NOTIFIER =").append(NotificationUtilities.getEObject((Notification)theNotification)).toString();
        }
        return NotificationUtilities.paramString((Notification)theNotification);
    }

    private static String getAddedChildrenPrintString(Notification notification) {
        if (NotificationUtilities.getAddedChildren((Notification)notification) == null || NotificationUtilities.getAddedChildren((Notification)notification).length == 0) {
            return "EMPTY";
        }
        StringBuffer returnString = new StringBuffer().append(" ");
        int i = 0;
        while (i < NotificationUtilities.getAddedChildren((Notification)notification).length) {
            returnString.append("\n     child =").append(NotificationUtilities.getAddedChildren((Notification)notification)[i]);
            ++i;
        }
        return returnString.toString();
    }

    private static String getRemovedChildrenPrintString(Notification notification) {
        if (NotificationUtilities.getRemovedChildren((Notification)notification) == null || NotificationUtilities.getRemovedChildren((Notification)notification).length == 0) {
            return "EMPTY";
        }
        StringBuffer returnString = new StringBuffer().append(" ");
        int i = 0;
        while (i < NotificationUtilities.getRemovedChildren((Notification)notification).length) {
            returnString.append("\n     child =").append(NotificationUtilities.getRemovedChildren((Notification)notification)[i]);
            ++i;
        }
        return returnString.toString();
    }
}

