/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.actions.DiagramGlobalActionsMap;
import org.teiid.designer.diagram.ui.actions.RefreshAction;
import org.teiid.designer.diagram.ui.editor.DiagramActionAdapter;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramToolBarManager;
import org.teiid.designer.diagram.ui.pakkage.actions.RenameAction;
import org.teiid.designer.mapping.factory.ITreeToRelationalMapper;
import org.teiid.designer.mapping.factory.MappingClassFactory;
import org.teiid.designer.mapping.factory.ModelMapperFactory;
import org.teiid.designer.mapping.factory.TreeMappingAdapter;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.actions.CloneAction;
import org.teiid.designer.mapping.ui.actions.CollapseAllEnumsAction;
import org.teiid.designer.mapping.ui.actions.CopyAction;
import org.teiid.designer.mapping.ui.actions.CutAction;
import org.teiid.designer.mapping.ui.actions.DeleteAction;
import org.teiid.designer.mapping.ui.actions.DeleteMappingLinksAction;
import org.teiid.designer.mapping.ui.actions.ExpandAllEnumsAction;
import org.teiid.designer.mapping.ui.actions.GenerateMappingClassesAction;
import org.teiid.designer.mapping.ui.actions.IMappingDiagramActionConstants;
import org.teiid.designer.mapping.ui.actions.LockAction;
import org.teiid.designer.mapping.ui.actions.MappingAction;
import org.teiid.designer.mapping.ui.actions.MappingSelectionHelper;
import org.teiid.designer.mapping.ui.actions.MergeMappingClassesAction;
import org.teiid.designer.mapping.ui.actions.NewMappingClassAction;
import org.teiid.designer.mapping.ui.actions.NewMappingLinkAction;
import org.teiid.designer.mapping.ui.actions.NewStagingTableAction;
import org.teiid.designer.mapping.ui.actions.PasteAction;
import org.teiid.designer.mapping.ui.actions.SaveMappingDiagramAction;
import org.teiid.designer.mapping.ui.actions.ShowDetailedMappingDiagramAction;
import org.teiid.designer.mapping.ui.actions.ShowParentDiagramAction;
import org.teiid.designer.mapping.ui.actions.SplitMappingClassAction;
import org.teiid.designer.mapping.ui.actions.ToggleDisplayAllMappingClassesAction;
import org.teiid.designer.mapping.ui.actions.ToggleFoldAllMappingClassesAction;
import org.teiid.designer.mapping.ui.actions.TogglePopulateDiagramFromTreeSelectionAction;
import org.teiid.designer.mapping.ui.editor.MappingDiagramController;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.InputParameter;
import org.teiid.designer.metamodels.transformation.InputSet;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.MappingClassSet;
import org.teiid.designer.metamodels.transformation.TransformationContainer;
import org.teiid.designer.metamodels.transformation.TransformationFactory;
import org.teiid.designer.metamodels.transformation.TransformationPlugin;
import org.teiid.designer.transformation.ui.actions.AddJoinExpressionAction;
import org.teiid.designer.transformation.ui.actions.AddToSqlSelectAction;
import org.teiid.designer.transformation.ui.actions.AddTransformationSourceAction;
import org.teiid.designer.transformation.ui.actions.AddUnionSourceAction;
import org.teiid.designer.transformation.ui.actions.ClearTransformationAction;
import org.teiid.designer.transformation.ui.actions.ReconcileTransformationAction;
import org.teiid.designer.transformation.ui.actions.RemoveTransformationSourceAction;
import org.teiid.designer.transformation.ui.actions.TransformationAction;
import org.teiid.designer.transformation.ui.actions.TransformationSourceManager;
import org.teiid.designer.ui.actions.CopyFullNameAction;
import org.teiid.designer.ui.actions.CopyNameAction;
import org.teiid.designer.ui.actions.IModelObjectActionContributor;
import org.teiid.designer.ui.actions.IModelerActionConstants;
import org.teiid.designer.ui.actions.ModelerActionBarIdManager;
import org.teiid.designer.ui.actions.ModelerGlobalActionsMap;
import org.teiid.designer.ui.common.actions.AbstractAction;
import org.teiid.designer.ui.common.actions.ControlledPopupMenuExtender;
import org.teiid.designer.ui.common.actions.GlobalActionsMap;
import org.teiid.designer.ui.common.actions.IActionConstants;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.editors.ModelEditorSite;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class MappingDiagramActionAdapter
extends DiagramActionAdapter
implements UiConstants,
IMappingDiagramActionConstants {
    private static final String D_MARKER = " mappingDiagramStart";
    private static final String T_MARKER = "transformationStart";
    private static final String M_MARKER = "mappingStart";
    static final String PARAM_BASE_NAME = UiConstants.Util.getString("MappingDiagramActionAdapter.inputParamBaseName.text", new Object[0]);
    static final String NEW_INPUT_PARAMETER_TITLE = UiConstants.Util.getString("MappingDiagramActionAdapter.inputParameterTitle.text", new Object[0]);
    private List modelObjectContributors;
    private AbstractAction showDetailedMappingAction;
    private MappingAction newMappingClassAction;
    private MappingAction newStagingTableAction;
    private MappingAction newMappingLinkAction;
    private MappingAction deleteMappingLinksAction;
    private MappingAction mergeMappingClassesAction;
    private MappingAction splitMappingClassAction;
    private MappingAction toggleDisplayAllMappingClassesAction;
    private MappingAction toggleFoldAllMappingClassesAction;
    private MappingAction togglePopulateDiagramFromTreeSelectionAction;
    private MappingAction expandAllEnumsAction;
    private MappingAction collapseAllEnumsAction;
    private GenerateMappingClassesAction generateMappingClassesAction;
    private MappingAction lockAction;
    private RefreshAction refreshDiagramAction;
    private AbstractAction saveDiagramAction;
    private ShowParentDiagramAction upDiagramAction;
    private AddTransformationSourceAction addSourcesAction;
    private AddUnionSourceAction addUnionSourcesAction;
    private TransformationAction removeSourcesAction;
    private TransformationAction clearSourcesAction;
    private TransformationAction reconcileAction;
    private TransformationAction addToSqlSelectAction;
    private TransformationAction addJoinExpressionAction;
    private MappingAction deleteAction;
    private MappingAction cutAction;
    private MappingAction copyAction;
    private MappingAction pasteAction;
    private MappingAction cloneAction;
    private RenameAction renameAction;
    private AddInputSetParameterAction addInputSetParameterAction;
    private ModelerGlobalActionsMap actionsMap;

    public MappingDiagramActionAdapter(ModelEditorPage page) {
        super(page);
    }

    private void addDiagramActions(IMenuManager theMenuMgr) {
        if (this.isDetailedMapping()) {
            theMenuMgr.add((IContributionItem)new Separator());
            theMenuMgr.add((IContributionItem)new GroupMarker(D_MARKER));
            theMenuMgr.appendToGroup(D_MARKER, (IAction)this.refreshDiagramAction);
            theMenuMgr.appendToGroup(D_MARKER, (IAction)this.upDiagramAction);
            theMenuMgr.appendToGroup(D_MARKER, (IAction)this.saveDiagramAction);
        } else {
            theMenuMgr.add((IContributionItem)new Separator());
            theMenuMgr.add((IContributionItem)new GroupMarker(D_MARKER));
            theMenuMgr.appendToGroup(D_MARKER, (IAction)this.refreshDiagramAction);
            theMenuMgr.appendToGroup(D_MARKER, (IAction)this.saveDiagramAction);
        }
    }

    private void addExtendedActions(IMenuManager theMenuMgr) {
        ISelectionProvider selProvider = this.getEditorPage().getModelObjectSelectionProvider();
        if (selProvider != null) {
            IEditorPart editor = ((ModelEditorSite)this.getEditorPage().getEditorSite()).getEditor();
            ControlledPopupMenuExtender popupMenuExtender = new ControlledPopupMenuExtender("diagramEditorPage.contextMenu", (MenuManager)theMenuMgr, selProvider, (IWorkbenchPart)editor);
            popupMenuExtender.menuAboutToShow(theMenuMgr);
        }
    }

    private void addExternalExportedActions(IMenuManager theMenuMgr, ISelection selection) {
        List contributors = this.getModelObjectActionContributors();
        int size = contributors.size();
        int i = 0;
        while (i < size) {
            IModelObjectActionContributor contributor = (IModelObjectActionContributor)contributors.get(i);
            contributor.contributeToContextMenu(theMenuMgr, selection);
            ++i;
        }
    }

    private void contributeCoarseActions(IMenuManager theMenuMgr, ISelection selection) {
        block17: {
            MappingSelectionHelper selectionHelper;
            block16: {
                selectionHelper = new MappingSelectionHelper(selection);
                if (selectionHelper.getCountType() != 1) break block16;
                switch (selectionHelper.getType()) {
                    case 0: 
                    case 1: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        this.resetTransformationActions();
                        if (!ModelIdentifier.isLogicalModel((ModelResource)((DiagramEditor)this.getEditorPage()).getCurrentModelResource())) {
                            theMenuMgr.add((IContributionItem)new Separator());
                            theMenuMgr.add((IContributionItem)new GroupMarker(M_MARKER));
                            theMenuMgr.appendToGroup(M_MARKER, (IAction)this.showDetailedMappingAction);
                            theMenuMgr.appendToGroup(M_MARKER, (IAction)this.generateMappingClassesAction);
                            theMenuMgr.appendToGroup(M_MARKER, (IAction)this.splitMappingClassAction);
                            theMenuMgr.appendToGroup(M_MARKER, (IAction)this.lockAction);
                        }
                        this.addDiagramActions(theMenuMgr);
                        break;
                    }
                    case -1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 9: {
                        break;
                    }
                    case 11: {
                        this.resetTransformationActions();
                        if (ModelIdentifier.isLogicalModel((ModelResource)((DiagramEditor)this.getEditorPage()).getCurrentModelResource())) {
                            theMenuMgr.add((IAction)this.expandAllEnumsAction);
                            theMenuMgr.add((IAction)this.collapseAllEnumsAction);
                        }
                        this.addDiagramActions(theMenuMgr);
                        break;
                    }
                    case 26: 
                    case 27: {
                        theMenuMgr.add((IAction)this.expandAllEnumsAction);
                        theMenuMgr.add((IAction)this.collapseAllEnumsAction);
                        theMenuMgr.add((IContributionItem)new Separator());
                        IAction openAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.OPEN);
                        if (openAction != null) {
                            theMenuMgr.add(openAction);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block17;
            }
            if (selectionHelper.getCountType() == -1) {
                switch (selectionHelper.getType()) {
                    case 0: 
                    case 1: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        this.resetTransformationActions();
                        theMenuMgr.add((IContributionItem)new Separator());
                        theMenuMgr.add((IContributionItem)new GroupMarker(M_MARKER));
                        theMenuMgr.appendToGroup(M_MARKER, (IAction)this.showDetailedMappingAction);
                        theMenuMgr.appendToGroup(M_MARKER, (IAction)this.generateMappingClassesAction);
                        theMenuMgr.appendToGroup(M_MARKER, (IAction)this.splitMappingClassAction);
                        theMenuMgr.appendToGroup(M_MARKER, (IAction)this.mergeMappingClassesAction);
                        theMenuMgr.appendToGroup(M_MARKER, (IAction)this.toggleDisplayAllMappingClassesAction);
                        theMenuMgr.appendToGroup(M_MARKER, (IAction)this.toggleFoldAllMappingClassesAction);
                        theMenuMgr.appendToGroup(M_MARKER, (IAction)this.togglePopulateDiagramFromTreeSelectionAction);
                        this.addDiagramActions(theMenuMgr);
                        break;
                    }
                    case -1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 9: {
                        break;
                    }
                }
            } else if (selectionHelper.getCountType() == 2) {
                this.resetTransformationActions();
                this.addDiagramActions(theMenuMgr);
            }
        }
        theMenuMgr.add((IContributionItem)new Separator());
    }

    private void contributeDetailedActions(IMenuManager theMenuMgr, ISelection selection) {
        if (this.isDetailedMapping()) {
            Diagram currentDiagram = ((DiagramEditor)this.getEditorPage()).getDiagram();
            EObject transformationEObject = TransformationSourceManager.getTransformationFromDiagram((Diagram)currentDiagram);
            MappingSelectionHelper selectionHelper = new MappingSelectionHelper(transformationEObject, selection);
            if (selectionHelper.getCountType() == 1) {
                switch (selectionHelper.getType()) {
                    case 9: {
                        this.resetTransformationActions();
                        IAction editAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.EDIT);
                        if (editAction != null) {
                            theMenuMgr.add(editAction);
                        }
                        theMenuMgr.add((IContributionItem)new Separator());
                        theMenuMgr.add((IAction)this.clearSourcesAction);
                        theMenuMgr.add((IContributionItem)new Separator());
                        this.addDiagramActions(theMenuMgr);
                        break;
                    }
                    case 4: {
                        this.resetTransformationActions();
                        IAction newChildAction = this.getAction(ModelerActionBarIdManager.getInsertChildMenuId());
                        if (newChildAction != null) {
                            theMenuMgr.add(newChildAction);
                        } else {
                            this.addInputSetParameterAction.setInputSet(selectionHelper.getSingleEObject());
                            theMenuMgr.add((IAction)this.addInputSetParameterAction);
                        }
                        IAction editAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.EDIT);
                        if (editAction != null) {
                            theMenuMgr.add(editAction);
                        }
                        theMenuMgr.add((IContributionItem)new Separator());
                        theMenuMgr.add((IContributionItem)new GroupMarker(T_MARKER));
                        theMenuMgr.appendToGroup(T_MARKER, (IAction)this.clearSourcesAction);
                        theMenuMgr.add((IContributionItem)new Separator());
                        this.addDiagramActions(theMenuMgr);
                        break;
                    }
                    case 5: {
                        this.resetTransformationActions();
                        this.addDiagramActions(theMenuMgr);
                        break;
                    }
                    case 3: 
                    case 25: {
                        this.resetTransformationActions();
                        IAction existingAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.OPEN);
                        if (existingAction != null) {
                            theMenuMgr.add(existingAction);
                        }
                        theMenuMgr.add((IContributionItem)new Separator());
                        theMenuMgr.add((IContributionItem)new GroupMarker(T_MARKER));
                        theMenuMgr.appendToGroup(T_MARKER, (IAction)this.removeSourcesAction);
                        theMenuMgr.appendToGroup(T_MARKER, (IAction)this.clearSourcesAction);
                        theMenuMgr.appendToGroup(T_MARKER, (IAction)this.addToSqlSelectAction);
                        theMenuMgr.add((IContributionItem)new Separator("transformationEnd"));
                        MenuManager copyMenu = this.getCopyNameSubMenu(selection);
                        if (copyMenu != null) {
                            theMenuMgr.add((IContributionItem)copyMenu);
                            theMenuMgr.add((IContributionItem)new Separator());
                        }
                        this.addExtendedActions(theMenuMgr);
                        break;
                    }
                    case 2: 
                    case 24: {
                        this.resetTransformationActions();
                        IAction existingAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.OPEN);
                        if (existingAction != null) {
                            theMenuMgr.add(existingAction);
                        }
                        theMenuMgr.add((IContributionItem)new Separator());
                        theMenuMgr.add((IContributionItem)new GroupMarker(T_MARKER));
                        theMenuMgr.appendToGroup(T_MARKER, (IAction)this.addSourcesAction);
                        theMenuMgr.appendToGroup(T_MARKER, (IAction)this.removeSourcesAction);
                        theMenuMgr.appendToGroup(T_MARKER, (IAction)this.clearSourcesAction);
                        if (selectionHelper.isVirtual()) {
                            this.addExternalExportedActions(theMenuMgr, selection);
                        }
                        theMenuMgr.add((IContributionItem)new Separator("transformationEnd"));
                        MenuManager copyMenu = this.getCopyNameSubMenu(selection);
                        if (copyMenu != null) {
                            theMenuMgr.add((IContributionItem)copyMenu);
                            theMenuMgr.add((IContributionItem)new Separator());
                        }
                        this.addExtendedActions(theMenuMgr);
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 22: 
                    case 23: {
                        this.resetTransformationActions();
                        theMenuMgr.add((IContributionItem)new GroupMarker(M_MARKER));
                        theMenuMgr.appendToGroup(M_MARKER, (IAction)this.lockAction);
                        this.addDiagramActions(theMenuMgr);
                        break;
                    }
                    case 20: {
                        this.resetTransformationActions();
                        theMenuMgr.add((IContributionItem)new GroupMarker(M_MARKER));
                        theMenuMgr.appendToGroup(M_MARKER, (IAction)this.deleteMappingLinksAction);
                        this.addDiagramActions(theMenuMgr);
                        break;
                    }
                    case -1: {
                        break;
                    }
                    case 11: {
                        this.resetTransformationActions();
                        this.addDiagramActions(theMenuMgr);
                        break;
                    }
                }
            } else if (selectionHelper.getCountType() == -1) {
                switch (selectionHelper.getType()) {
                    case 9: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 3: 
                    case 25: {
                        this.resetTransformationActions();
                        theMenuMgr.add((IContributionItem)new GroupMarker(T_MARKER));
                        theMenuMgr.appendToGroup(T_MARKER, (IAction)this.removeSourcesAction);
                        theMenuMgr.appendToGroup(T_MARKER, (IAction)this.clearSourcesAction);
                        theMenuMgr.appendToGroup(T_MARKER, (IAction)this.addToSqlSelectAction);
                        theMenuMgr.appendToGroup(T_MARKER, (IAction)this.addJoinExpressionAction);
                        theMenuMgr.add((IContributionItem)new Separator());
                        break;
                    }
                    case 2: 
                    case 24: {
                        this.resetTransformationActions();
                        IAction existingAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.OPEN);
                        if (existingAction != null) {
                            theMenuMgr.add(existingAction);
                        }
                        theMenuMgr.add((IContributionItem)new Separator());
                        theMenuMgr.add((IContributionItem)new GroupMarker(T_MARKER));
                        theMenuMgr.appendToGroup(T_MARKER, (IAction)this.removeSourcesAction);
                        theMenuMgr.appendToGroup(T_MARKER, (IAction)this.clearSourcesAction);
                        if (selectionHelper.isVirtual()) {
                            this.addExternalExportedActions(theMenuMgr, selection);
                        }
                        theMenuMgr.add((IContributionItem)new Separator());
                        break;
                    }
                    case 20: {
                        this.resetTransformationActions();
                        theMenuMgr.add((IContributionItem)new GroupMarker(M_MARKER));
                        theMenuMgr.appendToGroup(M_MARKER, (IAction)this.deleteMappingLinksAction);
                        this.addDiagramActions(theMenuMgr);
                        break;
                    }
                    case 0: 
                    case 1: {
                        this.resetTransformationActions();
                        this.addDiagramActions(theMenuMgr);
                        break;
                    }
                    case -1: {
                        break;
                    }
                }
            } else if (selectionHelper.getCountType() == 2) {
                this.resetTransformationActions();
                if (selectionHelper.someExtentSelected()) {
                    theMenuMgr.add((IContributionItem)new Separator());
                    theMenuMgr.add((IContributionItem)new GroupMarker(M_MARKER));
                    theMenuMgr.appendToGroup(M_MARKER, (IAction)this.newMappingLinkAction);
                }
                this.addDiagramActions(theMenuMgr);
            }
        }
        theMenuMgr.add((IContributionItem)new Separator());
    }

    public void contributeExportedActions(IMenuManager theMenuMgr) {
        if (this.isDetailedMapping()) {
            this.resetTransformationActions();
            Separator groupMarker = new Separator(T_MARKER);
            if (theMenuMgr.getId() != null && theMenuMgr.getId().equals(ModelerActionBarIdManager.getEditMenuId())) {
                this.setEditMenu(theMenuMgr);
                theMenuMgr.appendToGroup(ModelerActionBarIdManager.getMenuAdditionsMarkerId(), (IContributionItem)groupMarker);
                this.addContributionItem((IContributionItem)groupMarker);
                theMenuMgr.appendToGroup(T_MARKER, (IContributionItem)this.createActionContributionItem((IAction)this.addSourcesAction));
                theMenuMgr.appendToGroup(T_MARKER, (IContributionItem)this.createActionContributionItem((IAction)this.addUnionSourcesAction));
                theMenuMgr.appendToGroup(T_MARKER, (IContributionItem)this.createActionContributionItem((IAction)this.clearSourcesAction));
            } else {
                theMenuMgr.add((IContributionItem)groupMarker);
                if (this.addSourcesAction.isEnabled()) {
                    theMenuMgr.appendToGroup(T_MARKER, (IAction)this.addSourcesAction);
                }
                if (this.addUnionSourcesAction.isEnabled()) {
                    theMenuMgr.appendToGroup(T_MARKER, (IAction)this.addUnionSourcesAction);
                }
                if (this.clearSourcesAction.isEnabled()) {
                    theMenuMgr.appendToGroup(T_MARKER, (IAction)this.clearSourcesAction);
                }
            }
        }
    }

    public void contributeToDiagramToolBar() {
        boolean logicalModel = ModelIdentifier.isLogicalModel((ModelResource)((DiagramEditor)this.getEditorPage()).getCurrentModelResource());
        DiagramToolBarManager tbm = (DiagramToolBarManager)((DiagramEditor)this.getEditorPage()).getToolBarManager();
        tbm.removeAll();
        tbm.add((IAction)this.refreshDiagramAction);
        tbm.add((IAction)this.upDiagramAction);
        if (!this.isDetailedMapping() && !logicalModel) {
            tbm.add((IAction)this.showDetailedMappingAction);
        }
        this.newMappingLinkAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        this.deleteMappingLinksAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        this.mergeMappingClassesAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        this.splitMappingClassAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        this.toggleDisplayAllMappingClassesAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        this.toggleFoldAllMappingClassesAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        this.togglePopulateDiagramFromTreeSelectionAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        this.refreshDiagramAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        this.upDiagramAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        if (this.isDetailedMapping()) {
            tbm.add((IContributionItem)new Separator());
            tbm.add((IAction)this.newMappingLinkAction);
            tbm.add((IAction)this.deleteMappingLinksAction);
            this.resetTransformationActions();
            tbm.add((IContributionItem)new Separator());
            tbm.add((IAction)this.addSourcesAction);
            tbm.add((IAction)this.addUnionSourcesAction);
            tbm.add((IAction)this.removeSourcesAction);
            tbm.add((IAction)this.clearSourcesAction);
            tbm.add((IAction)this.reconcileAction);
            this.addSourcesAction.setToolBarManager(tbm);
            ActionContributionItem addSourcesItem = new ActionContributionItem((IAction)this.addSourcesAction);
            this.addSourcesAction.setItem(addSourcesItem);
            this.addUnionSourcesAction.setToolBarManager(tbm);
            ActionContributionItem addUnionSourcesItem = new ActionContributionItem((IAction)this.addUnionSourcesAction);
            this.addUnionSourcesAction.setItem(addUnionSourcesItem);
            tbm.add((IContributionItem)new Separator());
            tbm.add((IAction)this.saveDiagramAction);
        } else {
            tbm.add((IContributionItem)new Separator());
            if (!logicalModel) {
                tbm.add((IAction)this.generateMappingClassesAction);
                tbm.add((IAction)this.newMappingClassAction);
                tbm.add((IAction)this.newStagingTableAction);
                tbm.add((IAction)this.mergeMappingClassesAction);
                tbm.add((IAction)this.splitMappingClassAction);
                tbm.add((IContributionItem)new Separator());
            }
            tbm.add((IAction)this.toggleDisplayAllMappingClassesAction);
            tbm.add((IAction)this.toggleFoldAllMappingClassesAction);
            tbm.add((IAction)this.togglePopulateDiagramFromTreeSelectionAction);
        }
        this.wireMappingClassActions();
        tbm.update(true);
        this.resetGlobalActionsMap();
    }

    public void contributeToMenuManager(IMenuManager theMenuMgr, ISelection selection) {
        this.removeAllActions(theMenuMgr);
        if (this.isDetailedMapping()) {
            this.contributeDetailedActions(theMenuMgr, selection);
        } else {
            this.processDefaultCoarseMenu(theMenuMgr, selection);
            this.contributeCoarseActions(theMenuMgr, selection);
        }
    }

    public void createContextMenu() {
        this.createContextMenu("diagramEditorPage.contextMenu", this.getEditorPage().getControl());
    }

    public void dispose() {
        this.unwireMappingClassActions();
        super.dispose();
        this.reconcileAction.dispose();
        this.clearSourcesAction.dispose();
    }

    public void enableDiagramToolbarActions() {
        if (this.upDiagramAction != null) {
            this.upDiagramAction.determineEnablement();
        }
    }

    private IAction getAction(String theActionId) {
        IAction action = null;
        try {
            action = this.getActionService().getAction(theActionId);
        }
        catch (CoreException coreException) {}
        return action;
    }

    private MenuManager getCopyNameSubMenu(Object selection) {
        MenuManager menu = new MenuManager(org.teiid.designer.ui.UiConstants.Util.getString("ModelerActionService.copyNameSubMenu.title", new Object[0]));
        CopyFullNameAction action1 = new CopyFullNameAction();
        action1.getActionWorker().selectionChanged(selection);
        menu.add((IAction)action1);
        CopyNameAction action2 = new CopyNameAction();
        action1.getActionWorker().selectionChanged(selection);
        menu.add((IAction)action2);
        return menu;
    }

    public GlobalActionsMap getGlobalActions() {
        if (this.actionsMap == null) {
            this.resetGlobalActionsMap();
        }
        return this.actionsMap;
    }

    private List getModelObjectActionContributors() {
        if (this.modelObjectContributors == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", "modelObjectActionContributor");
            IExtension[] extensions = extensionPoint.getExtensions();
            if (extensions.length > 0) {
                this.modelObjectContributors = new ArrayList(extensions.length);
                IExtension[] iExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension2 = iExtensionArray[n2];
                    IConfigurationElement[] elements = extension2.getConfigurationElements();
                    Object extension = null;
                    String uniqueID = extension2.getSimpleIdentifier();
                    if (uniqueID.startsWith("transformationDiagramModelObjectActionContributor")) {
                        IConfigurationElement[] iConfigurationElementArray = elements;
                        int n3 = elements.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement element = iConfigurationElementArray[n4];
                            try {
                                extension = element.createExecutableExtension("name");
                                if (extension instanceof IModelObjectActionContributor) {
                                    this.modelObjectContributors.add(extension);
                                } else {
                                    org.teiid.designer.ui.UiConstants.Util.log(4, org.teiid.designer.ui.UiConstants.Util.getString("ModelerActionService.wrongContributorClass", new Object[]{extension.getClass().getName()}));
                                }
                            }
                            catch (Exception theException) {
                                org.teiid.designer.ui.UiConstants.Util.log(4, (Throwable)theException, org.teiid.designer.ui.UiConstants.Util.getString("ModelerActionService.contributorProblem", new Object[]{element.getAttribute("name")}));
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            } else {
                this.modelObjectContributors = Collections.EMPTY_LIST;
            }
        }
        return this.modelObjectContributors;
    }

    private TreeMappingAdapter getTreeMappingAdapter() {
        MappingDiagramController controller = (MappingDiagramController)((DiagramEditor)this.getEditorPage()).getDiagramController();
        if (controller != null) {
            return controller.getMappingAdapter();
        }
        return null;
    }

    public void handleNotification(Notification theNotification) {
        Object changedObject = ModelerCore.getModelEditor().getChangedObject(theNotification);
        if (changedObject instanceof MappingClassSet) {
            this.generateMappingClassesAction.determineEnablement();
        }
        if (this.shouldUpdateMappingClassFactory(theNotification)) {
            this.wireMappingClassActions();
        }
    }

    protected void initActions() {
        super.initActions();
        Diagram currentDiagram = ((DiagramEditor)this.getEditorPage()).getDiagram();
        EObject transformationEObject = null;
        if (this.isDetailedMapping()) {
            transformationEObject = TransformationSourceManager.getTransformationFromDiagram((Diagram)currentDiagram);
        }
        this.addSourcesAction = (AddTransformationSourceAction)this.getRegisteredAction(AddTransformationSourceAction.class.getName());
        if (this.addSourcesAction == null) {
            this.addSourcesAction = new AddTransformationSourceAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.addSourcesAction);
        }
        this.addUnionSourcesAction = (AddUnionSourceAction)this.getRegisteredAction(AddUnionSourceAction.class.getName());
        if (this.addUnionSourcesAction == null) {
            this.addUnionSourcesAction = new AddUnionSourceAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.addUnionSourcesAction);
        }
        this.removeSourcesAction = (TransformationAction)this.getRegisteredAction(RemoveTransformationSourceAction.class.getName());
        if (this.removeSourcesAction == null) {
            this.removeSourcesAction = new RemoveTransformationSourceAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.removeSourcesAction);
        }
        this.clearSourcesAction = (TransformationAction)this.getRegisteredAction(ClearTransformationAction.class.getName());
        if (this.clearSourcesAction == null) {
            this.clearSourcesAction = new ClearTransformationAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.clearSourcesAction);
        }
        this.reconcileAction = (TransformationAction)this.getRegisteredAction(ReconcileTransformationAction.class.getName());
        if (this.reconcileAction == null) {
            this.reconcileAction = new ReconcileTransformationAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.reconcileAction);
        }
        this.addToSqlSelectAction = (TransformationAction)this.getRegisteredAction(AddToSqlSelectAction.class.getName());
        if (this.addToSqlSelectAction == null) {
            this.addToSqlSelectAction = new AddToSqlSelectAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.addToSqlSelectAction);
        }
        this.addJoinExpressionAction = (TransformationAction)this.getRegisteredAction(AddJoinExpressionAction.class.getName());
        if (this.addJoinExpressionAction == null) {
            this.addJoinExpressionAction = new AddJoinExpressionAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.addJoinExpressionAction);
        }
        this.showDetailedMappingAction = (AbstractAction)this.getRegisteredAction(ShowDetailedMappingDiagramAction.class.getName());
        if (this.showDetailedMappingAction == null) {
            this.showDetailedMappingAction = new ShowDetailedMappingDiagramAction();
            this.registerAction(this.showDetailedMappingAction);
        }
        this.newMappingClassAction = (MappingAction)this.getRegisteredAction(NewMappingClassAction.class.getName());
        if (this.newMappingClassAction == null) {
            this.newMappingClassAction = new NewMappingClassAction();
            this.registerAction((AbstractAction)this.newMappingClassAction);
        }
        this.newStagingTableAction = (MappingAction)this.getRegisteredAction(NewStagingTableAction.class.getName());
        if (this.newStagingTableAction == null) {
            this.newStagingTableAction = new NewStagingTableAction();
            this.registerAction((AbstractAction)this.newStagingTableAction);
        }
        this.newMappingLinkAction = (MappingAction)this.getRegisteredAction(NewMappingLinkAction.class.getName());
        if (this.newMappingLinkAction == null) {
            this.newMappingLinkAction = new NewMappingLinkAction();
            this.registerAction((AbstractAction)this.newMappingLinkAction);
        }
        this.deleteMappingLinksAction = (MappingAction)this.getRegisteredAction(DeleteMappingLinksAction.class.getName());
        if (this.deleteMappingLinksAction == null) {
            this.deleteMappingLinksAction = new DeleteMappingLinksAction();
            this.registerAction((AbstractAction)this.deleteMappingLinksAction);
        }
        this.mergeMappingClassesAction = (MappingAction)this.getRegisteredAction(MergeMappingClassesAction.class.getName());
        if (this.mergeMappingClassesAction == null) {
            this.mergeMappingClassesAction = new MergeMappingClassesAction();
            this.registerAction((AbstractAction)this.mergeMappingClassesAction);
        }
        this.splitMappingClassAction = (MappingAction)this.getRegisteredAction(SplitMappingClassAction.class.getName());
        if (this.splitMappingClassAction == null) {
            this.splitMappingClassAction = new SplitMappingClassAction();
            this.registerAction((AbstractAction)this.splitMappingClassAction);
        }
        this.toggleDisplayAllMappingClassesAction = (MappingAction)this.getRegisteredAction(ToggleDisplayAllMappingClassesAction.class.getName());
        if (this.toggleDisplayAllMappingClassesAction == null) {
            this.toggleDisplayAllMappingClassesAction = new ToggleDisplayAllMappingClassesAction();
            this.registerAction((AbstractAction)this.toggleDisplayAllMappingClassesAction);
        }
        this.toggleFoldAllMappingClassesAction = (MappingAction)this.getRegisteredAction(ToggleFoldAllMappingClassesAction.class.getName());
        if (this.toggleFoldAllMappingClassesAction == null) {
            this.toggleFoldAllMappingClassesAction = new ToggleFoldAllMappingClassesAction();
            this.registerAction((AbstractAction)this.toggleFoldAllMappingClassesAction);
        }
        this.togglePopulateDiagramFromTreeSelectionAction = (MappingAction)this.getRegisteredAction(TogglePopulateDiagramFromTreeSelectionAction.class.getName());
        if (this.togglePopulateDiagramFromTreeSelectionAction == null) {
            this.togglePopulateDiagramFromTreeSelectionAction = new TogglePopulateDiagramFromTreeSelectionAction();
            this.registerAction((AbstractAction)this.togglePopulateDiagramFromTreeSelectionAction);
        }
        this.expandAllEnumsAction = (MappingAction)this.getRegisteredAction(ExpandAllEnumsAction.class.getName());
        if (this.expandAllEnumsAction == null) {
            this.expandAllEnumsAction = new ExpandAllEnumsAction();
            this.registerAction((AbstractAction)this.expandAllEnumsAction);
        }
        this.collapseAllEnumsAction = (MappingAction)this.getRegisteredAction(CollapseAllEnumsAction.class.getName());
        if (this.collapseAllEnumsAction == null) {
            this.collapseAllEnumsAction = new CollapseAllEnumsAction();
            this.registerAction((AbstractAction)this.collapseAllEnumsAction);
        }
        this.generateMappingClassesAction = (GenerateMappingClassesAction)this.getRegisteredAction(GenerateMappingClassesAction.class.getName());
        if (this.generateMappingClassesAction == null) {
            this.generateMappingClassesAction = new GenerateMappingClassesAction();
            this.registerAction((AbstractAction)this.generateMappingClassesAction);
        }
        this.lockAction = (MappingAction)this.getRegisteredAction(LockAction.class.getName());
        if (this.lockAction == null) {
            this.lockAction = new LockAction();
            this.registerAction((AbstractAction)this.lockAction);
        }
        this.deleteAction = (MappingAction)this.getRegisteredAction(DeleteAction.class.getName());
        if (this.deleteAction == null) {
            this.deleteAction = new DeleteAction(transformationEObject);
            this.registerAction((AbstractAction)this.deleteAction);
        }
        this.deleteAction.setDetailed(this.isDetailedMapping());
        this.cutAction = (MappingAction)this.getRegisteredAction(CutAction.class.getName());
        if (this.cutAction == null) {
            this.cutAction = new CutAction(transformationEObject);
            this.registerAction((AbstractAction)this.cutAction);
        }
        this.copyAction = (MappingAction)this.getRegisteredAction(CopyAction.class.getName());
        if (this.copyAction == null) {
            this.copyAction = new CopyAction(transformationEObject);
            this.registerAction((AbstractAction)this.copyAction);
        }
        this.pasteAction = (MappingAction)this.getRegisteredAction(PasteAction.class.getName());
        if (this.pasteAction == null) {
            this.pasteAction = new PasteAction(transformationEObject);
            this.registerAction((AbstractAction)this.pasteAction);
        }
        this.cloneAction = (MappingAction)this.getRegisteredAction(CloneAction.class.getName());
        if (this.cloneAction == null) {
            this.cloneAction = new CloneAction(transformationEObject);
            this.registerAction((AbstractAction)this.cloneAction);
        }
        this.renameAction = (RenameAction)this.getRegisteredAction(RenameAction.class.getName());
        if (this.renameAction == null) {
            this.renameAction = new RenameAction();
            this.registerAction((AbstractAction)this.renameAction);
        }
        this.refreshDiagramAction = (RefreshAction)this.getRegisteredAction(RefreshAction.class.getName());
        if (this.refreshDiagramAction == null) {
            this.refreshDiagramAction = new RefreshAction();
            this.registerAction((AbstractAction)this.refreshDiagramAction);
        }
        this.upDiagramAction = (ShowParentDiagramAction)this.getRegisteredAction(ShowParentDiagramAction.class.getName());
        if (this.upDiagramAction == null) {
            this.upDiagramAction = new ShowParentDiagramAction();
            this.registerAction((AbstractAction)this.upDiagramAction);
        }
        this.saveDiagramAction = (AbstractAction)this.getRegisteredAction(SaveMappingDiagramAction.class.getName());
        if (this.saveDiagramAction == null) {
            this.saveDiagramAction = new SaveMappingDiagramAction((DiagramEditor)this.getEditorPage());
            this.registerAction(this.saveDiagramAction);
        }
        this.addInputSetParameterAction = new AddInputSetParameterAction();
    }

    private boolean isDetailedMapping() {
        MappingDiagramController controller = (MappingDiagramController)((DiagramEditor)this.getEditorPage()).getDiagramController();
        if (controller != null) {
            return controller.getMappingType() == 1;
        }
        return false;
    }

    private boolean objectsResourceSameAsDiagram(EObject eObject) {
        Diagram diagram = ((DiagramEditor)this.getEditorPage()).getDiagram();
        if (diagram != null) {
            return ModelUtilities.areModelResourcesSame((EObject)eObject, (EObject)diagram);
        }
        return false;
    }

    private void processDefaultCoarseMenu(IMenuManager theMenuMgr, ISelection theSelection) {
        if (theSelection != null && !theSelection.isEmpty() && ModelIdentifier.isLogicalModel((ModelResource)((DiagramEditor)this.getEditorPage()).getCurrentModelResource()) && theSelection instanceof IStructuredSelection) {
            IContributionItem newSiblingMenu;
            IContributionManager menuMgr = null;
            if (((IStructuredSelection)theSelection).getFirstElement() instanceof MappingClass) {
                IContributionItem newChildMenu = theMenuMgr.find(ModelerActionBarIdManager.getInsertChildMenuId());
                if (newChildMenu != null && newChildMenu instanceof IContributionManager) {
                    menuMgr = (IContributionManager)newChildMenu;
                }
            } else if (((IStructuredSelection)theSelection).getFirstElement() instanceof MappingClassColumn && (newSiblingMenu = theMenuMgr.find(ModelerActionBarIdManager.getInsertSiblingMenuId())) != null && newSiblingMenu instanceof IContributionManager) {
                menuMgr = (IContributionManager)newSiblingMenu;
            }
            if (menuMgr != null) {
                String DEFAULT_LABEL = TransformationPlugin.Util.getString("_UI_MappingClassColumn_type", new Object[0]);
                String NEW_LABEL = UiConstants.Util.getString("MappingDiagramActionAdapter.logicalNewMappingClassColumn", new Object[0]);
                IContributionItem[] items = menuMgr.getItems();
                if (items != null && items.length != 0) {
                    int i = 0;
                    while (i < items.length) {
                        IAction action;
                        if (items[i] instanceof ActionContributionItem && DEFAULT_LABEL.equals((action = ((ActionContributionItem)items[i]).getAction()).getText())) {
                            action.setText(NEW_LABEL);
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    private void removeAllActions(IMenuManager theMenuMgr) {
        this.removeMappingActions(theMenuMgr);
        this.removeTransformationActions(theMenuMgr);
        this.removeDiagramActions(theMenuMgr);
    }

    private void removeDiagramActions(IMenuManager theMenuMgr) {
        if (theMenuMgr.find(D_MARKER) != null) {
            theMenuMgr.remove(D_MARKER);
        }
        if (theMenuMgr.find(this.refreshDiagramAction.getId()) != null) {
            theMenuMgr.remove(this.refreshDiagramAction.getId());
        }
        if (theMenuMgr.find(this.upDiagramAction.getId()) != null) {
            theMenuMgr.remove(this.upDiagramAction.getId());
        }
        if (theMenuMgr.find(this.saveDiagramAction.getId()) != null) {
            theMenuMgr.remove(this.saveDiagramAction.getId());
        }
    }

    private void removeMappingActions(IMenuManager theMenuMgr) {
        if (theMenuMgr.find(M_MARKER) != null) {
            theMenuMgr.remove(M_MARKER);
        }
        if (theMenuMgr.find(this.showDetailedMappingAction.getId()) != null) {
            theMenuMgr.remove(this.showDetailedMappingAction.getId());
        }
        if (theMenuMgr.find(this.generateMappingClassesAction.getId()) != null) {
            theMenuMgr.remove(this.generateMappingClassesAction.getId());
        }
        if (theMenuMgr.find(this.newMappingClassAction.getId()) != null) {
            theMenuMgr.remove(this.newMappingClassAction.getId());
        }
        if (theMenuMgr.find(this.splitMappingClassAction.getId()) != null) {
            theMenuMgr.remove(this.splitMappingClassAction.getId());
        }
        if (theMenuMgr.find(this.toggleDisplayAllMappingClassesAction.getId()) != null) {
            theMenuMgr.remove(this.toggleDisplayAllMappingClassesAction.getId());
        }
        if (theMenuMgr.find(this.toggleFoldAllMappingClassesAction.getId()) != null) {
            theMenuMgr.remove(this.toggleFoldAllMappingClassesAction.getId());
        }
        if (theMenuMgr.find(this.togglePopulateDiagramFromTreeSelectionAction.getId()) != null) {
            theMenuMgr.remove(this.togglePopulateDiagramFromTreeSelectionAction.getId());
        }
        if (theMenuMgr.find(this.expandAllEnumsAction.getId()) != null) {
            theMenuMgr.remove(this.expandAllEnumsAction.getId());
        }
        if (theMenuMgr.find(this.collapseAllEnumsAction.getId()) != null) {
            theMenuMgr.remove(this.collapseAllEnumsAction.getId());
        }
        if (theMenuMgr.find(this.mergeMappingClassesAction.getId()) != null) {
            theMenuMgr.remove(this.mergeMappingClassesAction.getId());
        }
        if (theMenuMgr.find(this.newStagingTableAction.getId()) != null) {
            theMenuMgr.remove(this.newStagingTableAction.getId());
        }
        if (theMenuMgr.find(this.newMappingLinkAction.getId()) != null) {
            theMenuMgr.remove(this.newMappingLinkAction.getId());
        }
        if (theMenuMgr.find(this.deleteMappingLinksAction.getId()) != null) {
            theMenuMgr.remove(this.deleteMappingLinksAction.getId());
        }
        if (theMenuMgr.find(this.lockAction.getId()) != null) {
            theMenuMgr.remove(this.lockAction.getId());
        }
    }

    private void removeTransformationActions(IMenuManager theMenuMgr) {
        if (theMenuMgr.find(T_MARKER) != null) {
            theMenuMgr.remove(T_MARKER);
        }
        if (theMenuMgr.find(this.addSourcesAction.getId()) != null) {
            theMenuMgr.remove(this.addSourcesAction.getId());
        }
        if (theMenuMgr.find(this.addUnionSourcesAction.getId()) != null) {
            theMenuMgr.remove(this.addUnionSourcesAction.getId());
        }
        if (theMenuMgr.find(this.removeSourcesAction.getId()) != null) {
            theMenuMgr.remove(this.removeSourcesAction.getId());
        }
        if (theMenuMgr.find(this.clearSourcesAction.getId()) != null) {
            theMenuMgr.remove(this.clearSourcesAction.getId());
        }
    }

    private void resetGlobalActionsMap() {
        this.actionsMap = new DiagramGlobalActionsMap();
        this.actionsMap.reset();
        this.actionsMap.put((Object)IActionConstants.EclipseGlobalActions.DELETE, (Object)this.deleteAction);
        this.actionsMap.put((Object)IActionConstants.EclipseGlobalActions.CUT, (Object)this.cutAction);
        this.actionsMap.put((Object)IActionConstants.EclipseGlobalActions.COPY, (Object)this.copyAction);
        this.actionsMap.put((Object)IActionConstants.EclipseGlobalActions.PASTE, (Object)this.pasteAction);
        this.actionsMap.put((Object)IModelerActionConstants.ModelerGlobalActions.CLONE, (Object)this.cloneAction);
        this.renameAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        this.actionsMap.put((Object)IActionConstants.EclipseGlobalActions.RENAME, (Object)this.renameAction);
    }

    private void resetTransformationActions() {
        Diagram currentDiagram = ((DiagramEditor)this.getEditorPage()).getDiagram();
        EObject transformationEObject = null;
        if (this.isDetailedMapping()) {
            transformationEObject = TransformationSourceManager.getTransformationFromDiagram((Diagram)currentDiagram);
        }
        this.addSourcesAction.setTransformation(transformationEObject);
        this.addUnionSourcesAction.setTransformation(transformationEObject);
        this.removeSourcesAction.setTransformation(transformationEObject);
        this.clearSourcesAction.setTransformation(transformationEObject);
        this.reconcileAction.setTransformation(transformationEObject);
        this.addToSqlSelectAction.setTransformation(transformationEObject);
        this.addJoinExpressionAction.setTransformation(transformationEObject);
        this.deleteAction.setTransformation(transformationEObject);
        this.cutAction.setTransformation(transformationEObject);
        this.copyAction.setTransformation(transformationEObject);
        this.pasteAction.setTransformation(transformationEObject);
        this.cloneAction.setTransformation(transformationEObject);
        this.lockAction.setTransformation(transformationEObject);
        this.addSourcesAction.setDiagram(currentDiagram);
        this.addUnionSourcesAction.setDiagram(currentDiagram);
        this.removeSourcesAction.setDiagram(currentDiagram);
        this.clearSourcesAction.setDiagram(currentDiagram);
        this.reconcileAction.setDiagram(currentDiagram);
        this.addToSqlSelectAction.setDiagram(currentDiagram);
        this.addJoinExpressionAction.setDiagram(currentDiagram);
    }

    public boolean shouldOverrideMenu(ISelection selection) {
        boolean value = false;
        if (this.isDetailedMapping()) {
            Diagram currentDiagram = ((DiagramEditor)this.getEditorPage()).getDiagram();
            EObject transformationEObject = TransformationSourceManager.getTransformationFromDiagram((Diagram)currentDiagram);
            MappingSelectionHelper selectionHelper = new MappingSelectionHelper(transformationEObject, selection);
            if (selectionHelper.getCountType() == 1) {
                switch (selectionHelper.getType()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 9: 
                    case 11: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 25: {
                        value = true;
                        break;
                    }
                }
            } else if (selectionHelper.getCountType() == -1) {
                switch (selectionHelper.getType()) {
                    case 20: 
                    case 21: {
                        value = true;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 24: 
                    case 25: {
                        value = true;
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else {
            MappingSelectionHelper selectionHelper = new MappingSelectionHelper(selection);
            if (selectionHelper.getCountType() == 1) {
                switch (selectionHelper.getType()) {
                    case 11: 
                    case 20: 
                    case 21: 
                    case 26: 
                    case 27: {
                        value = true;
                        break;
                    }
                }
            } else if (selectionHelper.getCountType() == -1) {
                switch (selectionHelper.getType()) {
                    case 20: 
                    case 21: 
                    case 26: 
                    case 27: {
                        value = true;
                        break;
                    }
                }
            }
        }
        return value;
    }

    public boolean shouldUpdateMappingClassFactory(Notification theNotification) {
        boolean update = false;
        if (theNotification instanceof SourcedNotification) {
            Collection notifications = ((SourcedNotification)theNotification).getNotifications();
            Iterator iter = notifications.iterator();
            Notification nextNot = null;
            while (iter.hasNext() && !update) {
                nextNot = (Notification)iter.next();
                Object changedObject = ModelerCore.getModelEditor().getChangedObject(nextNot);
                if (!(changedObject instanceof EObject) || !this.objectsResourceSameAsDiagram((EObject)changedObject) || !(changedObject instanceof MappingClassSet) && !(changedObject instanceof TransformationContainer)) continue;
                update = true;
            }
        } else {
            Object changedObject = ModelerCore.getModelEditor().getChangedObject(theNotification);
            if (changedObject instanceof EObject && this.objectsResourceSameAsDiagram((EObject)changedObject) && (changedObject instanceof MappingClassSet || changedObject instanceof TransformationContainer)) {
                update = true;
            }
        }
        return update;
    }

    private void unwireMappingClassActions() {
        this.generateMappingClassesAction.setMappingClassFactory(null);
        this.newMappingClassAction.setMappingClassFactory(null);
        this.newStagingTableAction.setMappingClassFactory(null);
        this.deleteMappingLinksAction.setMappingClassFactory(null);
        this.mergeMappingClassesAction.setMappingClassFactory(null);
        this.splitMappingClassAction.setMappingClassFactory(null);
        this.toggleDisplayAllMappingClassesAction.setMappingClassFactory(null);
        this.toggleFoldAllMappingClassesAction.setMappingClassFactory(null);
        this.togglePopulateDiagramFromTreeSelectionAction.setMappingClassFactory(null);
        this.deleteAction.setMappingClassFactory(null);
        this.lockAction.setMappingClassFactory(null);
    }

    private void wireMappingClassActions() {
        boolean isDetailed = this.isDetailedMapping();
        EObject targetEO = null;
        Diagram currentDiagram = ((DiagramEditor)this.getEditorPage()).getDiagram();
        if (!isDetailed) {
            targetEO = currentDiagram.getTarget();
        } else {
            MappingClass mappingClass = (MappingClass)currentDiagram.getTarget();
            targetEO = mappingClass.getMappingClassSet().getTarget();
        }
        if (targetEO != null && ModelMapperFactory.isTreeRoot((EObject)targetEO)) {
            ITreeToRelationalMapper ittrm = ModelMapperFactory.createModelMapper((EObject)targetEO);
            MappingClassFactory mcf = new MappingClassFactory(ittrm, this.getTreeMappingAdapter());
            this.generateMappingClassesAction.setMappingClassFactory(mcf);
            this.newMappingClassAction.setMappingClassFactory(mcf);
            this.newStagingTableAction.setMappingClassFactory(mcf);
            this.mergeMappingClassesAction.setMappingClassFactory(mcf);
            this.splitMappingClassAction.setMappingClassFactory(mcf);
            this.toggleDisplayAllMappingClassesAction.setMappingClassFactory(mcf);
            this.toggleFoldAllMappingClassesAction.setMappingClassFactory(mcf);
            this.togglePopulateDiagramFromTreeSelectionAction.setMappingClassFactory(mcf);
            this.deleteMappingLinksAction.setMappingClassFactory(mcf);
            this.newMappingLinkAction.setMappingClassFactory(mcf);
            this.deleteAction.setMappingClassFactory(mcf);
            this.lockAction.setMappingClassFactory(mcf);
        }
        this.generateMappingClassesAction.setDetailed(isDetailed);
        this.newMappingClassAction.setDetailed(isDetailed);
        this.newStagingTableAction.setDetailed(isDetailed);
        this.mergeMappingClassesAction.setDetailed(isDetailed);
        this.splitMappingClassAction.setDetailed(isDetailed);
        this.deleteMappingLinksAction.setDetailed(isDetailed);
        this.newMappingLinkAction.setDetailed(isDetailed);
        this.deleteAction.setDetailed(isDetailed);
        this.lockAction.setDetailed(isDetailed);
    }

    public class AddInputSetParameterAction
    extends Action {
        private EObject inputSet;

        public AddInputSetParameterAction() {
            this.setText(NEW_INPUT_PARAMETER_TITLE);
        }

        public EObject getInputSet() {
            return this.inputSet;
        }

        public void run() {
            if (this.getInputSet() != null) {
                InputSet inputSet = (InputSet)this.getInputSet();
                boolean started = ModelerCore.startTxn((boolean)true, (boolean)true, (String)NEW_INPUT_PARAMETER_TITLE, (Object)((Object)this));
                boolean succeeded = false;
                try {
                    int nameIndex = inputSet.getInputParameters().size();
                    InputParameter param = TransformationFactory.eINSTANCE.createInputParameter();
                    param.setInputSet(inputSet);
                    String name = String.valueOf(PARAM_BASE_NAME) + ++nameIndex;
                    boolean tryAgain = true;
                    while (tryAgain) {
                        tryAgain = false;
                        Iterator iter = inputSet.getInputParameters().iterator();
                        while (iter.hasNext()) {
                            if (!name.equals(((InputParameter)iter.next()).getName())) continue;
                            name = String.valueOf(PARAM_BASE_NAME) + ++nameIndex;
                            tryAgain = true;
                        }
                    }
                    param.setName(name);
                    succeeded = true;
                }
                finally {
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }

        public void setInputSet(EObject inputSet) {
            this.inputSet = inputSet;
        }
    }
}

