/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.mapping.factory.MappingClassFactory;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.mapping.ui.actions.MappingAction;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class GenerateMappingClassesAction
extends MappingAction {
    private static final String ACTION_DESCRIPTION = "Generate Mapping Classes";
    private static final boolean AUTO_POPULATE_ATTRIBUTES = true;

    public GenerateMappingClassesAction() {
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_gen_mapping_classes.gif"));
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        if (this.getMappingClassFactory() != null) {
            boolean canUndo = false;
            Object eoXmlRoot = null;
            EObject eoTreeRoot = this.getMappingClassFactory().getTreeRoot();
            eoXmlRoot = eoTreeRoot instanceof XmlDocument ? ((XmlDocument)eoTreeRoot).getRoot() : eoTreeRoot;
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)canUndo, (String)ACTION_DESCRIPTION, (Object)((Object)this));
            boolean succeeded = false;
            try {
                this.getMappingClassFactory().generateMappingClasses(eoXmlRoot, MappingClassFactory.getDefaultStrategy(), true);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        this.setEnabled(false);
    }

    public void determineEnablement() {
        EObject treeRootEObject;
        boolean enable = false;
        if (this.getPart() instanceof ModelEditor && this.getMappingClassFactory() != null && !ModelObjectUtilities.isReadOnly((EObject)(treeRootEObject = this.getMappingClassFactory().getTreeRoot())) && this.getMappingClassFactory().canGenerateMappingClasses()) {
            enable = true;
        }
        this.setEnabled(enable);
    }
}

