/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.xsd.procedures;

import javax.xml.namespace.QName;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.RelationalPackage;
import org.teiid.designer.modelgenerator.xsd.procedures.ProcedureBuilder;
import org.teiid.designer.modelgenerator.xsd.procedures.TraversalContext;

public class BaseTraversalContext {
    protected RelationalFactory factory = RelationalPackage.eINSTANCE.getRelationalFactory();
    protected DatatypeManager datatypeManager = ModelerCore.getBuiltInTypesManager();
    protected StringBuffer elementPath = new StringBuffer();
    protected String procedureName;
    protected ProcedureBuilder builder;
    private boolean reachedResultNode = false;
    protected QName namespace;

    public BaseTraversalContext(String procedureName, QName namespace, TraversalContext ctx, ProcedureBuilder builder) {
        this.procedureName = procedureName;
        this.namespace = namespace;
        this.builder = builder;
        this.elementPath = new StringBuffer(ctx.getPath());
    }

    public BaseTraversalContext(String procedureName, QName namespace, ProcedureBuilder builder) {
        this.procedureName = procedureName;
        this.namespace = namespace;
        this.builder = builder;
    }

    public boolean isReachedResultNode() {
        return this.reachedResultNode;
    }

    public void setReachedResultNode(boolean reachedResultNode) {
        this.reachedResultNode = reachedResultNode;
    }

    public void appendToPath(String path) {
        this.elementPath.append('/').append(path);
    }

    public String getPath() {
        String result = this.elementPath.toString();
        if (result == null || result.isEmpty()) {
            result = "/";
        }
        return result;
    }

    public QName getNamespace() {
        return this.namespace;
    }

    public void setNamespace(QName namespace) {
        this.namespace = namespace;
    }
}

