/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.designer.util;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.designer.util.Stopwatch;

public class DebuggingStopwatch {
    private static final String NEW_LINE = "\n";
    private static final String SPACER = "   -- > ";
    private static final String DELTA_TIME = " Delta Time (ms) = ";
    private static final String TOTAL_TIME = " Total Time (ms) = ";
    private static final String STOPWATCH_STATS = " ===>> Stopwatch Statistics for: ";
    private static final String END = " =========== END STATS =============";
    private String title;
    private long[] increments;
    private List messages;
    private int nValues = 0;
    private Stopwatch incStopwatch;
    private Stopwatch totalStopwatch;

    public DebuggingStopwatch(String title, int maxStatistics, boolean printStart) {
        this.title = title;
        this.increments = new long[maxStatistics];
        this.messages = new ArrayList(maxStatistics);
        this.incStopwatch = new Stopwatch();
        this.totalStopwatch = new Stopwatch();
        if (printStart) {
            System.out.println(" *** Stopwatch Statistics intiated for: " + title);
        }
    }

    public void stopStats() {
        this.incStopwatch.stop();
        this.incStopwatch.reset();
    }

    public void startStats() {
        this.incStopwatch.start(true);
    }

    public void start() {
        this.totalStopwatch.start();
    }

    public void stop() {
        this.totalStopwatch.stop();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(STOPWATCH_STATS + this.title + NEW_LINE);
        int i = 0;
        while (i < this.nValues) {
            sb.append(SPACER + this.messages.get(i) + DELTA_TIME + this.increments[i] + NEW_LINE);
            ++i;
        }
        sb.append(TOTAL_TIME + this.totalStopwatch.getTotalDuration() + NEW_LINE);
        sb.append(END);
        return sb.toString();
    }
}

