/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extensions.annotation;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.extensions.annotation.ServiceReference;
import org.springframework.osgi.service.importer.support.Cardinality;
import org.springframework.osgi.service.importer.support.CollectionType;
import org.springframework.osgi.service.importer.support.ImportContextClassLoader;
import org.springframework.osgi.service.importer.support.OsgiServiceCollectionProxyFactoryBean;
import org.springframework.osgi.service.importer.support.OsgiServiceProxyFactoryBean;
import org.springframework.util.ReflectionUtils;

public class ServiceReferenceInjectionBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BundleContextAware,
BeanFactoryAware,
BeanClassLoaderAware {
    private BundleContext bundleContext;
    private static Log logger = LogFactory.getLog(ServiceReferenceInjectionBeanPostProcessor.class);
    private BeanFactory beanFactory;
    private ClassLoader classLoader;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("processing [" + bean.getClass().getName() + ", " + beanName + "]"));
        }
        if (!(bean instanceof FactoryBean) && this.beanFactory.containsBean("&" + beanName)) {
            this.injectServices(bean, beanName);
        }
        return bean;
    }

    private void injectServices(final Object bean, final String beanName) {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                ServiceReference s = (ServiceReference)AnnotationUtils.getAnnotation((Method)method, ServiceReference.class);
                if (s != null && method.getParameterTypes().length == 1) {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Processing annotation [" + s + "] for [" + bean.getClass().getName() + "." + method.getName() + "()] on bean [" + beanName + "]"));
                        }
                        method.invoke(bean, ServiceReferenceInjectionBeanPostProcessor.this.getServiceImporter(s, method, beanName).getObject());
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Error processing service annotation", e);
                    }
                }
            }
        });
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        MutablePropertyValues newprops = new MutablePropertyValues(pvs);
        for (PropertyDescriptor pd : pds) {
            ServiceReference s = this.hasServiceProperty(pd);
            if (s == null || pvs.contains(pd.getName())) continue;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Processing annotation [" + s + "] for [" + beanName + "." + pd.getName() + "]"));
                }
                FactoryBean importer = this.getServiceImporter(s, pd.getWriteMethod(), beanName);
                if (bean instanceof BeanPostProcessor) {
                    ImporterCallAdapter.setCardinality(importer, Cardinality.C_0__1);
                }
                newprops.addPropertyValue(pd.getName(), importer.getObject());
            }
            catch (Exception e) {
                throw new FatalBeanException("Could not create service reference", (Throwable)e);
            }
        }
        return newprops;
    }

    private FactoryBean getServiceImporter(ServiceReference s, Method writeMethod, String beanName) throws Exception {
        Class<?>[] params = writeMethod.getParameterTypes();
        if (params.length != 1) {
            throw new IllegalArgumentException("Setter for [" + beanName + "] must have only one argument");
        }
        if (Collection.class.isAssignableFrom(params[0])) {
            return this.getServiceProperty(new OsgiServiceCollectionProxyFactoryBean(), s, writeMethod, beanName);
        }
        return this.getServiceProperty(new OsgiServiceProxyFactoryBean(), s, writeMethod, beanName);
    }

    private boolean impliedServiceType(ServiceReference s) {
        return s.serviceTypes() == null || s.serviceTypes().length == 0 || s.serviceTypes().length == 1 && s.serviceTypes()[0].equals(ServiceReference.class);
    }

    private FactoryBean getServicePropertyInternal(FactoryBean pfb, ServiceReference s, Method writeMethod, String beanName) throws Exception {
        if (s.filter().length() > 0) {
            ImporterCallAdapter.setFilter(pfb, s.filter());
        }
        if (this.impliedServiceType(s)) {
            Class<?>[] params = writeMethod.getParameterTypes();
            if (params.length != 1) {
                throw new IllegalArgumentException("Setter for [" + beanName + "] must have only one argument");
            }
            if (Collection.class.isAssignableFrom(params[0])) {
                throw new IllegalArgumentException("Cannot infer type for collection-based reference [" + beanName + "]");
            }
            ImporterCallAdapter.setInterfaces(pfb, new Class[]{params[0]});
        } else {
            ImporterCallAdapter.setInterfaces(pfb, s.serviceTypes());
        }
        ImporterCallAdapter.setCardinality(pfb, s.cardinality().toCardinality());
        ImporterCallAdapter.setContextClassLoader(pfb, s.contextClassLoader().toImportContextClassLoader());
        ImporterCallAdapter.setBundleContext(pfb, this.bundleContext);
        if (s.serviceBeanName().length() > 0) {
            ImporterCallAdapter.setServiceBean(pfb, s.serviceBeanName());
        }
        ImporterCallAdapter.setBeanClassLoader(pfb, this.classLoader);
        ImporterCallAdapter.afterPropertiesSet(pfb);
        return pfb;
    }

    FactoryBean getServiceProperty(OsgiServiceProxyFactoryBean pfb, ServiceReference s, Method writeMethod, String beanName) throws Exception {
        pfb.setTimeout((long)s.timeout());
        return this.getServicePropertyInternal((FactoryBean)pfb, s, writeMethod, beanName);
    }

    FactoryBean getServiceProperty(OsgiServiceCollectionProxyFactoryBean pfb, ServiceReference s, Method writeMethod, String beanName) throws Exception {
        Class<?>[] params = writeMethod.getParameterTypes();
        if (SortedSet.class.isAssignableFrom(params[0])) {
            pfb.setCollectionType(CollectionType.SORTED_SET);
        } else if (Set.class.isAssignableFrom(params[0])) {
            pfb.setCollectionType(CollectionType.SET);
        } else if (List.class.isAssignableFrom(params[0])) {
            pfb.setCollectionType(CollectionType.LIST);
        } else {
            throw new IllegalArgumentException("Setter for [" + beanName + "] does not have a valid Collection type argument");
        }
        return this.getServicePropertyInternal((FactoryBean)pfb, s, writeMethod, beanName);
    }

    protected ServiceReference hasServiceProperty(PropertyDescriptor propertyDescriptor) {
        Method setter = propertyDescriptor.getWriteMethod();
        return setter != null ? (ServiceReference)AnnotationUtils.getAnnotation((Method)setter, ServiceReference.class) : null;
    }

    public void setBundleContext(BundleContext context) {
        this.bundleContext = context;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ImporterCallAdapter {
        private ImporterCallAdapter() {
        }

        static void setInterfaces(Object importer, Class<?>[] classes) {
            if (importer instanceof OsgiServiceProxyFactoryBean) {
                ((OsgiServiceProxyFactoryBean)importer).setInterfaces((Class[])classes);
            } else {
                ((OsgiServiceCollectionProxyFactoryBean)importer).setInterfaces((Class[])classes);
            }
        }

        static void setBundleContext(Object importer, BundleContext context) {
            ((BundleContextAware)importer).setBundleContext(context);
        }

        static void setBeanClassLoader(Object importer, ClassLoader cl) {
            ((BeanClassLoaderAware)importer).setBeanClassLoader(cl);
        }

        static void setCardinality(Object importer, Cardinality cardinality) {
            if (importer instanceof OsgiServiceProxyFactoryBean) {
                ((OsgiServiceProxyFactoryBean)importer).setCardinality(cardinality);
            } else {
                ((OsgiServiceCollectionProxyFactoryBean)importer).setCardinality(cardinality);
            }
        }

        static void setGreedyProxying(Object importer, boolean greedy) {
            if (importer instanceof OsgiServiceCollectionProxyFactoryBean) {
                ((OsgiServiceCollectionProxyFactoryBean)importer).setGreedyProxying(greedy);
            }
        }

        static void afterPropertiesSet(Object importer) throws Exception {
            ((InitializingBean)importer).afterPropertiesSet();
        }

        static void setFilter(Object importer, String filter) throws Exception {
            if (importer instanceof OsgiServiceProxyFactoryBean) {
                ((OsgiServiceProxyFactoryBean)importer).setFilter(filter);
            } else {
                ((OsgiServiceCollectionProxyFactoryBean)importer).setFilter(filter);
            }
        }

        static void setContextClassLoader(Object importer, ImportContextClassLoader ccl) {
            if (importer instanceof OsgiServiceProxyFactoryBean) {
                ((OsgiServiceProxyFactoryBean)importer).setContextClassLoader(ccl);
            } else {
                ((OsgiServiceCollectionProxyFactoryBean)importer).setContextClassLoader(ccl);
            }
        }

        static void setServiceBean(Object importer, String name) {
            if (importer instanceof OsgiServiceProxyFactoryBean) {
                ((OsgiServiceProxyFactoryBean)importer).setServiceBeanName(name);
            } else {
                ((OsgiServiceCollectionProxyFactoryBean)importer).setServiceBeanName(name);
            }
        }
    }
}

