/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.custom;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.custom.ExcelDatabaseMetaDataHandler;

public class ExcelConnectionHandler
implements InvocationHandler {
    private Connection connection;
    private File excelFile;

    public ExcelConnectionHandler(Connection connection, String url) {
        CoreArgCheck.isNotNull((Object)connection);
        CoreArgCheck.isNotNull((Object)url);
        this.connection = connection;
        String fileName = ExcelConnectionHandler.getFilePath(url);
        this.excelFile = new File(fileName);
        if (!this.excelFile.exists()) {
            throw new IllegalArgumentException(JdbcPlugin.Util.getString("ExcelConnecton.FileNotFound", (Object)fileName));
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("getMetaData")) {
            return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{DatabaseMetaData.class}, (InvocationHandler)new ExcelDatabaseMetaDataHandler(this.connection.getMetaData(), this.excelFile));
        }
        return method.invoke((Object)this.connection, args);
    }

    protected static String getFilePath(String url) {
        int endIndex;
        String upperCaseUrl = url.toUpperCase();
        int startIndex = upperCaseUrl.indexOf("DBQ");
        if (startIndex == -1) {
            throw new IllegalArgumentException(JdbcPlugin.Util.getString("ExcelConnecton.invalidUrl", (Object)url));
        }
        if ((startIndex = url.indexOf("=", startIndex)) == -1) {
            throw new IllegalArgumentException(JdbcPlugin.Util.getString("ExcelConnecton.invalidUrl", (Object)url));
        }
        if ((endIndex = url.indexOf(";", ++startIndex)) == -1) {
            endIndex = url.indexOf("\"", startIndex);
        }
        if (endIndex == -1) {
            return url.substring(startIndex);
        }
        return url.substring(startIndex, endIndex);
    }
}

