/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class DRLProjectDetector {
    private List<IFile> resources = new ArrayList<IFile>();

    public List<IFile> detect(IProject project) throws CoreException {
        this.detect(project.members());
        return this.resources;
    }

    private void detect(IResource[] members) throws CoreException {
        if (members == null) {
            return;
        }
        int i = 0;
        while (i < members.length) {
            IFile file;
            if (members[i] instanceof IFolder) {
                IFolder folder = (IFolder)members[i];
                if (!folder.isDerived()) {
                    this.detect(folder.members());
                }
            } else if (members[i] instanceof IFile && (file = (IFile)members[i]).getFileExtension() != null && file.getFileExtension().equalsIgnoreCase("drl") && file.isAccessible() && !file.isReadOnly() && !file.isDerived()) {
                this.resources.add(file);
            }
            ++i;
        }
    }
}

