/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseTitleAreaDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VariableDialog
extends BaseTitleAreaDialog {
    private ReportDesignHandle designHandle;
    private VariableElementHandle variable;
    private Text nameTxt;
    private Text expressionTxt;
    private Button reportRadio;
    private Button pageRadio;

    public VariableDialog(String title, ReportDesignHandle designHandle, VariableElementHandle variable) {
        super(UIUtil.getDefaultShell());
        this.title = title;
        this.designHandle = designHandle;
        this.variable = variable;
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.AddEditSortkey_ID");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        contents.setLayoutData((Object)new GridData(1808));
        contents.setLayout((Layout)new GridLayout());
        this.setTitle(this.title);
        this.getShell().setText(this.title);
        VariableDialog.applyDialogFont((Control)contents);
        this.initializeDialogUnits((Control)area);
        this.createInputContents(contents);
        Composite space = new Composite(contents, 0);
        GridData gdata = new GridData(768);
        gdata.heightHint = 10;
        space.setLayoutData((Object)gdata);
        Label lb = new Label(contents, 258);
        lb.setLayoutData((Object)new GridData(768));
        return area;
    }

    protected Control createInputContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayoutData((Object)new GridData(1808));
        content.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).create());
        new Label(content, 0).setText(Messages.getString((String)"VariableDialog.VariableType"));
        Composite typeChoices = new Composite(content, 0);
        typeChoices.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        this.reportRadio = new Button(typeChoices, 16);
        this.reportRadio.setText(Messages.getString((String)"VariableDialog.ReportVariable"));
        this.pageRadio = new Button(typeChoices, 16);
        this.pageRadio.setText(Messages.getString((String)"VariableDialog.PageVariable"));
        new Label(content, 0);
        new Label(content, 0).setText(Messages.getString((String)"VariableDialog.Name"));
        this.nameTxt = new Text(content, 2048);
        this.nameTxt.setLayoutData((Object)new GridData(768));
        this.nameTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VariableDialog.this.validate();
            }
        });
        new Label(content, 0);
        new Label(content, 0).setText(Messages.getString((String)"VariableDialog.DefaultValue"));
        this.expressionTxt = new Text(content, 2050);
        GridData gd = new GridData(768);
        gd.heightHint = this.expressionTxt.computeSize((int)-1, (int)-1).y - this.expressionTxt.getBorderWidth() * 2;
        this.expressionTxt.setLayoutData((Object)gd);
        ExpressionButtonUtil.createExpressionButton(content, (Control)this.expressionTxt, this.getExpressionProvider(), this.variable);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.VariableDialog_ID");
        return content;
    }

    protected boolean initDialog() {
        if (this.variable != null) {
            this.nameTxt.setText(this.variable.getName());
            if (this.variable.getType() == null || this.variable.getType().equals("report")) {
                this.reportRadio.setSelection(true);
            } else {
                this.pageRadio.setSelection(true);
            }
            ExpressionButtonUtil.initExpressionButtonControl((Control)this.expressionTxt, this.variable, "value");
        } else {
            this.reportRadio.setSelection(true);
        }
        this.validate();
        return true;
    }

    protected void okPressed() {
        if (this.variable == null) {
            this.variable = DesignElementFactory.getInstance((ModuleHandle)this.designHandle).newVariableElement(this.nameTxt.getText().trim());
            try {
                this.designHandle.add("pageVariables", (DesignElementHandle)this.variable);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        }
        try {
            this.variable.setVariableName(this.nameTxt.getText().trim());
            if (this.reportRadio.getSelection()) {
                this.variable.setType("report");
            } else {
                this.variable.setType("page");
            }
            ExpressionButtonUtil.saveExpressionButtonControl((Control)this.expressionTxt, this.variable, "value");
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        super.okPressed();
    }

    private void validate() {
        if (this.nameTxt.getText().trim().length() == 0) {
            this.getOkButton().setEnabled(false);
        } else if (this.isNameDuplicated(this.nameTxt.getText().trim())) {
            this.setErrorMessage(Messages.getFormattedString((String)"VariableDialog.Error.NameDuplicate", (Object[])new String[]{this.nameTxt.getText().trim()}));
            this.getOkButton().setEnabled(false);
        } else {
            this.setErrorMessage(null);
            this.getOkButton().setEnabled(true);
        }
    }

    private boolean isNameDuplicated(String text) {
        if (this.variable != null && this.variable.getName().equals(text)) {
            return false;
        }
        for (VariableElementHandle veh : this.designHandle.getPageVariables()) {
            if (!veh.getName().equals(text)) continue;
            return true;
        }
        return false;
    }

    private IExpressionProvider getExpressionProvider() {
        ExpressionProvider provider = new ExpressionProvider((DesignElementHandle)this.variable);
        provider.addFilter(new ExpressionFilter(){

            public boolean select(Object parentElement, Object element) {
                return !element.equals(VariableDialog.this.variable);
            }
        });
        return provider;
    }
}

