/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRulerComposite;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractTableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DummyEditpart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.ShowDragInfomationProcessor;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayout;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.swt.widgets.Display;

public abstract class TableDragGuideTracker
extends DragEditPartsTracker {
    public static final DecimalFormat FORMAT = new DecimalFormat("#0.000");
    public static final String PIXELS_LABEL = Messages.getString((String)"TableDragGuideTracker.Pixels");
    private int start;
    private ShowDragInfomationProcessor processor;
    private int end;
    private Figure marqueeRectangleFigure;
    private static IChoiceSet choiceSet = ChoiceSetFactory.getElementChoiceSet("ReportDesign", "units");

    public TableDragGuideTracker(EditPart sourceEditPart, int start, int end) {
        super(sourceEditPart);
        this.start = start;
        this.end = end;
        this.processor = new ShowDragInfomationProcessor(sourceEditPart);
    }

    protected boolean handleButtonUp(int button) {
        boolean bool = super.handleButtonUp(button);
        this.eraseSourceFeedback();
        return bool;
    }

    protected boolean handleButtonDown(int button) {
        boolean bool = super.handleButtonDown(button);
        if (button == 1) {
            this.showSourceFeedback();
        }
        return bool;
    }

    protected void performSelection() {
    }

    protected void showSourceFeedback() {
        Rectangle rect = this.getMarqueeSelectionRectangle().getCopy();
        this.getMarqueeFeedbackFigure().translateToRelative((Translatable)rect);
        this.getMarqueeFeedbackFigure().setBounds(rect);
        this.processor.getInfomationLabel(this.getInfomation(), this.getStartLocation()).setText(this.getInfomation());
        this.showDragGuide();
    }

    protected void showTargetFeedback() {
    }

    protected void performDrag() {
        if (this.isFitResize()) {
            this.fitResize();
        } else {
            this.resize();
        }
        EditPart part = this.getSourceEditPart();
        part.getViewer().setSelection(part.getViewer().getSelection());
    }

    protected EditorRulerComposite.DragGuideInfo createDragGuideInfo() {
        return null;
    }

    protected boolean isFitResize() {
        EditPart part = this.getSourceEditPart();
        if (part instanceof ReportElementEditPart) {
            return ((ReportElementEditPart)part).isFixLayout();
        }
        return false;
    }

    private IFigure getMarqueeFeedbackFigure() {
        if (this.marqueeRectangleFigure == null) {
            this.marqueeRectangleFigure = new MarqueeRectangleFigure();
            this.addFeedback((IFigure)this.marqueeRectangleFigure);
        }
        return this.marqueeRectangleFigure;
    }

    protected void eraseSourceFeedback() {
        super.eraseSourceFeedback();
        if (this.marqueeRectangleFigure != null) {
            this.removeFeedback((IFigure)this.marqueeRectangleFigure);
            this.marqueeRectangleFigure = null;
        }
        this.processor.removeLabelFigue();
        this.eraseDragGuide();
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    protected void fitResize() {
        this.resize();
    }

    protected abstract void resize();

    protected abstract Rectangle getMarqueeSelectionRectangle();

    protected abstract Dimension getDragWidth(int var1, int var2);

    protected abstract String getInfomation();

    protected void updateInfomation(String label) {
        this.processor.updateInfomation(label, this.getStartLocation());
    }

    public Dimension getDragWidth() {
        return this.getDragWidth(this.getStart(), this.getEnd());
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    protected int getTrueValue(int value) {
        return this.getTrueValue(value, this.getStart(), this.getEnd());
    }

    protected int getTrueValueAbsolute(int value) {
        Dimension dimension = this.getDragWidth(this.getStart(), this.getEnd());
        ((GraphicalEditPart)this.getSourceEditPart()).getFigure().translateToAbsolute((Translatable)dimension);
        if (value < dimension.width) {
            value = dimension.width;
        } else if (value > dimension.height) {
            value = dimension.height;
        }
        return value;
    }

    protected int getTrueValue(int value, int start, int end) {
        Dimension dimension = this.getDragWidth(start, end);
        if (value < dimension.width) {
            value = dimension.width;
        } else if (value > dimension.height) {
            value = dimension.height;
        }
        return value;
    }

    protected List filterEditPart(List list) {
        ArrayList retValue = new ArrayList();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) instanceof DummyEditpart) {
                retValue.add(list.get(i));
            }
            ++i;
        }
        return retValue;
    }

    public static String getUnitDisplayName(String unit) {
        IChoice choice = choiceSet.findChoice(unit);
        return choice.getDisplayName();
    }

    protected TableLayout.WorkingData getTableWorkingData() {
        AbstractTableEditPart part = this.getAbstractTableEditPart();
        IFigure figure = part.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        return data;
    }

    protected String getDefaultUnits() {
        Object model = this.getSourceEditPart().getModel();
        if (!(model instanceof DesignElementHandle)) {
            return "in";
        }
        ModuleHandle handle = ((DesignElementHandle)model).getModuleHandle();
        return handle.getDefaultUnits();
    }

    protected double converPixToDefaultUnit(int pix) {
        double in = MetricUtility.pixelToPixelInch((int)pix);
        return DimensionUtil.convertTo((double)in, (String)"in", (String)this.getDefaultUnits()).getMeasure();
    }

    protected int getMouseTrueValueX() {
        int value = this.getLocation().x - this.getStartLocation().x;
        Dimension temp = new Dimension(value, 0);
        this.getAbstractTableEditPart().getFigure().translateToRelative((Translatable)temp);
        value = temp.width;
        return value;
    }

    protected int getMouseTrueValueY() {
        int value = this.getLocation().y - this.getStartLocation().y;
        Dimension temp = new Dimension(value, 0);
        this.getAbstractTableEditPart().getFigure().translateToRelative((Translatable)temp);
        value = temp.width;
        return value;
    }

    protected AbstractTableEditPart getAbstractTableEditPart() {
        return (AbstractTableEditPart)this.getSourceEditPart();
    }

    private void showDragGuide() {
        EditorRulerComposite.DragGuideInfo info = this.createDragGuideInfo();
        if (info != null) {
            this.getSourceEditPart().getViewer().setProperty("Drag Guide", (Object)info);
        }
    }

    private void eraseDragGuide() {
        EditorRulerComposite.DragGuideInfo info = this.createDragGuideInfo();
        if (info != null) {
            info.setPostion(-1);
            this.getSourceEditPart().getViewer().setProperty("Drag Guide", (Object)info);
        }
    }

    public boolean isCtrlDown() {
        return this.getCurrentInput().isControlKeyDown();
    }

    private static class MarqueeRectangleFigure
    extends Figure {
        private int offset = 0;
        private boolean schedulePaint = true;
        private static final int DELAY = 110;

        private MarqueeRectangleFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle bounds = this.getBounds().getCopy();
            graphics.translate(this.getLocation());
            graphics.setXORMode(true);
            graphics.setForegroundColor(ColorConstants.white);
            graphics.setBackgroundColor(ColorConstants.black);
            graphics.setLineStyle(3);
            int[] points = new int[]{0 + this.offset, 0, bounds.width - 1, 0, bounds.width - 1, bounds.height - 1};
            graphics.drawPolyline(points);
            points[0] = 0;
            points[1] = 0 + this.offset;
            points[2] = 0;
            points[3] = bounds.height - 1;
            points[4] = bounds.width - 1;
            points[5] = bounds.height - 1;
            graphics.drawPolyline(points);
            graphics.translate(this.getLocation().getNegated());
            if (this.schedulePaint) {
                Display.getCurrent().timerExec(110, new Runnable(){

                    public void run() {
                        MarqueeRectangleFigure marqueeRectangleFigure = MarqueeRectangleFigure.this;
                        marqueeRectangleFigure.offset = marqueeRectangleFigure.offset + 1;
                        if (MarqueeRectangleFigure.this.offset > 5) {
                            MarqueeRectangleFigure.this.offset = 0;
                        }
                        MarqueeRectangleFigure.this.schedulePaint = true;
                        MarqueeRectangleFigure.this.repaint();
                    }
                });
            }
            this.schedulePaint = false;
        }
    }
}

