/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.MasterPageEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportContainerEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportFlowLayoutEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.AreaFigure;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportFlowLayout;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;

public class AreaEditPart
extends ReportElementEditPart {
    public AreaEditPart(Object model) {
        super(model);
    }

    protected IFigure createFigure() {
        AreaFigure figure = new AreaFigure();
        figure.setLayoutManager((LayoutManager)new ReportFlowLayout());
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", null);
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ReportFlowLayoutEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new ReportContainerEditPolicy());
    }

    protected List getModelChildren() {
        ArrayList list = new ArrayList();
        this.insertIteratorToList(((SlotHandle)this.getModel()).iterator(), list);
        return list;
    }

    protected void insertIteratorToList(Iterator iterator, List list) {
        Iterator it = iterator;
        while (it.hasNext()) {
            list.add(it.next());
        }
    }

    public void refreshFigure() {
        ((MasterPageEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.figure, this.getConstraint());
    }

    private Rectangle getConstraint() {
        IFigure parent = ((MasterPageEditPart)this.getParent()).getFigure();
        Rectangle region = parent.getClientArea();
        Rectangle rect = new Rectangle();
        rect.height = -1;
        rect.width = region.width;
        SimpleMasterPageHandle mphandle = (SimpleMasterPageHandle)((MasterPageEditPart)this.getParent()).getModel();
        if (((SlotHandle)this.getModel()).getSlotID() == 0) {
            if (mphandle.getPropertyHandle("headerHeight").isSet() || DEUtil.isFixLayout((Object)this.getParent().getModel())) {
                DimensionHandle handle = mphandle.getHeaderHeight();
                rect.height = this.getHeight(handle);
            }
        } else if (mphandle.getPropertyHandle("footerHeight").isSet() || DEUtil.isFixLayout((Object)this.getParent().getModel())) {
            DimensionHandle handle = mphandle.getFooterHeight();
            rect.height = this.getHeight(handle);
        }
        if (((SlotHandle)this.getModel()).getSlotID() == 0) {
            rect.setLocation(0, 0);
        } else {
            rect.setLocation(-1, -1);
        }
        return rect;
    }

    private int getHeight(DimensionHandle handle) {
        if ("%".equals(handle.getUnits())) {
            return (int)((double)((GraphicalEditPart)this.getParent()).getFigure().getClientArea().height * handle.getMeasure() / 100.0);
        }
        return (int)DEUtil.convertoToPixel((Object)handle);
    }
}

