/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.HashMap;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatLayoutPeer;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatNumberAdapter;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FormatCurrencyNumPattern;
import org.eclipse.birt.report.designer.util.FormatCustomNumPattern;
import org.eclipse.birt.report.designer.util.FormatFixedNumPattern;
import org.eclipse.birt.report.designer.util.FormatNumberPattern;
import org.eclipse.birt.report.designer.util.FormatPercentNumPattern;
import org.eclipse.birt.report.designer.util.FormatScientificNumPattern;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FormatNumberLayoutPeer
extends FormatLayoutPeer {
    private static final String PREVIEW_TEXT_INVALID_NUMBER_TO_PREVIEW = Messages.getString((String)"FormatNumberPage.preview.invalidNumber");
    private static final String LABEL_CURRENCY_SETTINGS_GROUP = Messages.getString((String)"FormatNumberPage.label.currency.settings");
    private static final String LABEL_CURRENCY_SYMBOL = Messages.getString((String)"FormatNumberPage.label.symbol");
    private static final String LABEL_FIXED_SETTINGS_GROUP = Messages.getString((String)"FormatNumberPage.label.fixed.settings");
    private static final String LABEL_PERCENT_SETTINGS_GROUP = Messages.getString((String)"FormatNumberPage.label.percent.settings");
    private static final String LABEL_USE_1000S_SEPARATOR = Messages.getString((String)"FormatNumberPage.label.use1000sSeparator");
    private static final String LABEL_USE_SYMBOL_SPACE = Messages.getString((String)"FormatNumberPage.label.useSymbolSpace");
    private static final String LABEL_SYMBOL_POSITION = Messages.getString((String)"FormatNumberPage.label.symbol.position");
    private static final String LABEL_NEGATIVE_NUMBERS = Messages.getString((String)"FormatNumberPage.label.negative.numbers");
    private static final String LABEL_SCIENTIFIC_SETTINGS_GROUP = Messages.getString((String)"FormatNumberPage.label.scientific.settings");
    private static final String LABEL_DECIMAL_PLACES = Messages.getString((String)"FormatNumberPage.label.decimal.places");
    private static final String LABEL_ROUNDING_MODE = Messages.getString((String)"FormatNumberPage.label.rounding.mode");
    private static final String LABEL_CUSTOM_PREVIEW_NUMBER = Messages.getString((String)"FormatNumberPage.label.preview.number");
    private static final String LABEL_GENERAL_PREVIEW_GROUP = Messages.getString((String)"FormatNumberPage.label.general.preview.group");
    private static final String DEFAULT_PATTERN = "#,##0.00";
    private static final int FORMAT_TYPE_INDEX = 0;
    private static final double DEFAULT_PREVIEW_NUMBER = 1234.56;
    private static final String DEFAULT_PREVIEW_TEXT = NumberFormat.getNumberInstance((ULocale)ULocale.getDefault()).format(1234.56);
    private HashMap<String, Object> categoryPatternMaps;
    private Composite currencyPage;
    private Composite fixedPage;
    private Composite percentPage;
    private Composite scientificPage;
    private Label gPreviewLabel;
    private Label cPreviewLabel;
    private Label fPreviewLabel;
    private Label pPreviewLabel;
    private Label sPreviewLabel;
    private FormatLayoutPeer.XCombo cPlacesChoice;
    private FormatLayoutPeer.XCombo cSymbolChoice;
    private FormatLayoutPeer.XCombo cSymPosChoice;
    private FormatLayoutPeer.XCombo fPlacesChoice;
    private FormatLayoutPeer.XCombo pSymPosChoice;
    private FormatLayoutPeer.XCombo pPlacesChoice;
    private FormatLayoutPeer.XCombo sPlacesChoice;
    private FormatLayoutPeer.XCombo cRoundgingChoice;
    private FormatLayoutPeer.XCombo pRoundgingChoice;
    private FormatLayoutPeer.XCombo fRoundgingChoice;
    private FormatLayoutPeer.XCombo sRoundgingChoice;
    private Button cUseSep;
    private Button pUseSep;
    private Button fUseSep;
    private Button cUseSpace;
    private List cNegNumChoice;
    private List fNegNumChoice;
    private List pNegNumChoice;
    private SelectionListener mySelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            FormatNumberLayoutPeer.this.updatePreview();
            FormatNumberLayoutPeer.this.notifyFormatChange();
        }
    };
    private ModifyListener myModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (FormatNumberLayoutPeer.this.hasLoaded) {
                FormatNumberLayoutPeer.this.updatePreview();
            }
        }
    };
    private FocusListener myFocusListener = new FocusListener(){

        public void focusLost(FocusEvent e) {
            FormatNumberLayoutPeer.this.notifyFormatChange();
        }

        public void focusGained(FocusEvent e) {
        }
    };

    public FormatNumberLayoutPeer(int pageAlignment, boolean isFormStyle, boolean showLocale) {
        super(pageAlignment, isFormStyle, showLocale);
        this.formatAdapter = new FormatNumberAdapter();
    }

    protected void fireFormatChanged(String newCategory, String newPattern, String newLocale) {
        this.fireFormatChanged("numberFormat", newCategory, newPattern, newLocale);
    }

    protected void createCategoryPages(Composite parent) {
        this.categoryPageMaps = new HashMap();
        this.categoryPageMaps.put("Unformatted", this.getGeneralPage(parent));
        this.categoryPageMaps.put("General Number", this.getGeneralPage(parent));
        this.categoryPageMaps.put("Currency", this.getCurrencyPage(parent));
        this.categoryPageMaps.put("Fixed", this.getFixedPage(parent));
        this.categoryPageMaps.put("Percent", this.getPercentPage(parent));
        this.categoryPageMaps.put("Scientific", this.getScientificPage(parent));
        this.categoryPageMaps.put("Custom", this.getCustomPage(parent, false, LABEL_CUSTOM_PREVIEW_NUMBER));
    }

    protected void createCategoryPatterns() {
        this.categoryPatternMaps = new HashMap();
        this.categoryPatternMaps.put("General Number", new FormatNumberPattern());
        this.categoryPatternMaps.put("Currency", new FormatCurrencyNumPattern("Currency"));
        this.categoryPatternMaps.put("Fixed", new FormatFixedNumPattern("Fixed"));
        this.categoryPatternMaps.put("Percent", new FormatPercentNumPattern("Percent"));
        this.categoryPatternMaps.put("Scientific", new FormatScientificNumPattern("Scientific"));
        this.categoryPatternMaps.put("Custom", new FormatCustomNumPattern("Custom"));
    }

    protected String getDefaultPreviewText() {
        return DEFAULT_PREVIEW_TEXT;
    }

    protected void updateDefaultsByLocale() {
        String defaultPosition;
        String category;
        ULocale locale = this.getLocaleByDisplayName(this.localeChoicer.getText());
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        if ((category = this.formatAdapter.getCategory4DisplayName(this.typeChoicer.getText())).equals("Currency")) {
            String defaultPosition2 = FormatCurrencyNumPattern.getDefaultSymbolPosition((ULocale)locale);
            boolean defaultUseSpace = FormatCurrencyNumPattern.getDefaultUsingSymbolSpace((ULocale)locale);
            int defaultDigits = FormatCurrencyNumPattern.getDefaultFractionDigits((ULocale)locale);
            this.cUseSpace.setSelection(defaultUseSpace);
            if (defaultPosition2 != null) {
                this.cSymPosChoice.setText(defaultPosition2);
            }
            this.cPlacesChoice.setText(String.valueOf(defaultDigits));
        } else if (category.equals("Percent") && (defaultPosition = FormatPercentNumPattern.getDefaultSymbolPosition((ULocale)locale)) != null) {
            this.pSymPosChoice.setText(defaultPosition);
        }
    }

    protected void initiatePageLayout(String categoryStr, String patternStr, String localeStr) {
        this.initiatePageLayout("Custom", categoryStr, patternStr, localeStr);
        this.createCategoryPatterns();
        FormatNumberPattern fmtPattern = (FormatNumberPattern)this.categoryPatternMaps.get(categoryStr);
        if (fmtPattern == null) {
            return;
        }
        fmtPattern.setPattern(patternStr);
        if ("Currency".equals(categoryStr)) {
            this.refreshCurrencySetting((FormatCurrencyNumPattern)fmtPattern);
        } else if ("Fixed".equals(categoryStr)) {
            this.refreshFixedSetting((FormatFixedNumPattern)fmtPattern);
        } else if ("Percent".equals(categoryStr)) {
            this.refreshPercentSetting((FormatPercentNumPattern)fmtPattern);
        } else if ("Scientific".equals(categoryStr)) {
            this.refreshScientificSetting((FormatScientificNumPattern)fmtPattern);
        } else if ("Custom".equals(categoryStr)) {
            this.refreshCustomSetting((FormatCustomNumPattern)fmtPattern);
        }
    }

    protected void reLayoutSubPages() {
        this.reLayoutSubPages("Custom");
    }

    private void refreshCurrencySetting(FormatCurrencyNumPattern fmtPattern) {
        this.cPlacesChoice.setText(String.valueOf(fmtPattern.getDecPlaces()));
        this.cUseSep.setSelection(fmtPattern.getUseSep());
        this.cUseSpace.setSelection(fmtPattern.getUseSpace());
        this.cRoundgingChoice.select(FormatNumberPattern.getRoundingModeIndexByValue((String)fmtPattern.getRoundingMode()));
        if (!StringUtil.isBlank((String)fmtPattern.getSymbol())) {
            this.cSymbolChoice.setText(fmtPattern.getSymbol());
        } else {
            this.cSymbolChoice.setText(FormatNumberPattern.TEXT_CURRENCY_SYMBOL_NONE);
        }
        if (!StringUtil.isBlank((String)fmtPattern.getSymPos())) {
            this.cSymPosChoice.setText(fmtPattern.getSymPos());
            this.cSymPosChoice.setEnabled(true);
        }
        if (this.cSymbolChoice.getSelectionIndex() == 0) {
            this.cSymPosChoice.deselectAll();
            this.cSymPosChoice.setEnabled(false);
            this.cUseSpace.setEnabled(false);
        } else {
            if (!this.cSymPosChoice.isEnabled()) {
                this.cSymPosChoice.setEnabled(true);
                this.cSymPosChoice.select(1);
            }
            this.cUseSpace.setEnabled(true);
        }
        if (fmtPattern.getUseBracket()) {
            this.cNegNumChoice.select(1);
        } else {
            this.cNegNumChoice.select(0);
        }
    }

    private void refreshFixedSetting(FormatFixedNumPattern fmtPattern) {
        this.fPlacesChoice.setText(String.valueOf(fmtPattern.getDecPlaces()));
        this.fRoundgingChoice.select(FormatNumberPattern.getRoundingModeIndexByValue((String)fmtPattern.getRoundingMode()));
        this.fUseSep.setSelection(fmtPattern.getUseSep());
        if (fmtPattern.getUseBracket()) {
            this.fNegNumChoice.select(1);
        } else {
            this.fNegNumChoice.select(0);
        }
    }

    private void refreshPercentSetting(FormatPercentNumPattern fmtPattern) {
        this.pPlacesChoice.setText(String.valueOf(fmtPattern.getDecPlaces()));
        this.pRoundgingChoice.select(FormatNumberPattern.getRoundingModeIndexByValue((String)fmtPattern.getRoundingMode()));
        this.pUseSep.setSelection(fmtPattern.getUseSep());
        this.pSymPosChoice.setText(fmtPattern.getSymPos());
        if (fmtPattern.getUseBracket()) {
            this.pNegNumChoice.select(1);
        } else {
            this.pNegNumChoice.select(0);
        }
    }

    private void refreshScientificSetting(FormatScientificNumPattern fmtPattern) {
        this.sPlacesChoice.setText(String.valueOf(fmtPattern.getDecPlaces()));
        this.sRoundgingChoice.select(FormatNumberPattern.getRoundingModeIndexByValue((String)fmtPattern.getRoundingMode()));
    }

    private void refreshCustomSetting(FormatCustomNumPattern fmtPattern) {
        this.customFormatCodeTextBox.setText(fmtPattern.getPattern() == null ? "" : fmtPattern.getPattern());
    }

    private void setFmtPatternFromControls() {
        if (this.categoryPatternMaps == null) {
            return;
        }
        String category = this.formatAdapter.getCategory4DisplayName(this.typeChoicer.getText());
        if (category.equals("Currency")) {
            FormatCurrencyNumPattern pattern = (FormatCurrencyNumPattern)this.categoryPatternMaps.get(category);
            String places = this.cPlacesChoice.getText();
            pattern.setDecPlaces(DEUtil.isValidInteger((String)places) ? Integer.parseInt(places) : 0);
            pattern.setRoundingMode(FormatNumberPattern.getRoundingModeByName((String)this.cRoundgingChoice.getText()));
            pattern.setUseSep(this.cUseSep.getSelection());
            pattern.setUseSpace(this.cUseSpace.getSelection());
            pattern.setSymbol(this.cSymbolChoice.getText());
            pattern.setSymPos(this.cSymPosChoice.getText());
            pattern.setUseBracket(this.cNegNumChoice.getSelectionIndex() == 1);
        } else if (category.equals("Fixed")) {
            FormatFixedNumPattern pattern = (FormatFixedNumPattern)this.categoryPatternMaps.get(category);
            String places = this.fPlacesChoice.getText();
            pattern.setDecPlaces(DEUtil.isValidInteger((String)places) ? Integer.parseInt(places) : 0);
            pattern.setRoundingMode(FormatNumberPattern.getRoundingModeByName((String)this.fRoundgingChoice.getText()));
            pattern.setUseSep(this.fUseSep.getSelection());
            pattern.setUseBracket(this.fNegNumChoice.getSelectionIndex() == 1);
        } else if (category.equals("Percent")) {
            FormatPercentNumPattern pattern = (FormatPercentNumPattern)this.categoryPatternMaps.get(category);
            String places = this.pPlacesChoice.getText();
            pattern.setDecPlaces(DEUtil.isValidInteger((String)places) ? Integer.parseInt(places) : 0);
            pattern.setRoundingMode(FormatNumberPattern.getRoundingModeByName((String)this.pRoundgingChoice.getText()));
            pattern.setUseSep(this.pUseSep.getSelection());
            pattern.setSymPos(this.pSymPosChoice.getText());
            pattern.setUseBracket(this.pNegNumChoice.getSelectionIndex() == 1);
        } else if (category.equals("Scientific")) {
            FormatScientificNumPattern pattern = (FormatScientificNumPattern)this.categoryPatternMaps.get(category);
            String places = this.sPlacesChoice.getText();
            pattern.setDecPlaces(DEUtil.isValidInteger((String)places) ? Integer.parseInt(places) : 0);
            pattern.setRoundingMode(FormatNumberPattern.getRoundingModeByName((String)this.sRoundgingChoice.getText()));
        } else if (category.equals("Custom")) {
            FormatCustomNumPattern pattern = (FormatCustomNumPattern)this.categoryPatternMaps.get(category);
            pattern.setPattern(this.customFormatCodeTextBox.getText().length() == 0 ? null : this.customFormatCodeTextBox.getText());
        }
    }

    private Composite getGeneralPage(Composite parent) {
        if (this.generalPage == null) {
            this.generalPage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            this.generalPage.setLayout((Layout)layout);
            this.gPreviewLabel = this.createGeneralPreviewPart4Page(this.generalPage);
        }
        return this.generalPage;
    }

    private Composite getCurrencyPage(Composite parent) {
        if (this.currencyPage == null) {
            this.currencyPage = new Composite(parent, 0);
            this.currencyPage.setLayout((Layout)this.createGridLayout4Page());
            this.createCurrencySettingPart(this.currencyPage);
            this.cPreviewLabel = this.createGeneralPreviewPart4Page(this.currencyPage);
        }
        return this.currencyPage;
    }

    private Composite getFixedPage(Composite parent) {
        if (this.fixedPage == null) {
            this.fixedPage = new Composite(parent, 0);
            this.fixedPage.setLayout((Layout)this.createGridLayout4Page());
            this.createFixedSettingPart(this.fixedPage);
            this.fPreviewLabel = this.createGeneralPreviewPart4Page(this.fixedPage);
        }
        return this.fixedPage;
    }

    private Composite getPercentPage(Composite parent) {
        if (this.percentPage == null) {
            this.percentPage = new Composite(parent, 0);
            this.percentPage.setLayout((Layout)this.createGridLayout4Page());
            this.createPercentSettingPart(this.percentPage);
            this.pPreviewLabel = this.createGeneralPreviewPart4Page(this.percentPage);
        }
        return this.percentPage;
    }

    private Composite getScientificPage(Composite parent) {
        if (this.scientificPage == null) {
            this.scientificPage = new Composite(parent, 0);
            this.scientificPage.setLayout((Layout)this.createGridLayout4Page());
            this.createScientificSettingPart(this.scientificPage);
            this.sPreviewLabel = this.createGeneralPreviewPart4Page(this.scientificPage);
        }
        return this.scientificPage;
    }

    private void createCurrencySettingPart(Composite parent) {
        Group setting = this.isFormStyle ? FormWidgetFactory.getInstance().createGroup(parent, "") : new Group(parent, 0);
        setting.setText(LABEL_CURRENCY_SETTINGS_GROUP);
        setting.setLayoutData((Object)this.createGridData4Part());
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 4;
        layout.verticalSpacing = 5;
        setting.setLayout((Layout)layout);
        FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle).setText(LABEL_DECIMAL_PLACES);
        this.cPlacesChoice = new FormatLayoutPeer.XCombo((Composite)setting, false, this.isFormStyle);
        this.cPlacesChoice.setItems(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        GridData data = new GridData(768);
        this.cPlacesChoice.setLayoutData(data);
        this.cPlacesChoice.addSelectionListener(this.mySelectionListener);
        this.cPlacesChoice.addModifyListener(this.myModifyListener);
        this.cPlacesChoice.addFocusListener(this.myFocusListener);
        this.cPlacesChoice.select(2);
        FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle).setText(LABEL_ROUNDING_MODE);
        this.cRoundgingChoice = new FormatLayoutPeer.XCombo((Composite)setting, true, this.isFormStyle);
        this.cRoundgingChoice.setLayoutData(new GridData(256));
        this.cRoundgingChoice.setItems(FormatNumberPattern.ROUNDING_MODES_NAMES);
        this.cRoundgingChoice.addSelectionListener(this.mySelectionListener);
        this.cRoundgingChoice.select(0);
        this.cUseSep = FormWidgetFactory.getInstance().createButton((Composite)setting, 32, this.isFormStyle);
        this.cUseSep.setText(LABEL_USE_1000S_SEPARATOR);
        data = new GridData();
        data.horizontalSpan = 2;
        this.cUseSep.setLayoutData((Object)data);
        this.cUseSep.addSelectionListener(this.mySelectionListener);
        this.cUseSpace = FormWidgetFactory.getInstance().createButton((Composite)setting, 32, this.isFormStyle);
        this.cUseSpace.setText(LABEL_USE_SYMBOL_SPACE);
        data = new GridData();
        data.horizontalSpan = 2;
        this.cUseSpace.setLayoutData((Object)data);
        this.cUseSpace.addSelectionListener(this.mySelectionListener);
        this.cUseSpace.setEnabled(false);
        FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle).setText(LABEL_CURRENCY_SYMBOL);
        this.cSymbolChoice = new FormatLayoutPeer.XCombo((Composite)setting, true, this.isFormStyle);
        this.cSymbolChoice.setLayoutData(new GridData(256));
        this.cSymbolChoice.setItems(FormatCurrencyNumPattern.BUILT_IN_SYMBOLS);
        this.cSymbolChoice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FormatNumberLayoutPeer.this.cSymbolChoice.getSelectionIndex() == 0) {
                    FormatNumberLayoutPeer.this.cSymPosChoice.deselectAll();
                    FormatNumberLayoutPeer.this.cSymPosChoice.setEnabled(false);
                    FormatNumberLayoutPeer.this.cUseSpace.setEnabled(false);
                } else {
                    if (!FormatNumberLayoutPeer.this.cSymPosChoice.isEnabled()) {
                        FormatNumberLayoutPeer.this.cSymPosChoice.setEnabled(true);
                        String defaultPosition = FormatCurrencyNumPattern.getDefaultSymbolPosition((ULocale)FormatNumberLayoutPeer.this.getLocale());
                        if (defaultPosition != null) {
                            FormatNumberLayoutPeer.this.cSymPosChoice.setText(defaultPosition);
                        } else {
                            FormatNumberLayoutPeer.this.cSymPosChoice.select(1);
                        }
                    }
                    if (!FormatNumberLayoutPeer.this.cUseSpace.isEnabled()) {
                        FormatNumberLayoutPeer.this.cUseSpace.setEnabled(true);
                        boolean defaultUseSpace = FormatCurrencyNumPattern.getDefaultUsingSymbolSpace((ULocale)FormatNumberLayoutPeer.this.getLocale());
                        FormatNumberLayoutPeer.this.cUseSpace.setSelection(defaultUseSpace);
                    }
                }
                FormatNumberLayoutPeer.this.updatePreview();
                FormatNumberLayoutPeer.this.notifyFormatChange();
            }
        });
        this.cSymbolChoice.select(0);
        FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle).setText(LABEL_SYMBOL_POSITION);
        this.cSymPosChoice = new FormatLayoutPeer.XCombo((Composite)setting, true, this.isFormStyle);
        this.cSymPosChoice.setItems(new String[]{FormatNumberPattern.SYMBOL_POSITION_AFTER, FormatNumberPattern.SYMBOL_POSITION_BEFORE});
        this.cSymPosChoice.setLayoutData(new GridData(768));
        this.cSymPosChoice.addSelectionListener(this.mySelectionListener);
        this.cSymPosChoice.setEnabled(false);
        Label label = FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle);
        label.setLayoutData((Object)new GridData(2));
        label.setText(LABEL_NEGATIVE_NUMBERS);
        this.cNegNumChoice = this.isFormStyle ? FormWidgetFactory.getInstance().createList((Composite)setting, 4) : new List((Composite)setting, 2052);
        this.cNegNumChoice.add("-" + DEFAULT_PREVIEW_TEXT);
        this.cNegNumChoice.add("(" + DEFAULT_PREVIEW_TEXT + ")");
        data = new GridData(1808);
        this.cNegNumChoice.setLayoutData((Object)data);
        this.cNegNumChoice.addSelectionListener(this.mySelectionListener);
        this.cNegNumChoice.select(0);
    }

    private void createFixedSettingPart(Composite parent) {
        Group setting = this.isFormStyle ? FormWidgetFactory.getInstance().createGroup(parent, "") : new Group(parent, 0);
        setting.setText(LABEL_FIXED_SETTINGS_GROUP);
        setting.setLayoutData((Object)this.createGridData4Part());
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 4;
        layout.verticalSpacing = 5;
        setting.setLayout((Layout)layout);
        Label label = FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle);
        label.setText(LABEL_DECIMAL_PLACES);
        this.fPlacesChoice = new FormatLayoutPeer.XCombo((Composite)setting, false, this.isFormStyle);
        this.fPlacesChoice.setItems(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        GridData data = new GridData(768);
        this.fPlacesChoice.setLayoutData(data);
        this.fPlacesChoice.addSelectionListener(this.mySelectionListener);
        this.fPlacesChoice.addModifyListener(this.myModifyListener);
        this.fPlacesChoice.addFocusListener(this.myFocusListener);
        this.fPlacesChoice.select(2);
        FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle).setText(LABEL_ROUNDING_MODE);
        this.fRoundgingChoice = new FormatLayoutPeer.XCombo((Composite)setting, true, this.isFormStyle);
        this.fRoundgingChoice.setLayoutData(new GridData(256));
        this.fRoundgingChoice.setItems(FormatNumberPattern.ROUNDING_MODES_NAMES);
        this.fRoundgingChoice.addSelectionListener(this.mySelectionListener);
        this.fRoundgingChoice.select(0);
        this.fUseSep = FormWidgetFactory.getInstance().createButton((Composite)setting, 32, this.isFormStyle);
        this.fUseSep.setText(LABEL_USE_1000S_SEPARATOR);
        GridData gData = new GridData();
        gData.horizontalSpan = 2;
        this.fUseSep.setLayoutData((Object)gData);
        this.fUseSep.addSelectionListener(this.mySelectionListener);
        label = FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle);
        label.setText(LABEL_NEGATIVE_NUMBERS);
        label.setLayoutData((Object)new GridData(2));
        this.fNegNumChoice = this.isFormStyle ? FormWidgetFactory.getInstance().createList((Composite)setting, 516) : new List((Composite)setting, 2564);
        this.fNegNumChoice.add("-" + DEFAULT_PREVIEW_TEXT);
        this.fNegNumChoice.add("(" + DEFAULT_PREVIEW_TEXT + ")");
        gData = new GridData(1808);
        this.fNegNumChoice.setLayoutData((Object)gData);
        this.fNegNumChoice.addSelectionListener(this.mySelectionListener);
        this.fNegNumChoice.select(0);
    }

    private void createPercentSettingPart(Composite parent) {
        Group setting = this.isFormStyle ? FormWidgetFactory.getInstance().createGroup(parent, "") : new Group(parent, 0);
        setting.setText(LABEL_PERCENT_SETTINGS_GROUP);
        setting.setLayoutData((Object)this.createGridData4Part());
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 4;
        layout.verticalSpacing = 5;
        setting.setLayout((Layout)layout);
        FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle).setText(LABEL_DECIMAL_PLACES);
        this.pPlacesChoice = new FormatLayoutPeer.XCombo((Composite)setting, false, this.isFormStyle);
        this.pPlacesChoice.setItems(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        GridData data = new GridData(768);
        this.pPlacesChoice.setLayoutData(data);
        this.pPlacesChoice.addSelectionListener(this.mySelectionListener);
        this.pPlacesChoice.addModifyListener(this.myModifyListener);
        this.pPlacesChoice.addFocusListener(this.myFocusListener);
        this.pPlacesChoice.select(2);
        FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle).setText(LABEL_ROUNDING_MODE);
        this.pRoundgingChoice = new FormatLayoutPeer.XCombo((Composite)setting, true, this.isFormStyle);
        this.pRoundgingChoice.setLayoutData(new GridData(256));
        this.pRoundgingChoice.setItems(FormatNumberPattern.ROUNDING_MODES_NAMES);
        this.pRoundgingChoice.addSelectionListener(this.mySelectionListener);
        this.pRoundgingChoice.select(0);
        this.pUseSep = FormWidgetFactory.getInstance().createButton((Composite)setting, 32, this.isFormStyle);
        this.pUseSep.setText(LABEL_USE_1000S_SEPARATOR);
        GridData gData = new GridData();
        gData.horizontalSpan = 2;
        this.pUseSep.setLayoutData((Object)gData);
        this.pUseSep.addSelectionListener(this.mySelectionListener);
        FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle).setText(LABEL_SYMBOL_POSITION);
        this.pSymPosChoice = new FormatLayoutPeer.XCombo((Composite)setting, true, this.isFormStyle);
        this.pSymPosChoice.setItems(new String[]{FormatNumberPattern.SYMBOL_POSITION_AFTER, FormatNumberPattern.SYMBOL_POSITION_BEFORE});
        this.pSymPosChoice.setLayoutData(new GridData(768));
        this.pSymPosChoice.addSelectionListener(this.mySelectionListener);
        this.pSymPosChoice.select(0);
        Label label = FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle);
        label.setText(LABEL_NEGATIVE_NUMBERS);
        label.setLayoutData((Object)new GridData(2));
        this.pNegNumChoice = this.isFormStyle ? FormWidgetFactory.getInstance().createList((Composite)setting, 516) : new List((Composite)setting, 2564);
        this.pNegNumChoice.add("-" + DEFAULT_PREVIEW_TEXT);
        this.pNegNumChoice.add("(" + DEFAULT_PREVIEW_TEXT + ")");
        this.pNegNumChoice.setLayoutData((Object)new GridData(1808));
        this.pNegNumChoice.addSelectionListener(this.mySelectionListener);
        this.pNegNumChoice.select(0);
    }

    private void createScientificSettingPart(Composite parent) {
        Group setting = this.isFormStyle ? FormWidgetFactory.getInstance().createGroup(parent, "") : new Group(parent, 0);
        setting.setText(LABEL_SCIENTIFIC_SETTINGS_GROUP);
        setting.setLayoutData((Object)this.createGridData4Part());
        setting.setLayout((Layout)new GridLayout(2, false));
        Label label = FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle);
        label.setText(LABEL_DECIMAL_PLACES);
        this.sPlacesChoice = new FormatLayoutPeer.XCombo((Composite)setting, false, this.isFormStyle);
        this.sPlacesChoice.setItems(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        GridData data = new GridData(768);
        data.widthHint = 60;
        this.sPlacesChoice.setLayoutData(data);
        this.sPlacesChoice.addSelectionListener(this.mySelectionListener);
        this.sPlacesChoice.addModifyListener(this.myModifyListener);
        this.pPlacesChoice.addFocusListener(this.myFocusListener);
        this.sPlacesChoice.select(2);
        FormWidgetFactory.getInstance().createLabel((Composite)setting, this.isFormStyle).setText(LABEL_ROUNDING_MODE);
        this.sRoundgingChoice = new FormatLayoutPeer.XCombo((Composite)setting, true, this.isFormStyle);
        this.sRoundgingChoice.setLayoutData(new GridData(256));
        this.sRoundgingChoice.setItems(FormatNumberPattern.ROUNDING_MODES_NAMES);
        this.sRoundgingChoice.addSelectionListener(this.mySelectionListener);
        this.sRoundgingChoice.select(0);
    }

    private Label createGeneralPreviewPart4Page(Composite parent) {
        Group group = this.isFormStyle ? FormWidgetFactory.getInstance().createGroup(parent, "") : new Group(parent, 0);
        group.setText(LABEL_GENERAL_PREVIEW_GROUP);
        GridData data = this.pageAlignment == 1 ? new GridData(1808) : new GridData(768);
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        group.setLayout((Layout)layout);
        Label previewText = FormWidgetFactory.getInstance().createLabel((Composite)group, 0x1000300, this.isFormStyle);
        previewText.setLayoutData((Object)new GridData(1808));
        return previewText;
    }

    protected void createTable(Composite parent) {
        super.createTable(parent);
        ULocale locale = this.getLocale();
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        TableColumn tableColumValue = new TableColumn(this.customFormatTable, 0);
        tableColumValue.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_CODE);
        tableColumValue.setWidth(120);
        tableColumValue.setResizable(true);
        TableColumn tableColumnDisplay = new TableColumn(this.customFormatTable, 0);
        tableColumnDisplay.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_RESULT);
        tableColumnDisplay.setWidth(120);
        tableColumnDisplay.setResizable(true);
        new TableItem(this.customFormatTable, 0).setText(new String[]{this.formatAdapter.getDisplayName4Category("Currency"), new NumberFormatter(FormatNumberPattern.getPatternForCategory((String)"Currency", (ULocale)locale)).format(1234.56)});
        new TableItem(this.customFormatTable, 0).setText(new String[]{this.formatAdapter.getDisplayName4Category("Fixed"), new NumberFormatter(FormatNumberPattern.getPatternForCategory((String)"Fixed", (ULocale)locale)).format(1234.56)});
        new TableItem(this.customFormatTable, 0).setText(new String[]{this.formatAdapter.getDisplayName4Category("Percent"), new NumberFormatter(FormatNumberPattern.getPatternForCategory((String)"Percent", (ULocale)locale)).format(1234.56)});
        new TableItem(this.customFormatTable, 0).setText(new String[]{this.formatAdapter.getDisplayName4Category("Scientific"), new NumberFormatter(FormatNumberPattern.getPatternForCategory((String)"Scientific", (ULocale)locale)).format(1234.56)});
        this.customFormatTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String displayName = ((TableItem)e.item).getText(0);
                String pattern = FormatNumberLayoutPeer.this.formatAdapter.getPattern4DisplayName(displayName, FormatNumberLayoutPeer.this.getLocale());
                FormatNumberLayoutPeer.this.customFormatCodeTextBox.setText(pattern);
                FormatNumberLayoutPeer.this.updatePreview();
                FormatNumberLayoutPeer.this.notifyFormatChange();
            }
        });
    }

    protected void setControlsEnabled(boolean enabled) {
        this.typeChoicer.setEnabled(enabled);
        this.localeChoicer.setEnabled(enabled);
        this.cPlacesChoice.setEnabled(enabled);
        this.cRoundgingChoice.setEnabled(enabled);
        this.cUseSep.setEnabled(enabled);
        this.cUseSpace.setEnabled(enabled);
        this.cSymbolChoice.setEnabled(enabled);
        this.cSymPosChoice.setEnabled(enabled);
        if (enabled && this.cSymbolChoice.getSelectionIndex() == 0) {
            if (this.cSymPosChoice.isEnabled()) {
                this.cSymPosChoice.setEnabled(false);
            }
            if (this.cUseSpace.isEnabled()) {
                this.cUseSpace.setEnabled(false);
            }
        }
        this.cNegNumChoice.setEnabled(enabled);
        this.fPlacesChoice.setEnabled(enabled);
        this.fRoundgingChoice.setEnabled(enabled);
        this.fUseSep.setEnabled(enabled);
        this.fNegNumChoice.setEnabled(enabled);
        this.pPlacesChoice.setEnabled(enabled);
        this.pRoundgingChoice.setEnabled(enabled);
        this.pUseSep.setEnabled(enabled);
        this.pSymPosChoice.setEnabled(enabled);
        this.pNegNumChoice.setEnabled(enabled);
        this.sPlacesChoice.setEnabled(enabled);
        this.sRoundgingChoice.setEnabled(enabled);
        this.customFormatCodeTextBox.setEnabled(enabled);
        this.customPreviewTextBox.setEnabled(enabled);
        this.customFormatTable.setEnabled(enabled);
    }

    protected void setDefaultPreviewText(String text) {
        this.previewText = text == null || StringUtil.isBlank((String)text) || !this.isValidNumber(text) ? null : text;
    }

    private boolean isValidNumber(String text) {
        ULocale locale = this.getLocaleByDisplayName(this.localeChoicer.getText());
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        try {
            NumberFormat.getNumberInstance((ULocale)locale).parse(text);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    private void doPreview(String category, String patternStr, String localeName) {
        ULocale locale = this.getLocaleByDisplayName(localeName);
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        double num = 1234.56;
        if (this.getPreviewText() != null) {
            try {
                if (category.equals("Currency")) {
                    num = new NumberFormatter(DEFAULT_PATTERN, locale).parse(this.getPreviewText()).doubleValue();
                } else if (category.equals("Fixed")) {
                    num = new NumberFormatter(DEFAULT_PATTERN, locale).parse(this.getPreviewText()).doubleValue();
                } else if (category.equals("Percent")) {
                    num = new NumberFormatter(DEFAULT_PATTERN, locale).parse(this.getPreviewText()).doubleValue();
                } else if (category.equals("Scientific")) {
                    num = new NumberFormatter(null, locale).parse(this.getPreviewText()).doubleValue();
                } else if (category.equals("Custom")) {
                    num = new NumberFormatter(null, locale).parse(this.getPreviewText()).doubleValue();
                }
            }
            catch (ParseException e) {
                ExceptionHandler.handle(e);
                num = 1234.56;
            }
        }
        if (category == null) {
            String fmtStr = new NumberFormatter(patternStr, locale).format(num);
            this.gPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals("Unformatted")) {
            String fmtStr = new NumberFormatter(patternStr, locale).format(num);
            this.gPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals("General Number")) {
            String fmtStr = new NumberFormatter(patternStr, locale).format(num);
            this.gPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals("Currency")) {
            String fmtStr = new NumberFormatter(patternStr, locale).format(num);
            this.cPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals("Fixed")) {
            String fmtStr = new NumberFormatter(patternStr, locale).format(num);
            this.fPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals("Percent")) {
            String fmtStr = new NumberFormatter(patternStr, locale).format(num);
            this.pPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals("Scientific")) {
            String fmtStr = new NumberFormatter(patternStr, locale).format(num);
            if (Double.isInfinite(num)) {
                BigDecimal tempDecimal = new BigDecimal(this.getPreviewText());
                fmtStr = new NumberFormatter(patternStr, locale).format(tempDecimal);
            }
            this.sPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals("Custom")) {
            String fmtStr = StringUtil.isBlank((String)this.customPreviewTextBox.getText()) || this.isValidNumber(this.customPreviewTextBox.getText()) ? new NumberFormatter(patternStr, locale).format(num) : PREVIEW_TEXT_INVALID_NUMBER_TO_PREVIEW;
            this.customPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
    }

    protected void updatePreview() {
        String category;
        this.markDirty(this.hasLoaded);
        if (this.hasLoaded) {
            this.setFmtPatternFromControls();
        }
        if ("Unformatted".equals(category = this.formatAdapter.getCategory4DisplayName(this.typeChoicer.getText()))) {
            this.setCategory("Unformatted");
            this.setPattern(null);
        } else {
            FormatNumberPattern fmtPattern = (FormatNumberPattern)this.categoryPatternMaps.get(category);
            this.setCategory(fmtPattern.getCategory());
            this.setPattern(fmtPattern.getPattern());
        }
        this.doPreview(this.getCategory(), this.getPattern(), this.locale);
    }

    protected void updateTextByLocale() {
        GridData gd;
        int index;
        this.setLocale(this.localeChoicer.getText());
        ULocale locale = this.getLocaleByDisplayName(this.locale);
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        String category = this.formatAdapter.getCategory4DisplayName(this.typeChoicer.getText());
        String priviewText = "";
        if (category.equals("Currency")) {
            priviewText = new NumberFormatter(DEFAULT_PATTERN, locale).format(1234.56);
        } else if (category.equals("Fixed")) {
            priviewText = new NumberFormatter(DEFAULT_PATTERN, locale).format(1234.56);
        } else if (category.equals("Percent")) {
            priviewText = new NumberFormatter(DEFAULT_PATTERN, locale).format(1234.56);
        } else if (category.equals("Scientific")) {
            priviewText = new NumberFormatter(null, locale).format(1234.56);
        } else if (category.equals("Custom")) {
            priviewText = new NumberFormatter(null, locale).format(1234.56);
        }
        this.setFmtPatternFromControls();
        this.setPreviewText(priviewText);
        if (this.fNegNumChoice != null && this.fNegNumChoice.getItemCount() > 0) {
            index = this.fNegNumChoice.getSelectionIndex();
            this.fNegNumChoice.removeAll();
            this.fNegNumChoice.add("-" + priviewText);
            this.fNegNumChoice.add("(" + priviewText + ")");
            if (index > -1 && index < 2) {
                this.fNegNumChoice.select(index);
            } else {
                this.fNegNumChoice.select(0);
            }
            gd = (GridData)this.fNegNumChoice.getLayoutData();
            gd.heightHint = this.fNegNumChoice.computeSize((int)-1, (int)-1).y + 2;
            this.fNegNumChoice.setLayoutData((Object)gd);
        }
        if (this.cNegNumChoice != null && this.cNegNumChoice.getItemCount() > 0) {
            index = this.cNegNumChoice.getSelectionIndex();
            this.cNegNumChoice.removeAll();
            this.cNegNumChoice.add("-" + priviewText);
            this.cNegNumChoice.add("(" + priviewText + ")");
            if (index > -1 && index < 2) {
                this.cNegNumChoice.select(index);
            } else {
                this.cNegNumChoice.select(0);
            }
            gd = (GridData)this.fNegNumChoice.getLayoutData();
            gd.heightHint = this.fNegNumChoice.computeSize((int)-1, (int)-1).y + 2;
            this.cNegNumChoice.setLayoutData((Object)gd);
        }
        if (this.pNegNumChoice != null && this.pNegNumChoice.getItemCount() > 0) {
            index = this.pNegNumChoice.getSelectionIndex();
            this.pNegNumChoice.removeAll();
            this.pNegNumChoice.add("-" + priviewText);
            this.pNegNumChoice.add("(" + priviewText + ")");
            if (index > -1 && index < 2) {
                this.pNegNumChoice.select(index);
            } else {
                this.pNegNumChoice.select(0);
            }
            gd = (GridData)this.fNegNumChoice.getLayoutData();
            gd.heightHint = this.fNegNumChoice.computeSize((int)-1, (int)-1).y + 2;
            this.pNegNumChoice.setLayoutData((Object)gd);
        }
        this.customFormatTable.getItem(0).setText(new String[]{this.formatAdapter.getDisplayName4Category("Currency"), new NumberFormatter(FormatNumberPattern.getPatternForCategory((String)"Currency", (ULocale)locale), locale).format(1234.56)});
        this.customFormatTable.getItem(1).setText(new String[]{this.formatAdapter.getDisplayName4Category("Fixed"), new NumberFormatter(FormatNumberPattern.getPatternForCategory((String)"Fixed", (ULocale)locale), locale).format(1234.56)});
        this.customFormatTable.getItem(2).setText(new String[]{this.formatAdapter.getDisplayName4Category("Percent"), new NumberFormatter(FormatNumberPattern.getPatternForCategory((String)"Percent", (ULocale)locale), locale).format(1234.56)});
        this.customFormatTable.getItem(3).setText(new String[]{this.formatAdapter.getDisplayName4Category("Scientific"), new NumberFormatter(FormatNumberPattern.getPatternForCategory((String)"Scientific", (ULocale)locale), locale).format(1234.56)});
    }

    public String getFormatString() {
        if (this.category == null && this.pattern == null) {
            return "Unformatted";
        }
        if (this.category == null) {
            this.category = "";
        }
        if (this.pattern == null) {
            this.pattern = "";
        }
        if (this.category.equals(this.pattern)) {
            return this.category;
        }
        return String.valueOf(this.category) + ":" + this.pattern;
    }

    public void setPreviewText(String text) {
        if (text == null) {
            this.customPreviewTextBox.setText(DEFAULT_PREVIEW_TEXT);
        } else {
            this.customPreviewTextBox.setText(text);
        }
    }
}

