/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.internal.ui.command.SelectionHandler;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DummyEditpart;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;

public class InsertColumnHandler
extends SelectionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        super.execute(event);
        IEvaluationContext context = (IEvaluationContext)event.getApplicationContext();
        Object position = UIUtil.getVariableFromContext(context, "InsertColumnAction.Position");
        int intPos = -1;
        if (position instanceof Integer) {
            intPos = (Integer)position;
        }
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Insert row above action >> Run ...");
        }
        if (this.getTableEditPart() != null && !this.getColumnHandles().isEmpty()) {
            this.getTableEditPart().insertColumns(intPos, this.getColumnNumbers());
        }
        return Boolean.TRUE;
    }

    protected List getColumnHandles() {
        List list = this.getSelectedObjects();
        if (list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> columnHandles = new ArrayList<Object>();
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof DummyEditpart && ((DummyEditpart)obj).getModel() instanceof ColumnHandle) {
                columnHandles.add(((DummyEditpart)obj).getModel());
            }
            ++i;
        }
        return columnHandles;
    }

    public int[] getColumnNumbers() {
        List columnHandles = this.getColumnHandles();
        if (columnHandles.isEmpty()) {
            return new int[0];
        }
        int size = columnHandles.size();
        int[] colNumbers = new int[size];
        int i = 0;
        while (i < size) {
            colNumbers[i] = this.getColumnNumber(columnHandles.get(i));
            ++i;
        }
        int[] a = colNumbers;
        Arrays.sort(a);
        return a;
    }

    public int getColumnNumber(Object columnHandle) {
        return HandleAdapterFactory.getInstance().getColumnHandleAdapter(columnHandle).getColumnNumber();
    }
}

