/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.ui.wizards;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.jdbc.CaseConversion;
import org.teiid.designer.jdbc.JdbcImportSettings;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.SourceNames;
import org.teiid.designer.jdbc.metadata.Includes;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.relational.JdbcImporter;
import org.teiid.designer.jdbc.ui.util.JdbcUiUtil;
import org.teiid.designer.jdbc.ui.wizards.JdbcImportWizard;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.dialog.FolderSelectionDialog;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.wizard.IPersistentWizardPage;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelResourceSelectionValidator;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;

public class JdbcImportOptionsPage
extends WizardPage
implements InternalUiConstants.Widgets,
IPersistentWizardPage,
UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(JdbcImportOptionsPage.class);
    private static final String TITLE = JdbcImportOptionsPage.getString("title");
    private static final String TITLE_WITH_VDB_SOURCE = String.valueOf(TITLE) + " (VDB source model)";
    private static final int COLUMN_COUNT = 3;
    private static final String INITIAL_MESSAGE_ID = "initialMessage";
    private static final String INITIAL_MESSAGE_HIDDEN_PROJECT_ID = "initialMessageHiddenProject";
    private static final String NO_NODEL_TO_UPDATE_MESSAGE_ID = "noModelToUpdateMessage";
    private static final String NAME_LABEL = JdbcImportOptionsPage.getString("nameLabel");
    private static final String FOLDER_LABEL = JdbcImportOptionsPage.getString("folderLabel");
    private static final String UPDATE_CHECKBOX = JdbcImportOptionsPage.getString("updateCheckBox");
    private static final String VIRTUAL_MODEL_CHECKBOX = JdbcImportOptionsPage.getString("makeTargetModelVirtualBox");
    private static final String MODEL_GROUP = JdbcImportOptionsPage.getString("modelGroup");
    private static final String CASE_OPTIONS_GROUP = JdbcImportOptionsPage.getString("caseOptionsGroup");
    private static final String CHANGE_CASE_GROUP = JdbcImportOptionsPage.getString("changeCaseGroup");
    private static final String FULLY_QUALIFIED_CHECKBOX = JdbcImportOptionsPage.getString("fullyQualifiedNamesCheckBox");
    private static final String FULLY_QUALIFIED_CHECKBOX_TOOLTIP = JdbcImportOptionsPage.getString("fullyQualifiedNamesCheckBox.tooltip");
    private static final String CALCULATE_COSTING_CHECKBOX = JdbcImportOptionsPage.getString("calculateCostingCheckBox");
    private static final String CALCULATE_COSTING_CHECKBOX_TOOLTIP = JdbcImportOptionsPage.getString("calculateCostingCheckBox.tooltip");
    private static final String INCLUDE_CATALOG_CHECKBOX = JdbcImportOptionsPage.getString("includeCatalogCheckBox");
    private static final String INCLUDE_CATALOG_CHECKBOX_TOOLTIP = JdbcImportOptionsPage.getString("includeCatalogCheckBox.tooltip");
    private static final String MODEL_OBJECT_NAMES_GROUP = JdbcImportOptionsPage.getString("modelObjectNamesGroup");
    private static final String SOURCE_OBJECT_NAMES_GROUP = JdbcImportOptionsPage.getString("sourceObjectNamesGroup");
    private static final String MODIFY_CASE_CHECKBOX = JdbcImportOptionsPage.getString("modifyCaseCheckBox");
    private static final String MAKE_ALL_UPPER_RADIO = JdbcImportOptionsPage.getString("makeAllUpperRadioButton");
    private static final String MAKE_ALL_LOWER_RADIO = JdbcImportOptionsPage.getString("makeAllLowerRadioButton");
    private static final String FILE_EXISTS_MESSAGE = JdbcImportOptionsPage.getString("fileExistsMessage", UPDATE_CHECKBOX);
    private static final String NOT_MODEL_PROJECT_MESSAGE = JdbcImportOptionsPage.getString("notModelProjectMessage");
    private static final String NOT_RELATIONAL_MODEL_MESSAGE = JdbcImportOptionsPage.getString("notRelationalModelMessage");
    private static final String READ_ONLY_MODEL_MESSAGE = JdbcImportOptionsPage.getString("readOnlyModelMessage");
    private static final String VIRTUAL_MODEL_MESSAGE = JdbcImportOptionsPage.getString("virtualModelMessage");
    private static final String PHYSICAL_MODEL_MESSAGE = "The model to update is not a virtual model.";
    private JdbcDatabase db;
    private JdbcImportSettings importSettings;
    private Group changeCaseGroup;
    private Text nameText;
    private Text folderText;
    private Button updateCheckBox;
    private Button fullyQualifiedNamesCheckBox;
    private Button includeCatalogCheckBox;
    private Button modifyCaseCheckBox;
    private Button uppercaseButton;
    private Button lowercaseButton;
    private Button virtualModelBox;
    private Button calculateCostingCheckBox;
    private Button browseSelectedModelBtn;
    private boolean initd;
    private IContainer folder;
    private boolean usesHiddenProject = false;
    private IFile selectedModel;
    private boolean isVirtual = false;
    private JdbcImporter importer;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object parameter) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, parameter);
    }

    protected JdbcImportOptionsPage() {
        super(JdbcImportOptionsPage.class.getSimpleName(), TITLE, null);
    }

    public void createControl(Composite parent) {
        this.usesHiddenProject = ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric();
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)mainPanel);
        Group modelGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)MODEL_GROUP, (int)256, (int)1, (int)3);
        WidgetFactory.createLabel((Composite)modelGroup, (String)NAME_LABEL);
        this.nameText = WidgetFactory.createTextField((Composite)modelGroup, (int)768);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                JdbcImportOptionsPage.this.nameModified();
            }
        });
        this.browseSelectedModelBtn = WidgetFactory.createButton((Composite)modelGroup, (String)BROWSE_BUTTON);
        this.browseSelectedModelBtn.setToolTipText(JdbcImportOptionsPage.getString("browseModelButton.tip"));
        this.browseSelectedModelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.browseModelSelected();
            }
        });
        org.teiid.designer.ui.common.widget.Label folderLabel = WidgetFactory.createLabel((Composite)modelGroup, (String)FOLDER_LABEL);
        IContainer folder = ((JdbcImportWizard)this.getWizard()).getFolder();
        String name = folder == null ? null : folder.getFullPath().makeRelative().toString();
        this.folderText = WidgetFactory.createTextField((Composite)modelGroup, (int)768, (String)name);
        if (this.usesHiddenProject) {
            this.folderText.setEditable(false);
            this.folderText.setVisible(false);
            folderLabel.setVisible(false);
        }
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                JdbcImportOptionsPage.this.folderModified();
            }
        });
        if (!this.usesHiddenProject) {
            WidgetFactory.createButton((Composite)modelGroup, (String)BROWSE_BUTTON).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    JdbcImportOptionsPage.this.browseButtonSelected();
                }
            });
        }
        this.virtualModelBox = WidgetFactory.createCheckBox((Composite)modelGroup, (String)VIRTUAL_MODEL_CHECKBOX, (int)0, (int)3);
        this.virtualModelBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.virtualModelBoxSelected();
            }
        });
        this.virtualModelBox.setSelection(this.isVirtual);
        this.updateCheckBox = WidgetFactory.createCheckBox((Composite)modelGroup, (String)UPDATE_CHECKBOX, (int)0, (int)3);
        this.updateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.updateCheckBoxSelected();
            }
        });
        WidgetFactory.createLabel((Composite)mainPanel, (String)"  ");
        this.calculateCostingCheckBox = WidgetFactory.createCheckBox((Composite)mainPanel, (String)CALCULATE_COSTING_CHECKBOX, (int)0, (int)1);
        this.calculateCostingCheckBox.setToolTipText(CALCULATE_COSTING_CHECKBOX_TOOLTIP);
        this.calculateCostingCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.calculateCostingCheckBox();
            }
        });
        this.calculateCostingCheckBox.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.includeCatalogCheckBox = WidgetFactory.createCheckBox((Composite)mainPanel, (String)INCLUDE_CATALOG_CHECKBOX, (int)0, (int)1);
        this.includeCatalogCheckBox.setToolTipText(INCLUDE_CATALOG_CHECKBOX_TOOLTIP);
        this.includeCatalogCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.includeCatalogCheckBox();
            }
        });
        this.includeCatalogCheckBox.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        WidgetFactory.createLabel((Composite)mainPanel, (String)"  ");
        Group caseOptionsGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)CASE_OPTIONS_GROUP, (int)256, (int)1, (int)2);
        this.fullyQualifiedNamesCheckBox = WidgetFactory.createCheckBox((Composite)caseOptionsGroup, (String)FULLY_QUALIFIED_CHECKBOX, (int)0, (int)2);
        this.fullyQualifiedNamesCheckBox.setToolTipText(FULLY_QUALIFIED_CHECKBOX_TOOLTIP);
        this.fullyQualifiedNamesCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.fullyQualifiedNamesCheckBoxSelected();
            }
        });
        this.fullyQualifiedNamesCheckBox.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        ((GridData)this.fullyQualifiedNamesCheckBox.getLayoutData()).horizontalSpan = 2;
        this.modifyCaseCheckBox = WidgetFactory.createCheckBox((Composite)caseOptionsGroup, (String)MODIFY_CASE_CHECKBOX, (int)0, (int)2);
        this.modifyCaseCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.modifyCaseSelected();
            }
        });
        this.modifyCaseCheckBox.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        ((GridData)this.modifyCaseCheckBox.getLayoutData()).horizontalSpan = 2;
        Label spacer = new Label((Composite)caseOptionsGroup, 0);
        spacer.setText("      ");
        this.changeCaseGroup = WidgetFactory.createGroup((Composite)caseOptionsGroup, (String)CHANGE_CASE_GROUP, (int)256, (int)1, (int)1);
        this.uppercaseButton = WidgetFactory.createRadioButton((Composite)this.changeCaseGroup, (String)MAKE_ALL_UPPER_RADIO);
        this.uppercaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.uppercaseButtonSelected();
            }
        });
        this.lowercaseButton = WidgetFactory.createRadioButton((Composite)this.changeCaseGroup, (String)MAKE_ALL_LOWER_RADIO);
        this.lowercaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.lowercaseButtonSelected();
            }
        });
    }

    public void saveSettings() {
        IDialogSettings dlgSettings = this.getDialogSettings();
        JdbcImportWizard wizard = (JdbcImportWizard)this.getWizard();
        JdbcImportSettings importSettings = wizard.getSource().getImportSettings();
        try {
            Includes incls = ((JdbcImportWizard)this.getWizard()).getDatabase().getIncludes();
            dlgSettings.put(CALCULATE_COSTING_CHECKBOX, incls.isCalculateCosting());
            DatabaseMetaData metadata = wizard.getDatabase().getDatabaseMetaData();
            dlgSettings.put(metadata.getCatalogTerm(), importSettings.isCreateCatalogsInModel());
            dlgSettings.put(metadata.getSchemaTerm(), importSettings.isCreateSchemasInModel());
        }
        catch (Exception err) {
            Util.log((Throwable)err);
            WidgetUtil.showError((Throwable)err);
        }
        dlgSettings.put(MODEL_OBJECT_NAMES_GROUP, importSettings.getConvertCaseInModel().getName());
        dlgSettings.put(SOURCE_OBJECT_NAMES_GROUP, importSettings.getGenerateSourceNamesInModel().getName());
    }

    public boolean updateSelected() {
        if (this.updateCheckBox != null) {
            return this.updateCheckBox.getSelection();
        }
        return false;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Initializing Option Settings", (Object)((Object)this));
            boolean succeeded = false;
            try {
                this.initializeInTransaction();
                succeeded = true;
            }
            finally {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        super.setVisible(visible);
        if (this.importer.isVdbSourceModel()) {
            this.nameText.setEditable(false);
            this.nameText.setBackground(this.nameText.getParent().getBackground());
            if (this.importer.getVdbSourceModelName() != null) {
                this.nameText.setText(this.importer.getVdbSourceModelName());
            }
            this.virtualModelBox.setSelection(false);
            this.virtualModelBox.setEnabled(false);
            this.browseSelectedModelBtn.setEnabled(false);
            this.updateCheckBox.setSelection(false);
            this.updateCheckBox.setEnabled(false);
            this.fullyQualifiedNamesCheckBox.setSelection(false);
            this.fullyQualifiedNamesCheckBox.setEnabled(false);
            this.includeCatalogCheckBox.setSelection(false);
            this.includeCatalogCheckBox.setEnabled(false);
            this.modifyCaseCheckBox.setSelection(false);
            this.modifyCaseCheckBox.setEnabled(false);
        } else {
            this.nameText.setEditable(true);
            this.virtualModelBox.setEnabled(true);
            this.browseSelectedModelBtn.setEnabled(true);
            this.updateCheckBox.setEnabled(true);
            this.fullyQualifiedNamesCheckBox.setEnabled(true);
            this.includeCatalogCheckBox.setEnabled(true);
            this.modifyCaseCheckBox.setEnabled(true);
        }
        this.fullyQualifiedNamesCheckBoxSelected();
        this.includeCatalogCheckBox();
        this.modifyCaseSelected();
        if (this.importer.isVdbSourceModel()) {
            this.setTitle(TITLE_WITH_VDB_SOURCE);
        } else {
            this.setTitle(TITLE);
        }
        this.validatePage(false);
    }

    void initializeInTransaction() {
        String name;
        block19: {
            JdbcImportWizard wizard = (JdbcImportWizard)this.getWizard();
            this.db = wizard.getDatabase();
            name = wizard.getModelName();
            if (this.importer.isVdbSourceModel()) {
                name = this.importer.getVdbSourceModelName();
                if (name == null) {
                    name = wizard.getModelName();
                }
                this.nameText.setText(name);
            } else {
                name = wizard.getModelName();
            }
            this.nameText.setText(name);
            try {
                JdbcSource src = wizard.getSource();
                JdbcPlugin.recordJdbcDatabaseSelections((JdbcSource)src, (JdbcDatabase)this.db);
                this.importSettings = src.getImportSettings();
                this.importSettings.setCreateCatalogsInModel(false);
                this.importSettings.setCreateSchemasInModel(false);
                if (this.initd) break block19;
                this.setInitd(true);
                DatabaseMetaData metadata = this.db.getDatabaseMetaData();
                boolean supportsCatalogs = false;
                ResultSet resultSet = metadata.getCatalogs();
                while (resultSet.next()) {
                    String catalogName = resultSet.getString(1);
                    if (catalogName == null || catalogName.length() <= 0) continue;
                    supportsCatalogs = true;
                }
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    JdbcPlugin.Util.log((Throwable)e);
                }
                IDialogSettings dlgSettings = this.getDialogSettings();
                boolean calcCosting = true;
                if (dlgSettings != null) {
                    calcCosting = dlgSettings.getBoolean(CALCULATE_COSTING_CHECKBOX);
                }
                this.calculateCostingCheckBox.setSelection(calcCosting);
                ((JdbcImportWizard)this.getWizard()).getDatabase().getIncludes().setCalculateCosting(calcCosting);
                if (supportsCatalogs) {
                    this.includeCatalogCheckBox.setSelection(supportsCatalogs);
                    this.includeCatalogCheckBox.setEnabled(true);
                    this.importSettings.setCreateCatalogsInModel(true);
                } else {
                    this.includeCatalogCheckBox.setSelection(false);
                    this.includeCatalogCheckBox.setEnabled(false);
                    this.importSettings.setCreateCatalogsInModel(false);
                }
                this.fullyQualifiedNamesCheckBox.setSelection(false);
                this.importSettings.setGenerateSourceNamesInModel(SourceNames.FULLY_QUALIFIED_LITERAL);
                switch (this.importSettings.getConvertCaseInModel().getValue()) {
                    case 0: {
                        this.modifyCaseCheckBox.setSelection(false);
                        this.uppercaseButton.setSelection(true);
                        this.changeCaseGroup.setEnabled(false);
                        this.uppercaseButton.setEnabled(false);
                        this.lowercaseButton.setEnabled(false);
                        break;
                    }
                    case 1: {
                        this.uppercaseButton.setEnabled(true);
                        this.lowercaseButton.setEnabled(true);
                        this.uppercaseButton.setSelection(true);
                        this.modifyCaseCheckBox.setSelection(true);
                        this.changeCaseGroup.setEnabled(true);
                        break;
                    }
                    case 2: {
                        this.uppercaseButton.setEnabled(true);
                        this.lowercaseButton.setEnabled(true);
                        this.lowercaseButton.setSelection(true);
                        this.modifyCaseCheckBox.setSelection(true);
                        this.changeCaseGroup.setEnabled(true);
                    }
                }
            }
            catch (Exception err) {
                JdbcUiUtil.showAccessError(err);
            }
        }
        this.validatePage(true);
        if (this.isPageComplete()) {
            if (this.usesHiddenProject) {
                this.setMessage(JdbcImportOptionsPage.getString(INITIAL_MESSAGE_HIDDEN_PROJECT_ID, name));
            } else {
                this.setMessage(JdbcImportOptionsPage.getString(INITIAL_MESSAGE_ID, name));
            }
        }
    }

    protected JdbcImportSettings getImportSettings() {
        return this.importSettings;
    }

    void browseModelSelected() {
        MetamodelDescriptor descriptor = ModelerCore.getMetamodelRegistry().getMetamodelDescriptor("http://www.metamatrix.com/metamodels/Relational");
        Object[] resources = WidgetUtil.showWorkspaceObjectSelectionDialog((String)JdbcImportOptionsPage.getString("dialog.modelChooser.title"), (String)JdbcImportOptionsPage.getString("dialog.modelChooser.msg"), (boolean)false, (Object)((JdbcImportWizard)this.getWizard()).getFolder(), (ViewerFilter)new ModelWorkspaceViewerFilter(true), (ISelectionStatusValidator)new ModelResourceSelectionValidator(descriptor, false), (ILabelProvider)new ModelExplorerLabelProvider());
        if (resources != null && resources.length > 0) {
            IFile model = (IFile)resources[0];
            try {
                ModelResource mr = ModelUtil.getModelResource((IFile)model, (boolean)true);
                this.isVirtual = mr.getModelAnnotation().getModelType().equals(ModelType.VIRTUAL_LITERAL);
                this.virtualModelBox.setSelection(this.isVirtual);
            }
            catch (ModelWorkspaceException theException) {
                Util.log((Throwable)theException);
            }
            this.selectedModel = model;
            IContainer folder = model.getParent();
            this.nameText.setText(model.getName());
            this.folderText.setText(folder == null ? "" : folder.getFullPath().makeRelative().toString());
            this.updateCheckBox.setSelection(true);
            this.updateCheckBoxSelected();
        } else {
            this.selectedModel = null;
        }
    }

    void virtualModelBoxSelected() {
        this.isVirtual = this.virtualModelBox.getSelection();
        this.validatePage(false);
    }

    void browseButtonSelectedOLD() {
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                try {
                    return ((IContainer)element).getProject().getNature("org.teiid.designer.core.modelNature") != null;
                }
                catch (CoreException err) {
                    Util.log((Throwable)err);
                    return false;
                }
            }
        };
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)((JdbcImportWizard)this.getWizard()).getFolder(), (ViewerFilter)new ModelingResourceFilter(filter), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null) {
            this.folderText.setText(folder.getFullPath().makeRelative().toString());
            this.validatePage(false);
        }
    }

    void browseButtonSelected() {
        this.folder = this.getFolder();
        if (this.folder != null) {
            this.folderText.setText(this.folder.getFullPath().makeRelative().toString());
            this.validatePage(false);
        }
    }

    private IContainer getFolder() {
        ViewerFilter filter = this.getFilter();
        FolderSelectionDialog dlg = new FolderSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dlg.setInitialSelection((Object)((JdbcImportWizard)this.getWizard()).getFolder());
        dlg.addFilter((ViewerFilter)new ModelingResourceFilter(filter));
        dlg.setValidator((ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        dlg.setAllowMultiple(false);
        dlg.setInput((Object)ModelerCore.getWorkspace().getRoot());
        Object[] objs = new Object[1];
        if (dlg.open() == 0) {
            objs = dlg.getResult();
        }
        return objs.length == 0 ? null : (IContainer)objs[0];
    }

    private ViewerFilter getFilter() {
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                boolean projectOpen;
                boolean result = false;
                if (element instanceof IResource && (projectOpen = ((IResource)element).getProject().isOpen())) {
                    if (element instanceof IProject) {
                        result = true;
                    } else if (element instanceof IFolder) {
                        result = true;
                    }
                }
                return result;
            }
        };
        return filter;
    }

    void folderModified() {
        this.validatePage(false);
    }

    void lowercaseButtonSelected() {
        if (this.lowercaseButton.getSelection()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Lower Case Option", (Object)((Object)this));
            boolean succeeded = false;
            try {
                this.importSettings.setConvertCaseInModel(CaseConversion.TO_LOWERCASE_LITERAL);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    void nameModified() {
        this.validatePage(false);
    }

    protected void newFolderButtonSelected(TreeViewer viewer, IContainer folder) {
        NewFolderDialog dlg = new NewFolderDialog(this.getShell(), folder);
        if (dlg.open() == 0) {
            viewer.refresh((Object)folder);
            Object newFolder = dlg.getResult()[0];
            viewer.setSelection((ISelection)new StructuredSelection(newFolder), true);
        }
    }

    void modifyCaseSelected() {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set None Option", (Object)((Object)this));
        boolean succeeded = false;
        try {
            if (!this.modifyCaseCheckBox.getSelection()) {
                this.importSettings.setConvertCaseInModel(CaseConversion.NONE_LITERAL);
                this.changeCaseGroup.setEnabled(false);
                this.uppercaseButton.setEnabled(false);
                this.lowercaseButton.setEnabled(false);
            } else {
                this.changeCaseGroup.setEnabled(true);
                this.uppercaseButton.setEnabled(true);
                this.lowercaseButton.setEnabled(true);
                if (this.uppercaseButton.getSelection()) {
                    this.importSettings.setConvertCaseInModel(CaseConversion.TO_UPPERCASE_LITERAL);
                } else {
                    this.importSettings.setConvertCaseInModel(CaseConversion.TO_LOWERCASE_LITERAL);
                }
            }
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    void fullyQualifiedNamesCheckBoxSelected() {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Fully Qualified Names Selected", (Object)((Object)this));
        boolean succeeded = false;
        try {
            SourceNames value = SourceNames.UNQUALIFIED_LITERAL;
            if (this.fullyQualifiedNamesCheckBox.getSelection()) {
                value = SourceNames.FULLY_QUALIFIED_LITERAL;
            }
            this.importSettings.setGenerateSourceNamesInModel(value);
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    void calculateCostingCheckBox() {
        boolean isChecked = this.calculateCostingCheckBox.getSelection();
        ((JdbcImportWizard)this.getWizard()).getDatabase().getIncludes().setCalculateCosting(isChecked);
        IDialogSettings dlgSettings = this.getDialogSettings();
        if (dlgSettings != null) {
            dlgSettings.put(CALCULATE_COSTING_CHECKBOX, isChecked);
        }
    }

    void includeCatalogCheckBox() {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Include Catalogs Selected", (Object)((Object)this));
        boolean succeeded = false;
        try {
            this.importSettings.setCreateCatalogsInModel(this.includeCatalogCheckBox.getSelection());
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    void updateCheckBoxSelected() {
        if (this.updateCheckBox.getSelection()) {
            try {
                ModelResource model = this.getSelectedModelResource();
                if (model != null && !model.isReadOnly() && model.getModelType().getValue() != ModelType.VIRTUAL) {
                    this.nameText.setText(model.getItemName());
                    return;
                }
            }
            catch (ModelWorkspaceException err) {
                Util.log((Throwable)err);
                WidgetUtil.showError((String)err.getLocalizedMessage());
            }
        }
        this.validatePage(false);
    }

    private ModelResource getSelectedModelResource() throws ModelWorkspaceException {
        ModelResource model = null;
        if (this.selectedModel != null) {
            model = ModelUtil.getModel((Object)this.selectedModel);
        } else {
            IStructuredSelection selection = UiUtil.getStructuredSelection();
            if (selection.size() == 1) {
                model = ModelUtil.getModel((Object)selection.getFirstElement());
            }
        }
        return model;
    }

    void uppercaseButtonSelected() {
        if (this.uppercaseButton.getSelection()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Uppercase Option", (Object)((Object)this));
            boolean succeeded = false;
            try {
                this.importSettings.setConvertCaseInModel(CaseConversion.TO_UPPERCASE_LITERAL);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    private void validatePage(boolean firstTime) {
        block19: {
            boolean updating = this.updateCheckBox.getSelection();
            try {
                this.folder = WizardUtil.validateFileAndFolder((Text)this.nameText, (Text)this.folderText, (WizardPage)this, (String)".xmi", (int)(updating ? 0 : 3));
                if (this.folder != null && this.folder.getProject().getNature("org.teiid.designer.core.modelNature") == null) {
                    WizardUtil.setPageComplete((WizardPage)this, (String)NOT_MODEL_PROJECT_MESSAGE, (int)3);
                    this.folder = null;
                }
                String name = this.nameText.getText();
                IStatus status = ModelNameUtil.validate((String)name, (String)".xmi", (IContainer)this.folder, (int)5);
                if (!updating && status.getSeverity() == 4) {
                    WizardUtil.setPageComplete((WizardPage)this, (String)(String.valueOf(ModelNameUtil.MESSAGES.INVALID_MODEL_NAME) + status.getMessage()), (int)3);
                    this.folder = null;
                }
                if (this.isPageComplete()) {
                    name = FileUtils.toFileNameWithExtension((String)name, (String)".xmi");
                    IFile file = this.folder.getFile((IPath)new Path(name));
                    ModelResource model = null;
                    if (file.exists()) {
                        try {
                            model = ModelerCore.getModelEditor().findModelResource((IResource)file);
                            if (model.isReadOnly()) {
                                WizardUtil.setPageComplete((WizardPage)this, (String)READ_ONLY_MODEL_MESSAGE, (int)3);
                                return;
                            }
                            if (!"http://www.metamatrix.com/metamodels/Relational".equals(model.getPrimaryMetamodelDescriptor().getNamespaceURI())) {
                                WizardUtil.setPageComplete((WizardPage)this, (String)NOT_RELATIONAL_MODEL_MESSAGE, (int)3);
                                return;
                            }
                            if (!this.isVirtual() && model.getModelType().getValue() == ModelType.VIRTUAL) {
                                WizardUtil.setPageComplete((WizardPage)this, (String)VIRTUAL_MODEL_MESSAGE, (int)3);
                                return;
                            }
                            if (this.isVirtual() && model.getModelType().getValue() == ModelType.PHYSICAL) {
                                WizardUtil.setPageComplete((WizardPage)this, (String)PHYSICAL_MODEL_MESSAGE, (int)3);
                                return;
                            }
                        }
                        catch (ModelWorkspaceException err) {
                            Util.log((Throwable)err);
                            WidgetUtil.showError((String)err.getLocalizedMessage());
                        }
                    } else if (updating) {
                        WizardUtil.setPageComplete((WizardPage)this, (String)JdbcImportOptionsPage.getString(NO_NODEL_TO_UPDATE_MESSAGE_ID, file.getFullPath().makeRelative()), (int)3);
                        return;
                    }
                    JdbcImportWizard wizard = (JdbcImportWizard)this.getWizard();
                    wizard.setModelName(name);
                    wizard.setFolder(this.folder);
                    if (model != wizard.getUpdatedModel()) {
                        ArrayList newlySelectedNodes = new ArrayList();
                        this.collectNewlySelectedNodes(this.db.getChildren(), newlySelectedNodes, this.getOriginalImportSettings(model));
                        wizard.setUpdatedModel(model);
                        this.removeExcludedNodes(newlySelectedNodes);
                    }
                    this.getContainer().updateButtons();
                    break block19;
                }
                if (this.folder != null) {
                    if (firstTime) {
                        this.updateCheckBox.setSelection(true);
                        this.updateCheckBoxSelected();
                    } else {
                        WizardUtil.setPageComplete((WizardPage)this, (String)(String.valueOf(this.getMessage()) + '\n' + FILE_EXISTS_MESSAGE), (int)this.getMessageType());
                    }
                }
            }
            catch (CoreException err) {
                Util.log((Throwable)err);
                WizardUtil.setPageComplete((WizardPage)this, (String)err.getLocalizedMessage(), (int)3);
            }
        }
    }

    private void collectNewlySelectedNodes(JdbcNode[] children, List newlySelectedNodes, JdbcImportSettings settings) throws CoreException {
        if (children == null) {
            return;
        }
        if (settings != null) {
            int ndx = children.length;
            while (--ndx >= 0) {
                JdbcNode child = children[ndx];
                if (child.getSelectionMode() == 1) {
                    Iterator objIter = settings.getExcludedObjectPaths().iterator();
                    while (objIter.hasNext()) {
                        Path path = new Path((String)objIter.next());
                        if (!child.equals(((JdbcImportWizard)this.getWizard()).findNode((IPath)path, (JdbcNode)this.db))) continue;
                        newlySelectedNodes.add(child);
                        break;
                    }
                }
                if (child.getSelectionMode() != 1 && child.getSelectionMode() != 2) continue;
                this.collectNewlySelectedNodes(child.getChildren(), newlySelectedNodes, settings);
            }
        }
    }

    private JdbcImportSettings getOriginalImportSettings(ModelResource model) throws CoreException {
        if (model != null) {
            for (Object obj : model.getAllRootEObjects()) {
                if (!(obj instanceof JdbcSource)) continue;
                return ((JdbcSource)obj).getImportSettings();
            }
        }
        return ((JdbcImportWizard)this.getWizard()).getSource().getImportSettings();
    }

    private void removeExcludedNodes(List nodes) throws CoreException {
        if (nodes.isEmpty()) {
            return;
        }
        JdbcImportSettings settings = ((JdbcImportWizard)this.getWizard()).getSource().getImportSettings();
        if (settings != null) {
            block0: for (JdbcNode node : nodes) {
                node.setSelected(true);
                Iterator objIter = settings.getExcludedObjectPaths().iterator();
                while (objIter.hasNext()) {
                    Path path = new Path((String)objIter.next());
                    if (!node.equals(((JdbcImportWizard)this.getWizard()).findNode((IPath)path, (JdbcNode)this.db))) continue;
                    objIter.remove();
                    continue block0;
                }
            }
        }
    }

    public boolean canFlipToNextPage() {
        boolean updating = this.updateCheckBox.getSelection();
        IFile file = null;
        if (this.folder != null) {
            String name = this.nameText.getText();
            name = FileUtils.toFileNameWithExtension((String)name, (String)".xmi");
            file = this.folder.getFile((IPath)new Path(name));
        }
        return this.folder != null && file != null && updating && this.isPageComplete() && file.exists();
    }

    public void setInitd(boolean initd) {
        this.initd = initd;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public void setImporter(JdbcImporter importer) {
        this.importer = importer;
    }
}

