/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.ui.wizards;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.jdbc.JdbcImportSettings;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.metadata.Includes;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.relational.JdbcImporter;
import org.teiid.designer.jdbc.ui.util.JdbcUiUtil;
import org.teiid.designer.jdbc.ui.wizards.JdbcImportWizard;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.widget.IListPanelController;
import org.teiid.designer.ui.common.widget.ListPanel;
import org.teiid.designer.ui.common.widget.ListPanelAdapter;
import org.teiid.designer.ui.common.wizard.IPersistentWizardPage;

final class JdbcImportMetadataPage
extends WizardPage
implements InternalUiConstants.Widgets,
IPersistentWizardPage,
ListPanel.Constants,
UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(JdbcImportMetadataPage.class);
    private static final String TITLE = JdbcImportMetadataPage.getString("title");
    private static final String TITLE_WITH_VDB_SOURCE = String.valueOf(TITLE) + " (VDB source model)";
    private static final String APPROXIMATIONS_BUTTON = JdbcImportMetadataPage.getString("approximationsButton");
    private static final String FOREIGN_KEYS_BUTTON = JdbcImportMetadataPage.getString("foreignKeysButton");
    private static final String INCOMPLETE_FK_BUTTON = JdbcImportMetadataPage.getString("incompleteFKButton");
    private static final String INDEXES_BUTTON = JdbcImportMetadataPage.getString("indexesButton");
    private static final String PROCEDURES_BUTTON = JdbcImportMetadataPage.getString("proceduresButton");
    private static final String UNIQUE_BUTTON = JdbcImportMetadataPage.getString("uniqueButton");
    private static final String TABLE_TYPES_GROUP = JdbcImportMetadataPage.getString("tableTypesGroup");
    private static final String INITIAL_MESSAGE = JdbcImportMetadataPage.getString("initialMessage");
    private static final String INVALID_PAGE_MESSAGE = JdbcImportMetadataPage.getString("invalidPageMessage", PROCEDURES_BUTTON, TABLE_TYPES_GROUP);
    private static final int COLUMN_COUNT = 2;
    private static final int CHECKBOX_TEXT_GAP = 5;
    private Includes incls;
    private JdbcImportSettings importSettings;
    private Button foreignKeysCheckBox;
    private Button incompleteFKCheckBox;
    private Button indexesCheckBox;
    private Button uniqueCheckBox;
    private Button approximationsCheckBox;
    private Button proceduresCheckBox;
    private ListPanel listPanel;
    private Map enableMap;
    private boolean initd;
    private JdbcImporter importer;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, String parameter1, String parameter2) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[]{parameter1, parameter2});
    }

    JdbcImportMetadataPage() {
        super(JdbcImportMetadataPage.class.getSimpleName(), TITLE, null);
    }

    public void createControl(Composite parent) {
        Composite pg = new Composite(parent, 0);
        pg.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)pg);
        Composite checkBoxPanel = WidgetFactory.createPanel((Composite)pg, (int)8, (int)2);
        this.foreignKeysCheckBox = WidgetFactory.createCheckBox((Composite)checkBoxPanel);
        this.foreignKeysCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportMetadataPage.this.foreignKeysCheckBoxSelected();
            }
        });
        int fkIndent = this.foreignKeysCheckBox.computeSize((int)-1, (int)-1, (boolean)true).x + 5;
        this.foreignKeysCheckBox.setText(FOREIGN_KEYS_BUTTON);
        this.incompleteFKCheckBox = this.createNestedCheckbox(checkBoxPanel, INCOMPLETE_FK_BUTTON, fkIndent);
        this.incompleteFKCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportMetadataPage.this.incompleteFKsCheckBoxSelected();
            }
        });
        this.indexesCheckBox = WidgetFactory.createCheckBox((Composite)checkBoxPanel);
        this.indexesCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportMetadataPage.this.indexesCheckBoxSelected();
            }
        });
        int indent = this.indexesCheckBox.computeSize((int)-1, (int)-1, (boolean)true).x + 5;
        this.indexesCheckBox.setText(INDEXES_BUTTON);
        this.uniqueCheckBox = this.createNestedCheckbox(checkBoxPanel, UNIQUE_BUTTON, indent);
        this.uniqueCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportMetadataPage.this.uniqueCheckBoxSelected();
            }
        });
        this.approximationsCheckBox = this.createNestedCheckbox(checkBoxPanel, APPROXIMATIONS_BUTTON, indent);
        this.approximationsCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportMetadataPage.this.approximationsCheckBoxSelected();
            }
        });
        this.proceduresCheckBox = WidgetFactory.createCheckBox((Composite)checkBoxPanel, (String)PROCEDURES_BUTTON);
        this.proceduresCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportMetadataPage.this.procuduresButtonSelected();
            }
        });
        ListPanelAdapter ctrlr = new ListPanelAdapter(){

            public Object[] addButtonSelected() {
                return null;
            }
        };
        this.listPanel = new ListPanel(pg, TABLE_TYPES_GROUP, (IListPanelController)ctrlr, 10, 4);
        this.listPanel.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JdbcImportMetadataPage.this.tableTypesSelected(event);
            }
        });
    }

    public void saveSettings() {
        IDialogSettings dlgSettings = this.getDialogSettings();
        Includes incls = ((JdbcImportWizard)this.getWizard()).getDatabase().getIncludes();
        dlgSettings.put(APPROXIMATIONS_BUTTON, incls.getApproximateIndexes());
        dlgSettings.put(FOREIGN_KEYS_BUTTON, incls.includeForeignKeys());
        dlgSettings.put(INCOMPLETE_FK_BUTTON, incls.includeIncompleteFKs());
        dlgSettings.put(INDEXES_BUTTON, incls.includeIndexes());
        dlgSettings.put(PROCEDURES_BUTTON, incls.includeProcedures());
        dlgSettings.put(UNIQUE_BUTTON, incls.getUniqueIndexesOnly());
        String[] tableTypes = incls.getIncludedTableTypes();
        if (tableTypes != null) {
            dlgSettings.put(TABLE_TYPES_GROUP, tableTypes);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Initializing Import Settings", (Object)((Object)this));
            boolean succeeded = false;
            try {
                this.initializeInTransaction();
                succeeded = true;
            }
            finally {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        this.setMessage(INITIAL_MESSAGE);
        if (this.importer.isVdbSourceModel()) {
            this.setTitle(TITLE_WITH_VDB_SOURCE);
        } else {
            this.setTitle(TITLE);
        }
        super.setVisible(visible);
    }

    void initializeInTransaction() {
        block21: {
            if (this.importer.isReachedObjectsPage()) {
                EList lastTypes = this.importSettings.getIncludedTableTypes();
                if (lastTypes != null && !lastTypes.isEmpty()) {
                    this.listPanel.getTableViewer().setSelection((ISelection)new StructuredSelection((List)lastTypes));
                }
                return;
            }
            JdbcDatabase db = ((JdbcImportWizard)this.getWizard()).getDatabase();
            if (db == null) {
                return;
            }
            this.incls = db.getIncludes();
            JdbcSource src = ((JdbcImportWizard)this.getWizard()).getSource();
            this.importSettings = src.getImportSettings();
            IDialogSettings dlgSettings = this.getDialogSettings();
            boolean updating = ((JdbcImportWizard)this.getWizard()).isUpdatedModel();
            if (!updating && dlgSettings.get(PROCEDURES_BUTTON) != null && !this.initd) {
                this.initd = true;
                this.incls.setApproximateIndexes(dlgSettings.getBoolean(APPROXIMATIONS_BUTTON));
                this.incls.setIncludeForeignKeys(dlgSettings.getBoolean(FOREIGN_KEYS_BUTTON));
                this.incls.setIncludeIncompleteFKs(dlgSettings.getBoolean(INCOMPLETE_FK_BUTTON));
                this.incls.setIncludeIndexes(dlgSettings.getBoolean(INDEXES_BUTTON));
                this.incls.setIncludeProcedures(dlgSettings.getBoolean(PROCEDURES_BUTTON));
                this.incls.setUniqueIndexesOnly(dlgSettings.getBoolean(UNIQUE_BUTTON));
                this.incls.setIncludedTableTypes(dlgSettings.getArray(TABLE_TYPES_GROUP));
                this.importSettings.setIncludeApproximateIndexes(dlgSettings.getBoolean(APPROXIMATIONS_BUTTON));
                this.importSettings.setIncludeForeignKeys(dlgSettings.getBoolean(FOREIGN_KEYS_BUTTON));
                this.importSettings.setIncludeIndexes(dlgSettings.getBoolean(INDEXES_BUTTON));
                this.importSettings.setIncludeProcedures(dlgSettings.getBoolean(PROCEDURES_BUTTON));
                this.importSettings.setIncludeUniqueIndexes(dlgSettings.getBoolean(UNIQUE_BUTTON));
                EList tableTypes = this.importSettings.getIncludedTableTypes();
                String[] ttypes = this.incls.getIncludedTableTypes();
                int i = 0;
                while (i < ttypes.length) {
                    String tableType = ttypes[i];
                    tableTypes.add(tableType);
                    ++i;
                }
            } else {
                this.incls.setApproximateIndexes(false);
                this.incls.setIncludeForeignKeys(true);
                this.incls.setIncludeIncompleteFKs(true);
                this.incls.setIncludeIndexes(false);
                this.incls.setIncludeProcedures(false);
                this.incls.setUniqueIndexesOnly(false);
                this.importSettings.setIncludeApproximateIndexes(true);
                this.importSettings.setIncludeForeignKeys(true);
                this.importSettings.setIncludeIndexes(false);
                this.importSettings.setIncludeProcedures(false);
                this.importSettings.setIncludeUniqueIndexes(false);
            }
            this.setSelected(this.approximationsCheckBox, this.incls.getApproximateIndexes());
            this.setSelected(this.foreignKeysCheckBox, this.incls.includeForeignKeys());
            this.setSelected(this.indexesCheckBox, this.incls.includeIndexes());
            this.setSelected(this.proceduresCheckBox, this.incls.includeProcedures());
            this.setSelected(this.uniqueCheckBox, this.incls.getUniqueIndexesOnly());
            TableViewer viewer = this.listPanel.getTableViewer();
            Object obj = viewer.getElementAt(0);
            while (obj != null) {
                viewer.remove(obj);
                obj = viewer.getElementAt(0);
            }
            ResultSet result = null;
            try {
                try {
                    result = db.getDatabaseMetaData().getTableTypes();
                    ArrayList<String> types = new ArrayList<String>();
                    while (result.next()) {
                        String type = result.getString(1).trim();
                        if (types.contains(type)) continue;
                        types.add(type);
                    }
                    if (types.isEmpty()) break block21;
                    viewer.add(types.toArray());
                    EList lastTypes = this.importSettings.getIncludedTableTypes();
                    if (lastTypes != null && !lastTypes.isEmpty()) {
                        viewer.setSelection((ISelection)new StructuredSelection((List)lastTypes));
                        break block21;
                    }
                    viewer.setSelection((ISelection)new StructuredSelection(types));
                }
                catch (Exception err) {
                    JdbcUiUtil.showAccessError(err);
                    if (result == null) break block21;
                    try {
                        result.close();
                    }
                    catch (SQLException e) {
                        UiConstants.Util.log((Throwable)e);
                    }
                }
            }
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException e) {
                        UiConstants.Util.log((Throwable)e);
                    }
                }
            }
        }
    }

    void approximationsCheckBoxSelected() {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Opproxomations Option", (Object)((Object)this));
        boolean succeeded = false;
        try {
            this.incls.setApproximateIndexes(this.approximationsCheckBox.getSelection());
            this.importSettings.setIncludeApproximateIndexes(this.incls.getApproximateIndexes());
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    void foreignKeysCheckBoxSelected() {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Foreign Keys Option", (Object)((Object)this));
        boolean succeeded = false;
        try {
            boolean enabled = this.foreignKeysCheckBox.getSelection();
            this.incompleteFKCheckBox.setSelection(enabled);
            this.incompleteFKCheckBox.setEnabled(enabled);
            this.incls.setIncludeForeignKeys(this.foreignKeysCheckBox.getSelection());
            this.incls.setIncludeIncompleteFKs(this.incompleteFKCheckBox.getSelection());
            this.importSettings.setIncludeForeignKeys(this.incls.includeForeignKeys());
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    void incompleteFKsCheckBoxSelected() {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Include Incomplete FKs Option", (Object)((Object)this));
        boolean succeeded = false;
        try {
            this.incls.setIncludeIncompleteFKs(this.incompleteFKCheckBox.getSelection());
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    void indexesCheckBoxSelected() {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Indexes Option", (Object)((Object)this));
        boolean succeeded = false;
        try {
            boolean enabled = this.indexesCheckBox.getSelection();
            this.approximationsCheckBox.setSelection(enabled);
            this.approximationsCheckBox.setEnabled(enabled);
            this.incls.setIncludeIndexes(enabled);
            this.incls.setApproximateIndexes(enabled);
            this.uniqueCheckBox.setEnabled(enabled);
            this.importSettings.setIncludeIndexes(this.incls.includeIndexes());
            this.importSettings.setIncludeUniqueIndexes(this.incls.getUniqueIndexesOnly());
            this.importSettings.setIncludeApproximateIndexes(this.incls.getApproximateIndexes());
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    void procuduresButtonSelected() {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Procedures Option", (Object)((Object)this));
        boolean succeeded = false;
        try {
            this.incls.setIncludeProcedures(this.proceduresCheckBox.getSelection());
            this.importSettings.setIncludeProcedures(this.incls.includeProcedures());
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        this.validatePage();
    }

    void tableTypesSelected(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        String[] types = new String[selection.size()];
        EList tableTypes = this.importSettings.getIncludedTableTypes();
        tableTypes.clear();
        Iterator iter = selection.iterator();
        int ndx = 0;
        while (ndx < types.length) {
            types[ndx] = (String)iter.next();
            tableTypes.add(types[ndx]);
            ++ndx;
        }
        this.incls.setIncludedTableTypes(types);
        boolean enabled = types.length > 0;
        this.foreignKeysCheckBox.setEnabled(enabled);
        this.indexesCheckBox.setEnabled(enabled);
        if (enabled) {
            if (this.enableMap != null) {
                WidgetUtil.restore((Map)this.enableMap);
                this.enableMap = null;
            }
        } else {
            this.enableMap = WidgetUtil.disable((Control[])new Control[]{this.uniqueCheckBox, this.approximationsCheckBox});
        }
        this.validatePage();
    }

    void uniqueCheckBoxSelected() {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Unique Indexes Option", (Object)((Object)this));
        boolean succeeded = false;
        try {
            this.incls.setUniqueIndexesOnly(this.uniqueCheckBox.getSelection());
            this.importSettings.setIncludeUniqueIndexes(this.incls.getUniqueIndexesOnly());
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public void setImporter(JdbcImporter importer) {
        this.importer = importer;
    }

    private Button createNestedCheckbox(Composite parent, String text, int indent) {
        Button button = WidgetFactory.createCheckBox((Composite)parent, (String)text);
        GridData gridData = (GridData)button.getLayoutData();
        gridData.horizontalIndent = indent;
        return button;
    }

    private void setSelected(Button checkBox, boolean selected) {
        checkBox.setSelection(selected);
        checkBox.notifyListeners(13, new Event());
    }

    private void validatePage() {
        if (this.proceduresCheckBox.getSelection() || !this.listPanel.getViewer().getSelection().isEmpty()) {
            WizardUtil.setPageComplete((WizardPage)this);
        } else {
            WizardUtil.setPageComplete((WizardPage)this, (String)INVALID_PAGE_MESSAGE, (int)3);
        }
    }
}

