/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.FileReportDocumentProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportEditorInput;
import org.eclipse.birt.report.designer.internal.ui.editors.wizards.SaveReportAsWizard;
import org.eclipse.birt.report.designer.internal.ui.editors.wizards.SaveReportAsWizardDialog;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class FileReportProvider
implements IReportProvider {
    protected static final Logger logger = Logger.getLogger(FileReportProvider.class.getName());
    private ModuleHandle model;
    private static final String VERSION_MESSAGE = Messages.getString((String)"TextPropertyDescriptor.Message.Version");

    public ModuleHandle queryReportModuleHandle() {
        return this.model;
    }

    public ModuleHandle getReportModuleHandle(Object element) {
        return this.getReportModuleHandle(element, false);
    }

    public ModuleHandle getReportModuleHandle(Object element, boolean reset) {
        IPath path;
        if ((this.model == null || reset) && element instanceof IPathEditorInput && (path = ((IPathEditorInput)element).getPath()) != null) {
            String fileName = path.toOSString();
            FileInputStream stream = null;
            try {
                try {
                    String projectFolder;
                    stream = new FileInputStream(path.toFile());
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    String designerVersion = MessageFormat.format(VERSION_MESSAGE, ReportPlugin.getVersion(), ReportPlugin.getBuildInfo());
                    properties.put("createdBy", designerVersion);
                    properties.put("createdBy", designerVersion);
                    if (fileName.endsWith(".rpttemplate")) {
                        properties.put("semanticCheck", false);
                    }
                    if ((projectFolder = this.getProjectFolder((IEditorInput)((IPathEditorInput)element))) != null) {
                        properties.put("resourceFolder", projectFolder);
                    }
                    this.model = SessionHandleAdapter.getInstance().init(fileName, (InputStream)stream, properties);
                }
                catch (DesignFileException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    try {
                        if (stream != null) {
                            ((InputStream)stream).close();
                        }
                    }
                    catch (IOException e2) {
                        logger.log(Level.SEVERE, e2.getMessage(), e2);
                    }
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    try {
                        if (stream != null) {
                            ((InputStream)stream).close();
                        }
                    }
                    catch (IOException e3) {
                        logger.log(Level.SEVERE, e3.getMessage(), e3);
                    }
                }
            }
            finally {
                try {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return this.model;
    }

    private String getProjectFolder(IEditorInput input) {
        return UIUtil.getProjectFolder((IEditorInput)input);
    }

    public void saveReport(ModuleHandle moduleHandle, Object element, IProgressMonitor monitor) {
        this.saveReport(moduleHandle, element, null, monitor);
    }

    public void saveReport(ModuleHandle moduleHandle, Object element, IPath origReportPath, IProgressMonitor monitor) {
        if (element instanceof IPathEditorInput) {
            IPathEditorInput input = (IPathEditorInput)element;
            this.saveFile(moduleHandle, input.getPath().toFile(), origReportPath, monitor);
        }
    }

    private void saveFile(final ModuleHandle moduleHandle, final File file, final IPath oldReportPath, IProgressMonitor monitor) {
        if (file.exists() && !file.canWrite()) {
            MessageDialog.openError((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"IDEFileReportProvider.ReadOnlyEncounter.Title"), (String)Messages.getFormattedString((String)"IDEFileReportProvider.ReadOnlyEncounter.Message", (Object[])new Object[]{file.getAbsolutePath()}));
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public final synchronized void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor pm) throws CoreException {
                            try {
                                this.execute(pm);
                            }
                            catch (CoreException e) {
                                throw e;
                            }
                            catch (IOException e) {
                                ExceptionUtil.handle((Throwable)e);
                            }
                        }
                    };
                    ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 0, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }

            public void execute(IProgressMonitor monitor) throws CoreException, IOException {
                if (file.exists() || file.createNewFile()) {
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file), 16384);
                    try {
                        moduleHandle.serialize((OutputStream)out);
                        ((OutputStream)out).flush();
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                    if (oldReportPath != null) {
                        FileReportProvider.copyReportConfigFile((IPath)new Path(file.getAbsolutePath()), oldReportPath);
                    }
                }
            }
        };
        try {
            new ProgressMonitorDialog(UIUtil.getDefaultShell()).run(false, true, op);
        }
        catch (Exception e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }

    public static void copyReportConfigFile(IPath newReportPath, IPath oldReportPath) throws IOException {
        if (oldReportPath != null) {
            String retConfigExtension = "rptconfig";
            IPath newConfigPath = newReportPath.removeFileExtension();
            IPath oldConfigPath = oldReportPath.removeFileExtension();
            newConfigPath = newConfigPath.addFileExtension(retConfigExtension);
            oldConfigPath = oldConfigPath.addFileExtension(retConfigExtension);
            File newConfigFile = newConfigPath.toFile();
            File oldConfigFile = oldConfigPath.toFile();
            if (oldConfigFile.exists()) {
                FileReportProvider.copyFile(oldConfigFile, newConfigFile);
            } else if (newConfigFile.exists() && !newConfigFile.delete()) {
                throw new IOException(Messages.getFormattedString((String)"FileReportProvider.CopyConfigFile.DeleteFailure", (Object[])new Object[]{newConfigFile.getAbsolutePath()}));
            }
        }
    }

    private static void copyFile(File srcFile, File destFile) throws IOException {
        Exception exception;
        block45: {
            if (srcFile.equals(destFile)) {
                return;
            }
            FileInputStream fis = null;
            FileOutputStream fos = null;
            AbstractInterruptibleChannel fcin = null;
            AbstractInterruptibleChannel fcout = null;
            exception = null;
            try {
                try {
                    fis = new FileInputStream(srcFile);
                    fos = new FileOutputStream(destFile);
                    fcin = fis.getChannel();
                    fcout = fos.getChannel();
                    ((FileChannel)fcin).transferTo(0L, ((FileChannel)fcin).size(), (WritableByteChannel)((Object)fcout));
                }
                catch (Exception e) {
                    exception = e;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception e2) {
                            Exception exception2 = exception = exception == null ? e2 : exception;
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception e3) {
                            Exception exception3 = exception = exception == null ? e3 : exception;
                        }
                    }
                    if (fcin != null) {
                        try {
                            fcin.close();
                        }
                        catch (Exception e4) {
                            Exception exception4 = exception = exception == null ? e4 : exception;
                        }
                    }
                    if (fcout != null) {
                        try {
                            fcout.close();
                        }
                        catch (Exception e5) {
                            exception = exception == null ? e5 : exception;
                        }
                    }
                    break block45;
                }
            }
            catch (Throwable throwable) {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        Exception exception5 = exception = exception == null ? e : exception;
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e) {
                        Exception exception6 = exception = exception == null ? e : exception;
                    }
                }
                if (fcin != null) {
                    try {
                        fcin.close();
                    }
                    catch (Exception e) {
                        Exception exception7 = exception = exception == null ? e : exception;
                    }
                }
                if (fcout != null) {
                    try {
                        fcout.close();
                    }
                    catch (Exception e) {
                        exception = exception == null ? e : exception;
                    }
                }
                throw throwable;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    Exception exception8 = exception = exception == null ? e : exception;
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    Exception exception9 = exception = exception == null ? e : exception;
                }
            }
            if (fcin != null) {
                try {
                    fcin.close();
                }
                catch (Exception e) {
                    Exception exception10 = exception = exception == null ? e : exception;
                }
            }
            if (fcout != null) {
                try {
                    fcout.close();
                }
                catch (Exception e) {
                    Exception exception11 = exception = exception == null ? e : exception;
                }
            }
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (exception != null) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public IPath getSaveAsPath(Object element) {
        if (element instanceof IPathEditorInput) {
            IEditorInput input = (IEditorInput)element;
            SaveReportAsWizardDialog dialog = new SaveReportAsWizardDialog(UIUtil.getDefaultShell(), (IWizard)new SaveReportAsWizard(this.model, input));
            if (dialog.open() == 0) {
                return dialog.getResult();
            }
        }
        return null;
    }

    public IEditorInput createNewEditorInput(IPath path) {
        File file = new File(path.toOSString());
        try {
            if (file.exists() || file.createNewFile()) {
                return new ReportEditorInput(file);
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public IPath getInputPath(IEditorInput input) {
        if (input instanceof IPathEditorInput) {
            return ((IPathEditorInput)input).getPath();
        }
        return null;
    }

    public IDocumentProvider getReportDocumentProvider(Object element) {
        return new FileReportDocumentProvider();
    }

    public void connect(ModuleHandle handle) {
        this.model = handle;
    }
}

