/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug.structure;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JavaLogicalStructure;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIPlaceholderValue;
import org.eclipse.jdt.internal.debug.ui.JDIModelPresentation;

public abstract class JavaInterfaceVariable
extends DebugElement
implements IJavaVariable {
    private final String _name;
    private final String _valueType;
    private final String _getterExpression;
    private final String _setterMethod;
    private final IJavaObject _underlyingObject;
    private IValue _value;

    public JavaInterfaceVariable(IJavaObject underlyingObject, String variableName, String valueType, boolean readOnly) {
        this(underlyingObject, variableName, "get" + JavaInterfaceVariable.pruneWhiteSpace(variableName) + "()", readOnly ? null : "set" + JavaInterfaceVariable.pruneWhiteSpace(variableName), valueType);
    }

    public JavaInterfaceVariable(IJavaObject underlyingObject, String variableName, String getterExpression, String setterMethod, String valueType) {
        super(underlyingObject.getDebugTarget());
        this._name = variableName;
        this._getterExpression = getterExpression;
        this._setterMethod = setterMethod;
        this._valueType = valueType;
        this._underlyingObject = underlyingObject;
    }

    public boolean isPublic() throws DebugException {
        return true;
    }

    public boolean isPrivate() throws DebugException {
        return false;
    }

    public boolean isProtected() throws DebugException {
        return false;
    }

    public boolean isPackagePrivate() throws DebugException {
        return false;
    }

    public boolean isFinal() throws DebugException {
        return false;
    }

    public boolean isStatic() throws DebugException {
        return false;
    }

    public boolean isSynthetic() throws DebugException {
        return false;
    }

    public synchronized IValue getValue() throws DebugException {
        if (this._value == null) {
            try {
                IJavaValue value = this.getRawValue();
                this._value = value.isNull() ? value : this.wrapJavaValue(value);
            }
            catch (CoreException coreException) {
                this._value = new JDIPlaceholderValue((JDIDebugTarget)this.getDebugTarget(), "Could not retrieve value");
            }
        }
        return this._value;
    }

    protected abstract IValue wrapJavaValue(IJavaValue var1);

    protected IJavaValue getRawValue() throws CoreException {
        if (this._getterExpression == null) {
            return this.getUnderlyingObject();
        }
        return (IJavaValue)new JavaLogicalStructure(this._underlyingObject.getReferenceTypeName(), true, this._getterExpression, null, null).getLogicalStructure((IValue)this._underlyingObject);
    }

    public String getName() throws DebugException {
        return this._name;
    }

    public String getReferenceTypeName() throws DebugException {
        return this._valueType;
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public void setValue(String expression) throws DebugException {
        this.notSupported("setValue(java.lang.String) not supported.", null);
    }

    public synchronized void setValue(IValue value) throws DebugException {
        if (this._setterMethod == null) {
            this.notSupported(String.valueOf(this.getReferenceTypeName()) + " does not support setValue()", null);
        }
        if (value instanceof IJavaValue) {
            IJavaThread thread = JDIModelPresentation.getEvaluationThread((IJavaDebugTarget)((IJavaDebugTarget)this.getDebugTarget()));
            this._underlyingObject.sendMessage(this._setterMethod, this.getSetterMethodSignature(), new IJavaValue[]{(IJavaValue)value}, thread, false);
            this._value = null;
            this.fireChangeEvent(512);
        }
    }

    protected String getSetterMethodSignature() {
        return Signature.createMethodSignature((String[])new String[]{Signature.createTypeSignature((String)this._valueType, (boolean)true)}, (String)"V").replace('.', '/');
    }

    public boolean supportsValueModification() {
        return this._setterMethod != null;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return value instanceof IJavaValue && this.typeCompatible(((IJavaValue)value).getJavaType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean typeCompatible(IJavaType type) {
        try {
            if (!(type instanceof IJavaClassType)) return false;
            IJavaInterfaceType[] iJavaInterfaceTypeArray = ((IJavaClassType)type).getAllInterfaces();
            int n = iJavaInterfaceTypeArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IJavaInterfaceType intf = iJavaInterfaceTypeArray[n2];
                if (intf.getName().equals(this._valueType)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (DebugException e) {
            e.fillInStackTrace();
        }
        return false;
    }

    public String getModelIdentifier() {
        return JDIDebugModel.getPluginIdentifier();
    }

    public String getSignature() throws DebugException {
        return Signature.getTypeErasure((String)this.getGenericSignature()).replace('.', '/');
    }

    public String getGenericSignature() throws DebugException {
        return Signature.createTypeSignature((String)this._valueType, (boolean)true).replace('.', '/');
    }

    public IJavaType getJavaType() throws DebugException {
        return ((IJavaValue)this.getValue()).getJavaType();
    }

    public boolean isLocal() throws DebugException {
        return false;
    }

    protected IJavaValue getUnderlyingObject() {
        return this._underlyingObject;
    }

    private static String pruneWhiteSpace(String source) {
        StringBuffer buffer = new StringBuffer();
        String[] stringArray = source.split("\\s*");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            buffer.append(segment);
            ++n2;
        }
        return buffer.toString();
    }
}

