/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import java.util.Set;
import javax.xml.namespace.QName;
import org.switchyard.tools.ui.debug.IConditionBuilder;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;

public class SwitchYardExchangeConditionBuilder
implements IConditionBuilder {
    private final String _exchangeVariable;

    public SwitchYardExchangeConditionBuilder(String exchangeVariable) {
        this._exchangeVariable = exchangeVariable;
    }

    @Override
    public String provider(QName name) {
        if (name == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        buffer.append(this._exchangeVariable).append(".getConsumer() != null && ");
        buffer.append('\"').append(name.toString()).append('\"').append(".equals(").append(this._exchangeVariable).append(".getConsumer().getTargetServiceName().toString())");
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public String consumer(QName name) {
        if (name == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        buffer.append(this._exchangeVariable).append(".getConsumer() != null && ");
        buffer.append('\"').append(name.toString()).append('\"').append(".equals(").append(this._exchangeVariable).append(".getConsumer().getName().toString())");
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public String exchangePhase(Set<IInteractionConfiguration.TriggerType> triggers) {
        StringBuffer buffer = new StringBuffer();
        boolean addOr = false;
        buffer.append("(");
        if (triggers.contains((Object)IInteractionConfiguration.TriggerType.IN)) {
            if (triggers.contains((Object)IInteractionConfiguration.TriggerType.OUT)) {
                return null;
            }
            buffer.append("org.switchyard.ExchangePhase.IN == ").append(this._exchangeVariable).append(".getProperty(\"org.switchyard.bus.camel.phase\", org.switchyard.ExchangePhase.class)");
            addOr = true;
        }
        if (triggers.contains((Object)IInteractionConfiguration.TriggerType.OUT)) {
            if (addOr) {
                buffer.append("\n            || ");
            }
            buffer.append("org.switchyard.ExchangePhase.OUT == ").append(this._exchangeVariable).append(".getProperty(\"org.switchyard.bus.camel.phase\", org.switchyard.ExchangePhase.class)");
        } else if (triggers.contains((Object)IInteractionConfiguration.TriggerType.FAULT)) {
            if (addOr) {
                buffer.append("\n            || ");
            }
            buffer.append(this.exchangeState(true));
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public String exchangeState(boolean fault) {
        StringBuffer buffer = new StringBuffer();
        if (!fault) {
            buffer.append('!');
        }
        buffer.append(this._exchangeVariable).append(".getProperty(\"org.switchyard.bus.camel.fault\", false, Boolean.class)");
        return buffer.toString();
    }
}

