/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.mm.algorithms.styles;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Orientation implements Enumerator
{
    ALIGNMENT_CENTER(0, "ALIGNMENT_CENTER", "ALIGNMENT_CENTER"),
    ALIGNMENT_LEFT(1, "ALIGNMENT_LEFT", "ALIGNMENT_LEFT"),
    ALIGNMENT_TOP(2, "ALIGNMENT_TOP", "ALIGNMENT_TOP"),
    ALIGNMENT_RIGHT(3, "ALIGNMENT_RIGHT", "ALIGNMENT_RIGHT"),
    ALIGNMENT_BOTTOM(4, "ALIGNMENT_BOTTOM", "ALIGNMENT_BOTTOM"),
    ALIGNMENT_MIDDLE(5, "ALIGNMENT_MIDDLE", "ALIGNMENT_MIDDLE"),
    UNSPECIFIED(6, "UNSPECIFIED", "UNSPECIFIED");

    public static final int ALIGNMENT_CENTER_VALUE = 0;
    public static final int ALIGNMENT_LEFT_VALUE = 1;
    public static final int ALIGNMENT_TOP_VALUE = 2;
    public static final int ALIGNMENT_RIGHT_VALUE = 3;
    public static final int ALIGNMENT_BOTTOM_VALUE = 4;
    public static final int ALIGNMENT_MIDDLE_VALUE = 5;
    public static final int UNSPECIFIED_VALUE = 6;
    private static final Orientation[] VALUES_ARRAY;
    public static final List<Orientation> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Orientation[]{ALIGNMENT_CENTER, ALIGNMENT_LEFT, ALIGNMENT_TOP, ALIGNMENT_RIGHT, ALIGNMENT_BOTTOM, ALIGNMENT_MIDDLE, UNSPECIFIED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Orientation get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Orientation result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Orientation getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Orientation result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Orientation get(int value) {
        switch (value) {
            case 0: {
                return ALIGNMENT_CENTER;
            }
            case 1: {
                return ALIGNMENT_LEFT;
            }
            case 2: {
                return ALIGNMENT_TOP;
            }
            case 3: {
                return ALIGNMENT_RIGHT;
            }
            case 4: {
                return ALIGNMENT_BOTTOM;
            }
            case 5: {
                return ALIGNMENT_MIDDLE;
            }
            case 6: {
                return UNSPECIFIED;
            }
        }
        return null;
    }

    private Orientation(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

