/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.function.bre;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.function.i18n.Messages;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionContext;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionExecutor;

class BirtStr
implements IScriptFunctionExecutor {
    private static final long serialVersionUID = 1L;
    private IScriptFunctionExecutor executor;

    BirtStr(String functionName) throws BirtException {
        if ("left".equals(functionName)) {
            this.executor = new Function_Left();
        } else if ("right".equals(functionName)) {
            this.executor = new Function_Right();
        } else if ("concat".equals(functionName)) {
            this.executor = new Function_Concat();
        } else if ("toUpper".equals(functionName)) {
            this.executor = new Function_ToUpper();
        } else if ("toLower".equals(functionName)) {
            this.executor = new Function_ToLower();
        } else if ("trim".equals(functionName)) {
            this.executor = new Function_Trim();
        } else if ("trimLeft".equals(functionName)) {
            this.executor = new Function_TrimLeft();
        } else if ("trimRight".equals(functionName)) {
            this.executor = new Function_TrimRight();
        } else if ("indexOf".equals(functionName)) {
            this.executor = new Function_IndexOf();
        } else if ("search".equals(functionName)) {
            this.executor = new Function_Search();
        } else if ("charLength".equals(functionName)) {
            this.executor = new Function_CharLength();
        } else {
            throw new BirtException("org.eclipse.birt.core.script.function.bre", null, (Object)(String.valueOf(Messages.getString("invalid.function.name")) + "BirtStr." + functionName));
        }
    }

    public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
        return this.executor.execute(arguments, context);
    }

    private static class Function_CharLength
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;
        private static final int fixedArgumentNum = 1;

        private Function_CharLength() {
        }

        private int charLength(String str) {
            if (str == null) {
                return 0;
            }
            return str.length();
        }

        public Object execute(Object[] args, IScriptFunctionContext context) throws BirtException {
            if (args == null) {
                throw new IllegalArgumentException(Messages.getString("error.arguement.cannot.empty"));
            }
            if (args.length != 1) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.incorrect.number.function.fixedArgument", new Object[]{1, args.length}));
            }
            return this.charLength(args[0] == null ? null : (String)args[0]);
        }
    }

    private static class Function_Concat
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private Function_Concat() {
        }

        public Object execute(Object[] args, IScriptFunctionContext context) throws BirtException {
            if (args == null) {
                throw new IllegalArgumentException(Messages.getString("error.arguement.cannot.empty"));
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < args.length) {
                buf.append(args[i]);
                ++i;
            }
            return buf.toString();
        }
    }

    private static class Function_IndexOf
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;
        private static final int minArgumentNum = 2;
        private static final int maxArgumentNum = 3;

        private Function_IndexOf() {
        }

        private int indexOf(String find_text, String str, int start) {
            if (start < 0) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtStr.indexOf.invalidArgument", new Object[]{start}));
            }
            if (find_text == null || str == null || str.indexOf(find_text) < 0) {
                return -1;
            }
            return str.indexOf(find_text, start);
        }

        private int indexOf(String find_text, String str) {
            return this.indexOf(find_text, str, 0);
        }

        public Object execute(Object[] args, IScriptFunctionContext context) throws BirtException {
            if (args == null) {
                throw new IllegalArgumentException(Messages.getString("error.arguement.cannot.empty"));
            }
            if (args.length > 3 || args.length < 2) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.argument.number.outofValidRange", new Object[]{2, 3, args.length}));
            }
            if (args.length == 3) {
                return new Integer(this.indexOf(args[0] == null ? null : (String)args[0], args[1] == null ? null : (String)args[1], ((Number)args[2]).intValue()));
            }
            return this.indexOf(args[0] == null ? null : (String)args[0], args[1] == null ? null : (String)args[1]);
        }
    }

    private static class Function_Left
    implements IScriptFunctionExecutor {
        private static final int maxArgumentNum = 2;
        private static final long serialVersionUID = 1L;

        private Function_Left() {
        }

        private String left(String str, int n) {
            if (n < 0) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtStr.left.invalidArgument", new Object[]{n}));
            }
            if (str == null) {
                return null;
            }
            if (n == 0) {
                return "";
            }
            if (n >= str.length()) {
                return str;
            }
            return str.substring(0, n);
        }

        private String left(String str) {
            return this.left(str, 1);
        }

        public Object execute(Object[] args, IScriptFunctionContext context) throws BirtException {
            if (args == null) {
                throw new IllegalArgumentException(Messages.getString("error.arguement.cannot.empty"));
            }
            if (args.length > 2) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.incorrect.number.function.variableArgument", new Object[]{2, args.length}));
            }
            if (args.length == 1) {
                return this.left(args[0] == null ? null : (String)args[0]);
            }
            return this.left(args[0] == null ? null : (String)args[0], ((Number)args[1]).intValue());
        }
    }

    private static class Function_Right
    implements IScriptFunctionExecutor {
        private static final int maxArgumentNum = 2;
        private static final long serialVersionUID = 1L;

        private Function_Right() {
        }

        public String right(String str, int n) {
            if (n < 0) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtStr.right.invalidArgument", new Object[]{n}));
            }
            if (str == null) {
                return null;
            }
            if (n == 0) {
                return "";
            }
            if (n >= str.length()) {
                return str;
            }
            return str.substring(str.length() - n, str.length());
        }

        public String right(String str) {
            return this.right(str, 1);
        }

        public Object execute(Object[] args, IScriptFunctionContext context) throws BirtException {
            if (args == null) {
                throw new IllegalArgumentException(Messages.getString("error.arguement.cannot.empty"));
            }
            if (args.length > 2) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.incorrect.number.function.variableArgument", new Object[]{2, args.length}));
            }
            if (args.length == 1) {
                return this.right(args[0] == null ? null : (String)args[0]);
            }
            return this.right(args[0] == null ? null : (String)args[0], ((Number)args[1]).intValue());
        }
    }

    private static class Function_Search
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;
        private static final int minArgumentNum = 2;
        private static final int maxArgumentNum = 3;

        private Function_Search() {
        }

        private int search(String pattern, String str, int start) {
            if (start < 0) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtStr.indexOf.invalidArgument", new Object[]{start}));
            }
            if (pattern == null || str == null) {
                return -1;
            }
            String subStr = str.substring(start);
            Pattern p = Pattern.compile(this.toPatternString(pattern), 2);
            Matcher matcher = p.matcher(subStr);
            if (matcher.find()) {
                return matcher.start() + start;
            }
            return -1;
        }

        private String toPatternString(String regex) {
            String pattern = "";
            boolean preserveFlag = false;
            int i = 0;
            while (i < regex.length()) {
                char c = regex.charAt(i);
                if (c == '\\') {
                    pattern = this.handlePreservedString(preserveFlag, pattern);
                    preserveFlag = false;
                    pattern = String.valueOf(pattern) + c;
                    if (++i < regex.length()) {
                        pattern = String.valueOf(pattern) + regex.charAt(i);
                    }
                } else if (c == '*') {
                    pattern = this.handlePreservedString(preserveFlag, pattern);
                    preserveFlag = false;
                    pattern = String.valueOf(pattern) + ".*";
                } else if (c == '?') {
                    pattern = this.handlePreservedString(preserveFlag, pattern);
                    preserveFlag = false;
                    pattern = String.valueOf(pattern) + ".";
                } else if (preserveFlag) {
                    pattern = String.valueOf(pattern) + c;
                } else {
                    pattern = String.valueOf(pattern) + "\\Q" + c;
                    preserveFlag = true;
                }
                ++i;
            }
            if (preserveFlag) {
                pattern = String.valueOf(pattern) + "\\E";
            }
            return pattern;
        }

        private String handlePreservedString(boolean preserveFlag, String pattern) {
            if (preserveFlag) {
                pattern = String.valueOf(pattern) + "\\E";
            }
            return pattern;
        }

        private int search(String pattern, String str) {
            return this.search(pattern, str, 0);
        }

        public Object execute(Object[] args, IScriptFunctionContext context) throws BirtException {
            if (args == null) {
                throw new IllegalArgumentException(Messages.getString("error.arguement.cannot.empty"));
            }
            if (args.length > 3 || args.length < 2) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.argument.number.outofValidRange", new Object[]{2, 3, args.length}));
            }
            if (args.length == 3) {
                return new Integer(this.search(args[0] == null ? null : (String)args[0], args[1] == null ? null : (String)args[1], ((Number)args[2]).intValue()));
            }
            return this.search(args[0] == null ? null : (String)args[0], args[1] == null ? null : (String)args[1]);
        }
    }

    private static class Function_ToLower
    implements IScriptFunctionExecutor {
        private static final int fixedArgumentNum = 1;
        private static final long serialVersionUID = 1L;

        private Function_ToLower() {
        }

        public Object execute(Object[] args, IScriptFunctionContext context) throws BirtException {
            if (args == null) {
                throw new IllegalArgumentException(Messages.getString("error.arguement.cannot.empty"));
            }
            if (args.length != 1) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.incorrect.number.function.fixedArgument", new Object[]{1, args.length}));
            }
            if (args[0] instanceof Object[]) {
                Object[] objArray = (Object[])args[0];
                String[] strArray = new String[objArray.length];
                int i = 0;
                while (i < objArray.length) {
                    if (objArray[i] == null) {
                        strArray[i] = null;
                    } else if (objArray[i] instanceof String) {
                        strArray[i] = ((String)objArray[i]).toLowerCase();
                    } else {
                        throw new IllegalArgumentException(Messages.getString("error.incorrect.type.function.argument"));
                    }
                    ++i;
                }
                return strArray;
            }
            if (args[0] == null) {
                return null;
            }
            if (!(args[0] instanceof String)) {
                throw new IllegalArgumentException(Messages.getString("error.incorrect.type.function.argument"));
            }
            return ((String)args[0]).toLowerCase();
        }
    }

    private static class Function_ToUpper
    implements IScriptFunctionExecutor {
        private static final int fixedArgumentNum = 1;
        private static final long serialVersionUID = 1L;

        private Function_ToUpper() {
        }

        public Object execute(Object[] args, IScriptFunctionContext context) throws BirtException {
            if (args == null) {
                throw new IllegalArgumentException(Messages.getString("error.arguement.cannot.empty"));
            }
            if (args.length != 1) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.incorrect.number.function.fixedArgument", new Object[]{1, args.length}));
            }
            if (args[0] instanceof Object[]) {
                Object[] objArray = (Object[])args[0];
                String[] strArray = new String[objArray.length];
                int i = 0;
                while (i < objArray.length) {
                    if (objArray[i] == null) {
                        strArray[i] = null;
                    } else if (objArray[i] instanceof String) {
                        strArray[i] = ((String)objArray[i]).toUpperCase();
                    } else {
                        throw new IllegalArgumentException(Messages.getString("error.incorrect.type.function.argument"));
                    }
                    ++i;
                }
                return strArray;
            }
            if (args[0] == null) {
                return null;
            }
            if (args[0] instanceof Integer) {
                return args[0];
            }
            if (!(args[0] instanceof String)) {
                throw new IllegalArgumentException(Messages.getString("error.incorrect.type.function.argument"));
            }
            return ((String)args[0]).toUpperCase();
        }
    }

    private static class Function_Trim
    implements IScriptFunctionExecutor {
        private static final int fixedArgumentNum = 1;
        private static final long serialVersionUID = 1L;

        private Function_Trim() {
        }

        private String trim(String str) {
            if (str == null) {
                return null;
            }
            String trimStr = str.trim();
            return trimStr.replaceAll("\\s+", " ");
        }

        public Object execute(Object[] args, IScriptFunctionContext context) throws BirtException {
            if (args == null) {
                throw new IllegalArgumentException(Messages.getString("error.arguement.cannot.empty"));
            }
            if (args.length != 1) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.incorrect.number.function.fixedArgument", new Object[]{1, args.length}));
            }
            return this.trim(args[0] == null ? null : (String)args[0]);
        }
    }

    private static class Function_TrimLeft
    implements IScriptFunctionExecutor {
        private static final int fixedArgumentNum = 1;
        private static final long serialVersionUID = 1L;

        private Function_TrimLeft() {
        }

        private String trimLeft(String str) {
            if (str == null) {
                return null;
            }
            byte[] value = str.getBytes();
            int st = 0;
            while (st < str.length() && value[st] <= 32) {
                ++st;
            }
            return st > 0 ? str.substring(st, str.length()) : str;
        }

        public Object execute(Object[] args, IScriptFunctionContext context) throws BirtException {
            if (args == null) {
                throw new IllegalArgumentException(Messages.getString("error.arguement.cannot.empty"));
            }
            if (args.length != 1) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.incorrect.number.function.fixedArgument", new Object[]{1, args.length}));
            }
            return this.trimLeft(args[0] == null ? null : (String)args[0]);
        }
    }

    private static class Function_TrimRight
    implements IScriptFunctionExecutor {
        private static final int fixedArgumentNum = 1;
        private static final long serialVersionUID = 1L;

        private Function_TrimRight() {
        }

        private String trimRight(String str) {
            if (str == null) {
                return null;
            }
            byte[] value = str.getBytes();
            int end = str.length();
            while (end > 0 && value[end - 1] <= 32) {
                --end;
            }
            return end < str.length() ? str.substring(0, end) : str;
        }

        public Object execute(Object[] args, IScriptFunctionContext context) throws BirtException {
            if (args == null) {
                throw new IllegalArgumentException(Messages.getString("error.arguement.cannot.empty"));
            }
            if (args.length != 1) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.incorrect.number.function.fixedArgument", new Object[]{1, args.length}));
            }
            return this.trimRight(args[0] == null ? null : (String)args[0]);
        }
    }
}

