/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.views.outline;

import java.util.List;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.ui.property.PropertyLabelProvider;
import org.eclipse.bpmn2.modeler.ui.util.PropertyUtil;
import org.eclipse.bpmn2.modeler.ui.views.outline.DiagramTreeEditPart;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.graphics.Image;

public class AbstractGraphicsTreeEditPart
extends AbstractTreeEditPart {
    DiagramTreeEditPart diagramEditPart;
    PropertyLabelProvider labelProvider = new PropertyLabelProvider();

    public AbstractGraphicsTreeEditPart(DiagramTreeEditPart dep, Object model) {
        super(model);
        this.diagramEditPart = dep;
    }

    protected void setDiagramEditPart(DiagramTreeEditPart dep) {
        this.diagramEditPart = dep;
    }

    public Object getAdapter(Class key) {
        if (PictogramElement.class == key) {
            EObject bpmnModel = (EObject)super.getModel();
            if (bpmnModel instanceof BPMNDiagram) {
                BPMNDiagram bpmnDiagram = (BPMNDiagram)bpmnModel;
                bpmnModel = bpmnDiagram.getPlane().getBpmnElement();
            }
            if (this.diagramEditPart != null) {
                for (Diagram diagram : this.diagramEditPart.getAllDiagrams()) {
                    if (diagram == null) continue;
                    List pes = Graphiti.getLinkService().getPictogramElements(diagram, bpmnModel);
                    for (PictogramElement pe : pes) {
                        if (pe instanceof ContainerShape) {
                            return pe;
                        }
                        if (!(pe instanceof FreeFormConnection)) continue;
                        return pe;
                    }
                }
            }
        }
        return super.getAdapter(key);
    }

    protected void refreshChildren() {
        super.refreshChildren();
        if (this.children != null) {
            for (Object child : this.children) {
                if (!(child instanceof AbstractGraphicsTreeEditPart)) continue;
                ((AbstractGraphicsTreeEditPart)((Object)child)).refreshChildren();
            }
        }
        this.refreshVisuals();
    }

    protected Image getImage() {
        EObject o = (EObject)this.getModel();
        Image img = this.labelProvider.getImage(o);
        if (img != null) {
            return img;
        }
        return PropertyUtil.getImage(o);
    }

    protected String getText() {
        String text = null;
        if (this.getModel() instanceof EObject) {
            EObject o = (EObject)this.getModel();
            text = this.getText(o);
        }
        return text == null ? "" : text;
    }

    protected String getText(EObject o) {
        EStructuralFeature f;
        String text = "";
        if (o != null && (text = this.labelProvider.getText(o)) == null && ((text = ExtendedPropertiesProvider.getTextValue((EObject)o)) == null || text.isEmpty()) && (f = o.eClass().getEStructuralFeature("id")) != null) {
            text = o.eGet(f).toString();
        }
        return text;
    }

    public void refresh() {
        try {
            super.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

