/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.editors;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ComboObjectEditor;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.runtime.ServiceImplementationDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.ServiceTaskPropertiesAdapter;
import org.eclipse.bpmn2.modeler.ui.property.editors.Messages;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ServiceImplementationObjectEditor
extends ComboObjectEditor {
    public static String UNSPECIFIED_VALUE = "##unspecified";
    public static String WEBSERVICE_VALUE = "##WebService";

    public ServiceImplementationObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature) {
        super(parent, object, feature);
    }

    public ServiceImplementationObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature, EClass featureEType) {
        super(parent, object, feature, featureEType);
    }

    protected boolean canEdit() {
        if (this.editButton == null) {
            return true;
        }
        Object value = this.object.eGet(this.feature);
        if (value instanceof String) {
            TargetRuntime rt = TargetRuntime.getCurrentRuntime();
            for (ServiceImplementationDescriptor eld : rt.getServiceImplementationDescriptors()) {
                if (!value.equals(eld.getName())) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean canCreateNew() {
        return true;
    }

    public boolean setValue(Object result) {
        if (ModelUtil.isStringWrapper((Object)result)) {
            result = ModelUtil.getStringWrapperValue((Object)result);
        }
        return super.setValue(result);
    }

    public Object getValue() {
        Object value = this.object.eGet(this.feature);
        if (value == null) {
            return "";
        }
        Hashtable<String, Object> choices = this.getChoiceOfValues(this.object, this.feature);
        for (Map.Entry<String, Object> entry : choices.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return value.toString();
    }

    protected EObject createObject() throws Exception {
        Hashtable<String, Object> choices = this.getChoiceOfValues(this.object, this.feature);
        ImplementationEditingDialog dialog = new ImplementationEditingDialog(this.getDiagramEditor().getEditorSite().getShell(), Messages.ServiceImplementationObjectEditor_Create_New_Title, choices, null, null);
        if (dialog.open() == 0) {
            Bpmn2Preferences prefs = (Bpmn2Preferences)this.getDiagramEditor().getAdapter(Bpmn2Preferences.class);
            String newURI = dialog.getURI();
            String newName = dialog.getName();
            prefs.addServiceImplementation(newName, newURI);
            return ModelUtil.createStringWrapper((String)newURI);
        }
        throw new OperationCanceledException(Messages.ServiceImplementationObjectEditor_Dialog_Cancelled);
    }

    protected EObject editObject(EObject value) throws Exception {
        Hashtable<String, Object> choices = this.getChoiceOfValues(this.object, this.feature);
        final String oldURI = ModelUtil.getStringWrapperTextValue((Object)value);
        String oldName = (String)this.getValue();
        ImplementationEditingDialog dialog = new ImplementationEditingDialog(this.getDiagramEditor().getEditorSite().getShell(), Messages.ServiceImplementationObjectEditor_Edit_Title, choices, oldName, oldURI);
        if (dialog.open() == 0) {
            final String newURI = dialog.getURI();
            String newName = dialog.getName();
            if (!newURI.equals(value)) {
                final Definitions definitions = ModelUtil.getDefinitions((Object)this.object);
                if (definitions != null) {
                    TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            TreeIterator iter = definitions.eAllContents();
                            while (iter.hasNext()) {
                                String implementation;
                                EObject o = (EObject)iter.next();
                                EStructuralFeature f = o.eClass().getEStructuralFeature("implementation");
                                if (f == null || !oldURI.equals(implementation = (String)o.eGet(f))) continue;
                                o.eSet(f, (Object)newURI);
                            }
                        }
                    });
                }
                Bpmn2Preferences prefs = (Bpmn2Preferences)this.getDiagramEditor().getAdapter(Bpmn2Preferences.class);
                prefs.removeServiceImplementation(oldName);
                prefs.addServiceImplementation(newName, newURI);
                return ModelUtil.createStringWrapper((String)newURI);
            }
        }
        throw new OperationCanceledException(Messages.ServiceImplementationObjectEditor_Dialog_Cancelled);
    }

    protected Hashtable<String, Object> getChoiceOfValues(EObject object, EStructuralFeature feature) {
        return ServiceTaskPropertiesAdapter.getChoiceOfValues(object);
    }

    public class ImplementationEditingDialog
    extends InputDialog {
        private String nameString;
        private Text nameText;

        public ImplementationEditingDialog(Shell shell, String title, final Map<String, Object> choices, String nameString, final String uriString) {
            super(shell, title, Messages.ServiceImplementationObjectEditor_Implementation_URI_Label, uriString, new IInputValidator(){

                public String isValid(String newText) {
                    if (newText == null || newText.isEmpty()) {
                        return Messages.ServiceImplementationObjectEditor_Invalid_Empty;
                    }
                    if (newText.equals(uriString)) {
                        return null;
                    }
                    if (choices.containsKey(newText) || choices.containsValue(newText)) {
                        return NLS.bind((String)Messages.ServiceImplementationObjectEditor_Invalid_Duplicate, (Object)newText);
                    }
                    return null;
                }
            });
            this.nameString = nameString;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = this.createMyComposite(parent);
            Label label = new Label(composite, 64);
            label.setText(Messages.ServiceImplementationObjectEditor_Implementation_Name_Label);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
            this.nameText = new Text(composite, this.getInputTextStyle());
            this.nameText.setLayoutData((Object)new GridData(768));
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ImplementationEditingDialog.this.validateInput();
                }
            });
            return super.createDialogArea(parent);
        }

        private Composite createMyComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            ImplementationEditingDialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected void validateInput() {
            String errorMessage = this.getValidator().isValid(this.nameText.getText());
            if (errorMessage == null) {
                super.validateInput();
            } else {
                this.setErrorMessage(errorMessage);
            }
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.nameText.setFocus();
            if (this.nameString != null) {
                this.nameText.setText(this.nameString);
                this.nameText.selectAll();
            }
            this.validateInput();
        }

        protected void buttonPressed(int buttonId) {
            this.nameString = buttonId == 0 ? this.nameText.getText() : null;
            super.buttonPressed(buttonId);
        }

        public String getName() {
            return this.nameString;
        }

        public String getURI() {
            return super.getValue();
        }
    }
}

