/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.event;

import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.modeler.core.features.MoveFlowNodeFeature;
import org.eclipse.bpmn2.modeler.core.utils.BoundaryEventPositionHelper;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class MoveBoundaryEventFeature
extends MoveFlowNodeFeature {
    public MoveBoundaryEventFeature(IFeatureProvider fp) {
        super(fp);
    }

    protected void preMoveShape(IMoveShapeContext context) {
        super.preMoveShape(context);
        ContainerShape targetContainer = context.getTargetContainer();
        Activity activity = (Activity)BusinessObjectUtil.getFirstElementOfType((PictogramElement)targetContainer, Activity.class);
        Object property = context.getProperty((Object)"activity.move");
        if (activity != null && property == null) {
            ContainerShape taskContainer = context.getTargetContainer();
            ContainerShape parentContainer = (ContainerShape)context.getPictogramElement().eContainer();
            IPeService peService = Graphiti.getPeService();
            ILocation loc = peService.getLocationRelativeToDiagram((Shape)taskContainer);
            MoveShapeContext c = (MoveShapeContext)context;
            int eventX = loc.getX() + context.getX();
            int eventY = loc.getY() + context.getY();
            if (!(parentContainer instanceof Diagram)) {
                loc = peService.getLocationRelativeToDiagram((Shape)parentContainer);
                eventX -= loc.getX();
                eventY -= loc.getY();
            }
            c.setLocation(eventX, eventY);
            c.setTargetContainer(parentContainer);
        }
    }

    public boolean canMoveShape(IMoveShapeContext context) {
        boolean movedByActivity;
        Object property = context.getProperty((Object)"activity.move");
        PictogramElement[] selection = this.getDiagramEditor().getSelectedPictogramElements();
        boolean singleSelection = selection != null && selection.length == 1;
        BoundaryEvent event = (BoundaryEvent)context.getShape().getLink().getBusinessObjects().get(0);
        List activityPictogramElements = Graphiti.getLinkService().getPictogramElements(this.getDiagram(), (EObject)event.getAttachedToRef());
        if (!singleSelection) {
            for (PictogramElement activityElement : activityPictogramElements) {
                if (!ModelUtil.isElementSelected((IDiagramContainer)this.getDiagramBehavior().getDiagramContainer(), (PictogramElement)activityElement)) continue;
                if (!ModelUtil.isElementSelected((IDiagramContainer)this.getDiagramBehavior().getDiagramContainer(), (PictogramElement)context.getPictogramElement())) {
                    context.putProperty((Object)"selection.move", (Object)false);
                    context.putProperty((Object)"activity.move", (Object)true);
                } else {
                    context.putProperty((Object)"selection.move", (Object)true);
                    context.putProperty((Object)"activity.move", (Object)false);
                }
                return true;
            }
        }
        boolean bl = movedByActivity = property != null && (Boolean)property != false;
        if (!movedByActivity && !BoundaryEventPositionHelper.canMoveTo((IMoveShapeContext)context, (Diagram)this.getDiagram())) {
            return false;
        }
        return super.canMoveShape(context);
    }

    protected boolean onMoveAlgorithmNotFound(IMoveShapeContext context) {
        return true;
    }

    protected void postMoveShape(IMoveShapeContext context) {
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        Object property = context.getProperty((Object)"activity.move");
        Object selectionFlag = context.getProperty((Object)"selection.move");
        if (property != null && ((Boolean)property).booleanValue()) {
            IGaService gaService = Graphiti.getGaService();
            GraphicsAlgorithm ga = containerShape.getGraphicsAlgorithm();
            gaService.setLocation(ga, ga.getX() + context.getDeltaX(), ga.getY() + context.getDeltaY());
        } else if (selectionFlag == null || !((Boolean)selectionFlag).booleanValue()) {
            BoundaryEvent event = (BoundaryEvent)BusinessObjectUtil.getFirstElementOfType((PictogramElement)containerShape, BoundaryEvent.class);
            PictogramElement activityContainer = BusinessObjectUtil.getFirstBaseElementFromDiagram((Diagram)this.getDiagram(), (BaseElement)event.getAttachedToRef());
            BoundaryEventPositionHelper.PositionOnLine newPos = BoundaryEventPositionHelper.getPositionOnLineUsingAbsoluteCoordinates((Shape)containerShape, (Shape)((Shape)activityContainer));
            BoundaryEventPositionHelper.assignPositionOnLineProperty((PropertyContainer)containerShape, (BoundaryEventPositionHelper.PositionOnLine)newPos);
        }
        GraphicsUtil.sendToFront((Shape)context.getShape());
        super.postMoveShape(context);
    }
}

