/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.CollapseFlowNodeFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.Messages;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.osgi.util.NLS;

public class PushdownFeature
extends AbstractCustomFeature {
    protected String description;

    public PushdownFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return Messages.PushdownFeature_Name;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = Messages.PushdownFeature_Description;
        }
        return this.description;
    }

    public String getImageId() {
        return ImageProvider.IMG_16_PUSHDOWN;
    }

    public boolean isAvailable(IContext context) {
        PictogramElement pe;
        PictogramElement[] pes;
        return context instanceof ICustomContext && (pes = ((ICustomContext)context).getPictogramElements()) != null && pes.length == 1 && !ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)(pe = pes[0]));
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe = pes[0];
            if (ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)pe)) {
                return false;
            }
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            this.description = NLS.bind((String)Messages.PushdownFeature_Description_1, (Object)ModelUtil.getLabel((Object)bo));
            if (bo instanceof Participant) {
                bo = ((Participant)bo).getProcessRef();
            }
            if (bo instanceof FlowElementsContainer) {
                return DIUtils.findBPMNDiagram((BaseElement)((BaseElement)bo)) == null;
            }
        }
        return false;
    }

    public void execute(ICustomContext context) {
        ContainerShape shape = (ContainerShape)context.getPictogramElements()[0];
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)shape);
        BPMNShape bpmnShape = null;
        if (bo instanceof Participant) {
            bpmnShape = DIUtils.findBPMNShape((BaseElement)((Participant)bo));
            bo = ((Participant)bo).getProcessRef();
        } else if (bo instanceof FlowElementsContainer) {
            bpmnShape = DIUtils.findBPMNShape((BaseElement)((FlowElementsContainer)bo));
        }
        FlowElementsContainer container = (FlowElementsContainer)bo;
        Definitions definitions = ModelUtil.getDefinitions((Object)container);
        BPMNDiagram oldBpmnDiagram = DIUtils.getBPMNDiagram((DiagramElement)bpmnShape);
        Diagram oldDiagram = DIUtils.findDiagram((IDiagramBehavior)this.getDiagramBehavior(), (BPMNDiagram)oldBpmnDiagram);
        BPMNDiagram newBpmnDiagram = DIUtils.createBPMNDiagram((Definitions)definitions, (BaseElement)container);
        BPMNPlane newPlane = newBpmnDiagram.getPlane();
        Diagram newDiagram = DIUtils.getOrCreateDiagram((IDiagramBehavior)this.getDiagramBehavior(), (BPMNDiagram)newBpmnDiagram);
        ILocation loc = Graphiti.getLayoutService().getLocationRelativeToDiagram((Shape)shape);
        ArrayList<EObject> moved = new ArrayList<EObject>();
        for (FlowElement fe : container.getFlowElements()) {
            DiagramElement de = DIUtils.findDiagramElement((EObject)fe);
            if (de == null) continue;
            newPlane.getPlaneElement().add(de);
            List pes = Graphiti.getLinkService().getPictogramElements(oldDiagram, (EObject)fe);
            for (PictogramElement pe : pes) {
                PictogramElement pictogramElement;
                block12: {
                    block10: {
                        block11: {
                            pictogramElement = null;
                            if (pe instanceof ConnectionDecorator) continue;
                            if (!(pe instanceof Shape)) break block10;
                            if (BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, BPMNShape.class) == null) break block11;
                            newDiagram.getChildren().add((Object)((Shape)pe));
                            pictogramElement = pe;
                            break block12;
                        }
                        if (!FeatureSupport.isLabelShape((PictogramElement)pe)) break block12;
                        newDiagram.getChildren().add((Object)((Shape)pe));
                        pictogramElement = pe;
                        break block12;
                    }
                    if (pe instanceof Connection && BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, BPMNEdge.class) != null) {
                        newDiagram.getConnections().add((Object)((Connection)pe));
                        pictogramElement = pe;
                        if (pe instanceof FreeFormConnection) {
                            FreeFormConnection ffc = (FreeFormConnection)pe;
                            for (Point p : ffc.getBendpoints()) {
                                p.setX(p.getX() - loc.getX());
                                p.setY(p.getY() - loc.getY());
                            }
                        }
                    }
                }
                if (pictogramElement == null) continue;
                TreeIterator iter = pictogramElement.eAllContents();
                while (iter.hasNext()) {
                    EObject o = (EObject)iter.next();
                    if (!(o instanceof PictogramLink)) continue;
                    newDiagram.getPictogramLinks().add((Object)((PictogramLink)o));
                    moved.add(o);
                }
            }
        }
        oldDiagram.getPictogramLinks().removeAll(moved);
        if (FeatureSupport.isExpandableElement((BaseElement)container)) {
            bpmnShape.setIsExpanded(true);
            CollapseFlowNodeFeature collapseFeature = new CollapseFlowNodeFeature(this.getFeatureProvider());
            collapseFeature.execute(context);
        }
    }
}

