/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import java.util.Collection;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.ExpandFlowNodeFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.Messages;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.osgi.util.NLS;

public class PullupFeature
extends AbstractCustomFeature {
    protected String description;

    public PullupFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return Messages.PullupFeature_Name;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = Messages.PullupFeature_Description;
        }
        return this.description;
    }

    public String getImageId() {
        return ImageProvider.IMG_16_PULLUP;
    }

    public boolean isAvailable(IContext context) {
        PictogramElement pe;
        PictogramElement[] pes;
        return context instanceof ICustomContext && (pes = ((ICustomContext)context).getPictogramElements()) != null && pes.length == 1 && !ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)(pe = pes[0]));
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe = pes[0];
            if (ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)pe)) {
                return false;
            }
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            this.description = NLS.bind((String)Messages.PullupFeature_Description_1, (Object)ModelUtil.getLabel((Object)bo));
            if (bo instanceof Participant) {
                bo = ((Participant)bo).getProcessRef();
            }
            if (bo instanceof FlowElementsContainer) {
                BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((BaseElement)((BaseElement)bo));
                return bpmnDiagram != null;
            }
        }
        return false;
    }

    public void execute(ICustomContext context) {
        ContainerShape shape = (ContainerShape)context.getPictogramElements()[0];
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)shape);
        BPMNShape bpmnShape = null;
        if (bo instanceof Participant) {
            bpmnShape = DIUtils.findBPMNShape((BaseElement)((Participant)bo));
            bo = ((Participant)bo).getProcessRef();
        } else if (bo instanceof FlowElementsContainer) {
            bpmnShape = DIUtils.findBPMNShape((BaseElement)((FlowElementsContainer)bo));
        }
        FlowElementsContainer container = (FlowElementsContainer)bo;
        BPMNDiagram newBpmnDiagram = DIUtils.getBPMNDiagram((DiagramElement)bpmnShape);
        BPMNPlane newPlane = newBpmnDiagram.getPlane();
        Diagram newDiagram = DIUtils.findDiagram((IDiagramBehavior)this.getDiagramBehavior(), (BPMNDiagram)newBpmnDiagram);
        BPMNDiagram oldBpmnDiagram = DIUtils.findBPMNDiagram((BaseElement)container);
        BPMNPlane oldPlane = oldBpmnDiagram.getPlane();
        Diagram oldDiagram = DIUtils.findDiagram((IDiagramBehavior)this.getDiagramBehavior(), (BPMNDiagram)oldBpmnDiagram);
        while (oldPlane.getPlaneElement().size() > 0) {
            DiagramElement de = (DiagramElement)oldPlane.getPlaneElement().get(0);
            newPlane.getPlaneElement().add(de);
        }
        ILocation loc = Graphiti.getLayoutService().getLocationRelativeToDiagram((Shape)shape);
        shape.getChildren().addAll((Collection)oldDiagram.getChildren());
        for (Connection c : oldDiagram.getConnections()) {
            if (!(c instanceof FreeFormConnection)) continue;
            FreeFormConnection ffc = (FreeFormConnection)c;
            for (Point pp : ffc.getBendpoints()) {
                pp.setX(pp.getX() + loc.getX());
                pp.setY(pp.getY() + loc.getY());
            }
        }
        newDiagram.getConnections().addAll((Collection)oldDiagram.getConnections());
        newDiagram.getPictogramLinks().addAll((Collection)oldDiagram.getPictogramLinks());
        newDiagram.getColors().addAll((Collection)oldDiagram.getColors());
        newDiagram.getFonts().addAll((Collection)oldDiagram.getFonts());
        newDiagram.getStyles().addAll((Collection)oldDiagram.getStyles());
        DIUtils.deleteDiagram((IDiagramBehavior)this.getDiagramBehavior(), (BPMNDiagram)oldBpmnDiagram);
        if (FeatureSupport.isExpandableElement((BaseElement)container)) {
            bpmnShape.setIsExpanded(false);
            ExpandFlowNodeFeature expandFeature = new ExpandFlowNodeFeature(this.getFeatureProvider());
            expandFeature.execute(context);
        }
    }
}

