/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.modeler.core.features.CustomShapeFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.IBpmn2CreateFeature;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.ui.diagram.Bpmn2ToolBehaviorProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.palette.IPaletteCompartmentEntry;
import org.eclipse.graphiti.palette.IToolEntry;
import org.eclipse.graphiti.palette.impl.ObjectCreationToolEntry;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ILayoutService;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.util.ui.PopupMenu;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractMorphNodeFeature<T extends FlowNode>
extends AbstractCustomFeature {
    protected boolean changesDone = false;
    private static ILabelProvider labelProvider = new ILabelProvider(){

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            if (element instanceof ObjectCreationToolEntry) {
                ObjectCreationToolEntry te = (ObjectCreationToolEntry)element;
                return te.getLabel();
            }
            if (element instanceof IPaletteCompartmentEntry) {
                IPaletteCompartmentEntry ce = (IPaletteCompartmentEntry)element;
                return ce.getLabel();
            }
            return "?";
        }

        public Image getImage(Object element) {
            return null;
        }
    };

    public AbstractMorphNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canExecute(ICustomContext context) {
        return this.getTools(context).size() > 0;
    }

    public boolean isAvailable(IContext context) {
        EObject o;
        PictogramElement[] pe;
        if (context instanceof ICustomContext && this.getTools((ICustomContext)context).size() > 0 && (pe = ((ICustomContext)context).getPictogramElements()).length == 1 && (o = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)pe[0])) != null) {
            return o.eClass() == this.getBusinessObjectClass();
        }
        return false;
    }

    public void execute(ICustomContext context) {
        ICreateFeature createFeature;
        ContainerShape oldShape = this.getOldShape(context);
        if (oldShape != null && (createFeature = this.selectNewShape(context)) != null) {
            ContainerShape newShape = this.createNewShape(oldShape, createFeature);
            UpdateContext updateContext = new UpdateContext((PictogramElement)newShape);
            IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)updateContext);
            if (updateFeature.updateNeeded((IUpdateContext)updateContext).toBoolean()) {
                updateFeature.update((IUpdateContext)updateContext);
            }
            this.changesDone = true;
        }
    }

    protected ContainerShape getOldShape(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe = pes[0];
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            if (pe instanceof ContainerShape && bo instanceof FlowNode) {
                return (ContainerShape)pe;
            }
        }
        return null;
    }

    protected ICreateFeature selectNewShape(ICustomContext context) {
        boolean doit;
        DiagramEditor cfr_ignored_0 = (DiagramEditor)this.getDiagramEditor();
        Bpmn2ToolBehaviorProvider toolProvider = this.getToolProvider();
        List<IToolEntry> tools = this.getTools(context);
        Object feature = null;
        boolean bl = doit = tools.size() > 0;
        if (doit) {
            LinkedHashMap categories = new LinkedHashMap();
            ArrayList<IToolEntry> uncategorizedTools = new ArrayList<IToolEntry>();
            for (IToolEntry te : tools) {
                IPaletteCompartmentEntry ce = toolProvider.getCategory(te);
                if (ce != null) {
                    List<IToolEntry> categorizedTools;
                    if (categories.containsKey(ce)) {
                        categorizedTools = (List)categories.get(ce);
                    } else {
                        categorizedTools = new ArrayList();
                        categories.put(ce, categorizedTools);
                    }
                    categorizedTools.add(te);
                    continue;
                }
                uncategorizedTools.add(te);
            }
            IToolEntry tool = tools.get(0);
            feature = ((ObjectCreationToolEntry)tool).getCreateFeature();
            if (tools.size() > 1) {
                PopupMenu popupMenu = null;
                if (categories.size() > 1) {
                    ArrayList<PopupMenu.CascadingMenu> cascadingMenus = new ArrayList<PopupMenu.CascadingMenu>();
                    for (Map.Entry entry : categories.entrySet()) {
                        PopupMenu subMenu = new PopupMenu((List)entry.getValue(), labelProvider);
                        PopupMenu.CascadingMenu cascadingMenu = new PopupMenu.CascadingMenu(entry.getKey(), subMenu);
                        cascadingMenus.add(cascadingMenu);
                    }
                    popupMenu = new PopupMenu(cascadingMenus, labelProvider);
                } else {
                    popupMenu = new PopupMenu(tools, labelProvider);
                }
                doit = popupMenu.show((Control)Display.getCurrent().getActiveShell());
                if (doit) {
                    Object result = popupMenu.getResult();
                    if (result instanceof List) {
                        for (Map.Entry o : (List)result) {
                            if (!(o instanceof IToolEntry)) continue;
                            tool = (IToolEntry)o;
                            break;
                        }
                    } else if (result instanceof IToolEntry) {
                        tool = (IToolEntry)result;
                    }
                    feature = tool == null ? null : ((ObjectCreationToolEntry)tool).getCreateFeature();
                } else {
                    feature = null;
                }
            }
        }
        return feature;
    }

    protected List<EClass> getAvailableTypes(ICustomContext context) {
        DiagramEditor editor = (DiagramEditor)this.getDiagramEditor();
        ModelEnablements enablements = (ModelEnablements)editor.getAdapter(ModelEnablements.class);
        EClass newType = this.getBusinessObjectClass();
        ArrayList<EClass> subtypes = new ArrayList<EClass>();
        ContainerShape oldShape = this.getOldShape(context);
        if (oldShape != null) {
            BaseElement oldObject = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)oldShape, BaseElement.class);
            EClass oldType = oldObject.eClass();
            for (EClassifier ec : Bpmn2Package.eINSTANCE.getEClassifiers()) {
                EList superTypes;
                if (!(ec instanceof EClass) || ((EClass)ec).isAbstract() || !(superTypes = ((EClass)ec).getEAllSuperTypes()).contains((Object)newType) || !enablements.isEnabled((EClass)ec) || ec == Bpmn2Package.eINSTANCE.getBoundaryEvent() || ec == Bpmn2Package.eINSTANCE.getStartEvent() || ec == oldType) continue;
                subtypes.add((EClass)ec);
            }
        }
        return subtypes;
    }

    protected ContainerShape createNewShape(ContainerShape oldShape, ICreateFeature createFeature) {
        ILayoutService layoutService = Graphiti.getLayoutService();
        ILocation loc = layoutService.getLocationRelativeToDiagram((Shape)oldShape);
        IDimension size = GraphicsUtil.calculateSize((PictogramElement)oldShape);
        int x = loc.getX();
        int y = loc.getY();
        ContainerShape oldContainer = oldShape.getContainer();
        if (oldContainer != null && !(oldContainer instanceof Diagram)) {
            loc = layoutService.getLocationRelativeToDiagram((Shape)oldContainer);
            x -= loc.getX();
            y -= loc.getY();
        }
        int w = size.getWidth();
        int h = size.getHeight();
        CreateContext createContext = new CreateContext();
        createContext.setTargetContainer(oldShape.getContainer());
        createContext.setLocation(x, y);
        createContext.setSize(w, h);
        createContext.putProperty((Object)"is.importing", (Object)Boolean.TRUE);
        Object[] created = createFeature.create((ICreateContext)createContext);
        FlowElement newObject = (FlowElement)created[0];
        ContainerShape newShape = (ContainerShape)created[1];
        BaseElement oldObject = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)oldShape, BaseElement.class);
        if (oldObject instanceof Lane) {
            ((Lane)oldObject).getFlowNodeRefs().add((FlowNode)newObject);
        }
        this.copyBusinessObject((FlowNode)oldObject, (FlowNode)newObject);
        ArrayList oldAnchors = new ArrayList();
        oldAnchors.addAll(oldShape.getAnchors());
        for (Anchor oldAnchor : oldAnchors) {
            ArrayList connections = new ArrayList();
            connections.addAll(oldAnchor.getIncomingConnections());
            connections.addAll(oldAnchor.getOutgoingConnections());
            for (Connection connection : connections) {
                ILocation oldLocation = Graphiti.getPeService().getLocationRelativeToDiagram(oldAnchor);
                FixPointAnchor newAnchor = AnchorUtil.createAnchor((AnchorContainer)newShape, (int)oldLocation.getX(), (int)oldLocation.getY());
                ReconnectionContext reconnectContext = new ReconnectionContext(connection, oldAnchor, (Anchor)newAnchor, oldLocation);
                reconnectContext.setTargetPictogramElement((PictogramElement)newShape);
                if (connection.getStart() == oldAnchor) {
                    reconnectContext.setReconnectType(ReconnectionContext.RECONNECT_SOURCE);
                } else {
                    reconnectContext.setReconnectType(ReconnectionContext.RECONNECT_TARGET);
                }
                IReconnectionFeature reconnectFeature = this.getFeatureProvider().getReconnectionFeature((IReconnectionContext)reconnectContext);
                if (!reconnectFeature.canReconnect((IReconnectionContext)reconnectContext)) continue;
                reconnectFeature.reconnect((IReconnectionContext)reconnectContext);
            }
        }
        DeleteContext deleteContext = new DeleteContext((PictogramElement)oldShape);
        IDeleteFeature deleteFeature = this.getFeatureProvider().getDeleteFeature((IDeleteContext)deleteContext);
        if (deleteFeature.canDelete((IDeleteContext)deleteContext)) {
            deleteFeature.delete((IDeleteContext)deleteContext);
        }
        return newShape;
    }

    protected List<Shape> getFlowElementChildren(ContainerShape containerShape) {
        ArrayList<Shape> children = new ArrayList<Shape>();
        for (Shape s : containerShape.getChildren()) {
            FlowElement bo = (FlowElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)s, FlowElement.class);
            if (!(s instanceof ContainerShape) || bo == null) continue;
            children.add(s);
        }
        return children;
    }

    protected Bpmn2ToolBehaviorProvider getToolProvider() {
        IToolBehaviorProvider[] toolProviders;
        IToolBehaviorProvider[] iToolBehaviorProviderArray = toolProviders = this.getFeatureProvider().getDiagramTypeProvider().getAvailableToolBehaviorProviders();
        int n = toolProviders.length;
        int n2 = 0;
        while (n2 < n) {
            IToolBehaviorProvider tp = iToolBehaviorProviderArray[n2];
            if (tp instanceof Bpmn2ToolBehaviorProvider) {
                return (Bpmn2ToolBehaviorProvider)tp;
            }
            ++n2;
        }
        return null;
    }

    protected List<IToolEntry> getTools(ICustomContext context) {
        ArrayList<IToolEntry> tools = new ArrayList<IToolEntry>();
        Bpmn2ToolBehaviorProvider toolProvider = this.getToolProvider();
        if (toolProvider != null) {
            List<EClass> availableTypes = this.getAvailableTypes(context);
            for (IToolEntry te : toolProvider.getTools()) {
                EClass type;
                ObjectCreationToolEntry cte;
                ICreateFeature f;
                if (!(te instanceof ObjectCreationToolEntry) || !((f = (cte = (ObjectCreationToolEntry)te).getCreateFeature()) instanceof IBpmn2CreateFeature) || f instanceof CustomShapeFeatureContainer.CreateCustomShapeFeature || !availableTypes.contains(type = ((IBpmn2CreateFeature)f).getBusinessObjectClass())) continue;
                tools.add(te);
            }
        }
        return tools;
    }

    public abstract EClass getBusinessObjectClass();

    public abstract void copyBusinessObject(T var1, T var2);

    public boolean hasDoneChanges() {
        return this.changesDone;
    }
}

