/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editors;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.command.WrapperCommandStack;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.data.DataViewTreeViewerPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.editors.IReportEditorPage;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.designer.ui.editors.LibraryLayoutEditor;
import org.eclipse.birt.report.designer.ui.views.attributes.AttributeViewPage;
import org.eclipse.birt.report.designer.ui.views.attributes.IAttributeViewPage;
import org.eclipse.birt.report.designer.ui.views.data.IDataViewPage;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.activity.ActivityStackEvent;
import org.eclipse.birt.report.model.api.activity.ActivityStackListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.part.MultiPageEditorSite;

public class LibraryLayoutEditorFormPage
extends LibraryLayoutEditor
implements IReportEditorPage {
    public static final String ID = "org.eclipse.birt.report.designer.ui.editors.library.layout";
    private int index;
    private FormEditor editor;
    private Control control;
    private int staleType;
    private boolean alreadyShow = false;
    private ActivityStackListener commandStackListener = new ActivityStackListener(){

        public void stackChanged(ActivityStackEvent event) {
            LibraryLayoutEditorFormPage.this.updateStackActions();
            LibraryLayoutEditorFormPage.this.getEditor().editorDirtyStateChanged();
            LibraryLayoutEditorFormPage.this.staleType = 1;
        }
    };

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        WrapperCommandStack stack = (WrapperCommandStack)this.getCommandStack();
        if (stack != null) {
            stack.addCommandStackListener(this.getCommandStackListener());
        }
    }

    public ActivityStackListener getCommandStackListener() {
        return this.commandStackListener;
    }

    public void initialize(FormEditor editor) {
        this.editor = editor;
    }

    public FormEditor getEditor() {
        return this.editor;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.initialize((FormEditor)((MultiPageEditorSite)site).getMultiPageEditor());
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    public void setActive(boolean active) {
    }

    public boolean isActive() {
        return false;
    }

    public boolean canLeaveThePage() {
        return true;
    }

    public Control getPartControl() {
        return this.control;
    }

    public String getId() {
        return ID;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isEditor() {
        return true;
    }

    public boolean selectReveal(Object object) {
        return false;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Control[] children = parent.getChildren();
        this.control = children[children.length - 1];
    }

    public boolean onBroughtToTop(IReportEditorPage page) {
        GraphicalViewer view;
        String prompt = ReportPlugin.getDefault().getPreferenceStore().getString("designer.library.preference.libraries.warning.preferencestore");
        if (!(this.alreadyShow || prompt != null && ReportPlugin.getDefault().getPreferenceStore().getString("designer.library.preference.libraries.warning.preferencestore").equals("never"))) {
            this.alreadyShow = true;
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"LibraryLayoutEditorFormPage.warning.title"), (String)Messages.getString((String)"LibraryLayoutEditorFormPage.warning.message"), (String)Messages.getString((String)"LibraryLayoutEditorFormPage.warning.prompt"), (boolean)false, (IPreferenceStore)ReportPlugin.getDefault().getPreferenceStore(), (String)"designer.library.preference.libraries.warning.preferencestore");
            if (dialog.getToggleState()) {
                ReportPlugin.getDefault().getPreferenceStore().setValue("designer.library.preference.libraries.warning.preferencestore", "never");
            }
        }
        ModuleHandle newModel = this.getProvider().queryReportModuleHandle();
        boolean reload = false;
        if (this.getStaleType() == 4) {
            this.setModel(null);
            this.doSave(null);
            reload = true;
        }
        if (newModel != null && this.getModel() != newModel || reload) {
            ModuleHandle oldModel = this.getModel();
            this.setModel(newModel);
            this.rebuildReportDesign(oldModel);
            if (this.getModel() != null) {
                this.getGraphicalViewer().setContents((Object)this.getModel());
                this.hookModelEventManager(this.getModel());
                this.markPageStale(0);
            }
            this.updateStackActions();
        }
        if ((view = this.getGraphicalViewer()) != null) {
            UIUtil.resetViewSelection((EditPartViewer)view, (boolean)true);
        }
        return true;
    }

    protected void rebuildReportDesign(ModuleHandle oldModel) {
        WrapperCommandStack stack = (WrapperCommandStack)this.getCommandStack();
        if (stack != null) {
            stack.removeCommandStackListener(this.getCommandStackListener());
            stack.setActivityStack(this.getModel().getCommandStack());
            stack.addCommandStackListener(this.getCommandStackListener());
        }
        SessionHandleAdapter.getInstance().resetReportDesign(oldModel, this.getModel());
        SessionHandleAdapter.getInstance().setReportDesignHandle(this.getModel());
        UIUtil.processSessionResourceFolder((IEditorInput)this.getEditorInput(), (IProject)UIUtil.getProjectFromInput((IEditorInput)this.getEditorInput()), (ModuleHandle)this.getModel());
    }

    public void dispose() {
        if (this.getCommandStack() != null && this.getCommandStack() instanceof WrapperCommandStack) {
            WrapperCommandStack stack = (WrapperCommandStack)this.getCommandStack();
            stack.removeCommandStackListener(this.getCommandStackListener());
        }
        super.dispose();
    }

    public void markPageStale(int type) {
        this.staleType = type;
    }

    public int getStaleType() {
        return this.staleType;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IDataViewPage.class) {
            DataViewTreeViewerPage page = new DataViewTreeViewerPage(this.getModel());
            this.getModelEventManager().addModelEventProcessor(page.getModelProcessor());
            return page;
        }
        if (adapter == IAttributeViewPage.class) {
            AttributeViewPage page = new AttributeViewPage(this.getModel());
            return page;
        }
        return super.getAdapter(adapter);
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
    }

    protected IReportProvider getProvider() {
        return (IReportProvider)this.editor.getAdapter(IReportProvider.class);
    }

    protected void firePropertyChange(int type) {
        if (type == 257) {
            this.editor.editorDirtyStateChanged();
        } else {
            super.firePropertyChange(type);
        }
    }
}

