/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.mapping.factory.ITreeToRelationalMapper;
import org.teiid.designer.mapping.factory.MappingClassBuilderStrategy;
import org.teiid.designer.mapping.factory.MappingClassFactory;
import org.teiid.designer.mapping.factory.ModelMapperFactory;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.metamodels.xml.XmlDocumentBuilderImpl;
import org.teiid.designer.metamodels.xml.XmlDocumentFactory;
import org.teiid.designer.metamodels.xml.XmlElement;
import org.teiid.designer.metamodels.xml.XmlFragment;
import org.teiid.designer.metamodels.xml.XmlRoot;
import org.teiid.designer.metamodels.xml.util.XmlDocumentUtil;
import org.teiid.designer.metamodels.xsd.XsdUtil;
import org.teiid.designer.xml.PluginConstants;
import org.teiid.designer.xml.factory.IDocumentsAndFragmentsPopulator;

public class VirtualDocumentModelPopulator
implements IDocumentsAndFragmentsPopulator,
PluginConstants {
    private static final XmlFragment[] EMPTY_DOC_ARRAY = new XmlFragment[0];
    private static final String TXN_NAME = Util.getString("VirtualDocumentModelPopulator.transactionName", new Object[0]);
    private static final String DOCUMENT = Util.getString("VirtualDocumentModelPopulator.document", new Object[0]);
    private static final String FRAGMENT = Util.getString("VirtualDocumentModelPopulator.fragment", new Object[0]);
    private static final String DOC_ERROR_MSG = Util.getString("VirtualDocumentModelPopulator.documentErrorMessage", new Object[0]);
    private static final String FRAG_ERROR_MSG = Util.getString("VirtualDocumentModelPopulator.fragmentErrorMessage", new Object[0]);
    private IFile schemaModel;
    private Collection unhandledModelImports = new HashSet();
    private Collection allRootElements = new ArrayList();
    private Collection selectedRootElements = new ArrayList();
    private Collection allComplexTypes = new ArrayList();
    private Collection selectedComplexTypes = new ArrayList();
    private Set accumulatedDatatypes = new HashSet();
    private int estimatedNodeCount;
    private boolean doNotBuildDuplicates = false;

    public VirtualDocumentModelPopulator(IFile schemaModel) {
        this.schemaModel = schemaModel;
        this.populateLists();
    }

    public VirtualDocumentModelPopulator(List initialRootElements) {
        if (initialRootElements != null && !initialRootElements.isEmpty()) {
            EObject firstRoot = (EObject)initialRootElements.get(0);
            ModelResource mr = null;
            try {
                mr = ModelUtil.getModel((Object)firstRoot);
                if (mr != null) {
                    this.schemaModel = (IFile)mr.getUnderlyingResource();
                }
            }
            catch (ModelWorkspaceException modelWorkspaceException) {}
        }
        this.setSelectedDocuments(initialRootElements);
    }

    private void populateLists() {
        try {
            URI uri = URI.createFileURI((String)ModelUtil.getLocation((IResource)this.schemaModel).toString());
            Resource resource = ModelerCore.getModelContainer().getResource(uri, true);
            for (Object obj : resource.getContents()) {
                if (!(obj instanceof XSDSchema)) continue;
                EList elements = ((XSDSchema)obj).getElementDeclarations();
                for (XSDElementDeclaration elemDecl : elements) {
                    this.allRootElements.add(elemDecl);
                }
                EList types = ((XSDSchema)obj).getTypeDefinitions();
                for (XSDTypeDefinition typeDefn : types) {
                    if (!(typeDefn instanceof XSDComplexTypeDefinition)) continue;
                    this.allComplexTypes.add(typeDefn);
                }
            }
        }
        catch (Exception e) {
            Util.log((Throwable)e);
        }
    }

    @Override
    public Object getItem() {
        return this.schemaModel;
    }

    @Override
    public String getItemName() {
        return this.schemaModel.getFullPath().toOSString();
    }

    @Override
    public Collection getInitialAvailableDocuments() {
        return this.allRootElements;
    }

    @Override
    public Collection getSelectedDocuments() {
        return this.selectedRootElements;
    }

    @Override
    public Collection getInitialAvailableFragments() {
        return this.allComplexTypes;
    }

    @Override
    public Collection getSelectedFragments() {
        return this.selectedComplexTypes;
    }

    @Override
    public void setSelectedDocuments(Collection selectedItems) {
        this.selectedRootElements = selectedItems;
    }

    public void setAccumulatedDatatypes(Set accumulatedDatatypes) {
        this.accumulatedDatatypes = accumulatedDatatypes;
    }

    public Set getAccumulatedDatatypes() {
        if (this.accumulatedDatatypes != null) {
            return this.accumulatedDatatypes;
        }
        return new HashSet(0);
    }

    @Override
    public void setSelectedFragments(Collection selectedItems) {
        this.selectedComplexTypes = selectedItems;
    }

    @Override
    public XmlFragment[] buildModel(ModelResource modelResource, boolean buildEntireDocument, boolean buildMappingClasses, MappingClassBuilderStrategy strategy, IProgressMonitor progressMonitor) {
        XmlDocumentBuilderImpl builder;
        IProgressMonitor monitor;
        ArrayList<Object> rv;
        block36: {
            rv = new ArrayList<Object>(this.selectedComplexTypes.size() + this.selectedRootElements.size());
            this.estimatedNodeCount = 0;
            monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
            try {
                URI uri = URI.createFileURI((String)ModelUtil.getLocation((IResource)this.schemaModel).toString());
                Resource xsdResource = ModelerCore.getModelContainer().getResource(uri, true);
                if (xsdResource != null) {
                    XsdUtil.resolveSchemaDirectives((Resource)xsdResource);
                }
            }
            catch (Exception e) {
                Util.log((Throwable)e);
            }
            builder = new XmlDocumentBuilderImpl();
            XmlDocumentFactory factory = XmlDocumentFactory.eINSTANCE;
            ArrayList<XmlRoot> fragmentRoots = new ArrayList<XmlRoot>();
            boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)TXN_NAME, (Object)this);
            boolean succeeded = false;
            try {
                try {
                    String message;
                    XmlDocument document;
                    String suggestedName;
                    Resource resource = modelResource != null ? modelResource.getEmfResource() : null;
                    Iterator iter = this.selectedComplexTypes.iterator();
                    while (iter.hasNext()) {
                        if (monitor.isCanceled()) break;
                        XSDComplexTypeDefinition schemaComplexType = (XSDComplexTypeDefinition)iter.next();
                        try {
                            suggestedName = String.valueOf(schemaComplexType.getName()) + FRAGMENT;
                            if (this.shouldBuildDocument(modelResource, suggestedName)) {
                                XmlFragment fragment = factory.createXmlFragment();
                                fragment.setName(String.valueOf(schemaComplexType.getName()) + FRAGMENT);
                                if (resource != null) {
                                    resource.getContents().add((Object)fragment);
                                }
                                XmlRoot docRoot = factory.createXmlRoot();
                                docRoot.setName(schemaComplexType.getName());
                                docRoot.setXsdComponent((XSDComponent)schemaComplexType);
                                fragment.setRoot(docRoot);
                                if (buildEntireDocument) {
                                    this.estimatedNodeCount += builder.buildDocument((XmlElement)docRoot, monitor);
                                    fragmentRoots.add(docRoot);
                                    if (buildMappingClasses) {
                                        this.buildMappingClasses(fragment, strategy);
                                        System.gc();
                                        Thread.yield();
                                    }
                                } else {
                                    XmlDocumentUtil.setIncomplete((Object)docRoot, (boolean)true);
                                    ++this.estimatedNodeCount;
                                }
                                rv.add(fragment);
                                continue;
                            }
                            document = this.getExistingDocument(modelResource, suggestedName);
                            if (document == null) continue;
                            rv.add(document);
                        }
                        catch (Exception e) {
                            message = String.valueOf(FRAG_ERROR_MSG) + '\n' + schemaComplexType.getName();
                            Util.log(4, (Throwable)e, message);
                        }
                    }
                    System.gc();
                    Thread.yield();
                    iter = this.selectedRootElements.iterator();
                    while (iter.hasNext()) {
                        if (monitor.isCanceled()) break;
                        XSDElementDeclaration schemaRootElement = (XSDElementDeclaration)iter.next();
                        try {
                            suggestedName = String.valueOf(schemaRootElement.getName()) + DOCUMENT;
                            if (this.shouldBuildDocument(modelResource, suggestedName)) {
                                document = factory.createXmlDocument();
                                if (resource != null) {
                                    ModelerCore.getModelEditor().addValue((Object)resource, (Object)document, resource.getContents());
                                }
                                String baseName = String.valueOf(schemaRootElement.getName()) + DOCUMENT;
                                String newName = this.generateInitialUniqueName((EObject)document, baseName);
                                document.setName(newName);
                                XmlRoot docRoot = factory.createXmlRoot();
                                docRoot.setName(schemaRootElement.getName());
                                docRoot.setXsdComponent((XSDComponent)schemaRootElement);
                                document.setRoot(docRoot);
                                if (buildEntireDocument) {
                                    this.estimatedNodeCount += builder.buildDocument((XmlElement)docRoot, monitor);
                                    if (buildMappingClasses) {
                                        this.buildMappingClasses((XmlFragment)document, strategy);
                                        System.gc();
                                        Thread.yield();
                                    }
                                } else {
                                    XmlDocumentUtil.setIncomplete((Object)docRoot, (boolean)true);
                                    ++this.estimatedNodeCount;
                                }
                                rv.add(document);
                                continue;
                            }
                            document = this.getExistingDocument(modelResource, suggestedName);
                            if (document == null) continue;
                            rv.add(document);
                        }
                        catch (Exception e) {
                            message = String.valueOf(DOC_ERROR_MSG) + '\n' + schemaRootElement.getName();
                            Util.log(4, (Throwable)e, message);
                        }
                    }
                    System.gc();
                    Thread.yield();
                    succeeded = true;
                }
                catch (ModelWorkspaceException e) {
                    Util.log((Throwable)e);
                    if (startedTxn) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    monitor.done();
                    System.gc();
                    Thread.yield();
                    break block36;
                }
            }
            catch (Throwable throwable) {
                if (startedTxn) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                monitor.done();
                System.gc();
                Thread.yield();
                throw throwable;
            }
            if (startedTxn) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
            monitor.done();
            System.gc();
            Thread.yield();
        }
        this.unhandledModelImports = builder.getUnhandledModelImports();
        builder = null;
        if (modelResource != null) {
            try {
                modelResource.save(monitor, true);
                modelResource.getEmfResource().setModified(false);
                System.gc();
                Thread.yield();
            }
            catch (ModelWorkspaceException e) {
                Util.log((Throwable)e);
            }
        }
        return rv.toArray(EMPTY_DOC_ARRAY);
    }

    private String generateInitialUniqueName(EObject eObject, String proposedName) {
        String newName = proposedName;
        EStructuralFeature nameFeature = ModelerCore.getModelEditor().getNameFeature(eObject);
        if (nameFeature != null && eObject.eResource() != null) {
            EList siblings = null;
            siblings = eObject.eContainer() == null ? eObject.eResource().getContents() : eObject.eContainer().eContents();
            if (siblings != null && !siblings.isEmpty() && eObject.eGet(nameFeature) == null) {
                HashSet<Object> siblingNames = new HashSet<Object>();
                for (EObject child : siblings) {
                    if (!eObject.getClass().equals(child.getClass())) continue;
                    siblingNames.add(child.eGet(nameFeature));
                }
                boolean foundUniqueName = false;
                int index = 1;
                while (!foundUniqueName) {
                    if (siblingNames.contains(newName)) {
                        newName = String.valueOf(proposedName) + String.valueOf(index++);
                        continue;
                    }
                    foundUniqueName = true;
                }
            }
        }
        return newName;
    }

    @Override
    public Collection getUnhandledModelImports() {
        if (this.unhandledModelImports == null) {
            this.unhandledModelImports = new HashSet();
        }
        return this.unhandledModelImports;
    }

    @Override
    public void buildMappingClasses(XmlFragment treeNode, MappingClassBuilderStrategy strategy) {
        XmlRoot docRoot = treeNode.getRoot();
        ITreeToRelationalMapper mapper = ModelMapperFactory.createModelMapper((EObject)treeNode);
        this.getAccumulatedDatatypes().addAll(new MappingClassFactory(mapper).generateMappingClasses((EObject)docRoot, strategy, true));
    }

    @Override
    public int getLastEstimatedNodeCount() {
        return this.estimatedNodeCount;
    }

    public void setDoNotBuildDuplicates(boolean theDoNotBuildDuplicates) {
        this.doNotBuildDuplicates = theDoNotBuildDuplicates;
    }

    private boolean shouldBuildDocument(ModelResource modelResource, String newDocName) {
        if (newDocName != null && this.doNotBuildDuplicates) {
            List rootObjs = null;
            try {
                rootObjs = modelResource.getAllRootEObjects();
            }
            catch (ModelWorkspaceException theException) {
                Util.log((Throwable)theException);
            }
            if (rootObjs != null && !rootObjs.isEmpty()) {
                Iterator iter = rootObjs.iterator();
                Object nextObj = null;
                while (iter.hasNext()) {
                    String docName;
                    nextObj = iter.next();
                    if (!(nextObj instanceof XmlDocument) || (docName = ModelerCore.getModelEditor().getName((EObject)nextObj)) == null || !docName.equalsIgnoreCase(newDocName)) continue;
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private XmlDocument getExistingDocument(ModelResource modelResource, String newDocName) {
        if (newDocName != null && this.doNotBuildDuplicates) {
            List rootObjs = null;
            try {
                rootObjs = modelResource.getAllRootEObjects();
            }
            catch (ModelWorkspaceException theException) {
                Util.log((Throwable)theException);
            }
            if (rootObjs != null && !rootObjs.isEmpty()) {
                Iterator iter = rootObjs.iterator();
                Object nextObj = null;
                while (iter.hasNext()) {
                    String docName;
                    nextObj = iter.next();
                    if (!(nextObj instanceof XmlDocument) || (docName = ModelerCore.getModelEditor().getName((EObject)nextObj)) == null || !docName.equalsIgnoreCase(newDocName)) continue;
                    return nextObj;
                }
            }
        }
        return null;
    }
}

