/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.bpmn2.component;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMFactory;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMImplementationType;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMPackage;
import org.switchyard.tools.models.switchyard1_0.bpm.RemoteJmsType;
import org.switchyard.tools.ui.bpmn2.component.BpmExtraJaxbClassesTable;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.property.AbstractChangeAwareModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;
import org.switchyard.tools.ui.editor.util.PropTypeUtil;

public class RemoteJMSContainerDetailsComposite
extends AbstractChangeAwareModelComposite<BPMImplementationType> {
    private static final Pattern GAV_PATTERN = Pattern.compile("([^: ]*)(:([^: ]*)(:([^: ]*))?)?");
    private RemoteJmsType _remoteJMS = null;
    private boolean _updating = false;
    private Text _deploymentIdText;
    private Text _userNameText;
    private Text _passwordText;
    private Text _timeoutText;
    private Combo _useSSLCombo;
    private Text _hostNameText;
    private Text _keystorePasswordText;
    private Text _keystoreLocationText;
    private Text _truststorePasswordText;
    private Text _truststoreLocationText;
    private Text _remotingPortText;
    private Text _messagingPortText;
    private boolean _usesSSL = false;
    private BpmExtraJaxbClassesTable _extraJaxbClassesTable;

    private void handleTextChange(Text text, final EObject eobj, final EStructuralFeature feature) {
        String newValue;
        String string = newValue = text.getText().length() == 0 ? null : text.getText();
        if (!this._updating && (newValue == null && eobj.eGet(feature) != null || newValue != null && !newValue.equals(eobj.eGet(feature)))) {
            this.wrapOperation(new Runnable(){

                @Override
                public void run() {
                    eobj.eSet(feature, (Object)newValue);
                }
            });
            this.fireChangedEvent((Object)this);
            if (this.getContainer() != null) {
                this.getContainer().validated(this.validate());
            }
        }
    }

    private void handleComboChange(Combo combo, final EObject eobj, final EStructuralFeature feature) {
        String newValue;
        String string = newValue = combo.getText().length() == 0 ? null : combo.getText();
        if (!this._updating && (newValue == null && eobj.eGet(feature) != null || newValue != null && !newValue.equals(eobj.eGet(feature)))) {
            this._usesSSL = newValue != null ? !newValue.equals("false") : false;
            this.wrapOperation(new Runnable(){

                @Override
                public void run() {
                    eobj.eSet(feature, (Object)newValue);
                }
            });
            this.updateSSLFields();
            this.fireChangedEvent((Object)this);
            if (this.getContainer() != null) {
                this.getContainer().validated(this.validate());
            }
        }
    }

    private void updateSSLFields() {
        this._keystoreLocationText.setEnabled(this._usesSSL);
        this._keystorePasswordText.setEnabled(this._usesSSL);
        this._truststoreLocationText.setEnabled(this._usesSSL);
        this._truststorePasswordText.setEnabled(this._usesSSL);
        if (!this._updating && !this._usesSSL) {
            this.wrapOperation(new Runnable(){

                @Override
                public void run() {
                    if (!RemoteJMSContainerDetailsComposite.this._keystoreLocationText.getText().isEmpty()) {
                        RemoteJMSContainerDetailsComposite.this._keystoreLocationText.setText("");
                        RemoteJMSContainerDetailsComposite.this.getRemoteJMS().setKeystoreLocation(null);
                    }
                    if (!RemoteJMSContainerDetailsComposite.this._keystorePasswordText.getText().isEmpty()) {
                        RemoteJMSContainerDetailsComposite.this._keystorePasswordText.setText("");
                        RemoteJMSContainerDetailsComposite.this.getRemoteJMS().setKeystorePassword(null);
                    }
                    if (!RemoteJMSContainerDetailsComposite.this._truststoreLocationText.getText().isEmpty()) {
                        RemoteJMSContainerDetailsComposite.this._truststoreLocationText.setText("");
                        RemoteJMSContainerDetailsComposite.this.getRemoteJMS().setTruststoreLocation(null);
                    }
                    if (!RemoteJMSContainerDetailsComposite.this._truststorePasswordText.getText().isEmpty()) {
                        RemoteJMSContainerDetailsComposite.this._truststorePasswordText.setText("");
                        RemoteJMSContainerDetailsComposite.this.getRemoteJMS().setTruststorePassword(null);
                    }
                }
            });
        }
    }

    private void addModifyText(Control control, final EStructuralFeature feature) {
        if (control instanceof Text) {
            final Text text = (Text)control;
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RemoteJMSContainerDetailsComposite.this.handleTextChange(text, (EObject)RemoteJMSContainerDetailsComposite.this.getRemoteJMS(), feature);
                }
            });
        } else if (control instanceof Combo) {
            final Combo combo = (Combo)control;
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RemoteJMSContainerDetailsComposite.this.handleComboChange(combo, (EObject)RemoteJMSContainerDetailsComposite.this.getRemoteJMS(), feature);
                }
            });
        }
    }

    public RemoteJMSContainerDetailsComposite(ICompositeContainer container, Composite parent, int style, FormToolkit factory) {
        super(BPMImplementationType.class, container, parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        Composite deploymentIdComposite = factory.createComposite((Composite)this);
        deploymentIdComposite.setLayout((Layout)new GridLayout(2, false));
        deploymentIdComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        factory.createLabel(deploymentIdComposite, "Deployment ID");
        this._deploymentIdText = factory.createText(deploymentIdComposite, "", 2048);
        this._deploymentIdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addModifyText((Control)this._deploymentIdText, (EStructuralFeature)BPMPackage.eINSTANCE.getRemoteType_DeploymentId());
        Group jmsGroup = new Group((Composite)this, 0);
        jmsGroup.setText("JMS Details");
        jmsGroup.setLayout((Layout)new GridLayout(2, false));
        jmsGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 4));
        jmsGroup.setToolTipText("Details for the remote resources location");
        factory.createLabel((Composite)jmsGroup, "Host Name");
        this._hostNameText = factory.createText((Composite)jmsGroup, "", 2048);
        this._hostNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addModifyText((Control)this._hostNameText, (EStructuralFeature)BPMPackage.eINSTANCE.getRemoteJmsType_HostName());
        factory.createLabel((Composite)jmsGroup, "Remoting Port");
        this._remotingPortText = factory.createText((Composite)jmsGroup, "", 2048);
        this._remotingPortText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addModifyText((Control)this._remotingPortText, (EStructuralFeature)BPMPackage.eINSTANCE.getRemoteJmsType_RemotingPort());
        factory.createLabel((Composite)jmsGroup, "Messaging Port");
        this._messagingPortText = factory.createText((Composite)jmsGroup, "", 2048);
        this._messagingPortText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addModifyText((Control)this._messagingPortText, (EStructuralFeature)BPMPackage.eINSTANCE.getRemoteJmsType_MessagingPort());
        factory.createLabel((Composite)jmsGroup, "User Name");
        this._userNameText = factory.createText((Composite)jmsGroup, "", 2048);
        this._userNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addModifyText((Control)this._userNameText, (EStructuralFeature)BPMPackage.eINSTANCE.getRemoteType_UserName());
        factory.createLabel((Composite)jmsGroup, "Password");
        this._passwordText = factory.createText((Composite)jmsGroup, "", 2048);
        this._passwordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._passwordText.setEchoChar('*');
        this.addModifyText((Control)this._passwordText, (EStructuralFeature)BPMPackage.eINSTANCE.getRemoteType_Password());
        factory.createLabel((Composite)jmsGroup, "Timeout");
        this._timeoutText = factory.createText((Composite)jmsGroup, "", 2048);
        this._timeoutText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addModifyText((Control)this._timeoutText, (EStructuralFeature)BPMPackage.eINSTANCE.getRemoteType_Timeout());
        Group secureGroup = new Group((Composite)this, 0);
        secureGroup.setText("SSL Details");
        secureGroup.setLayout((Layout)new GridLayout(2, false));
        secureGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 4));
        secureGroup.setToolTipText("Details for the remote JMS resources location");
        factory.createLabel((Composite)secureGroup, "Use SSL");
        this._useSSLCombo = new Combo((Composite)secureGroup, 2052);
        factory.adapt((Composite)this._useSSLCombo);
        this._useSSLCombo.add("true");
        this._useSSLCombo.add("false");
        this._useSSLCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addModifyText((Control)this._useSSLCombo, (EStructuralFeature)BPMPackage.eINSTANCE.getRemoteJmsType_UseSsl());
        factory.createLabel((Composite)secureGroup, "Keystore Password");
        this._keystorePasswordText = factory.createText((Composite)secureGroup, "", 2048);
        this._keystorePasswordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._keystorePasswordText.setEchoChar('*');
        this.addModifyText((Control)this._keystorePasswordText, (EStructuralFeature)BPMPackage.eINSTANCE.getRemoteJmsType_KeystorePassword());
        factory.createLabel((Composite)secureGroup, "Keystore Location");
        this._keystoreLocationText = factory.createText((Composite)secureGroup, "", 2048);
        this._keystoreLocationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addModifyText((Control)this._keystoreLocationText, (EStructuralFeature)BPMPackage.eINSTANCE.getRemoteJmsType_KeystoreLocation());
        factory.createLabel((Composite)secureGroup, "Truststore Password");
        this._truststorePasswordText = factory.createText((Composite)secureGroup, "", 2048);
        this._truststorePasswordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._truststorePasswordText.setEchoChar('*');
        this.addModifyText((Control)this._truststorePasswordText, (EStructuralFeature)BPMPackage.eINSTANCE.getRemoteJmsType_TruststorePassword());
        factory.createLabel((Composite)secureGroup, "Truststore Location");
        this._truststoreLocationText = factory.createText((Composite)secureGroup, "", 2048);
        this._truststoreLocationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addModifyText((Control)this._truststoreLocationText, (EStructuralFeature)BPMPackage.eINSTANCE.getRemoteJmsType_TruststoreLocation());
        Composite actionsComposite = factory.createComposite((Composite)this);
        actionsComposite.setLayout((Layout)new GridLayout());
        GridData tableGD = new GridData(4, 4, true, true, 2, 4);
        actionsComposite.setLayoutData((Object)tableGD);
        Section actionsSection = factory.createSection(actionsComposite, 320);
        actionsSection.setText("Extra JAXB Classes");
        actionsSection.setLayout((Layout)new GridLayout());
        actionsSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this._extraJaxbClassesTable = new BpmExtraJaxbClassesTable((Composite)actionsSection, 0);
        this._extraJaxbClassesTable.setLayoutData(new GridData(4, 4, true, true));
        factory.adapt((Composite)this._extraJaxbClassesTable);
        actionsSection.setClient((Control)this._extraJaxbClassesTable);
    }

    public void setRemoteJMS(RemoteJmsType remoteJMS) {
        if (remoteJMS == null) {
            remoteJMS = BPMFactory.eINSTANCE.createRemoteJmsType();
        }
        this._remoteJMS = remoteJMS;
        this._updating = true;
        this._deploymentIdText.setText(this._remoteJMS.getDeploymentId() == null ? "" : this._remoteJMS.getDeploymentId());
        this._hostNameText.setText(this._remoteJMS.getHostName() == null ? "" : this._remoteJMS.getHostName());
        String remotingPortValue = PropTypeUtil.getPropValueString((Object)this._remoteJMS.getRemotingPort());
        this._remotingPortText.setText(remotingPortValue == null ? "" : remotingPortValue);
        String messagingPortValue = PropTypeUtil.getPropValueString((Object)this._remoteJMS.getMessagingPort());
        this._messagingPortText.setText(messagingPortValue == null ? "" : messagingPortValue);
        String sslValue = PropTypeUtil.getPropValueString((Object)this._remoteJMS.getUseSsl());
        this._usesSSL = sslValue != null ? !sslValue.equals("false") : false;
        this._useSSLCombo.setText(sslValue == null ? "" : sslValue);
        this._keystoreLocationText.setText(this._remoteJMS.getKeystoreLocation() == null ? "" : this._remoteJMS.getKeystoreLocation());
        this._keystorePasswordText.setText(this._remoteJMS.getKeystorePassword() == null ? "" : this._remoteJMS.getKeystorePassword());
        this._passwordText.setText(this._remoteJMS.getPassword() == null ? "" : this._remoteJMS.getPassword());
        String timeoutValue = PropTypeUtil.getPropValueString((Object)this._remoteJMS.getTimeout());
        this._timeoutText.setText(timeoutValue == null ? "" : timeoutValue);
        this._truststoreLocationText.setText(this._remoteJMS.getTruststoreLocation() == null ? "" : this._remoteJMS.getTruststoreLocation());
        this._truststorePasswordText.setText(this._remoteJMS.getTruststorePassword() == null ? "" : this._remoteJMS.getTruststorePassword());
        this._userNameText.setText(this._remoteJMS.getUserName() == null ? "" : this._remoteJMS.getUserName());
        this._extraJaxbClassesTable.setTargetObject((EObject)this._remoteJMS);
        this.updateSSLFields();
        this._updating = false;
    }

    public RemoteJmsType getRemoteJMS() {
        return this._remoteJMS;
    }

    protected void wrapOperation(final Runnable runner) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this._remoteJMS);
        if (domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    try {
                        runner.run();
                    }
                    catch (Exception e) {
                        Activator.logError((Exception)e);
                    }
                }
            });
        } else {
            try {
                runner.run();
            }
            catch (Exception e) {
                Activator.logError((Exception)e);
            }
        }
    }

    public void refresh() {
        if (((BPMImplementationType)this.getTargetObject()).getManifest() != null) {
            this.setRemoteJMS(((BPMImplementationType)this.getTargetObject()).getManifest().getRemoteJms());
        }
    }

    public IStatus validate() {
        String errMessage = null;
        if (this._remoteJMS != null) {
            if (this._remoteJMS.getDeploymentId() == null || this._remoteJMS.getDeploymentId().trim().isEmpty()) {
                errMessage = "Deployment ID must be specified.";
            } else if (!this._remoteJMS.getDeploymentId().matches(GAV_PATTERN.toString())) {
                errMessage = "Deployment ID must be specified in the GAV pattern - 'groupID:artifactId:version'.";
            }
        }
        if (errMessage != null) {
            return new Status(4, "org.switchyard.tools.ui.editor", errMessage);
        }
        return Status.OK_STATUS;
    }
}

