/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.bpmn2.component;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMFactory;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMImplementationType;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMOperationType;
import org.switchyard.tools.models.switchyard1_0.bpm.OperationType;
import org.switchyard.tools.ui.bpmn2.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.TableColumnLayout;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class BPMActionTable
extends Composite
implements ICellModifier {
    private TableViewer _propertyTreeTable;
    public static final String TYPE_COLUMN = "type";
    public static final String OPERATION_COLUMN = "operation";
    public static final String EVENT_ID_COLUMN = "eventId";
    private static final String[] TREE_COLUMNS = new String[]{"operation", "type", "eventId"};
    private Button _mAddButton;
    private Button _mRemoveButton;
    private boolean _isReadOnly = false;
    private EObject _targetObj = null;
    private String _mWarning = null;
    private ListenerList _changeListeners;

    public BPMActionTable(Composite parent, int style) {
        this(parent, style, false);
    }

    public BPMActionTable(Composite parent, int style, boolean isReadOnly) {
        super(parent, style);
        this._isReadOnly = isReadOnly;
        this._changeListeners = new ListenerList();
        int additionalStyles = 0;
        if (isReadOnly) {
            additionalStyles = 8;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Composite tableComposite = new Composite((Composite)this, additionalStyles);
        GridData gd11 = new GridData(4, 4, true, true, 1, 2);
        gd11.heightHint = 100;
        tableComposite.setLayoutData((Object)gd11);
        this._propertyTreeTable = new TableViewer(tableComposite, 0x10A40 | additionalStyles);
        this._propertyTreeTable.getTable().setHeaderVisible(true);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        TableColumn operationColumn = new TableColumn(this._propertyTreeTable.getTable(), 16384);
        operationColumn.setText(Messages.label_operation);
        tableLayout.setColumnData((Widget)operationColumn, (ColumnLayoutData)new ColumnWeightData(100, 150, true));
        TableColumn typeColumn = new TableColumn(this._propertyTreeTable.getTable(), 16384);
        typeColumn.setText(Messages.label_type);
        tableLayout.setColumnData((Widget)typeColumn, (ColumnLayoutData)new ColumnWeightData(100, 150, true));
        TableColumn eventIdColumn = new TableColumn(this._propertyTreeTable.getTable(), 16384);
        eventIdColumn.setText(Messages.label_eventId);
        tableLayout.setColumnData((Widget)eventIdColumn, (ColumnLayoutData)new ColumnWeightData(100, 150, true));
        this._propertyTreeTable.setColumnProperties(TREE_COLUMNS);
        this._propertyTreeTable.setLabelProvider((IBaseLabelProvider)new PropertyTreeLabelProvider());
        this._propertyTreeTable.setContentProvider((IContentProvider)new PropertyTreeContentProvider());
        this._propertyTreeTable.setCellModifier((ICellModifier)this);
        this._propertyTreeTable.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this._propertyTreeTable.getTable()), new ComboBoxCellEditor((Composite)this._propertyTreeTable.getTable(), new String[]{OperationType.STARTPROCESS.getLiteral(), OperationType.SIGNALEVENT.getLiteral(), OperationType.SIGNALEVENTALL.getLiteral(), OperationType.ABORTPROCESSINSTANCE.getLiteral()}), new TextCellEditor((Composite)this._propertyTreeTable.getTable())});
        this._mAddButton = new Button((Composite)this, 0);
        this._mAddButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this._mAddButton.setText(Messages.button_add);
        this._mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BPMActionTable.this.addPropertyToList();
                if (BPMActionTable.this._propertyTreeTable.getInput() == null) {
                    BPMActionTable.this._propertyTreeTable.setInput((Object)BPMActionTable.this._targetObj);
                }
                BPMActionTable.this._propertyTreeTable.refresh();
                BPMActionTable.this.fireChangedEvent(e.getSource());
            }
        });
        this._mAddButton.setEnabled(false);
        this._propertyTreeTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BPMActionTable.this.updatePropertyButtons();
            }
        });
        this._mRemoveButton = new Button((Composite)this, 0);
        this._mRemoveButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this._mRemoveButton.setText(Messages.button_remove);
        this._mRemoveButton.setEnabled(false);
        this._mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BPMActionTable.this.removeFromList();
                BPMActionTable.this._propertyTreeTable.refresh();
                BPMActionTable.this.fireChangedEvent(e.getSource());
            }
        });
        this.updatePropertyButtons();
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    protected void addPropertyToList() {
        if (this.getTargetObject() instanceof BPMImplementationType) {
            final BPMImplementationType impl = (BPMImplementationType)this.getTargetObject();
            if (impl.eContainer() != null) {
                TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        BPMOperationType newAction = BPMFactory.eINSTANCE.createBPMOperationType();
                        newAction.setType(OperationType.STARTPROCESS);
                        newAction.setName("NewOperation");
                        if (impl.getOperations() == null) {
                            impl.setOperations(BPMFactory.eINSTANCE.createOperationsType());
                        }
                        impl.getOperations().getOperation().add((Object)newAction);
                        BPMActionTable.this.getTableViewer().refresh(true);
                    }
                });
            } else {
                BPMOperationType newAction = BPMFactory.eINSTANCE.createBPMOperationType();
                newAction.setType(OperationType.STARTPROCESS);
                newAction.setName("NewOperation");
                if (impl.getOperations() == null) {
                    impl.setOperations(BPMFactory.eINSTANCE.createOperationsType());
                }
                impl.getOperations().getOperation().add((Object)newAction);
                this.getTableViewer().refresh(true);
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected void removeFromList() {
        if (this.getTargetObject() instanceof BPMImplementationType) {
            final BPMImplementationType impl = (BPMImplementationType)this.getTargetObject();
            final BPMOperationType actionToRemove = this.getTableSelection();
            if (impl.eContainer() != null) {
                TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        impl.getOperations().getOperation().remove((Object)actionToRemove);
                        if (impl.getOperations().getOperation().isEmpty()) {
                            impl.setOperations(null);
                        }
                        BPMActionTable.this.getTableViewer().refresh(true);
                    }
                });
            } else {
                impl.getOperations().getOperation().remove((Object)actionToRemove);
                if (impl.getOperations().getOperation().isEmpty()) {
                    impl.setOperations(null);
                }
                this.getTableViewer().refresh(true);
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected BPMOperationType getTableSelection() {
        IStructuredSelection ssel;
        if (this._propertyTreeTable != null && !this._propertyTreeTable.getSelection().isEmpty() && (ssel = (IStructuredSelection)this._propertyTreeTable.getSelection()).getFirstElement() instanceof BPMOperationType) {
            return (BPMOperationType)ssel.getFirstElement();
        }
        return null;
    }

    public void updatePropertyButtons() {
        if (this._isReadOnly) {
            this._mAddButton.setEnabled(false);
            this._mRemoveButton.setEnabled(false);
        } else {
            this._mAddButton.setEnabled(true);
            if (this.getTableSelection() != null) {
                this._mRemoveButton.setEnabled(true);
            }
        }
    }

    public String getWarning() {
        return this._mWarning;
    }

    protected void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this._changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListeners.remove((Object)listener);
    }

    public void setTargetObject(EObject target) {
        this._targetObj = target;
        this._propertyTreeTable.setInput((Object)target);
        this.updatePropertyButtons();
    }

    protected EObject getTargetObject() {
        return this._targetObj;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        if (element instanceof BPMOperationType && property.equalsIgnoreCase(TYPE_COLUMN)) {
            return new Integer(((BPMOperationType)element).getType().getValue());
        }
        if (element instanceof BPMOperationType && property.equalsIgnoreCase(OPERATION_COLUMN)) {
            if (((BPMOperationType)element).getName() != null) {
                return ((BPMOperationType)element).getName();
            }
            return "";
        }
        if (element instanceof BPMOperationType && property.equalsIgnoreCase(EVENT_ID_COLUMN)) {
            if (((BPMOperationType)element).getEventId() != null) {
                return ((BPMOperationType)element).getEventId();
            }
            return "";
        }
        return null;
    }

    public void modify(Object element, String property, final Object value) {
        if (element instanceof TableItem && property.equalsIgnoreCase(TYPE_COLUMN)) {
            final TableItem ti = (TableItem)element;
            if (this.getTargetObject() instanceof BPMImplementationType) {
                BPMImplementationType impl = (BPMImplementationType)this.getTargetObject();
                if (impl.eContainer() != null) {
                    TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            BPMOperationType parm = (BPMOperationType)ti.getData();
                            OperationType atype = OperationType.get((int)((Integer)value));
                            parm.setType(atype);
                            BPMActionTable.this.getTableViewer().refresh(true);
                        }
                    });
                } else {
                    BPMOperationType parm = (BPMOperationType)ti.getData();
                    OperationType atype = OperationType.get((int)((Integer)value));
                    parm.setType(atype);
                    this.getTableViewer().refresh(true);
                }
            }
            this.fireChangedEvent((Object)this);
        } else if (element instanceof TableItem && property.equalsIgnoreCase(OPERATION_COLUMN)) {
            final TableItem ti = (TableItem)element;
            if (this.getTargetObject() instanceof BPMImplementationType) {
                String newValue;
                BPMImplementationType impl = (BPMImplementationType)this.getTargetObject();
                String string = newValue = value == null || ((String)value).length() == 0 ? null : (String)value;
                if (impl.eContainer() != null) {
                    TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            BPMOperationType parm = (BPMOperationType)ti.getData();
                            parm.setName(newValue);
                            BPMActionTable.this.getTableViewer().refresh(true);
                        }
                    });
                } else {
                    BPMOperationType parm = (BPMOperationType)ti.getData();
                    parm.setName(newValue);
                    this.getTableViewer().refresh(true);
                }
            }
            this.fireChangedEvent((Object)this);
        } else if (element instanceof TableItem && property.equalsIgnoreCase(EVENT_ID_COLUMN)) {
            final TableItem ti = (TableItem)element;
            if (this.getTargetObject() instanceof BPMImplementationType) {
                String newValue;
                BPMImplementationType impl = (BPMImplementationType)this.getTargetObject();
                String string = newValue = value == null || ((String)value).length() == 0 ? null : (String)value;
                if (impl.eContainer() != null) {
                    TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            BPMOperationType parm = (BPMOperationType)ti.getData();
                            parm.setEventId(newValue);
                            BPMActionTable.this.getTableViewer().refresh(true);
                        }
                    });
                } else {
                    BPMOperationType parm = (BPMOperationType)ti.getData();
                    parm.setEventId(newValue);
                    this.getTableViewer().refresh(true);
                }
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected TableViewer getTableViewer() {
        return this._propertyTreeTable;
    }

    private class PropertyTreeContentProvider
    implements IStructuredContentProvider {
        private PropertyTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            BPMImplementationType bpmImpl;
            if (inputElement instanceof BPMImplementationType && (bpmImpl = (BPMImplementationType)inputElement).getOperations() != null) {
                return bpmImpl.getOperations().getOperation().toArray();
            }
            return new Object[0];
        }
    }

    private class PropertyTreeLabelProvider
    implements ITableLabelProvider {
        private PropertyTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            if (element instanceof BPMOperationType && property.equalsIgnoreCase(BPMActionTable.TYPE_COLUMN)) {
                return true;
            }
            return element instanceof BPMOperationType && property.equalsIgnoreCase(BPMActionTable.OPERATION_COLUMN);
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof BPMOperationType && columnIndex == 1) {
                BPMOperationType tp = (BPMOperationType)element;
                return tp.getType().getLiteral();
            }
            if (element instanceof BPMOperationType && columnIndex == 0) {
                BPMOperationType tp = (BPMOperationType)element;
                return tp.getName();
            }
            if (element instanceof BPMOperationType && columnIndex == 2) {
                BPMOperationType tp = (BPMOperationType)element;
                return tp.getEventId();
            }
            return null;
        }
    }
}

