/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Collection;
import java.util.List;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.attribute.impl.AttributeFactoryImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.impl.ComponentFactoryImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.fieldassist.FieldAssistHelper;
import org.eclipse.birt.chart.ui.swt.fieldassist.TextAssistField;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.TriggerSupportMatrix;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HyperlinkEditorDialog
extends TrayDialog
implements SelectionListener {
    private URLValue fURLValue;
    private ChartWizardContext fContext;
    private Button fBtnBaseURL;
    private Button fBtnAdvanced;
    private Text fTxtBaseParm;
    private Text fTxtValueParm;
    private Text fTxtSeriesParm;
    private boolean bAdvanced = false;
    private int fOptionalStyle;
    private Group fGrpParameters;
    private boolean fbEnableURLParameters;
    private Text fTxtHyperlinkLabel;
    private TriggerSupportMatrix fTriggerMatrix;
    private String fsBaseURL;
    private List<String> fExistingLabels;

    public HyperlinkEditorDialog(Shell shell, URLValue urlValue, ChartWizardContext context, TriggerSupportMatrix triggerMatrix, int optionalStyle) {
        super(shell);
        this.setShellStyle(67696);
        this.fURLValue = urlValue;
        this.fContext = context;
        this.fTriggerMatrix = triggerMatrix;
        this.fOptionalStyle = optionalStyle;
        boolean bl = this.fbEnableURLParameters = (optionalStyle & 1) == 1;
        if (this.fURLValue == null) {
            this.fURLValue = AttributeFactoryImpl.eINSTANCE.createURLValue();
        }
    }

    protected Control createDialogArea(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.Hyperlink_Editor_ID");
        this.getShell().setText(Messages.getString("HyperlinkEditorDialog.Title.HyperlinkEditor"));
        Composite c = (Composite)super.createDialogArea(parent);
        this.createURLComposite(c);
        this.updateUIValues();
        return c;
    }

    private void updateUIValues() {
        String v;
        if (this.fURLValue.getLabel() == null) {
            Label l = ComponentFactoryImpl.eINSTANCE.createLabel();
            this.fURLValue.setLabel(l);
            l.eAdapters().addAll((Collection)this.fURLValue.eAdapters());
            org.eclipse.birt.chart.model.attribute.Text t = AttributeFactoryImpl.eINSTANCE.createText();
            l.setCaption(t);
            t.eAdapters().addAll((Collection)l.eAdapters());
        }
        this.fTxtHyperlinkLabel.setText((v = this.fURLValue.getLabel().getCaption().getValue()) == null ? "" : v);
        this.fsBaseURL = this.fURLValue.getBaseUrl();
        this.fTxtBaseParm.setText(this.fURLValue.getBaseParameterName() == null ? "" : this.fURLValue.getBaseParameterName());
        this.fTxtSeriesParm.setText(this.fURLValue.getSeriesParameterName() == null ? "" : this.fURLValue.getSeriesParameterName());
        this.fTxtValueParm.setText(this.fURLValue.getValueParameterName() == null ? "" : this.fURLValue.getValueParameterName());
    }

    private void createURLComposite(Composite parent) {
        GridLayout gl = (GridLayout)parent.getLayout();
        gl.numColumns = 2;
        org.eclipse.swt.widgets.Label lblTarget = new org.eclipse.swt.widgets.Label(parent, 0);
        GridData gdLBLTarget = new GridData();
        gdLBLTarget.horizontalIndent = 2;
        lblTarget.setLayoutData((Object)gdLBLTarget);
        lblTarget.setText(Messages.getString("HyperlinkEditorDialog.Text.MenuLabel"));
        this.fTxtHyperlinkLabel = new Text(parent, 2048);
        GridData gdTXTTarget = new GridData(768);
        gdTXTTarget.widthHint = 80;
        this.fTxtHyperlinkLabel.setLayoutData((Object)gdTXTTarget);
        TextAssistField af = new TextAssistField(this.fTxtHyperlinkLabel, null){
            private boolean fIsDuplicate;
            {
                this.fIsDuplicate = false;
            }

            @Override
            public boolean isValid() {
                this.fIsDuplicate = false;
                String text = HyperlinkEditorDialog.this.fTxtHyperlinkLabel.getText();
                if (text == null || "".equals(text.trim())) {
                    return false;
                }
                if (HyperlinkEditorDialog.this.fExistingLabels != null && HyperlinkEditorDialog.this.fExistingLabels.contains(HyperlinkEditorDialog.this.fTxtHyperlinkLabel.getText())) {
                    this.fIsDuplicate = true;
                    return false;
                }
                return true;
            }

            @Override
            public boolean isRequiredField() {
                return true;
            }

            @Override
            public String getErrorMessage() {
                if (this.fIsDuplicate) {
                    return Messages.getString("HyperlinkEditorDialog.ErrorMessage.ExistingText");
                }
                return Messages.getString("HyperlinkEditorDialog.ErrorMessage.NullText");
            }
        };
        FieldAssistHelper.getInstance().addRequiredFieldIndicator(af, lblTarget);
        org.eclipse.swt.widgets.Label lblBaseURL = new org.eclipse.swt.widgets.Label(parent, 0);
        GridData gdLBLBaseURL = new GridData();
        gdLBLBaseURL.horizontalIndent = 2;
        lblBaseURL.setLayoutData((Object)gdLBLBaseURL);
        lblBaseURL.setText(Messages.getString("TriggerDataComposite.Lbl.BaseURL"));
        this.fBtnBaseURL = new Button(parent, 0);
        GridData gd = new GridData();
        this.fBtnBaseURL.setLayoutData((Object)gd);
        this.fBtnBaseURL.setText(Messages.getString("TriggerDataComposite.Text.EditBaseURL"));
        this.fBtnBaseURL.setToolTipText(Messages.getString("TriggerDataComposite.Tooltip.InvokeURLBuilder"));
        this.fBtnBaseURL.addSelectionListener((SelectionListener)this);
        this.fBtnBaseURL.setEnabled(this.fContext.getUIServiceProvider().isInvokingSupported());
        org.eclipse.swt.widgets.Label lblDefine = new org.eclipse.swt.widgets.Label(parent, 64);
        GridData gd2 = new GridData(768);
        gd2.horizontalIndent = 2;
        gd2.horizontalSpan = 3;
        gd2.widthHint = 200;
        lblDefine.setLayoutData((Object)gd2);
        lblDefine.setText(Messages.getString("TriggerDataComposite.Label.Description"));
        this.fBtnAdvanced = new Button(parent, 0);
        gd2 = new GridData();
        gd2.horizontalSpan = 2;
        this.fBtnAdvanced.setLayoutData((Object)gd2);
        this.fBtnAdvanced.setText(this.getAdvancedButtonText(this.bAdvanced));
        this.fBtnAdvanced.setToolTipText(Messages.getString("TriggerDataComposite.Tooltip.Advanced"));
        this.fBtnAdvanced.addSelectionListener((SelectionListener)this);
        this.fBtnAdvanced.setEnabled(this.fbEnableURLParameters);
        this.fGrpParameters = new Group(parent, 0);
        GridData gdGRPParameters = new GridData(768);
        gdGRPParameters.horizontalSpan = 3;
        this.fGrpParameters.setLayoutData((Object)gdGRPParameters);
        GridLayout glParameter = new GridLayout();
        glParameter.marginWidth = 2;
        glParameter.marginHeight = 6;
        glParameter.horizontalSpacing = 6;
        glParameter.numColumns = 3;
        this.fGrpParameters.setLayout((Layout)glParameter);
        this.fGrpParameters.setText(Messages.getString("TriggerDataComposite.Lbl.ParameterNames"));
        this.fGrpParameters.setVisible(this.bAdvanced);
        StyledText stParameters = new StyledText((Composite)this.fGrpParameters, 72);
        GridData gd3 = new GridData(768);
        gd3.horizontalIndent = 2;
        gd3.horizontalSpan = 3;
        gd3.widthHint = 200;
        stParameters.setLayoutData((Object)gd3);
        stParameters.setText(Messages.getString("TriggerDataComposite.Label.OptionalURLParameters"));
        stParameters.setBackground(parent.getBackground());
        org.eclipse.swt.widgets.Label lblBaseParm = new org.eclipse.swt.widgets.Label((Composite)this.fGrpParameters, 0);
        GridData gdLBLBaseParm = new GridData();
        gdLBLBaseParm.horizontalIndent = 2;
        lblBaseParm.setLayoutData((Object)gdLBLBaseParm);
        lblBaseParm.setText(Messages.getString("TriggerDataComposite.Lbl.CategorySeries"));
        lblBaseParm.setToolTipText(Messages.getString("TriggerDataComposite.Tooltip.ParameterCategory"));
        this.fTxtBaseParm = new Text((Composite)this.fGrpParameters, 2048);
        GridData gdTXTBaseParm = new GridData(768);
        gdTXTBaseParm.horizontalSpan = 2;
        this.fTxtBaseParm.setLayoutData((Object)gdTXTBaseParm);
        this.fTxtBaseParm.setToolTipText(Messages.getString("TriggerDataComposite.Tooltip.ParameterCategory"));
        this.fTxtBaseParm.setEnabled(this.fbEnableURLParameters && (this.fOptionalStyle & 2) != 2);
        org.eclipse.swt.widgets.Label lblValueParm = new org.eclipse.swt.widgets.Label((Composite)this.fGrpParameters, 0);
        GridData gdLBLValueParm = new GridData();
        gdLBLValueParm.horizontalIndent = 2;
        lblValueParm.setLayoutData((Object)gdLBLValueParm);
        lblValueParm.setText(Messages.getString("TriggerDataComposite.Lbl.ValueSeries"));
        lblValueParm.setToolTipText(Messages.getString("TriggerDataComposite.Tooltip.ParameterValue"));
        this.fTxtValueParm = new Text((Composite)this.fGrpParameters, 2048);
        GridData gdTXTValueParm = new GridData(768);
        gdTXTValueParm.horizontalSpan = 2;
        this.fTxtValueParm.setLayoutData((Object)gdTXTValueParm);
        this.fTxtValueParm.setToolTipText(Messages.getString("TriggerDataComposite.Tooltip.ParameterValue"));
        this.fTxtValueParm.setEnabled(this.fbEnableURLParameters && (this.fOptionalStyle & 4) != 4);
        org.eclipse.swt.widgets.Label lblSeriesParm = new org.eclipse.swt.widgets.Label((Composite)this.fGrpParameters, 0);
        GridData gdLBLSeriesParm = new GridData();
        gdLBLSeriesParm.horizontalIndent = 2;
        lblSeriesParm.setLayoutData((Object)gdLBLSeriesParm);
        lblSeriesParm.setText(Messages.getString("TriggerDataComposite.Lbl.ValueSeriesName"));
        lblSeriesParm.setToolTipText(Messages.getString("TriggerDataComposite.Tooltip.ParameterSeries"));
        this.fTxtSeriesParm = new Text((Composite)this.fGrpParameters, 2048);
        GridData gdTXTSeriesParm = new GridData(768);
        gdTXTSeriesParm.horizontalSpan = 2;
        this.fTxtSeriesParm.setLayoutData((Object)gdTXTSeriesParm);
        this.fTxtSeriesParm.setToolTipText(Messages.getString("TriggerDataComposite.Tooltip.ParameterSeries"));
        this.fTxtSeriesParm.setEnabled(this.fbEnableURLParameters && (this.fOptionalStyle & 8) != 8);
    }

    private String getAdvancedButtonText(boolean bAdvanced) {
        if (bAdvanced) {
            return Messages.getString("TriggerDataComposite.Text.OpenAdvanced");
        }
        return Messages.getString("TriggerDataComposite.Text.Advanced");
    }

    private int getHyperlinkBuilderCommand() {
        int type = this.fTriggerMatrix.getType();
        if ((type & 1) == 1) {
            boolean useCube;
            boolean bl = useCube = this.fContext.getDataServiceProvider().checkState(2) || this.fContext.getDataServiceProvider().checkState(256);
            if (useCube) {
                return 10;
            }
            return 7;
        }
        if ((type & 0x10) == 16) {
            return 8;
        }
        return 6;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.fBtnBaseURL)) {
            try {
                if (this.fContext != null) {
                    this.fsBaseURL = this.fContext.getUIServiceProvider().invoke(this.getHyperlinkBuilderCommand(), this.fsBaseURL, this.fContext.getExtendedItem(), null);
                }
            }
            catch (ChartException ex) {
                WizardBase.displayException((Throwable)ex);
            }
        } else if (e.getSource().equals(this.fBtnAdvanced)) {
            this.bAdvanced = !this.bAdvanced;
            this.fBtnAdvanced.setText(this.getAdvancedButtonText(this.bAdvanced));
            this.fGrpParameters.setVisible(this.bAdvanced);
            ((Composite)this.getDialogArea()).layout(true, true);
        }
    }

    protected void okPressed() {
        String result = this.getNameCheckResult();
        if (result != null) {
            MessageBox mb = new MessageBox(Display.getDefault().getActiveShell(), 8);
            mb.setText(Messages.getString("HyperlinkEditorDialog.HyperlinkName.Title.Warning"));
            mb.setMessage(result);
            mb.open();
            this.fTxtHyperlinkLabel.setFocus();
            return;
        }
        if (this.fsBaseURL == null) {
            MessageBox mb = new MessageBox(Display.getDefault().getActiveShell(), 8);
            mb.setText(Messages.getString("HyperlinkEditorDialog.HyperlinkName.Title.Warning"));
            mb.setMessage(Messages.getString("HyperlinkEditorDialog.BaseURL.Message"));
            mb.open();
            this.fTxtHyperlinkLabel.setFocus();
            return;
        }
        this.fURLValue.getLabel().getCaption().setValue(this.fTxtHyperlinkLabel.getText().trim());
        this.fURLValue.setBaseUrl(this.fsBaseURL);
        this.fURLValue.setBaseParameterName(this.fTxtBaseParm.getText());
        this.fURLValue.setSeriesParameterName(this.fTxtSeriesParm.getText());
        this.fURLValue.setValueParameterName(this.fTxtValueParm.getText());
        super.okPressed();
    }

    private String getNameCheckResult() {
        if ("".equals(this.fTxtHyperlinkLabel.getText().trim())) {
            return Messages.getString("HyperlinkEditorDialog.ErrorMessage.NullText");
        }
        if (this.fExistingLabels != null && this.fExistingLabels.contains(this.fTxtHyperlinkLabel.getText().trim())) {
            return Messages.getString("HyperlinkEditorDialog.ErrorMessage.ExistingText");
        }
        return null;
    }

    public URLValue getURLValue() {
        return this.fURLValue;
    }

    public void setExistingLabels(List<String> labels) {
        this.fExistingLabels = labels;
    }
}

