/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.teiid.core.designer.util.CoreArgCheck;

public class ResourceChangeUtilities {
    public static boolean isProjectRenamed(IResourceChangeEvent theEvent) {
        IResourceDelta[] deltas;
        boolean result = false;
        IResourceDelta delta = theEvent.getDelta();
        if (delta != null && ResourceChangeUtilities.isRename(theEvent, deltas = delta.getAffectedChildren()) && ResourceChangeUtilities.isProject(deltas[0])) {
            result = true;
        }
        return result;
    }

    public static boolean isRename(IResourceChangeEvent theEvent, IResourceDelta[] deltas) {
        CoreArgCheck.isNotNull((Object)theEvent);
        CoreArgCheck.isNotNull((Object)deltas);
        boolean result = false;
        if (ResourceChangeUtilities.isPreEvent(theEvent) || ResourceChangeUtilities.isAutoBuild(theEvent)) {
            return result;
        }
        if (deltas.length == 2) {
            IResourceDelta d1 = deltas[0];
            IResourceDelta d2 = deltas[1];
            result = ResourceChangeUtilities.isAdded(d1) && ResourceChangeUtilities.isMovedFrom(d1) && ResourceChangeUtilities.isRemoved(d2) && ResourceChangeUtilities.isMovedTo(d2) || ResourceChangeUtilities.isAdded(d2) && ResourceChangeUtilities.isMovedFrom(d2) && ResourceChangeUtilities.isRemoved(d1) && ResourceChangeUtilities.isMovedTo(d1);
        }
        return result;
    }

    public static boolean isAutoBuild(IResourceChangeEvent theEvent) {
        CoreArgCheck.isNotNull((Object)theEvent);
        return ResourceChangeUtilities.isPreAutoBuild(theEvent) || ResourceChangeUtilities.isPostAutoBuild(theEvent);
    }

    public static boolean isPreEvent(IResourceChangeEvent event) {
        if (event == null) {
            return false;
        }
        if (ResourceChangeUtilities.isPreAutoBuild(event)) {
            return true;
        }
        if (ResourceChangeUtilities.isPreClose(event)) {
            return true;
        }
        return ResourceChangeUtilities.isPreDelete(event);
    }

    public static boolean isProjectClosing(IResourceChangeEvent theEvent) {
        IResource resource = theEvent.getResource();
        if (resource instanceof IProject) {
            return ResourceChangeUtilities.isPreClose(theEvent);
        }
        return false;
    }

    public static void debug(IResourceChangeEvent theEvent) {
        if (theEvent == null) {
            return;
        }
        System.out.println("********************event=" + System.identityHashCode(theEvent));
        System.out.println("type=" + theEvent.getType());
        System.out.println("resource=" + theEvent.getResource());
        System.out.println("isPreClose=" + ResourceChangeUtilities.isPreClose(theEvent));
        System.out.println("isPreDelete=" + ResourceChangeUtilities.isPreDelete(theEvent));
        System.out.println("isPreAutoBuild=" + ResourceChangeUtilities.isPreAutoBuild(theEvent));
        System.out.println("delta=" + theEvent.getDelta());
        System.out.println("isPostAutoBuild=" + ResourceChangeUtilities.isPostAutoBuild(theEvent));
        System.out.println("isPostChange=" + ResourceChangeUtilities.isPostChange(theEvent));
        System.out.println("isPreAutoBuild=" + ResourceChangeUtilities.isPreAutoBuild(theEvent));
        if (theEvent.getDelta() != null) {
            System.out.println("affected children count=" + theEvent.getDelta().getAffectedChildren().length);
            try {
                theEvent.getDelta().accept((IResourceDeltaVisitor)new DebugDeltaVisitor());
            }
            catch (CoreException coreException) {}
        }
        System.out.println();
    }

    public static boolean isPostAutoBuild(IResourceChangeEvent theEvent) {
        return theEvent.getType() == 16;
    }

    public static boolean isPostChange(IResourceChangeEvent theEvent) {
        return theEvent.getType() == 1;
    }

    public static boolean isPreAutoBuild(IResourceChangeEvent theEvent) {
        return theEvent.getType() == 8;
    }

    public static boolean isPreClose(IResourceChangeEvent theEvent) {
        return theEvent.getType() == 2;
    }

    public static boolean isPreDelete(IResourceChangeEvent theEvent) {
        return theEvent.getType() == 4;
    }

    public static boolean isAdded(IResourceDelta theDelta) {
        if (theDelta == null) {
            return false;
        }
        return theDelta.getKind() == 1;
    }

    public static boolean isChanged(IResourceDelta theDelta) {
        if (theDelta == null) {
            return false;
        }
        return theDelta.getKind() == 4;
    }

    public static boolean isContentChanged(IResourceDelta theDelta) {
        if (theDelta == null) {
            return false;
        }
        return theDelta.getKind() == 4 && (theDelta.getFlags() & 0x100) != 0;
    }

    public static boolean isDescriptionChange(IResourceDelta theDelta) {
        if (theDelta == null) {
            return false;
        }
        return (theDelta.getFlags() & 0x80000) != 0;
    }

    public static boolean isMarkersChange(IResourceDelta theDelta) {
        if (theDelta == null) {
            return false;
        }
        return (theDelta.getFlags() & 0x20000) != 0;
    }

    public static boolean isFile(IResourceDelta theDelta) {
        if (theDelta == null) {
            return false;
        }
        return theDelta.getResource().getType() == 1;
    }

    public static boolean isFolder(IResourceDelta theDelta) {
        if (theDelta == null) {
            return false;
        }
        return theDelta.getResource().getType() == 2;
    }

    public static boolean isMovedFrom(IResourceDelta theDelta) {
        if (theDelta == null) {
            return false;
        }
        return (theDelta.getFlags() & 0x1000) != 0;
    }

    public static boolean isMovedTo(IResourceDelta theDelta) {
        if (theDelta == null) {
            return false;
        }
        return (theDelta.getFlags() & 0x2000) != 0;
    }

    public static boolean isOpened(IResourceDelta theDelta) {
        if (theDelta == null) {
            return false;
        }
        return (theDelta.getFlags() & 0x4000) != 0;
    }

    public static boolean isDescriptionChanged(IResourceDelta theDelta) {
        if (theDelta == null) {
            return false;
        }
        return (theDelta.getFlags() & 0x80000) != 0;
    }

    public static boolean isProject(IResourceDelta theDelta) {
        if (theDelta == null) {
            return false;
        }
        return theDelta.getResource().getType() == 4;
    }

    public static boolean isRemoved(IResourceDelta theDelta) {
        if (theDelta == null) {
            return false;
        }
        return theDelta.getKind() == 2;
    }

    public static boolean isReplaced(IResourceDelta theDelta) {
        if (theDelta == null) {
            return false;
        }
        return (theDelta.getFlags() & 0x40000) != 0;
    }

    public static boolean isTypeChange(IResourceDelta theDelta) {
        if (theDelta == null) {
            return false;
        }
        return (theDelta.getFlags() & 0x8000) != 0;
    }

    public static boolean isSynchChange(IResourceDelta theDelta) {
        if (theDelta == null) {
            return false;
        }
        return (theDelta.getFlags() & 0x10000) != 0;
    }

    static class DebugDeltaVisitor
    implements IResourceDeltaVisitor {
        DebugDeltaVisitor() {
        }

        public boolean visit(IResourceDelta theDelta) {
            System.out.println("resource=" + theDelta.getResource());
            System.out.println("kind=" + theDelta.getKind());
            System.out.println("flags=" + theDelta.getFlags());
            System.out.println("isAdded=" + ResourceChangeUtilities.isAdded(theDelta));
            System.out.println("isChanged=" + ResourceChangeUtilities.isChanged(theDelta));
            System.out.println("isContentChanged=" + ResourceChangeUtilities.isContentChanged(theDelta));
            System.out.println("isDescriptionChange=" + ResourceChangeUtilities.isDescriptionChange(theDelta));
            System.out.println("isFile=" + ResourceChangeUtilities.isFile(theDelta));
            System.out.println("isFolder=" + ResourceChangeUtilities.isFolder(theDelta));
            System.out.println("isMovedFrom=" + ResourceChangeUtilities.isMovedFrom(theDelta));
            System.out.println("isMovedTo=" + ResourceChangeUtilities.isMovedTo(theDelta));
            System.out.println("isOpened=" + ResourceChangeUtilities.isOpened(theDelta));
            System.out.println("isProject=" + ResourceChangeUtilities.isProject(theDelta));
            System.out.println("isRemoved=" + ResourceChangeUtilities.isRemoved(theDelta));
            System.out.println("isReplaced=" + ResourceChangeUtilities.isReplaced(theDelta));
            System.out.println("isTypeChange=" + ResourceChangeUtilities.isTypeChange(theDelta));
            System.out.println("-----\n\n");
            return true;
        }
    }
}

