/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelResourceContainerFactory;
import org.teiid.designer.core.workspace.ModelBufferImpl;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelResourceImpl;
import org.teiid.designer.core.workspace.ModelTransformations;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.NonOpenableModelWorkspaceItemImpl;
import org.teiid.designer.core.workspace.Openable;
import org.teiid.designer.metamodels.transformation.FragmentMappingRoot;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.metamodels.transformation.TransformationContainer;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;
import org.teiid.designer.metamodels.transformation.TreeMappingRoot;

public class ModelTransformationsImpl
extends NonOpenableModelWorkspaceItemImpl
implements ModelTransformations {
    private static final String CREATE_TRANSFORMATION_ERROR = "ModelTransformationsImpl.createTransformationMessage";
    protected static final String DEFAULT_NAME = ModelerCore.Util.getString("ModelTransformationsImpl.defaultName", new Object[0]);

    ModelTransformationsImpl() {
        super(9, null, DEFAULT_NAME);
    }

    public ModelTransformationsImpl(ModelWorkspaceItem parent) {
        super(9, parent, DEFAULT_NAME);
    }

    public ModelResource getModelResource() {
        return (ModelResource)this.getParent();
    }

    @Override
    public IResource getResource() {
        return this.getModelResource().getResource();
    }

    @Override
    public IResource getUnderlyingResource() {
        return this.getResource();
    }

    @Override
    public IPath getPath() {
        return this.getModelResource().getPath();
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    protected ModelBufferImpl getModelBuffer() throws ModelWorkspaceException {
        ModelResourceImpl modelResourceImpl = (ModelResourceImpl)this.getModelResource();
        return (ModelBufferImpl)modelResourceImpl.getBuffer();
    }

    @Override
    public List getTransformations(EObject target) throws ModelWorkspaceException {
        return this.getModelBuffer().getModelContents().getTransformations(target);
    }

    @Override
    public List getTransformations() throws ModelWorkspaceException {
        return this.getModelBuffer().getModelContents().getTransformations();
    }

    @Override
    public SqlTransformationMappingRoot createNewSqlTransformation(EObject target) throws ModelWorkspaceException {
        return ModelResourceContainerFactory.createNewSqlTransformationMappingRoot(target, this.getModelResource().getEmfResource());
    }

    @Override
    public FragmentMappingRoot createNewFragmentMapping(EObject target) throws ModelWorkspaceException {
        return ModelResourceContainerFactory.createNewFragmentMappingRoot(target, this.getModelResource().getEmfResource());
    }

    @Override
    public TreeMappingRoot createNewTreeMapping(EObject target) throws ModelWorkspaceException {
        return ModelResourceContainerFactory.createNewTreeMappingRoot(target, this.getModelResource().getEmfResource());
    }

    @Override
    public TransformationMappingRoot addNewTransformation(EObject target, TransformationMappingRoot newMappingRoot) throws ModelWorkspaceException {
        TransformationContainer tc = ModelResourceContainerFactory.getTransformationContainer(this.getModelResource().getEmfResource(), true);
        newMappingRoot.setTarget(target);
        try {
            ModelerCore.getModelEditor().addValue(tc, newMappingRoot, tc.getTransformationMappings());
        }
        catch (ModelerCoreException err) {
            ModelerCore.Util.log(4, (Throwable)err, ModelerCore.Util.getString(CREATE_TRANSFORMATION_ERROR, (Object)target));
        }
        return newMappingRoot;
    }

    @Override
    public boolean delete(TransformationMappingRoot transformation) {
        return ModelResourceContainerFactory.deleteTransformation(transformation);
    }

    @Override
    public Openable getOpenable() {
        return this.getOpenableParent();
    }
}

