/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelFileUtil;
import org.teiid.designer.core.workspace.ModelFolder;
import org.teiid.designer.core.workspace.ModelFolderImpl;
import org.teiid.designer.core.workspace.ModelProject;
import org.teiid.designer.core.workspace.ModelProjectInfo;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelResourceImpl;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.OpenableImpl;
import org.teiid.designer.core.workspace.OpenableModelWorkspaceItemInfo;

public class ModelProjectImpl
extends OpenableImpl
implements IProjectNature,
ModelProject {
    protected static final boolean IS_CASE_SENSITIVE = !new File("Temp").equals(new File("temp"));
    public static final String PREF_FILENAME = ".mprefs";
    protected IProject fProject;
    protected IPath path;

    public ModelProjectImpl() {
        super(2, null, null);
    }

    public ModelProjectImpl(IProject project, ModelWorkspaceItem parent) {
        super(2, parent, project.getName());
        this.fProject = project;
    }

    public static IPath canonicalizedPath(IPath externalPath) {
        Path result;
        if (externalPath == null) {
            return null;
        }
        if (IS_CASE_SENSITIVE) {
            return externalPath;
        }
        IWorkspace workspace = ModelerCore.getWorkspace();
        if (workspace == null) {
            return externalPath;
        }
        if (workspace.getRoot().findMember(externalPath) != null) {
            return externalPath;
        }
        Path canonicalPath = null;
        try {
            canonicalPath = new Path(new File(externalPath.toOSString()).getCanonicalPath());
        }
        catch (IOException iOException) {
            return externalPath;
        }
        int canonicalLength = canonicalPath.segmentCount();
        if (canonicalLength == 0) {
            return externalPath;
        }
        if (externalPath.isAbsolute()) {
            result = canonicalPath;
        } else {
            int externalLength = externalPath.segmentCount();
            if (canonicalLength >= externalLength) {
                result = canonicalPath.removeFirstSegments(canonicalLength - externalLength);
            } else {
                return externalPath;
            }
        }
        if (externalPath.getDevice() == null) {
            result = result.setDevice(null);
        }
        return result;
    }

    private void addToBuildSpec(String builderId) throws CoreException {
        IProject project = this.getProject();
        IProjectDescription desc = project.getDescription();
        ICommand cmd = this.getBuilderCommand(desc, builderId);
        if (cmd == null) {
            cmd = desc.newCommand();
            cmd.setBuilderName(builderId);
            ICommand[] cmds = desc.getBuildSpec();
            ICommand[] newCmds = new ICommand[cmds.length + 1];
            System.arraycopy(cmds, 0, newCmds, 1, cmds.length);
            newCmds[0] = cmd;
            desc.setBuildSpec(newCmds);
            project.setDescription(desc, null);
        }
    }

    public void configure() throws CoreException {
        this.addToBuildSpec("org.teiid.designer.core.modelBuilder");
        this.addToBuildSpec("org.teiid.designer.extension.ui.modelExtensionDefinitionBuilder");
        this.addToBuildSpec("org.teiid.designer.vdb.ui.vdbBuilder");
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec("org.teiid.designer.core.modelBuilder");
        this.removeFromBuildSpec("org.teiid.designer.extension.ui.modelExtensionDefinitionBuilder");
        this.removeFromBuildSpec("org.teiid.designer.vdb.ui.vdbBuilder");
    }

    @Override
    protected boolean generateInfos(OpenableModelWorkspaceItemInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelWorkspaceException {
        boolean validInfo = false;
        try {
            if (this.getProject().isOpen()) {
                ModelWorkspaceManager.getModelWorkspaceManager().putInfo(this, info);
                this.updatePackageFragmentRoots();
                validInfo = true;
            }
        }
        finally {
            if (!validInfo) {
                ModelWorkspaceManager.getModelWorkspaceManager().removeInfo(this);
            }
        }
        return validInfo;
    }

    private ICommand getBuilderCommand(IProjectDescription description, String builderId) {
        ICommand[] cmds = description.getBuildSpec();
        int ndx = cmds.length;
        while (--ndx >= 0) {
            ICommand cmd = cmds[ndx];
            if (!cmd.getBuilderName().equals(builderId)) continue;
            return cmd;
        }
        return null;
    }

    @Override
    public Object[] getNonModelingResources() throws ModelWorkspaceException {
        return ((ModelProjectInfo)this.getItemInfo()).getNonModelResources(this);
    }

    @Override
    public IPath getPath() {
        if (this.path == null) {
            return this.getProject().getFullPath();
        }
        return this.path;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    @Override
    public IProject getProject() {
        return this.fProject;
    }

    @Override
    public IResource getResource() {
        return this.getProject();
    }

    private void removeFromBuildSpec(String builderId) throws CoreException {
        IProject project = this.getProject();
        IProjectDescription desc = project.getDescription();
        ICommand[] cmds = desc.getBuildSpec();
        int ndx = cmds.length;
        while (--ndx >= 0) {
            ICommand cmd = cmds[ndx];
            if (!cmd.getBuilderName().equals(builderId)) continue;
            ICommand[] newCmds = new ICommand[cmds.length - 1];
            System.arraycopy(cmds, 0, newCmds, 0, ndx);
            System.arraycopy(cmds, ndx + 1, newCmds, ndx, cmds.length - ndx - 1);
            desc.setBuildSpec(newCmds);
            project.setDescription(desc, null);
            return;
        }
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    protected ModelProjectInfo getModelProjectInfo() throws ModelWorkspaceException {
        return (ModelProjectInfo)this.getItemInfo();
    }

    public void updatePackageFragmentRoots() throws ModelWorkspaceException {
        if (this.isOpen()) {
            boolean failed = false;
            try {
                try {
                    ModelProjectInfo info = this.getModelProjectInfo();
                    info.setNonModelResources(null);
                    info.setChildren(this.computeModelResources());
                }
                catch (ModelWorkspaceException e) {
                    failed = true;
                    throw e;
                }
                catch (RuntimeException e) {
                    failed = true;
                    throw e;
                }
            }
            catch (Throwable throwable) {
                if (failed) {
                    try {
                        this.close();
                    }
                    catch (ModelWorkspaceException modelWorkspaceException) {}
                }
                throw throwable;
            }
            if (failed) {
                try {
                    this.close();
                }
                catch (ModelWorkspaceException modelWorkspaceException) {}
            }
        }
    }

    @Override
    public ModelWorkspaceItem findModelWorkspaceItem(IResource resource) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)resource);
        return ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(resource);
    }

    protected ModelResource createModelResource(IFile resource) {
        ModelWorkspaceItem parent = this.findParent((IResource)resource);
        if (!ModelUtil.isVdbArchiveFile((IResource)resource)) {
            return new ModelResourceImpl(parent, resource.getName(), false);
        }
        return new ModelResourceImpl(parent, resource.getName());
    }

    protected ModelFolder createModelFolder(IFolder folder) {
        ModelWorkspaceItem parent = this.findParent((IResource)folder);
        return new ModelFolderImpl(folder, parent);
    }

    private ModelWorkspaceItem findParent(IResource resource) {
        IContainer iParent = resource.getParent();
        if (iParent instanceof IProject) {
            return this;
        }
        return this.getModelWorkspace().getParent(resource);
    }

    public ModelWorkspaceItem[] computeModelResources() {
        ArrayList accumulatedModelResources = new ArrayList();
        this.computeModelResources((IContainer)this.getProject(), accumulatedModelResources);
        ModelWorkspaceItem[] results = new ModelWorkspaceItem[accumulatedModelResources.size()];
        accumulatedModelResources.toArray(results);
        return results;
    }

    public void computeModelResources(IContainer container, ArrayList accumulatedModelResources) {
        try {
            IResource[] children = container.members();
            int i = 0;
            while (i < children.length) {
                IResource child = children[i];
                if (1 == child.getType()) {
                    if (ModelUtil.isModelFile(child)) {
                        ModelResource mdlResource = this.createModelResource((IFile)child);
                        accumulatedModelResources.add(mdlResource);
                    } else if (!ModelFileUtil.isModelFileExtension((String)child.getFileExtension(), (boolean)true) && ModelFileUtil.isModelFileExtension((String)child.getFileExtension(), (boolean)false)) {
                        String actualFileName = child.getName();
                        String actualExtension = child.getFileExtension();
                        int endIndex = actualFileName.length() - actualExtension.length();
                        String expectedFileName = String.valueOf(actualFileName.substring(0, endIndex)) + actualExtension.toLowerCase();
                        Object[] params = new Object[]{actualFileName, expectedFileName};
                        String msg = ModelerCore.Util.getString("ModelerCore.file_extension_not_correct_case_please_rename_file", params);
                        ModelerCore.Util.log(4, msg);
                    }
                } else if (2 == child.getType()) {
                    ModelFolder mdlFolder = this.createModelFolder((IFolder)child);
                    accumulatedModelResources.add(mdlFolder);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            ModelerCore.Util.log(4, (Throwable)e, ModelerCore.Util.getString("ModelProjectImpl.Error_while_computing_ModelResource_instances_for_ModelProject", (Object)this));
        }
    }

    @Override
    protected OpenableModelWorkspaceItemInfo createItemInfo() {
        return new ModelProjectInfo();
    }
}

